/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class SourceRelationHelper {
    private static final String TEMP_FORMAT = "%s_tp";

    public static String getTemporaryEntity(String sourceEntity) {
        QFilter q1 = new QFilter("source", "=", (Object)sourceEntity);
        QFilter q2 = new QFilter("relationtype", "=", (Object)"master_slave");
        DynamicObject object = BusinessDataServiceHelper.loadSingleFromCache((String)"bdtaxr_source_relation", (QFilter[])new QFilter[]{q1, q2});
        if (object != null) {
            return object.getString("sourcetemp");
        }
        return String.format(TEMP_FORMAT, sourceEntity);
    }

    public static String getSourceEntity(String temporaryEntity) {
        QFilter q1 = new QFilter("sourcetemp", "=", (Object)temporaryEntity);
        QFilter q2 = new QFilter("relationtype", "=", (Object)"master_slave");
        DynamicObject object = BusinessDataServiceHelper.loadSingleFromCache((String)"bdtaxr_source_relation", (QFilter[])new QFilter[]{q1, q2});
        if (object != null) {
            return object.getString("source");
        }
        return temporaryEntity.replace("_tp", "");
    }

    public static Map<String, List<DynamicObject>> queryRelationsGroupByRelationType(String templatetype) {
        List<DynamicObject> relations = SourceRelationHelper.queryRelations(templatetype);
        return relations.stream().collect(Collectors.groupingBy(d -> d.getString("relationtype")));
    }

    public static List<DynamicObject> queryRelations(String templatetype) {
        QFilter q1 = new QFilter("applytemplates", "like", (Object)("%," + templatetype + ",%"));
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bdtaxr_source_relation", (QFilter[])new QFilter[]{q1});
        return new ArrayList<DynamicObject>(map.values());
    }
}

