/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IFormView;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.privacy.DesensitizeStrategyFactory;
import kd.bos.privacy.IDesensitizeStrategy;
import kd.bos.privacy.model.PrivacyEncryptModel;
import kd.bos.servicehelper.privacy.PrivacyCenterServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;

public class TaxcPrivacyHelper {
    private static Log logger = LogFactory.getLog(TaxcPrivacyHelper.class);

    public static void setSmallEyes(IFormView view, String field) {
        HashMap itemMap = new HashMap(4);
        HashMap typeMap = new HashMap(4);
        HashMap<String, Boolean> valueMap = new HashMap<String, Boolean>(4);
        valueMap.put("canshowdetail", true);
        valueMap.put("isprivacy", true);
        typeMap.put("privacy", valueMap);
        itemMap.put("item", typeMap);
        view.updateControlMetadata(field, itemMap);
    }

    public static List<PrivacyFieldVo> getPrivacyProp(String entityId) {
        ArrayList<PrivacyFieldVo> privacyFieldVos = new ArrayList<PrivacyFieldVo>();
        if (EmptyCheckUtils.isNotEmpty(entityId)) {
            String allFieldStringNoCollection = MetadataUtil.getAllFieldStringNoCollection(entityId);
            for (String field : allFieldStringNoCollection.split(",")) {
                boolean desensitizeField = PrivacyCenterServiceHelper.isDesensitizeField((String)entityId, (String)field, (String)Lang.get().toString(), (String)"FORM", null);
                if (!desensitizeField) continue;
                PrivacyFieldVo privacyFieldVo = new PrivacyFieldVo(field, entityId, null);
                privacyFieldVos.add(privacyFieldVo);
            }
        }
        return privacyFieldVos;
    }

    public static boolean isPrivacyProp(String entityId, String field) {
        try {
            return PrivacyCenterServiceHelper.isDesensitizeField((String)entityId, (String)field, (String)Lang.get().toString(), (String)"FORM", null);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return false;
        }
    }

    public static String desensitizeByMeta(String entityId, String field, DynamicObject object) {
        try {
            Object desensitizeValue = PrivacyCenterServiceHelper.getDesensitizeValue((String)entityId, (String)field, (String)Lang.get().toString(), (String)"FORM", (DynamicObject)object, (Object)object.get(field));
            return (String)desensitizeValue;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return String.valueOf(object.get(field));
        }
    }

    public static String desensitizeByMeta(String entityId, String field, String val) {
        try {
            Object desensitizeValue = PrivacyCenterServiceHelper.getDesensitizeValue((String)entityId, (String)field, (String)Lang.get().toString(), (String)"FORM", null, (Object)val);
            return (String)desensitizeValue;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return val;
        }
    }

    public static String desensitizeByRule(String val, String desensitizeRuleId) {
        try {
            PrivacyEncryptModel encryptModel = new PrivacyEncryptModel();
            encryptModel.setFieldType("12");
            encryptModel.setDesensitizeRule(desensitizeRuleId);
            encryptModel.setDesensitizeType("SYSTEM");
            IDesensitizeStrategy strategy = DesensitizeStrategyFactory.getStrategy((String)desensitizeRuleId);
            String desensitize = strategy.desensitize(encryptModel, (Object)val);
            return desensitize;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return val;
        }
    }

    static class PrivacyFieldVo {
        private String field;
        private String entityId;
        private String desensitizeRuleId;
        private String encryptRuleId;

        public PrivacyFieldVo(String field, String entityId, String desensitizeRuleId) {
            this.field = field;
            this.entityId = entityId;
            this.desensitizeRuleId = desensitizeRuleId;
        }

        public String getField() {
            return this.field;
        }

        public void setField(String field) {
            this.field = field;
        }

        public String getEntityId() {
            return this.entityId;
        }

        public void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        public String getDesensitizeRuleId() {
            return this.desensitizeRuleId;
        }

        public void setDesensitizeRuleId(String desensitizeRuleId) {
            this.desensitizeRuleId = desensitizeRuleId;
        }

        public String getEncryptRuleId() {
            return this.encryptRuleId;
        }

        public void setEncryptRuleId(String encryptRuleId) {
            this.encryptRuleId = encryptRuleId;
        }
    }
}

