/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.helper;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.DeclareConstant;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.taxorg.TaxOrgUtil;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.bdtaxr.common.utils.ServiceInvokeUtils;
import kd.taxc.bdtaxr.common.utils.date.DateUtils;
import kd.taxc.bdtaxr.common.utils.string.StringUtil;

public class YbnsrServiceHelper {
    public static final String TCVAT_NSRXX = "tcvat_nsrxx";
    public static final String SPLITSTRING = "#";

    public static Map<String, String> createYbnsrNoBillNo(String id, String type, String orgId, String startData, String endData, boolean isCreate, Map<String, Object> extendParams, Long templateId) {
        return YbnsrServiceHelper.createYbnsr(id, null, type, orgId, startData, endData, isCreate, extendParams, templateId);
    }

    public static Map<String, String> createYbnsr(String id, String billNo, String type, String orgId, String startData, String endData, boolean isCreate, Map<String, Object> extendParams, Long templateId) {
        TaxResult mapTaxResult = ServiceInvokeUtils.invokeTaxcTpoCalculateService(Map.class, (String)"TpoYbnsrService", (String)"createYbnsr", (Object[])new Object[]{id, billNo, type, orgId, startData, endData, isCreate, extendParams, templateId});
        return (Map)ServiceInvokeUtils.getResultData((TaxResult)mapTaxResult);
    }

    public static Map<String, String> createYbnsrSetMainDataId(String id, String type, String orgId, String startData, String endData, boolean isCreate, Map<String, Object> extendParams, String mainDataId, Long temlateId) {
        TaxResult mapTaxResult = ServiceInvokeUtils.invokeTaxcTpoCalculateService(Map.class, (String)"TpoYbnsrService", (String)"createYbnsrSetMainDataId", (Object[])new Object[]{id, type, orgId, startData, endData, isCreate, extendParams, mainDataId, temlateId});
        return (Map)ServiceInvokeUtils.getResultData((TaxResult)mapTaxResult);
    }

    public static Map<String, String> createMutiCnDeclareMain(Long modelId, String id, String billNo, String type, String orgId, String startData, String endData, boolean isCreate, Map<String, Object> extendParams, Long templateId) {
        TaxResult mapTaxResult = ServiceInvokeUtils.invokeTaxcTpoCalculateService(Map.class, (String)"TpoYbnsrService", (String)"createMultiCnDeclareMain", (Object[])new Object[]{modelId, id, billNo, type, orgId, startData, endData, isCreate, extendParams, templateId});
        return (Map)ServiceInvokeUtils.getResultData((TaxResult)mapTaxResult);
    }

    public static Map<String, String> getOrgInfoById(Long orgId, String mainTable) {
        TaxResult mapTaxResult = ServiceInvokeUtils.invokeTaxcTpoCalculateService(Map.class, (String)"TpoYbnsrService", (String)"getOrgInfoById", (Object[])new Object[]{orgId, mainTable});
        return (Map)ServiceInvokeUtils.getResultData((TaxResult)mapTaxResult);
    }

    public static Map<String, String> getOrgInfoByIdWithEx(Long orgId, String mainTable, Map<String, Object> extendParams) {
        TaxResult mapTaxResult = ServiceInvokeUtils.invokeTaxcTpoCalculateService(Map.class, (String)"TpoYbnsrService", (String)"getOrgInfoByIdWithEx", (Object[])new Object[]{orgId, mainTable, extendParams});
        return (Map)ServiceInvokeUtils.getResultData((TaxResult)mapTaxResult);
    }

    public static Map<String, String> getOrgInfoById(long orgId, long taxSystem, String mainTable) {
        HashMap<String, String> map = new HashMap<String, String>();
        List taxMainList = (List)TaxcMainDataServiceHelper.queryTaxcMainByOrgIdsWithNoStatus(Collections.singletonList(orgId), (Long)taxSystem).getData();
        if (CollectionUtils.isEmpty((Collection)taxMainList)) {
            return map;
        }
        DynamicObject taxMain = (DynamicObject)taxMainList.get(0);
        if (taxMain != null) {
            DynamicObject taxorg = taxMain.getDynamicObject("taxorg");
            YbnsrServiceHelper.multiSet(map, "nsrsbh", TaxOrgUtil.getUnifiedsocialcodeByTaxSystem(taxorg, taxSystem), mainTable);
            YbnsrServiceHelper.multiSet(map, "nsrmc", TaxOrgUtil.getTaxpayerByTaxSystem(taxorg, taxSystem), mainTable);
            YbnsrServiceHelper.multiSet(map, "taxauthority", taxMain.getString("taxoffice.id"), mainTable);
            YbnsrServiceHelper.multiSet(map, "sshymc", taxMain.getString("codeandname.name"), mainTable);
            YbnsrServiceHelper.multiSet(map, "orgnumber", taxorg.getString("org.number"), mainTable);
            YbnsrServiceHelper.multiSet(map, "fddbrxm", taxMain.getString("legalpeople"), mainTable);
            YbnsrServiceHelper.multiSet(map, "registertype", taxMain.getString("registertype.name"), mainTable);
        }
        return map;
    }

    public static Map<String, String> getOrgInfoById(long orgId, long taxSystem, String mainTable, Map<String, Object> extendParams) {
        Map<String, String> map = YbnsrServiceHelper.getOrgInfoById(orgId, taxSystem, mainTable);
        if (null != extendParams && extendParams.size() != 0) {
            for (Map.Entry<String, Object> entry : extendParams.entrySet()) {
                if (entry.getValue() == null) continue;
                YbnsrServiceHelper.multiSet(map, entry.getKey(), entry.getValue().toString(), mainTable);
            }
        }
        return map;
    }

    public static String queryYbnsrPreMonth(String orgid, String type, String startData, String endData) {
        TaxResult stringTaxResult = ServiceInvokeUtils.invokeTaxcTpoCalculateService(String.class, (String)"TpoYbnsrService", (String)"queryYbnsrPreMonth", (Object[])new Object[]{orgid, type, startData, endData});
        return (String)ServiceInvokeUtils.getResultData((TaxResult)stringTaxResult);
    }

    public static String queryYbnsrPre(String orgid, String type, String startData, String endData, int month) {
        TaxResult stringTaxResult = ServiceInvokeUtils.invokeTaxcTpoCalculateService(String.class, (String)"TpoYbnsrService", (String)"queryYbnsrPre", (Object[])new Object[]{orgid, type, startData, endData, month});
        return (String)ServiceInvokeUtils.getResultData((TaxResult)stringTaxResult);
    }

    public static String queryYbnsrPreByDatePoint(String orgid, String type, String startData) {
        TaxResult stringTaxResult = ServiceInvokeUtils.invokeTaxcTpoCalculateService(String.class, (String)"TpoYbnsrService", (String)"queryYbnsrPreByDatePoint", (Object[])new Object[]{orgid, type, startData});
        return (String)ServiceInvokeUtils.getResultData((TaxResult)stringTaxResult);
    }

    public static String queryYbnsrPreYear(String orgid, String type, String startData, String endData) {
        TaxResult stringTaxResult = ServiceInvokeUtils.invokeTaxcTpoCalculateService(String.class, (String)"TpoYbnsrService", (String)"queryYbnsrPreYear", (Object[])new Object[]{orgid, type, startData, endData});
        return (String)ServiceInvokeUtils.getResultData((TaxResult)stringTaxResult);
    }

    public static DynamicObject queryYbnsrWithId(String sbbid) {
        TaxResult dynamicObjectTaxResult = ServiceInvokeUtils.invokeTaxcTpoServiceWithObjQuery((String)TCVAT_NSRXX, (String)DeclareConstant.ENTITY_MAIN_ALL_FIELD_STRING, (String)"TpoYbnsrService", (String)"queryYbnsrWithId", (String)"id asc", (Object[])new Object[]{sbbid});
        return (DynamicObject)ServiceInvokeUtils.getResultData((TaxResult)dynamicObjectTaxResult);
    }

    public static DynamicObject queryYbnsrWithEx(String orgid, String type, String startData, String endData, Map<String, Object> extendParams) {
        TaxResult dynamicObjectTaxResult = ServiceInvokeUtils.invokeTaxcTpoServiceWithObjQuery((String)TCVAT_NSRXX, (String)DeclareConstant.ENTITY_MAIN_ALL_FIELD_STRING, (String)"TpoYbnsrService", (String)"queryYbnsrWithEx", (String)"id asc", (Object[])new Object[]{orgid, type, startData, endData, extendParams});
        return (DynamicObject)ServiceInvokeUtils.getResultData((TaxResult)dynamicObjectTaxResult);
    }

    public static Map<String, String> getAdditionalInfo(String mainTable, boolean isCreate) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (isCreate) {
            YbnsrServiceHelper.multiSet(map, "creator", RequestContext.get().getUserId(), mainTable);
            YbnsrServiceHelper.multiSet(map, "createtime", DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"), mainTable);
        }
        YbnsrServiceHelper.multiSet(map, "billstatus", "A", mainTable);
        YbnsrServiceHelper.multiSet(map, "modifier", RequestContext.get().getUserId(), mainTable);
        YbnsrServiceHelper.multiSet(map, "modifytime", DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"), mainTable);
        return map;
    }

    private static void multiSet(Map<String, String> map, String key, String value, String mainTable) {
        if (StringUtil.isNotBlank((CharSequence)value)) {
            map.put(mainTable + SPLITSTRING + key, value);
        }
    }

    public static DynamicObject queryMultiDeclareMain(String mainTable, Long orgId, String type, String startData, String endData, QFilter extendFilter) {
        String allFieldString = MetadataUtil.getAllFieldToQuery(mainTable);
        String[] allFields = allFieldString.split(",");
        StringBuilder allFielsStringBuilder = new StringBuilder();
        for (int i = 0; i < allFields.length; ++i) {
            String str = allFields[i];
            if (!str.equals("attachment")) {
                allFielsStringBuilder.append(str);
            }
            if (i == allFields.length - 1 || str.equals("attachment")) continue;
            allFielsStringBuilder.append(",");
        }
        TaxResult dynamicObjectTaxResult = ServiceInvokeUtils.invokeTaxcTpoServiceWithObj((String)mainTable, (String)allFielsStringBuilder.toString(), (String)"TpoYbnsrService", (String)"queryMultiDeclareMain", (Object[])new Object[]{mainTable, orgId, type, startData, endData, extendFilter});
        return (DynamicObject)ServiceInvokeUtils.getResultData((TaxResult)dynamicObjectTaxResult);
    }

    public static List<DynamicObject> queryMultiDeclareMainList(String mainTable, Long orgId, String type, String startData, String endData, QFilter extendFilter) {
        String allFieldString = MetadataUtil.getAllFieldToQuery(mainTable);
        String[] allFields = allFieldString.split(",");
        StringBuilder allFielsStringBuilder = new StringBuilder();
        for (int i = 0; i < allFields.length; ++i) {
            String str = allFields[i];
            if (!str.equals("attachment")) {
                allFielsStringBuilder.append(str);
            }
            if (i == allFields.length - 1 || str.equals("attachment")) continue;
            allFielsStringBuilder.append(",");
        }
        TaxResult dynamicObjectTaxResult = ServiceInvokeUtils.invokeTaxcTpoServiceWithObj((String)mainTable, (String)allFielsStringBuilder.toString(), (String)"TpoYbnsrService", (String)"queryMultiDeclareMainList", (Object[])new Object[]{mainTable, orgId, type, startData, endData, extendFilter});
        return (List)ServiceInvokeUtils.getResultData((TaxResult)dynamicObjectTaxResult);
    }

    public static DynamicObject queryMultiDeclareMainEx(String mainTable, Long orgId, String type, String startData, String endData, Map<String, Object> saveDataDtoExtendParams) {
        String allFieldString = MetadataUtil.getAllFieldToQuery(mainTable);
        String[] allFields = allFieldString.split(",");
        StringBuilder allFielsStringBuilder = new StringBuilder();
        for (int i = 0; i < allFields.length; ++i) {
            String str = allFields[i];
            if (!str.equals("attachment")) {
                allFielsStringBuilder.append(str);
            }
            if (i == allFields.length - 1 || str.equals("attachment")) continue;
            allFielsStringBuilder.append(",");
        }
        TaxResult dynamicObjectTaxResult = ServiceInvokeUtils.invokeTaxcTpoServiceWithObj((String)mainTable, (String)allFielsStringBuilder.toString(), (String)"TpoYbnsrService", (String)"queryMultiDeclareMainEx", (Object[])new Object[]{mainTable, orgId, type, startData, endData, saveDataDtoExtendParams});
        return (DynamicObject)ServiceInvokeUtils.getResultData((TaxResult)dynamicObjectTaxResult);
    }

    public static List<DynamicObject> queryZzsSbb(List<String> orgList, String type, String startData, String endData) {
        TaxResult result = ServiceInvokeUtils.invokeTaxcTpoServiceWithObjQuery((String)TCVAT_NSRXX, (String)"declarestatus,org,id", (String)"TpoYbnsrService", (String)"queryZzsSbb", (String)"id asc", (Object[])new Object[]{orgList, type, startData, endData});
        return (List)ServiceInvokeUtils.getResultData((TaxResult)result);
    }

    public static List<DynamicObject> querySbbs(List<String> orgList, String type, String taxLimit, String startData, String endData) {
        TaxResult result = ServiceInvokeUtils.invokeTaxcTpoServiceWithObjQuery((String)TCVAT_NSRXX, (String)"declarestatus,org,id", (String)"TpoYbnsrService", (String)"querySbbs", (String)"id asc", (Object[])new Object[]{orgList, type, taxLimit, startData, endData});
        return (List)ServiceInvokeUtils.getResultData((TaxResult)result);
    }

    public static Boolean isExistsSbbs(List<String> orgList, List<String> typeList, String taxLimit, String startData, String endData) {
        TaxResult booleanTaxResult = ServiceInvokeUtils.invokeTaxcTpoCalculateService(Boolean.class, (String)"TpoYbnsrService", (String)"isExistsSbbs", (Object[])new Object[]{orgList, typeList, taxLimit, startData, endData});
        return (Boolean)ServiceInvokeUtils.getResultData((TaxResult)booleanTaxResult);
    }

    public static DynamicObject queryYbnsr(String orgid, String stype, String startData, String endData, int month, boolean dateRange, Map<String, Object> extendParams) {
        TaxResult dynamicObjectTaxResult = ServiceInvokeUtils.invokeTaxcTpoServiceWithObjQuery((String)TCVAT_NSRXX, (String)DeclareConstant.ENTITY_MAIN_ALL_FIELD_STRING, (String)"TpoYbnsrService", (String)"queryYbnsr", (String)"id asc", (Object[])new Object[]{orgid, stype, startData, endData, month, dateRange, extendParams});
        return (DynamicObject)ServiceInvokeUtils.getResultData((TaxResult)dynamicObjectTaxResult);
    }

    public static DynamicObject queryYbnsrByMainDataIdAndType(String stype, String mainDataId, Map<String, Object> extendParams) {
        TaxResult dynamicObjectTaxResult = ServiceInvokeUtils.invokeTaxcTpoServiceWithObjQuery((String)TCVAT_NSRXX, (String)DeclareConstant.ENTITY_MAIN_ALL_FIELD_STRING, (String)"TpoYbnsrService", (String)"queryYbnsrByMainDataIdAndType", (String)"id asc", (Object[])new Object[]{stype, mainDataId, extendParams});
        return (DynamicObject)ServiceInvokeUtils.getResultData((TaxResult)dynamicObjectTaxResult);
    }

    public static Map<String, DynamicObjectCollection> queryYbnsrTableByType(String type, String sbbid, String orgId, Map<String, Object> extendParams) {
        HashMap<String, DynamicObjectCollection> map = new HashMap<String, DynamicObjectCollection>();
        TaxResult result = ServiceInvokeUtils.invokeTaxcTpoCalculateService(Map.class, (String)"TpoYbnsrService", (String)"queryYbnsrTableByType", (Object[])new Object[]{type, sbbid, orgId, extendParams});
        if (result.isSuccess()) {
            Map data = (Map)result.getData();
            for (Map.Entry entry : data.entrySet()) {
                String entity = (String)entry.getKey();
                List pks = (List)entry.getValue();
                DynamicObjectCollection temp = QueryServiceHelper.query((String)entity, (String)MetadataUtil.getAllFieldStringNoCollection(entity), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pks)});
                map.put(entity, temp);
            }
        }
        return map;
    }

    public static Map<String, DynamicObjectCollection> queryYbnsrTable(String sbbid, Map<String, String> tableMap) {
        HashMap<String, DynamicObjectCollection> map = new HashMap<String, DynamicObjectCollection>();
        TaxResult result = ServiceInvokeUtils.invokeTaxcTpoCalculateService(Map.class, (String)"TpoYbnsrService", (String)"queryYbnsrTable", (Object[])new Object[]{sbbid, tableMap});
        if (result.isSuccess()) {
            Map data = (Map)result.getData();
            for (Map.Entry entry : data.entrySet()) {
                String entity = (String)entry.getKey();
                List pks = (List)entry.getValue();
                DynamicObjectCollection temp = QueryServiceHelper.query((String)entity, (String)MetadataUtil.getAllFieldStringNoCollection(entity), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pks)});
                map.put(entity, temp);
            }
        }
        return map;
    }

    public static Boolean deleteYbnsrTable(String type, String sbbid, String orgId, Map<String, Object> extendParams) {
        TaxResult booleanTaxResult = ServiceInvokeUtils.invokeTaxcTpoCalculateService(Boolean.class, (String)"TpoYbnsrService", (String)"deleteYbnsrTable", (Object[])new Object[]{type, sbbid, orgId, extendParams});
        return (Boolean)ServiceInvokeUtils.getResultData((TaxResult)booleanTaxResult);
    }

    public static Boolean deleteYbnsrTableByTableMap(String type, String sbbid, String orgId, Map<String, Object> extendParams, Map<String, String> tableMap) {
        TaxResult booleanTaxResult = ServiceInvokeUtils.invokeTaxcTpoCalculateService(Boolean.class, (String)"TpoYbnsrService", (String)"deleteYbnsrTableByTableMap", (Object[])new Object[]{type, sbbid, orgId, extendParams, tableMap});
        return (Boolean)ServiceInvokeUtils.getResultData((TaxResult)booleanTaxResult);
    }

    public static Boolean deleteYbnsrTableById(String sbbid) {
        TaxResult booleanTaxResult = ServiceInvokeUtils.invokeTaxcTpoCalculateService(Boolean.class, (String)"TpoYbnsrService", (String)"deleteYbnsrTableById", (Object[])new Object[]{sbbid});
        return (Boolean)ServiceInvokeUtils.getResultData((TaxResult)booleanTaxResult);
    }

    public static Boolean resetYbnsrTable(String sbbid, String strTempId) {
        TaxResult booleanTaxResult = ServiceInvokeUtils.invokeTaxcTpoCalculateService(Boolean.class, (String)"TpoYbnsrService", (String)"resetYbnsrTable", (Object[])new Object[]{sbbid, strTempId});
        return (Boolean)ServiceInvokeUtils.getResultData((TaxResult)booleanTaxResult);
    }
}

