/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.history;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.constant.RuleTypeEnum;
import kd.taxc.bdtaxr.common.util.RuleUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;

public class BaseDataHistoryService {
    private static final String HISTORY_ENTRY = "tctb_history_record";
    private static final String ORG_ID = "orgid";
    private static final String START_DATE = "startdate";
    private static final String END_DATE = "enddate";
    private static final String TYPE = "type";
    private static final String RECORD_ENTITY = "entityname";
    private static final String RECORD = "record_tag";
    public static final String TAXINFO_KEY = "tctb_tax_main";
    public static final String SUMMARYSCHEME_KEY = "tctb_org_group_latest";
    public static final String TAXRULE_KEY = "tcvat_rule";
    private static final String[] entryNameArr = new String[]{"tctb_tax_main", "tctb_org_group_latest", "tcvat_rule"};

    public static boolean saveBaseDataHistory(long orgid, Date startDate, Date endDate) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        for (int i = 0; i < entryNameArr.length; ++i) {
            QFilter q1;
            QFilter q;
            DynamicObject pkObj;
            if (TAXRULE_KEY.equals(entryNameArr[i])) {
                Map<RuleTypeEnum, List<DynamicObject>> rules = RuleUtils.getSharingAndOrgRules(orgid, RuleTypeEnum.ALL, null, "nssb");
                String jsonStr = SerializationUtils.toJsonString(rules);
                list.add(BaseDataHistoryService.createDynamicObject(orgid, startDate, endDate, entryNameArr[i], jsonStr));
                continue;
            }
            if (SUMMARYSCHEME_KEY.equals(entryNameArr[i])) {
                DynamicObject[] collect = BusinessDataServiceHelper.load((String)SUMMARYSCHEME_KEY, (String)"id", (QFilter[])new QFilter[]{new QFilter("taxtype", "=", (Object)"zzs")});
                ArrayList<DynamicObject> cList = new ArrayList<DynamicObject>();
                if (collect != null && collect.length != 0) {
                    Object[] ids = Arrays.stream(collect).map(d -> d.getLong("id")).toArray();
                    DynamicObject[] datas = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)SUMMARYSCHEME_KEY));
                    cList.addAll(Arrays.asList(datas));
                }
                if (cList.isEmpty()) continue;
                String jsonStr = SerializationUtils.toJsonString(cList);
                list.add(BaseDataHistoryService.createDynamicObject(orgid, startDate, endDate, entryNameArr[i], jsonStr));
                continue;
            }
            if (!TAXINFO_KEY.equals(entryNameArr[i]) || (pkObj = BusinessDataServiceHelper.loadSingle((String)entryNameArr[i], (String)"id", (QFilter[])new QFilter[]{q = new QFilter(ORG_ID, "=", (Object)orgid), q1 = new QFilter("taxationsys", "=", (Object)1L)})) == null) continue;
            ArrayList<DynamicObject> infoList = new ArrayList<DynamicObject>();
            DynamicObject dObj = BusinessDataServiceHelper.loadSingle((Object)pkObj.getLong("id"), (String)entryNameArr[i]);
            infoList.add(dObj);
            String jsonStr = SerializationUtils.toJsonString(infoList);
            list.add(BaseDataHistoryService.createDynamicObject(orgid, startDate, endDate, entryNameArr[i], jsonStr));
        }
        if (list.size() == 0) {
            return true;
        }
        DynamicObject[] dArr = new DynamicObject[list.size()];
        dArr = list.toArray(dArr);
        DeleteServiceHelper.delete((String)HISTORY_ENTRY, (QFilter[])new QFilter[]{new QFilter(ORG_ID, "=", (Object)String.valueOf(orgid)).and(START_DATE, "=", (Object)startDate).and(END_DATE, "=", (Object)endDate)});
        SaveServiceHelper.save((DynamicObject[])dArr);
        return true;
    }

    public static String queryBaseDataHistory(long orgid, String type, Date startDate, Date endDate) {
        QFilter q = new QFilter(ORG_ID, "=", (Object)String.valueOf(orgid)).and(TYPE, "=", (Object)type).and(START_DATE, ">=", (Object)DateUtils.getDayFirst(startDate)).and(END_DATE, "<=", (Object)DateUtils.getDayLast(endDate));
        DynamicObject dobj = BusinessDataServiceHelper.loadSingle((String)HISTORY_ENTRY, (String)"record_tag,entityname", (QFilter[])new QFilter[]{q});
        String record = "";
        if (dobj != null) {
            record = dobj.getString(RECORD);
        }
        return record;
    }

    public static DynamicObject createDynamicObject(long orgId, Date startDate, Date endDate, String type, String record) {
        DynamicObject dispatchorder = BusinessDataServiceHelper.newDynamicObject((String)HISTORY_ENTRY);
        dispatchorder.set(ORG_ID, (Object)orgId);
        dispatchorder.set(START_DATE, (Object)startDate);
        dispatchorder.set(END_DATE, (Object)endDate);
        dispatchorder.set(TYPE, (Object)type);
        dispatchorder.set(RECORD, (Object)record);
        return dispatchorder;
    }
}

