/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.impt;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.TaxTypeComboEnum;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.impt.TcvatEntryEntityVatRateEnum;
import kd.taxc.bdtaxr.common.impt.TcvatRuleEntryEntityEnum;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.bean.BeanCopyUtils;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import org.apache.commons.collections.map.CaseInsensitiveMap;

public class ImportRulePlugin
extends BatchImportPlugin {
    private String ybnsr = ResManager.loadKDString((String)"\u4e00\u822c\u7eb3\u7a0e\u4eba", (String)"ImportRulePlugin_31", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
    private String privateRule = ResManager.loadKDString((String)"\u81ea\u7528\u89c4\u5219", (String)"ImportRulePlugin_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
    private static Log LOG = LogFactory.getLog(ImportRulePlugin.class);
    private static Map<String, String> taxtypeMap = new CaseInsensitiveMap();
    private String YES = ResManager.loadKDString((String)"\u662f", (String)"ImportRulePlugin_25", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
    private String NO = ResManager.loadKDString((String)"\u5426", (String)"ImportRulePlugin_26", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
    private static Map<String, Long> ruleFormIdToGroupId;
    private Map<String, Long> orgMap = new HashMap<String, Long>();
    private Map<Long, String> orgNameMap = new HashMap<Long, String>();

    public String getDefaultKeyFields() {
        return "org,number";
    }

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        Iterator<ImportBillData> it = billdatas.iterator();
        while (it.hasNext()) {
            JSONObject importData;
            ImportBillData data = it.next();
            int index = data.getStartIndex();
            String entityType = data.getEntityMapping().getEntityType().getName();
            String orgNumber = (String)((Map)data.getData().get((Object)"org")).get("number");
            Long orgId = this.orgMap.get(orgNumber);
            String publicType = ResManager.loadKDString((String)"\u53ef\u5206\u914d\u89c4\u5219", (String)"ImportRulePlugin_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
            String privateType = this.privateRule;
            if ("tcret_rule_fcczzj".equals(entityType)) {
                importData = data.getData();
                String ruletype = importData.getString("ruletype");
                JSONObject leasecontractno = importData.getJSONObject("leasecontractno");
                if (publicType.equals(ruletype) && leasecontractno != null) {
                    logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u89c4\u5219\u7c7b\u578b\u4e3a(\u53ef\u5206\u914d\u89c4\u5219)\u65e0\u987b\u586b\u5199\u79df\u8d41\u9879\u76ee", (String)"ImportRulePlugin_2", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), orgNumber)).fail();
                    it.remove();
                    continue;
                }
                if (privateType.equals(ruletype) && leasecontractno == null) {
                    logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u89c4\u5219\u7c7b\u578b\u4e3a(\u81ea\u7528\u89c4\u5219)\u5fc5\u987b\u586b\u5199\u79df\u8d41\u9879\u76ee", (String)"ImportRulePlugin_3", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), orgNumber)).fail();
                    it.remove();
                    continue;
                }
                if (!publicType.equals(ruletype) && !privateType.equals(ruletype)) {
                    logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u89c4\u5219\u7c7b\u578b\u53ea\u80fd\u4e3a(\u53ef\u5206\u914d\u89c4\u5219)\u6216(\u81ea\u7528\u89c4\u5219)", (String)"ImportRulePlugin_4", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), orgNumber)).fail();
                    it.remove();
                    continue;
                }
            }
            if ("tcvat_rule_income".equals(entityType)) {
                importData = data.getData();
                if (importData.getJSONObject("taxrate") == null) {
                    return;
                }
                this.doSetTcvatRuleIncomeVatRate(importData);
                String msg = this.getCheckWsclMsg(importData, orgNumber);
                if (msg != null) {
                    logger.log(Integer.valueOf(index), msg).fail();
                    it.remove();
                    continue;
                }
            }
            if ("tcvat_rule_deduct".equals(entityType)) {
                importData = data.getData();
                JSONObject deduct = importData.getJSONObject("deducttype");
                if (Objects.isNull(deduct)) {
                    logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u201c*\u62b5\u6263\u7c7b\u578b.\u7f16\u7801\u201d\u4e3a\u7a7a\uff0c\u8bf7\u8865\u5168", (String)"ImportRulePlugin_5", (String)"taxc-bdtaxr-common", (Object[])new Object[0])).fail();
                    it.remove();
                    continue;
                }
                String deducttype = deduct.getString("number");
                String rulepurpose = importData.getString("rulepurpose");
                if (Objects.isNull(rulepurpose)) {
                    logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u201c*\u89c4\u5219\u7528\u9014\u201d\u4e3a\u7a7a\uff0c\u8bf7\u8865\u5168", (String)"ImportRulePlugin_6", (String)"taxc-bdtaxr-common", (Object[])new Object[0])).fail();
                    it.remove();
                    continue;
                }
                JSONArray entryentity = importData.getJSONArray("entryentity");
                if ("VAT_JXDK_BQDK_9".equals(deducttype) && !entryentity.isEmpty()) {
                    logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u201c\u62b5\u6263\u7c7b\u578b\u201d\u4e3a\u201c\u4ee3\u6263\u4ee3\u7f34\u7a0e\u6536\u7f34\u6b3e\u51ed\u8bc1\u201d\u65f6\uff0c\u65e0\u9700\u914d\u7f6e\u201c\u91d1\u989d\u201d\u53d6\u6570\u89c4\u5219\uff0c\u8bf7\u518d\u6b21\u786e\u8ba4\u3002", (String)"ImportRulePlugin_11", (String)"taxc-bdtaxr-common", (Object[])new Object[0])).fail();
                    it.remove();
                    continue;
                }
            }
            if ("tcvat_rule_diff".equals(entityType)) {
                importData = data.getData();
                JSONObject difftype = importData.getJSONObject("difftype");
                String jzjt = importData.getString("jzjt");
                LOG.info("tcvat_rule_diff import param  difftype={},jzjt={},importData={}", new Object[]{difftype, jzjt, importData});
                if (Objects.isNull(difftype)) {
                    logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u5dee\u989d\u6263\u9664\u7c7b\u578b\u201d\u3002", (String)"ImportRulePlugin_21", (String)"taxc-bdtaxr-common", (Object[])new Object[0])).fail();
                    it.remove();
                    continue;
                }
                if ("859352590188589062".equals(difftype.get((Object)"id")) && this.YES.equals(jzjt)) {
                    logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u201c\u5dee\u989d\u6263\u9664\u7c7b\u578b\u201d=\u201c\u514d\u62b5\u9000\u7a0e\u7684\u9879\u76ee\u201d\u65f6\uff0c\u201c\u5373\u5f81\u5373\u9000\u4e1a\u52a1\u201d\u4e0d\u80fd\u7b49\u4e8e\u201c\u662f\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ImportRulePlugin_22", (String)"taxc-bdtaxr-common", (Object[])new Object[0])).fail();
                    it.remove();
                    continue;
                }
                if ("859352590188589063".equals(difftype.get((Object)"id")) && this.YES.equals(jzjt)) {
                    logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u201c\u5dee\u989d\u6263\u9664\u7c7b\u578b\u201d=\u201c\u514d\u7a0e\u7684\u9879\u76ee\u201d\u65f6\uff0c\u201c\u5373\u5f81\u5373\u9000\u4e1a\u52a1\u201d\u4e0d\u80fd\u7b49\u4e8e\u201c\u662f\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ImportRulePlugin_23", (String)"taxc-bdtaxr-common", (Object[])new Object[0])).fail();
                    it.remove();
                    continue;
                }
                if (this.YES.equals(jzjt) && this.YES.equals(importData.getString("qzkce")) && !importData.getJSONArray("entryentity1").isEmpty()) {
                    logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u201c\u53d6\u81ea\u6263\u9664\u989d\uff08\u672c\u671f\u53d1\u751f\u989d\uff09\u201d\u7684\u5f00\u5173\u5df2\u6253\u5f00\uff0c\u65e0\u9700\u518d\u586b\u5199\u201c\u672c\u671f\u5b9e\u9645\u6263\u9664\u989d\u53d6\u6570\u89c4\u5219\u201d\u3002\u8bf7\u786e\u8ba4\u662f\u6253\u5f00\u914d\u7f6e\u5f00\u5173\u8fd8\u662f\u586b\u5199\u201c\u672c\u671f\u5b9e\u9645\u6263\u9664\u989d\u53d6\u6570\u89c4\u5219\u201d", (String)"ImportRulePlugin_24", (String)"taxc-bdtaxr-common", (Object[])new Object[0])).fail();
                    it.remove();
                    continue;
                }
                if ("859352590188589063".equals(difftype.get((Object)"id")) && this.NO.equals(jzjt) && this.YES.equals(importData.getString("qzkce")) && !importData.getJSONArray("entryentity1").isEmpty()) {
                    logger.log(Integer.valueOf(index), ResManager.loadKDString((String)"\u201c\u53d6\u81ea\u6263\u9664\u989d\uff08\u672c\u671f\u53d1\u751f\u989d\uff09\u201d\u7684\u5f00\u5173\u5df2\u6253\u5f00\uff0c\u65e0\u9700\u518d\u586b\u5199\u201c\u672c\u671f\u5b9e\u9645\u6263\u9664\u989d\u53d6\u6570\u89c4\u5219\u201d\u3002\u8bf7\u786e\u8ba4\u662f\u6253\u5f00\u914d\u7f6e\u5f00\u5173\u8fd8\u662f\u586b\u5199\u201c\u672c\u671f\u5b9e\u9645\u6263\u9664\u989d\u53d6\u6570\u89c4\u5219\u201d", (String)"ImportRulePlugin_24", (String)"taxc-bdtaxr-common", (Object[])new Object[0])).fail();
                    it.remove();
                    continue;
                }
                if (ResManager.loadKDString((String)"\u4e00\u822c\u7eb3\u7a0e\u4eba", (String)"TaxConstant_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]).equals(importData.getString("taxpayertype")) && "859352590188589063".equals(difftype.get((Object)"id")) && !"fseandkce".equals(importData.getString("deductproject"))) {
                    logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u201c\u514d\u7a0e\u7684\u9879\u76ee\u201d\u7684\u89c4\u5219\u5361\u7247\u7684\u201c\u6263\u9664\u9879\u76ee\u201d\u53ea\u80fd\u9009\u62e9\u201c\u672c\u671f\u53d1\u751f\u989d\u548c\u5b9e\u9645\u6263\u9664\u989d\u201d\uff0c\u7f16\u7801%s\u7684\u6263\u9664\u9879\u76ee\u6709\u8bef\u3002", (String)"ImportRulePlugin_27", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), importData.getString("number"))).fail();
                    it.remove();
                    continue;
                }
                String diffRuleExists = this.isDiffRuleExists(importData);
                if (StringUtil.isNotEmpty((CharSequence)diffRuleExists)) {
                    logger.log(Integer.valueOf(index), diffRuleExists).fail();
                    it.remove();
                    continue;
                }
            }
            if (TcvatRuleEntryEntityEnum.containsKey(entityType)) {
                this.doCheckTcvatRate(logger, it, data);
            }
            if (orgId != null) continue;
            QFilter qFilter = new QFilter("number", "=", (Object)orgNumber);
            DynamicObject org = QueryServiceHelper.queryOne((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{qFilter});
            if (org != null) {
                orgId = org.getLong("id");
                String taxtype = taxtypeMap.get(this.ctx.getAppId());
                TaxTypeComboEnum taxTypeComboEnum = TaxTypeComboEnum.getEnumByCode(taxtype);
                TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainCategoryByOrgIdsAndTaxtype(Collections.singletonList(orgId), (String)taxtype);
                if (EmptyCheckUtils.isNotEmpty(result.getData())) {
                    DynamicObject object = (DynamicObject)((List)result.getData()).get(0);
                    DynamicObjectCollection categoryentryentity = object.getDynamicObjectCollection("categoryentryentity");
                    boolean checkCategoryEnable = this.doCheckCategoryEnable(data, entityType, publicType);
                    if (checkCategoryEnable && (EmptyCheckUtils.isEmpty(categoryentryentity) || Objects.equals("0", ((DynamicObject)categoryentryentity.get(0)).getString("enable")))) {
                        logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7ec4\u7ec7%2$s\u7a0e\u79cd\u5c1a\u672a\u542f\u7528\uff0c\u5982\u9700\u64cd\u4f5c,\u8bf7\u524d\u5f80\u7a0e\u52a1\u4e91-\u57fa\u7840\u8bbe\u7f6e-\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u8fdb\u884c\u542f\u7528", (String)"ImportRulePlugin_12", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), orgNumber, taxTypeComboEnum.getTitle())).fail();
                        it.remove();
                        continue;
                    }
                } else {
                    logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u201c%s\u201d\u5c1a\u672a\u5f55\u5165\u4f01\u4e1a\u4fe1\u606f\uff0c\u8bf7\u5148\u5230\u57fa\u7840\u8bbe\u7f6e-\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u754c\u9762\u5f55\u5165\u4f01\u4e1a\u4fe1\u606f", (String)"ImportRulePlugin_13", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), orgNumber)).fail();
                    it.remove();
                    continue;
                }
                this.orgMap.put(orgNumber, orgId);
                continue;
            }
            logger.log(Integer.valueOf(index), String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u6570\u636e\u4e0d\u5b58\u5728\uff1a\u7ec4\u7ec7 # org.number\u201c%s\u201d", (String)"ImportRulePlugin_14", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), orgNumber)).fail();
            it.remove();
        }
        super.beforeSave(billdatas, logger);
    }

    private String isDiffRuleExists(JSONObject importData) {
        String diffType = importData.getJSONObject("difftype").getString("number");
        String ruleType = importData.getString("ruletype");
        String deductProject = importData.getString("deductproject");
        String enable = importData.getString("enable");
        if ("private".equals(ruleType) && "bqsjkce".equals(deductProject) && !"VAT_CEKCLX_008".equals(diffType) && "1".equals(enable)) {
            DynamicObject dbRule;
            String dbRulePurpose;
            String org = importData.getString("org");
            String taxpayertype = importData.getString("taxpayertype");
            String rulepurpose = importData.getString("rulepurpose");
            QFilter orgFilter = new QFilter("org", "=", (Object)org);
            QFilter taxpayertypeFilter = new QFilter("taxpayertype", "=", (Object)taxpayertype);
            QFilter difftypeFilter = new QFilter("difftype", "=", (Object)diffType);
            QFilter ruletypeFilter = new QFilter("ruletype", "=", (Object)"private");
            QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
            DynamicObjectCollection rules = QueryServiceHelper.query((String)"tcvat_rule_diff", (String)"rulepurpose", (QFilter[])new QFilter[]{orgFilter, taxpayertypeFilter, difftypeFilter, ruletypeFilter, enableFilter});
            if (!CollectionUtils.isEmpty((Collection)rules) && this.rulePurposeExists(dbRulePurpose = (dbRule = (DynamicObject)rules.get(0)).getString("rulepurpose"), rulepurpose)) {
                return String.format(ResManager.loadKDString((String)"\u6b64\u7a0e\u52a1\u7ec4\u7ec7\u5df2\u5b58\u5728\u540c\u4e00\u4e2a\u5dee\u989d\u6263\u9664\u7c7b\u578b\u7684\u672c\u671f\u5b9e\u9645\u6263\u9664\u989d\u89c4\u5219\u914d\u7f6e%s\uff0c\u8bf7\u52ff\u91cd\u65b0\u914d\u7f6e\u3002", (String)"ImportRulePlugin_28", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), dbRule.getString("number"));
            }
        }
        return null;
    }

    private boolean rulePurposeExists(String dbRulePurpose, String rulePurpose) {
        String[] split1 = dbRulePurpose.split(dbRulePurpose);
        List<String> split1Arr = Arrays.asList(split1);
        String[] split2 = dbRulePurpose.split(rulePurpose);
        List<String> split2Arr = Arrays.asList(split2);
        split1Arr.retainAll(split2Arr);
        return !CollectionUtils.isEmpty(split1Arr);
    }

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        ApiResult saveResult = super.save(rowdatas, logger);
        this.tcvatRuleImportSyncData(saveResult);
        return saveResult;
    }

    private void tcvatRuleImportSyncData(ApiResult saveResult) {
        List data = (List)saveResult.getData();
        for (Map datum : data) {
            if (!((Boolean)datum.get("success")).booleanValue()) continue;
            Long groupId = ruleFormIdToGroupId.get(this.getBillFormId());
            if (null == groupId) break;
            DynamicObject ruleObject = BusinessDataServiceHelper.loadSingle(datum.get("id"), (String)this.getBillFormId());
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"tcvat_all_rule_config");
            dynamicObject.set("issystem", (Object)"0");
            BeanCopyUtils.copyDynamicObjectWithoutEntity(ruleObject, dynamicObject);
            dynamicObject.set("group", (Object)groupId);
            if (QueryServiceHelper.exists((String)"tcvat_all_rule_config", datum.get("id"))) {
                SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{dynamicObject});
                continue;
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        }
    }

    private boolean doCheckCategoryEnable(ImportBillData data, String entityType, String publicType) {
        String ruletype;
        JSONObject importData = data.getData();
        return importData == null || !publicType.equals(ruletype = importData.getString("ruletype")) || !Lists.newArrayList((Object[])new String[]{"tcsd_rule_yshtpz", "tcsd_rule_cqzysj", "tcsd_rule_zjzb"}).contains(entityType);
    }

    private void doCheckTcvatRate(ImportLogger logger, Iterator<ImportBillData> it, ImportBillData data) {
        int index = data.getStartIndex();
        String entityType = data.getEntityMapping().getEntityType().getName();
        List<TcvatEntryEntityVatRateEnum> vatRateEnums = TcvatRuleEntryEntityEnum.get(entityType);
        vatRateEnums.forEach(v -> {
            if (this.checkVatRate(logger, data.getData(), index, (TcvatEntryEntityVatRateEnum)((Object)v))) {
                it.remove();
            }
        });
    }

    private boolean checkVatRate(ImportLogger logger, JSONObject importData, int index, TcvatEntryEntityVatRateEnum vatRateEnum) {
        JSONArray entryentity = importData.getJSONArray(vatRateEnum.getEntryEntity());
        for (int i = 0; i < entryentity.size(); ++i) {
            JSONObject jsonObject = entryentity.getJSONObject(i);
            String datatype = jsonObject.getString(vatRateEnum.getDataTypeField());
            String taxrate = jsonObject.getString(vatRateEnum.getVatRateField());
            String dataTypeZJQS = ResManager.loadKDString((String)"\u76f4\u63a5\u53d6\u6570", (String)"ImportRulePlugin_15", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
            if (datatype.equals(dataTypeZJQS)) {
                if (taxrate == null || new BigDecimal(taxrate).compareTo(BigDecimal.ZERO) == 0) continue;
                logger.log(Integer.valueOf(index + i), ResManager.loadKDString((String)"\u89c4\u5219\u4e2d\u53d6\u6570\u65b9\u5f0f=\u201c\u76f4\u63a5\u53d6\u6570\u201d\u65f6\uff0c\u65e0\u9700\u914d\u7f6e\u201c\u589e\u503c\u7a0e\u7a0e\u7387/\u5f81\u6536\u7387\u201d,\u8bf7\u5220\u9664\u5e76\u91cd\u65b0\u5f15\u5165", (String)"ImportRulePlugin_16", (String)"taxc-bdtaxr-common", (Object[])new Object[0])).fail();
                return true;
            }
            if (taxrate != null && new BigDecimal(taxrate).compareTo(BigDecimal.ZERO) > 0 && new BigDecimal(taxrate).compareTo(new BigDecimal(1)) <= 0) continue;
            logger.log(Integer.valueOf(index + i), ResManager.loadKDString((String)"\u89c4\u5219\u4e2d\u53d6\u6570\u65b9\u5f0f\u2260\u76f4\u63a5\u53d6\u6570\u201d\u65f6\uff0c\u201c\u589e\u503c\u7a0e\u7a0e\u7387/\u5f81\u6536\u7387\u201d\u9700\u5728(0,1]\u5185\uff0c\u8bf7\u91cd\u65b0\u586b\u5199", (String)"ImportRulePlugin_17", (String)"taxc-bdtaxr-common", (Object[])new Object[0])).fail();
            return true;
        }
        return false;
    }

    private void doSetTcvatRuleIncomeVatRate(JSONObject importData) {
        Long id = importData.getJSONObject("taxrate").getLong("id");
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"tpo_tcvat_taxrates", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
        if (dynamicObject != null) {
            String number = dynamicObject.getString("number");
            BigDecimal rate = BigDecimal.ZERO;
            try {
                rate = new BigDecimal(number.replace("%", "")).divide(new BigDecimal(100)).setScale(4);
            }
            catch (Exception exception) {
                // empty catch block
            }
            JSONArray entryentity = importData.getJSONArray("entryentity");
            for (int i = 0; i < entryentity.size(); ++i) {
                JSONObject entity = (JSONObject)entryentity.get(i);
                if (entity.get((Object)"entryentityconfjson") != null) continue;
                entity.put("entryentityconfjson", (Object)rate.toString());
            }
        }
    }

    private String getCheckWsclMsg(JSONObject importData, String orgNumber) {
        String nrjzjtjs;
        String msg = null;
        if (ResManager.loadKDString((String)"\u662f", (String)"ImportRulePlugin_8", (String)"taxc-bdtaxr-common", (Object[])new Object[0]).equals(importData.getString("iswkpwscl"))) {
            if (ResManager.loadKDString((String)"\u5c0f\u89c4\u6a21\u7eb3\u7a0e\u4eba", (String)"ImportRulePlugin_18", (String)"taxc-bdtaxr-common", (Object[])new Object[0]).equals(importData.getString("taxpayertype"))) {
                msg = ResManager.loadKDString((String)"\u201c\u5c0f\u89c4\u6a21\u7eb3\u7a0e\u4eba\u201d\u6682\u4e0d\u652f\u6301\u201c\u5c3e\u6570\u5904\u7406\u201d\u5f00\u5173\u6253\u5f00\uff0c\u8bf7\u6539\u4e3a\u201c\u5173\u201d\u3002", (String)"ImportRulePlugin_19", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
            } else if (!ResManager.loadKDString((String)"\u662f", (String)"ImportRulePlugin_8", (String)"taxc-bdtaxr-common", (Object[])new Object[0]).equals(importData.getString("wkpseqs"))) {
                msg = ResManager.loadKDString((String)" \u201c\u914d\u7f6e\u7a0e\u989d\u53d6\u6570\u201d=\u201c\u5173\u201d\u65f6\uff0c\u201c\u5c3e\u6570\u5904\u7406\u201d\u5217\u65e0\u9700\u6253\u5f00\uff0c\u8bf7\u6539\u4e3a\u201c\u5173\u201d\u3002", (String)"ImportRulePlugin_20", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
            }
        }
        if (StringUtil.isEmpty((CharSequence)(nrjzjtjs = importData.getString("nrjzjtjs")))) {
            msg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u7eb3\u5165\u8fdb\u9879\u5373\u5f81\u5373\u9000\u5206\u644a\u8ba1\u7b97\u201d\u3002\u5982\u65e0\u8fdb\u9879\u5373\u5f81\u5373\u9000\u7684\u7279\u6b8a\u5904\u7406\uff08\u5373\u65e0\u6cd5\u5212\u5206\u7684\u8fdb\u9879\u7a0e\u989d\u8ba1\u7b97\u65f6\u7684\u5206\u6bcd\uff08\u5373\u603b\u9500\u552e\u989d\uff09\u7684\u53e3\u5f84\u65e0\u7279\u6b8a\u5904\u7406\uff09\uff0c\u8bf7\u9009\u62e9\u201c\u5426\u201d\u3002", (String)"ImportRulePlugin_29", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
        } else {
            String orgname = "";
            Long orgId = this.orgMap.get(orgNumber);
            if (orgId == null) {
                QFilter qFilter = new QFilter("number", "=", (Object)orgNumber);
                DynamicObject org = QueryServiceHelper.queryOne((String)"bos_org", (String)"id,name", (QFilter[])new QFilter[]{qFilter});
                if (org != null) {
                    orgId = org.getLong("id");
                    orgname = org.getString("name");
                    this.orgMap.put(orgNumber, orgId);
                    this.orgNameMap.put(orgId, orgname);
                }
            } else {
                orgname = this.orgNameMap.get(orgId);
            }
            if (orgId != null) {
                String ruletype = importData.getString("ruletype");
                String taxpayertype = importData.getString("taxpayertype");
                if (this.ybnsr.equals(taxpayertype) && this.privateRule.equals(ruletype)) {
                    boolean jzjttsclB;
                    Object jzjttscl = SystemParamUtil.getAppParameter("tcvat", "jzjttscl", orgId);
                    boolean bl = jzjttsclB = jzjttscl != null && (Boolean)jzjttscl != false;
                    if (this.NO.equals(nrjzjtjs) && !jzjttsclB) {
                        msg = String.format(ResManager.loadKDString((String)"%1$s\u7684\u7cfb\u7edf\u53c2\u6570\u201c\u5373\u5f81\u5373\u9000\u8fdb\u9879\u7a0e\u989d\u5206\u644a\u6bd4\u4f8b\u8ba1\u7b97\u7684\u6536\u5165\u7279\u6b8a\u5904\u7406\u201d\u672a\u6253\u5f00\uff0c\u4e0d\u652f\u6301\u5f55\u5165\u201c\u7eb3\u5165\u8fdb\u9879\u5373\u5f81\u5373\u9000\u5206\u644a\u8ba1\u7b97\u201d=\u201c\u5426\u201d\u7684\u89c4\u5219\u3002", (String)"ImportRulePlugin_30", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), orgname);
                    }
                }
            }
        }
        return msg;
    }

    static {
        taxtypeMap.put("tcvat", "zzs");
        taxtypeMap.put("tccit", "qysds");
        taxtypeMap.put("tcsd", "yhs");
        taxtypeMap.put("tcret", "fcscztdsys");
        ruleFormIdToGroupId = new CaseInsensitiveMap(){
            {
                this.put("tcvat_rule_income", 1870263476069751808L);
                this.put("tcvat_rule_rollout", 1870265525532515328L);
                this.put("tcvat_rule_deduct", 1870264820906220544L);
                this.put("tcvat_rule_jzjt_jxse", 1952160271401603072L);
                this.put("tcvat_rule_diff", 1870264280101051392L);
                this.put("tcvat_rule_perpre", 1870265821113505792L);
                this.put("tcvat_rule_deduction", 1870266078643771392L);
                this.put("tcvat_rule_mdts", 1870266309020112896L);
                this.put("tcvat_rule_prepay", 1889922790833095680L);
                this.put("tcvat_rule_apportion", 1890543755803520000L);
                this.put("tcvat_rule_wkpsr", 1890632930188217344L);
                this.put("tcvat_ncp_product_rule", 1891260790015877120L);
                this.put("tcvat_ncp_rule", 1891260951278477312L);
                this.put("tcvat_rule_refund", 1891379881984783360L);
                this.put("tcvat_rule_incomeproject", 1891408507782290432L);
                this.put("tcvat_rule_outputproject", 1891408824250915840L);
            }
        };
    }
}

