/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.license.plugin.zerodeclare;

import com.alibaba.fastjson.JSONObject;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.taxc.bdtaxr.common.helper.bastax.taxcorg.TaxcOrgDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.helper.LicenseCheckServiceHelper;

public abstract class AbstractLicenseCheckBatchImportPlugin
extends BatchImportPlugin {
    public abstract String getAppId();

    public String getZeroDeclareKey() {
        return "zerodeclare";
    }

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        Iterator<ImportBillData> it = rowdatas.iterator();
        while (it.hasNext()) {
            StringBuilder message = new StringBuilder();
            ImportBillData data = it.next();
            this.validBillData(data, message);
            if (!StringUtils.isNotBlank((CharSequence)message.toString())) continue;
            logger.log(Integer.valueOf(data.getStartIndex()), message.toString()).fail();
            it.remove();
        }
        return super.save(rowdatas, logger);
    }

    public void validBillData(ImportBillData importBillData, StringBuilder message) {
        JSONObject data = importBillData.getData();
        JSONObject orgJsonObject = data.getJSONObject("org");
        if (orgJsonObject == null) {
            return;
        }
        String orgNumber = orgJsonObject.getString("number") != null ? orgJsonObject.getString("number") : "";
        AbstractLicenseCheckBatchImportPlugin.checkOrg(orgNumber, AbstractLicenseCheckBatchImportPlugin.queryOrgId(orgNumber), message, this.getAppId(), this.getZeroDeclareKey());
    }

    private static void checkOrg(String orgNumber, Long orgid, StringBuilder message, String appid, String zeroDeclareParamKey) {
        boolean notAuthorize = LicenseCheckServiceHelper.isOrgNotAuthorize(orgid, null, appid, zeroDeclareParamKey);
        if (notAuthorize) {
            message.append(ResManager.loadKDString((String)"%s\u7ec4\u7ec7\u672a\u6fc0\u6d3b\u7a0e\u52a1\u4e91\u8bb8\u53ef\u3002", (String)"AbstractLicenseCheckBatchImportPlugin_1", (String)"taxc-bdtaxr-common", (Object[])new Object[]{orgNumber}));
        }
    }

    private static Long queryOrgId(String orgNumber) {
        return (Long)TaxcOrgDataServiceHelper.queryTaxcOrgIdByOrgNum((String)orgNumber).getData();
    }
}

