/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.mq.draft;

import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.constant.TemplateTypeConstant;
import kd.taxc.bdtaxr.common.mq.DeclareMQEvent;
import kd.taxc.bdtaxr.common.mq.MQSender;
import kd.taxc.bdtaxr.common.mq.draft.DraftMQMessage;
import kd.taxc.bdtaxr.common.taxdeclare.draft.DraftConstant;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class DraftMQSender
extends MQSender {
    private static final Log logger = LogFactory.getLog(DraftMQSender.class);

    private static void sendDraftMQ(DraftMQMessage message) {
        DraftMQSender.send("taxc.common.draft.taxableList", JsonUtil.toJson(message));
    }

    public static void sendMQ(DynamicObject entity, Date startdate, Date enddate, String topic, String event) {
        try {
            event = event.toLowerCase();
            DraftMQMessage message = DraftMQSender.transformMessage(entity, startdate, enddate, topic, event);
            DraftMQSender.sendDraftMQ(message);
        }
        catch (Exception e) {
            logger.error("DraftMQSender send error!", (Throwable)e);
        }
    }

    public static void sendMQ(List<DynamicObject> list, String topic, String event) {
        try {
            event = event.toLowerCase();
            for (DynamicObject entity : list) {
                Date startdate = entity.getDate("startdate");
                Date enddate = entity.getDate("enddate");
                DraftMQMessage message = DraftMQSender.transformMessage(entity, startdate, enddate, topic, event);
                DraftMQSender.sendDraftMQ(message);
            }
        }
        catch (Exception e) {
            logger.error("DraftMQSender send error!", (Throwable)e);
        }
    }

    private static DraftMQMessage transformMessage(DynamicObject entity, Date startdate, Date enddate, String topic, String event) {
        DraftMQMessage message = new DraftMQMessage();
        DraftMQSender.transformTax(entity.getString("drafttype"), entity.getString("templatetype"), message);
        message.setTopic(topic);
        message.setEvent(DeclareMQEvent.match(event));
        message.setOrg(DraftMQSender.doAdaptOrg(entity));
        message.setSkssqq(DateUtils.format(startdate));
        message.setSkssqz(DateUtils.format(enddate));
        message.setType(entity.getString("type"));
        message.setTemplatetype(entity.getString("templatetype"));
        message.setDrafttype(entity.getString("drafttype"));
        message.setDraftPurpose(entity.getString("draftpurpose"));
        message.setBillno(entity.getString("billno"));
        message.setBillstatus(entity.getString("billstatus"));
        return message;
    }

    private static String transformTax(String drafttype, String templatetype, DraftMQMessage message) {
        if (StringUtil.isEmpty((CharSequence)drafttype)) {
            drafttype = TemplateTypeConstant.getDraftTypeByDraftTemplateType(templatetype);
        }
        String tax = DraftConstant.getTaxByDraftType(drafttype);
        message.setTax(tax);
        message.setDrafttype(drafttype);
        return tax;
    }

    private static Long doAdaptOrg(DynamicObject entity) {
        Object org = entity.get("org");
        if (org instanceof DynamicObject) {
            return ((DynamicObject)org).getLong("id");
        }
        if (org instanceof String) {
            return Long.valueOf((String)org);
        }
        if (org instanceof Long) {
            return (Long)org;
        }
        return null;
    }
}

