/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.mq.oversea;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.enums.TableTypeMappingTemplateTypeEnum;
import kd.taxc.bdtaxr.common.errorcode.TaxcErrorCode;
import kd.taxc.bdtaxr.common.helper.bd.taxationsys.TaxAtionsysDataServiceHelper;
import kd.taxc.bdtaxr.common.mq.DeclareMQEvent;
import kd.taxc.bdtaxr.common.mq.MQSender;
import kd.taxc.bdtaxr.common.mq.oversea.MessageSceneType;
import kd.taxc.bdtaxr.common.mq.oversea.OverSeaDraftMQMessage;
import kd.taxc.bdtaxr.common.mq.oversea.OverSeaDraftMQMessageData;
import kd.taxc.bdtaxr.common.mq.oversea.OverSeaPayRefundMQMessage;
import kd.taxc.bdtaxr.common.mq.oversea.OverSeaPayRefundMQMessageData;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class OverSeaMQSender
extends MQSender {
    private static final Log logger = LogFactory.getLog(OverSeaMQSender.class);
    private static final List<String> STATISTICS_CONVERT_QUEUES = Collections.singletonList("taxc.common.declare.statistics");
    private static final List<String> ELEMENT_AUTOUPDATE_QUEUES = Collections.singletonList("taxc.common.declare.eleUpdate");
    private static final DeclareMQEvent[] NEED_WRITEBACK_EVENTS = new DeclareMQEvent[]{DeclareMQEvent.AUDIT, DeclareMQEvent.UNAUDIT, DeclareMQEvent.IMPORT, DeclareMQEvent.UNPAYREFUND, DeclareMQEvent.PAYREFUND};
    private static final DeclareMQEvent[] NEED_AUTO_EVENTS = new DeclareMQEvent[]{DeclareMQEvent.AUDIT, DeclareMQEvent.DELETE, DeclareMQEvent.IMPORT};

    private static void sendDraft(OverSeaDraftMQMessage message, String event) {
        if (Arrays.stream(NEED_WRITEBACK_EVENTS).anyMatch(v -> StringUtil.equalsIgnoreCase((CharSequence)event, (CharSequence)v.name()))) {
            for (String declareQueue : STATISTICS_CONVERT_QUEUES) {
                OverSeaMQSender.send(declareQueue, JsonUtil.toJson(message));
            }
        }
        if (Arrays.stream(NEED_AUTO_EVENTS).anyMatch(v -> StringUtil.equalsIgnoreCase((CharSequence)event, (CharSequence)v.name()))) {
            for (String declareQueue : ELEMENT_AUTOUPDATE_QUEUES) {
                OverSeaMQSender.send(declareQueue, JsonUtil.toJson(message));
            }
        }
    }

    private static void sendPayRefund(OverSeaPayRefundMQMessage message) {
        OverSeaMQSender.send("taxc.common.declare.statistics", JsonUtil.toJson(message));
    }

    public static void sendMQ(List<DynamicObject> dataEntities, String event) {
        try {
            Map<String, List<DynamicObject>> collect = dataEntities.stream().collect(Collectors.groupingBy(item -> item.getString("draftpurpose")));
            collect.forEach((key, value) -> {
                OverSeaDraftMQMessage message = new OverSeaDraftMQMessage();
                if ("sjjt".equals(key)) {
                    message.setTopic(MessageSceneType.ACCRUALDRAFT.name());
                }
                if ("nssb".equals(key)) {
                    message.setTopic(MessageSceneType.OVERSEADRAFT.name());
                }
                message.setEvent(event);
                message.setOverSeaDraftMQMessageData(OverSeaMQSender.buildDraftMessageData(value, key));
                OverSeaMQSender.sendDraft(message, event);
            });
        }
        catch (Exception e) {
            logger.error("OverSeaMQSender send draft error:{}", (Object)e.getMessage());
        }
    }

    public static void sendMQ(List<DynamicObject> dataEntities, String event, String entityName) {
        OverSeaMQSender.sendMQAndEntityName(dataEntities, event, entityName);
    }

    public static void sendMQForPayRefund(List<DynamicObject> dataEntities, String event) {
        try {
            OverSeaPayRefundMQMessage message = new OverSeaPayRefundMQMessage();
            message.setEvent(event);
            message.setTopic(MessageSceneType.OVERSEAPAYFUND.name());
            message.setOverSeaPayRefundMQMessageData(OverSeaMQSender.buildPayRefundMQMessageData(dataEntities));
            OverSeaMQSender.sendPayRefund(message);
        }
        catch (Exception e) {
            logger.error("OverSeaMQSender send payrefund error:{}", (Object)e.getMessage());
        }
    }

    public static void sendMQ(List<Long> ids, Long moduleId, String event, String entityName) {
        DynamicObject[] load = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)MultiTableEnum.getDeclareTable(moduleId).getMainTable()));
        if (EmptyCheckUtils.isNotEmpty(load)) {
            OverSeaMQSender.sendMQAndEntityName(Arrays.asList(load), event, entityName);
        }
    }

    private static void sendMQAndEntityName(List<DynamicObject> dataEntities, String event, String entityName) {
        try {
            Map<String, List<DynamicObject>> collect = dataEntities.stream().collect(Collectors.groupingBy(item -> item.getString("draftpurpose")));
            collect.forEach((key, value) -> {
                OverSeaDraftMQMessage message = new OverSeaDraftMQMessage();
                if ("sjjt".equals(key)) {
                    message.setTopic(MessageSceneType.ACCRUALDRAFT.name());
                }
                if ("nssb".equals(key)) {
                    message.setTopic(MessageSceneType.OVERSEADRAFT.name());
                }
                if ("sbjtThan".equals(key)) {
                    message.setTopic(MessageSceneType.PROVISTONCOMPARE.name());
                }
                message.setEvent(event);
                message.setOverSeaDraftMQMessageData(OverSeaMQSender.buildDraftMessageData(value, key, entityName));
                OverSeaMQSender.sendDraft(message, event);
            });
        }
        catch (Exception e) {
            logger.error("OverSeaMQSender send draft error:{}", (Object)e.getMessage());
        }
    }

    private static List<OverSeaDraftMQMessageData> buildDraftMessageData(List<DynamicObject> dynamicObjects, String draftpurpose) {
        return OverSeaMQSender.buildDraftMessageData(dynamicObjects, draftpurpose, null);
    }

    private static List<OverSeaDraftMQMessageData> buildDraftMessageData(List<DynamicObject> dynamicObjects, String draftpurpose, String entityName) {
        ArrayList<OverSeaDraftMQMessageData> list = new ArrayList<OverSeaDraftMQMessageData>(dynamicObjects.size());
        Map<Long, Long> collect = dynamicObjects.stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v.getLong("taxsystem.id"), (k1, k2) -> k1));
        TaxResult taxResult = TaxAtionsysDataServiceHelper.queryTaxAtionsysByIds(new ArrayList<Long>(collect.values()));
        Map<Object, Object> collectMap = new HashMap();
        if (TaxcErrorCode.TAXC_SUCCESS_CODE.getCode().equals(taxResult.getCode())) {
            List data = (List)taxResult.getData();
            collectMap = data.stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v.getLong("currency.id"), (k1, k2) -> k1));
        }
        for (DynamicObject dataEntity : dynamicObjects) {
            OverSeaDraftMQMessageData message = OverSeaMQSender.getOverSeaDraftMQMessageData(draftpurpose, dataEntity);
            message.setCurrency((Long)collectMap.get(collect.get(message.getId())));
            if (StringUtil.isBlank((CharSequence)entityName)) {
                message.setEntityName(dataEntity.getDataEntityType().getName());
            } else {
                message.setEntityName(entityName);
            }
            list.add(message);
        }
        return list;
    }

    private static OverSeaDraftMQMessageData getOverSeaDraftMQMessageData(String draftpurpose, DynamicObject dataEntity) {
        OverSeaDraftMQMessageData message = new OverSeaDraftMQMessageData();
        message.setOrg(dataEntity.getLong("org.id"));
        message.setTaxationsys(dataEntity.getLong("taxsystem.id"));
        message.setTaxareagroup(dataEntity.getLong("taxareagroup.id"));
        message.setTaxType(dataEntity.getLong("taxtype.id"));
        message.setType(dataEntity.getString("templatetype.id"));
        message.setSkssqq(dataEntity.getDate("skssqq"));
        message.setSkssqz(dataEntity.getDate("skssqz"));
        message.setId(dataEntity.getLong("id"));
        message.setBillNo(dataEntity.getString("billno"));
        message.setBillStatus(dataEntity.getString("billstatus"));
        message.setDataType(dataEntity.getString("datatype"));
        message.setTableType(TableTypeMappingTemplateTypeEnum.getEnumByTemplateType((String)dataEntity.getString("templatetype.number")).getTableType());
        message.setDraftpurpose(draftpurpose);
        message.setBusinessSource(OverSeaMQSender.buildBusinessSource(draftpurpose));
        return message;
    }

    private static List<OverSeaPayRefundMQMessageData> buildPayRefundMQMessageData(List<DynamicObject> dynamicObjects) {
        ArrayList<OverSeaPayRefundMQMessageData> list = new ArrayList<OverSeaPayRefundMQMessageData>(dynamicObjects.size());
        dynamicObjects.forEach(dataEntity -> {
            OverSeaPayRefundMQMessageData message = new OverSeaPayRefundMQMessageData();
            message.setOrg(dataEntity.getLong("org.id"));
            message.setTaxationsys(dataEntity.getLong("taxationsys.id"));
            message.setTaxareagroup(dataEntity.getLong("taxareagroup.id"));
            message.setTaxType(dataEntity.getLong("taxcategory.id"));
            message.setSkssqq(dataEntity.getDate("skssqq"));
            message.setSkssqz(dataEntity.getDate("skssqz"));
            message.setId(OverSeaMQSender.handleRefundid(dataEntity));
            message.setBillNo(OverSeaMQSender.handleRefundBillno(dataEntity));
            message.setBillStatus("C");
            message.setBusinessSource("5");
            message.setAmount(dataEntity.getBigDecimal("amount"));
            message.setDataType(OverSeaMQSender.transformDataSource(dataEntity.getString("datasouce")));
            message.setPayfedundStatus(dataEntity.getString("payrefstatus"));
            message.setEntityName(dataEntity.getDataEntityType().getName());
            list.add(message);
        });
        return list;
    }

    private static Long handleRefundid(DynamicObject dataEntity) {
        if (EmptyCheckUtils.isNotEmpty(dataEntity.getLong("draftid.id")) && 0L != dataEntity.getLong("draftid.id")) {
            return dataEntity.getLong("draftid.id");
        }
        return dataEntity.getLong("id");
    }

    private static String handleRefundBillno(DynamicObject dataEntity) {
        if (EmptyCheckUtils.isNotEmpty(dataEntity.getString("draftid.billno"))) {
            return dataEntity.getString("draftid.billno");
        }
        return dataEntity.getString("billno");
    }

    private static String transformDataSource(String datasource) {
        if (EmptyCheckUtils.isNotEmpty(datasource)) {
            if ("1".equals(datasource)) {
                return "999";
            }
            if ("2".equals(datasource)) {
                return "1000";
            }
        }
        return "";
    }

    private static String buildBusinessSource(String draftpurpose) {
        if ("sjjt".equals(draftpurpose)) {
            return "2";
        }
        if ("nssb".equals(draftpurpose)) {
            return "4";
        }
        return "";
    }

    public static String getEntityName(IFormView view) {
        String entityid = "";
        if (EmptyCheckUtils.isNotEmpty(view)) {
            entityid = view.getEntityId();
            if (view instanceof ListView) {
                entityid = ((ListView)view).getBillFormId();
            }
            if (EmptyCheckUtils.isEmpty(entityid)) {
                entityid = "";
            }
        }
        return entityid;
    }
}

