/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.mq.taxrefund;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.mq.MQSender;
import kd.taxc.bdtaxr.common.mq.taxrefund.TaxRefundMQEvent;
import kd.taxc.bdtaxr.common.mq.taxrefund.TaxRefundMessage;
import kd.taxc.bdtaxr.common.taxdeclare.constant.TaxTypeEnum;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;

public class TaxRefundMQSender
extends MQSender {
    private static final Log logger = LogFactory.getLog(TaxRefundMQSender.class);

    private static void sendDraftMQ(TaxRefundMessage message) {
        TaxRefundMQSender.send("taxc.common.declare.statistics", JsonUtil.toJson(message));
    }

    public static void sendMQ(DynamicObject entity, Date startdate, Date enddate, String topic, String event) {
        try {
            event = event.toLowerCase();
            TaxRefundMessage message = TaxRefundMQSender.transformMessage(entity, startdate, enddate, topic, event);
            TaxRefundMQSender.sendDraftMQ(message);
        }
        catch (Exception e) {
            logger.error("DraftMQSender send error!", (Throwable)e);
        }
    }

    public static void sendMQ(List<DynamicObject> list, String topic, String event) {
        try {
            event = event.toLowerCase();
            for (DynamicObject entity : list) {
                Date startdate = entity.getDate("skssqq");
                Date enddate = entity.getDate("skssqz");
                TaxRefundMessage message = TaxRefundMQSender.transformMessage(entity, startdate, enddate, topic, event);
                TaxRefundMQSender.sendDraftMQ(message);
            }
        }
        catch (Exception e) {
            logger.error("DraftMQSender send error!", (Throwable)e);
        }
    }

    private static TaxRefundMessage transformMessage(DynamicObject entity, Date startdate, Date enddate, String topic, String event) {
        TaxRefundMessage message = new TaxRefundMessage();
        message.setTopic(topic);
        message.setEvent(TaxRefundMQEvent.match(event));
        message.setTax("001");
        Long org = TaxRefundMQSender.doAdaptOrg(entity);
        message.setOrg(org);
        message.setSkssqq(DateUtils.format(startdate));
        message.setSkssqz(DateUtils.format(enddate));
        DynamicObject declareDyo = TaxRefundMQSender.getDeclareDyo(org, startdate, enddate);
        if (declareDyo != null) {
            message.setType(declareDyo.getString("type"));
        }
        message.setBqsqthclldtse(entity.getBigDecimal("bqsqthclldtse"));
        message.setBqsqthzlldtse(entity.getBigDecimal("bqsqthzlldtse"));
        return message;
    }

    public static DynamicObject getDeclareDyo(Long orgId, Date skssqq, Date skssqz) {
        List typeList = Arrays.stream(TaxTypeEnum.TCVAT.getTemplates()).collect(Collectors.toList());
        QFilter orgidFilter = new QFilter("org", "=", (Object)orgId);
        QFilter stypeFilter = new QFilter("type", "in", typeList);
        QFilter startDataFilter = new QFilter("skssqq", "=", (Object)skssqq);
        QFilter endDataFilter = new QFilter("skssqz", "<=", (Object)DateUtils.getDayLast(skssqz));
        return QueryServiceHelper.queryOne((String)"tcvat_zzs_declare_list", (String)"id,type", (QFilter[])new QFilter[]{orgidFilter, startDataFilter, endDataFilter, stypeFilter});
    }

    private static Long doAdaptOrg(DynamicObject entity) {
        Object org = entity.get("org");
        if (org instanceof DynamicObject) {
            return ((DynamicObject)org).getLong("id");
        }
        if (org instanceof String) {
            return Long.valueOf((String)org);
        }
        if (org instanceof Long) {
            return (Long)org;
        }
        return null;
    }
}

