/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.opplugin;

import java.util.Arrays;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.mq.accrual.AccrualMQSender;
import kd.taxc.bdtaxr.common.mq.oversea.OverSeaMQSender;

public class AccrualOperateOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().addAll(Arrays.asList("org", "taxsystem", "taxtype", "taxareagroup", "accountsettype", "skssqq", "skssqz", "templatetype", "id", "draftpurpose", "billno", "billstatus", "datatype"));
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                String operateKey = this.getOperateKey();
                if ("save".equalsIgnoreCase(operateKey)) {
                    for (ExtendedDataEntity dataEntity : this.dataEntities) {
                        TaxResult isTaxpayer = TaxcMainDataServiceHelper.isTaxcMainByOrgIdAndIsTaxpayer((Long)dataEntity.getDataEntity().getLong("org.id"));
                        if (isTaxpayer.getData() != null && ((Boolean)isTaxpayer.getData()).booleanValue()) continue;
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\u6216\u975e\u7eb3\u7a0e\u4e3b\u4f53", (String)"AccrualOperateOp_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                    }
                }
            }
        });
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] dataEntities;
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            AccrualMQSender.sendMQ(dataEntity);
        }
        if ("audit".equals(e.getOperationKey()) || "unaudit".equals(e.getOperationKey())) {
            OverSeaMQSender.sendMQ(Arrays.asList(dataEntities), e.getOperationKey());
        }
    }
}

