/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.opplugin.validator;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.util.CollectionUtils;
import kd.taxc.bdtaxr.common.constant.AccrualConstant;
import kd.taxc.bdtaxr.common.constant.BaseTaxCategory;
import kd.taxc.bdtaxr.common.helper.tctb.orgmapping.TaxcOrgMappingDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.orgtakerelation.TaxOrgTakeRelationServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.provision.ProvisionSharePlanDataServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;

public class SourceInfoDimensionSaveValidator
extends AbstractValidator {
    private Long taxTypeId;
    private String org = "org";

    public SourceInfoDimensionSaveValidator(Long taxTypeId) {
        this.taxTypeId = taxTypeId;
    }

    public SourceInfoDimensionSaveValidator(Long taxTypeId, String org) {
        this.taxTypeId = taxTypeId;
        this.org = org;
    }

    public void validate() {
        List orgIds = Arrays.stream(this.dataEntities).filter(d -> d.getDataEntity().getDynamicObject(this.org) != null).map(d -> d.getDataEntity().getDynamicObject(this.org).getLong("id")).collect(Collectors.toList());
        HashMap<Long, DynamicObject> orgTaxProvisionPlanMap = new HashMap<Long, DynamicObject>(8);
        for (Long orgId : orgIds) {
            List taxtionResult = (List)ProvisionSharePlanDataServiceHelper.queryTaxSharePlanByOrgIdsAndCategoryIdAndDateRange(Collections.singletonList(orgId), (Long)this.taxTypeId, (Long)AccrualConstant.TAXSYSTEM_CHINA, (Date)new Date(), (Date)new Date()).getData();
            if (CollectionUtils.isEmpty((Collection)taxtionResult)) continue;
            orgTaxProvisionPlanMap.put(orgId, (DynamicObject)taxtionResult.get(0));
        }
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject currentObj = dataEntity.getDataEntity();
            if (currentObj.getDynamicObject(this.org) == null) {
                return;
            }
            long orgid = currentObj.getDynamicObject(this.org).getLong("id");
            Date skssqq = new Date();
            Date skssqz = new Date();
            if (currentObj.containsProperty("skssqq") && currentObj.containsProperty("skssqz")) {
                skssqq = currentObj.getDate("skssqq");
                skssqz = currentObj.getDate("skssqz");
            }
            if (BaseTaxCategory.YHS.equals(this.taxTypeId) && currentObj.containsProperty("entryentity")) {
                DynamicObjectCollection entryentityList = currentObj.getDynamicObjectCollection("entryentity");
                for (DynamicObject object : entryentityList) {
                    DynamicObjectCollection data;
                    Map<Long, DynamicObject> orgProvisionPlanMap;
                    if ("acsb".equals(currentObj.getString("declaretype"))) {
                        skssqq = skssqz = object.getDate("voucherdate");
                    }
                    if (!this.checkdimension(dataEntity, object, orgid, skssqq, skssqz, orgProvisionPlanMap = (data = (DynamicObjectCollection)ProvisionSharePlanDataServiceHelper.queryProvisionSharePlanByOrgIdsAndCategoryIdAndDateRange(orgIds, (Long)this.taxTypeId, (Long)AccrualConstant.TAXSYSTEM_CHINA, (Date)skssqq, (Date)skssqz).getData()).stream().collect(Collectors.toMap(d -> d.getLong("orgentity.org"), d -> d, (k, v) -> k)), orgTaxProvisionPlanMap)) continue;
                    return;
                }
                continue;
            }
            DynamicObjectCollection data = (DynamicObjectCollection)ProvisionSharePlanDataServiceHelper.queryProvisionSharePlanByOrgIdsAndCategoryIdAndDateRange(orgIds, (Long)this.taxTypeId, (Long)AccrualConstant.TAXSYSTEM_CHINA, (Date)skssqq, (Date)skssqz).getData();
            Map<Long, DynamicObject> orgProvisionPlanMap = data.stream().collect(Collectors.toMap(d -> d.getLong("orgentity.org"), d -> d, (k, v) -> k));
            if (!this.checkdimension(dataEntity, currentObj, orgid, skssqq, skssqz, orgProvisionPlanMap, orgTaxProvisionPlanMap)) continue;
            return;
        }
    }

    private boolean checkdimension(ExtendedDataEntity dataEntity, DynamicObject currentObj, long orgid, Date skssqq, Date skssqz, Map<Long, DynamicObject> orgProvisionPlanMap, Map<Long, DynamicObject> orgTaxProvisionPlanMap) {
        DynamicObject provisionPlan = orgProvisionPlanMap.get(orgid);
        DynamicObject taxprovisionPlan = orgTaxProvisionPlanMap.get(orgid);
        Date now = new Date();
        if (provisionPlan != null) {
            boolean isdimprovision = provisionPlan.getBoolean("ruleentity.rule.isdimprovision");
            String provisiondimension = provisionPlan.getString("ruleentity.rule.provisiondimension");
            if (isdimprovision) {
                if (provisiondimension.contains("accountorg")) {
                    long accountOrgId = 0L;
                    if (currentObj.containsProperty("accountorg")) {
                        accountOrgId = currentObj.getLong("accountorg.id");
                    }
                    if (currentObj.containsProperty("accorg")) {
                        accountOrgId = currentObj.getLong("accorg.id");
                    }
                    if (accountOrgId == 0L) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8ba1\u63d0\u65b9\u6848\u5206\u7ef4\u5ea6\u8ba1\u63d0\u5df2\u6253\u5f00\uff0c\u6838\u7b97\u7ec4\u7ec7\u4e3a\u5fc5\u5f55\u5b57\u6bb5", (String)"SourceInfoDimensionSaveValidator_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                        return true;
                    }
                    List accountOrgs = TaxOrgTakeRelationServiceHelper.getOrgTakeRelation(Collections.singletonList(orgid), (Date)now, (Date)now);
                    if (EmptyCheckUtils.isEmpty(accountOrgs) || !accountOrgs.contains(accountOrgId)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7\u4e0e\u6838\u7b97\u7ec4\u7ec7\u4e0d\u5339\u914d\u8bf7\u91cd\u65b0\u586b\u5199", (String)"SourceInfoDimensionSaveValidator_4", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                        return true;
                    }
                } else {
                    if (currentObj.containsProperty("accountorg")) {
                        currentObj.set("accountorg", null);
                    }
                    if (currentObj.containsProperty("accorg")) {
                        currentObj.set("accorg", null);
                    }
                }
                if (provisiondimension.contains("businessdimension")) {
                    if (currentObj.get("bizdimensionname") == null || currentObj.get("bizdimensiontype") == null) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8ba1\u63d0\u65b9\u6848\u5206\u7ef4\u5ea6\u8ba1\u63d0\u5df2\u6253\u5f00\uff0c\u4e1a\u52a1\u7ef4\u5ea6\u548c\u4e1a\u52a1\u7ef4\u5ea6\u503c\u5fc5\u987b\u586b\u5199", (String)"SourceInfoDimensionSaveValidator_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                        return true;
                    }
                    if (currentObj.get("bizdimensionname") != null || currentObj.get("bizdimensiontype") != null) {
                        DynamicObject bizdimensiontype = currentObj.getDynamicObject("bizdimensiontype");
                        String id = bizdimensiontype.getString("id");
                        Map map = (Map)TaxcOrgMappingDataServiceHelper.getOrgMappingByOrgIdAndCategoryId((Long)orgid, (Long)this.taxTypeId, (Date)skssqq, (Date)skssqz).getData();
                        if (EmptyCheckUtils.isNotEmpty(map) && EmptyCheckUtils.isNotEmpty(map.get(id))) {
                            List maps = (List)map.get(id);
                            Object bizdimensionname = currentObj.get("bizdimensionname");
                            Optional<Map> businessname = maps.stream().filter(e -> e.get("businessname").equals(bizdimensionname)).findFirst();
                            if (businessname.isPresent()) {
                                currentObj.set("bizdimensionid", businessname.get().get("businessid"));
                            } else {
                                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e1a\u52a1\u7ef4\u5ea6\u4e0e\u4e1a\u52a1\u7ef4\u5ea6\u503c\u4e0d\u5339\u914d\u8bf7\u91cd\u65b0\u586b\u5199", (String)"SourceInfoDimensionSaveValidator_2", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                            }
                        } else {
                            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7\u4e0e\u4e1a\u52a1\u7ef4\u5ea6\u4e0d\u5339\u914d\u8bf7\u91cd\u65b0\u586b\u5199", (String)"SourceInfoDimensionSaveValidator_3", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                        }
                    }
                } else {
                    currentObj.set("bizdimensionname", null);
                    currentObj.set("bizdimensiontype", null);
                    currentObj.set("bizdimensionid", null);
                }
            }
        }
        if (taxprovisionPlan != null) {
            String taxdimension = taxprovisionPlan.getString("ruleentity.rule.provisiondimension");
            if (taxdimension.contains("accountorg")) {
                long accountOrgId = 0L;
                if (currentObj.containsProperty("accountorg")) {
                    accountOrgId = currentObj.getLong("accountorg.id");
                }
                if (currentObj.containsProperty("accorg")) {
                    accountOrgId = currentObj.getLong("accorg.id");
                }
                if (accountOrgId == 0L) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8ba1\u7a0e\u65b9\u6848\u5206\u7ef4\u5ea6\u8ba1\u7a0e\u5df2\u6253\u5f00\uff0c\u6838\u7b97\u7ec4\u7ec7\u4e3a\u5fc5\u5f55\u5b57\u6bb5", (String)"SourceInfoDimensionSaveValidator_5", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                    return true;
                }
                List accountOrgs = TaxOrgTakeRelationServiceHelper.getOrgTakeRelation(Collections.singletonList(orgid), (Date)now, (Date)now);
                if (EmptyCheckUtils.isEmpty(accountOrgs) || !accountOrgs.contains(accountOrgId)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7\u4e0e\u6838\u7b97\u7ec4\u7ec7\u4e0d\u5339\u914d\u8bf7\u91cd\u65b0\u586b\u5199", (String)"SourceInfoDimensionSaveValidator_4", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                    return true;
                }
            } else if (provisionPlan == null) {
                if (currentObj.containsProperty("accountorg")) {
                    currentObj.set("accountorg", null);
                }
                if (currentObj.containsProperty("accorg")) {
                    currentObj.set("accorg", null);
                }
            }
            if (provisionPlan == null) {
                currentObj.set("bizdimensionname", null);
                currentObj.set("bizdimensiontype", null);
                currentObj.set("bizdimensionid", null);
            }
        }
        if (provisionPlan == null && taxprovisionPlan == null) {
            if (currentObj.containsProperty("accountorg")) {
                currentObj.set("accountorg", null);
            }
            if (currentObj.containsProperty("accorg")) {
                currentObj.set("accorg", null);
            }
            currentObj.set("bizdimensionname", null);
            currentObj.set("bizdimensiontype", null);
            currentObj.set("bizdimensionid", null);
        }
        return false;
    }
}

