/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.plugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.taxc.bdtaxr.common.constant.TaxConstant;
import kd.taxc.bdtaxr.common.license.plugin.common.AbstractLicenseCheckFormPlugin;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public abstract class AbstractTaxFormPlugin
extends AbstractLicenseCheckFormPlugin {
    protected static final String ORGID_KEY = "orgid";
    protected static final String ORG_SEL = "org";
    protected static final String SKSSQQ = "skssqq";
    protected static final String SKSSQZ = "skssqz";
    protected static final String BILL_STATUS = "cache_billstatus";
    protected static final String STATUS = "status";
    protected static final String NUMBER = "number";
    protected boolean validDates = true;

    protected abstract String getStartTime();

    protected abstract String getEndTime();

    protected abstract String[] getTaxLimits();

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObject newOrg;
        String endTime;
        ChangeData[] changeData = e.getChangeSet();
        if (changeData == null || changeData.length == 0) {
            return;
        }
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        String startTime = this.getStartTime();
        if (StringUtil.isEmpty((CharSequence)startTime)) {
            startTime = SKSSQQ;
        }
        if (StringUtil.isEmpty((CharSequence)(endTime = this.getEndTime()))) {
            endTime = SKSSQZ;
        }
        if (name.equals(ORG_SEL) && null == (newOrg = (DynamicObject)changeData[0].getNewValue())) {
            this.getView().getModel().setValue(ORG_SEL, (Object)this.getPageCache().get(ORGID_KEY));
            return;
        }
        if (name.equals(startTime) || name.equals(endTime)) {
            if (null == this.getModel().getValue(ORG_SEL)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u7a0e\u52a1\u7ec4\u7ec7\u201d\u3002", (String)"AbstractTaxFormPlugin_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                return;
            }
            Date startDate = (Date)this.getModel().getValue(startTime);
            Date endDate = (Date)this.getModel().getValue(endTime);
            if (null == startDate || null == endDate) {
                return;
            }
            if (!this.isValidDates(startDate, endDate)) {
                this.validDates = false;
                this.getView().getModel().setValue(startTime, (Object)"");
                this.getView().getModel().setValue(endTime, (Object)"");
                return;
            }
        }
    }

    protected boolean isValidDates(Date startDate, Date endDate) {
        String[] taxLimits;
        boolean isvalid = false;
        for (String taxLimit : taxLimits = this.getTaxLimits()) {
            boolean temp = DateUtils.validDateRange(taxLimit, startDate, endDate);
            isvalid |= temp;
        }
        if (!isvalid) {
            String errMsg = this.buildErrorMsg(taxLimits);
            this.getView().showTipNotification(errMsg);
            return false;
        }
        return true;
    }

    private String buildErrorMsg(String[] taxLimits) {
        String msgTmp = ResManager.loadKDString((String)"\u6240\u5c5e\u7a0e\u671f\u5fc5\u987b\u4e3a%s\u3002", (String)"AbstractTaxFormPlugin_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
        ArrayList<String> nameList = new ArrayList<String>(taxLimits.length);
        for (String taxLimit : taxLimits) {
            nameList.add(TaxConstant.getTaxLimitNameMap().get(taxLimit));
        }
        return String.format(msgTmp, String.join((CharSequence)"\u3001", nameList));
    }
}

