/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeDragEvent;
import kd.bos.form.control.events.TreeNodeDragListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.util.CollectionUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.util.tree.SearchUtil;

public class AbstractTreePlugin
extends AbstractFormPlugin
implements TreeNodeCheckListener,
TreeNodeDragListener,
TreeNodeClickListener {
    public static final String DEFAULT_ROOT_ID = "-1";
    public static final int MAX_LEVEL = 20;

    public void bind(String treeName, List<TreeNode> nodeList) {
        TreeView treeView = (TreeView)this.getControl(treeName);
        List<TreeNode> roots = TreeUtils.findRoot(nodeList);
        int index = 0;
        for (TreeNode root : roots) {
            TreeUtils.findChildren(root, nodeList, TreeUtils.getSonItems(root, nodeList));
            treeView.addNode(root);
            if (index == 0) {
                treeView.focusNode(root);
                treeView.treeNodeClick(null, root.getId());
            }
            ++index;
        }
        if (roots.size() > 1) {
            TreeNode node = new TreeNode();
            node.setId(DEFAULT_ROOT_ID);
            node.setText("");
            node.setChildren(roots);
            this.setRoot(treeName, node);
        } else {
            this.setRoot(treeName, roots.get(0));
        }
    }

    public void setRoot(String treeName, TreeNode root) {
        List<TreeNode> list = TreeUtils.getNodeList(root);
        HashMap<String, TreeNode> map = new HashMap<String, TreeNode>(list.size());
        for (TreeNode node : list) {
            map.put(node.getId(), node);
        }
        if (!root.getId().equals(DEFAULT_ROOT_ID)) {
            map.put(root.getId(), root);
        }
        this.getPageCache().put(String.format("%s.nodeMap", treeName), SerializationUtils.toJsonString(map));
        TreeUtils.putCache(this.getPageCache(), String.format("%s.root", treeName), root);
    }

    public TreeNode getRoot(String treeName) {
        return TreeUtils.getCache(this.getPageCache(), String.format("%s.root", treeName), TreeNode.class);
    }

    public List<TreeNode> getSelectedNodeList(String treeName) {
        Map<String, TreeNode> map;
        ArrayList<TreeNode> list = new ArrayList<TreeNode>();
        TreeView treeView = (TreeView)this.getView().getControl(treeName);
        List selectIds = treeView.getTreeState().getSelectedNodeId();
        if (selectIds != null && !selectIds.isEmpty() && (map = this.getNodeMap(treeName)) != null) {
            for (String nodeId : selectIds) {
                list.add(map.get(nodeId));
            }
        }
        return list;
    }

    public String getCurrentNodeId(String treeName) {
        return this.getPageCache().get(String.format("%s.currentnodeid", treeName));
    }

    public TreeNode getNode(String treeName, String nodeId) {
        Map<String, TreeNode> map = this.getNodeMap(treeName);
        return map.get(nodeId);
    }

    private Map<String, TreeNode> getNodeMap(String treeName) {
        String json = this.getPageCache().get(String.format("%s.nodeMap", treeName));
        Map list = (Map)JSONObject.parseObject((String)json, Map.class);
        HashMap<String, TreeNode> map = new HashMap<String, TreeNode>(list.size());
        for (Map.Entry entry : list.entrySet()) {
            TreeNode node = (TreeNode)JSONObject.toJavaObject((JSON)((JSON)entry.getValue()), TreeNode.class);
            if (node.getData() != null && node.getData() instanceof JSONObject) {
                Map data = (Map)JSONObject.toJavaObject((JSON)((JSONObject)node.getData()), Map.class);
                node.setData((Object)data);
            }
            map.put((String)entry.getKey(), node);
        }
        return map;
    }

    public void treeNodeCheck(TreeNodeCheckEvent event) {
    }

    public void addNode(String treeName, String parentId, TreeNode addNode) {
        TreeNode root = this.getRoot(treeName);
        TreeNode dd = root.getTreeNode(addNode.getId(), 20);
        if (dd == null) {
            TreeView treeView = (TreeView)this.getControl(treeName);
            addNode.setParentid(parentId);
            treeView.addNode(addNode);
            TreeNode parent = root.getTreeNode(parentId, 20);
            parent.addChild(addNode);
            this.setRoot(treeName, root);
        }
    }

    public void treeNodeDragged(TreeNodeDragEvent event) {
        String nodeId = event.getNodeId().toString();
        String toParentId = event.getToParentId().toString();
        String fromParentId = event.getFromParentId().toString();
        TreeView treeView = (TreeView)event.getSource();
        TreeNode root = this.getRoot(treeView.getKey());
        TreeNode currNode = root.getTreeNode(nodeId, 20);
        currNode.setParentid(toParentId);
        treeView.deleteNode(currNode.getId());
        treeView.addNode(currNode);
        TreeNode toNode = root.getTreeNode(toParentId, 20);
        TreeNode fromNode = root.getTreeNode(fromParentId, 20);
        if (fromNode != null) {
            fromNode.deleteChildNode(nodeId);
        } else {
            root.deleteChildNode(nodeId);
        }
        if (toNode != null) {
            toNode.addChild(currNode);
        }
        TreeUtils.putCache(this.getPageCache(), String.format("%s.root", treeView.getKey()), root);
    }

    public void treeNodeClick(TreeNodeEvent event) {
        Object nodeId = event.getNodeId();
        TreeView treeView = (TreeView)event.getSource();
        this.getPageCache().put(String.format("%s.currentnodeid", treeView.getKey()), nodeId.toString());
    }

    public void treeNodeDoubleClick(TreeNodeEvent event) {
    }

    public void addTreeNodeDragListener(String ... keys) {
        final IPageCache pageCache = this.getPageCache();
        for (final String key : keys) {
            final TreeView treeView = (TreeView)this.getView().getControl(key);
            treeView.addTreeNodeDragListener(new TreeNodeDragListener(){

                public void treeNodeDragged(TreeNodeDragEvent event) {
                    String fromParentId;
                    if (event == null) {
                        return;
                    }
                    String nodeId = event.getNodeId().toString();
                    String toParentId = event.getToParentId().toString();
                    if (toParentId.equals(fromParentId = event.getFromParentId().toString())) {
                        return;
                    }
                    TreeNode root = TreeUtils.getCache(pageCache, String.format("%s.root", key), TreeNode.class);
                    TreeNode currNode = root.getTreeNode(nodeId, 20);
                    if (currNode == null) {
                        return;
                    }
                    List<String> childList = TreeUtils.getChildIdList(currNode);
                    if (childList.contains(toParentId)) {
                        return;
                    }
                    currNode.setParentid(toParentId);
                    treeView.deleteNode(currNode.getId());
                    treeView.addNode(currNode);
                    TreeNode toNode = root.getTreeNode(toParentId, 20);
                    TreeNode fromNode = root.getTreeNode(fromParentId, 20);
                    if (fromNode != null) {
                        fromNode.deleteChildNode(nodeId);
                    } else {
                        root.deleteChildNode(nodeId);
                    }
                    if (toNode != null) {
                        toNode.addChild(currNode);
                    }
                    TreeUtils.putCache(pageCache, String.format("%s.root", key), root);
                }
            });
        }
    }

    public void addEnterListener(String ... keys) {
        final IFormView view = this.getView();
        final IPageCache pageCache = this.getPageCache();
        for (final String key : keys) {
            final TreeView treeView = (TreeView)this.getView().getControl(key);
            Search search = (Search)this.getControl("searchap_" + key);
            if (search != null) {
                search.addEnterListener(new SearchEnterListener(){

                    public void search(SearchEnterEvent event) {
                        if (event.getText() != null && !"".equals(event.getText())) {
                            SearchUtil.searchMember(event.getText().toLowerCase().trim(), true, view, pageCache, treeView, String.format("%s.root", key));
                        } else {
                            pageCache.put(treeView.getKey() + "_resultlist", null);
                            AbstractTreePlugin.this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7f16\u7801\u6216\u540d\u79f0\u540e\u6309\u56de\u8f66\u952e\u3002", (String)"AbstractTreePlugin_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                        }
                    }
                });
            }
            this.addClickListeners(new String[]{"searchbefore_" + key, "searchnext_" + key});
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (key.startsWith("searchbefore_") || key.startsWith("searchnext_")) {
            String[] btns = new String[]{"searchbefore", "searchnext"};
            String treeName = key.replace("searchbefore_", "").replace("searchnext_", "");
            SearchUtil.getLeftOrRight(this.getPageCache(), this.getView(), key.substring(0, key.length() - treeName.length() - 1), (TreeView)this.getControl(treeName), btns, String.format("%s.root", treeName));
        }
    }

    protected void getLongNumberMap(TreeNode node, String parentLongNumber, Map<String, String> longNumberMap) {
        block4: {
            block3: {
                parentLongNumber = !StringUtils.isEmpty((CharSequence)parentLongNumber) ? parentLongNumber + "." : "";
                if (!DEFAULT_ROOT_ID.equals(node.getId())) break block3;
                if (CollectionUtils.isEmpty((Collection)node.getChildren())) break block4;
                for (TreeNode child : node.getChildren()) {
                    this.getLongNumberMap(child, "", longNumberMap);
                }
                break block4;
            }
            longNumberMap.put(node.getId(), parentLongNumber + node.getId());
            if (!CollectionUtils.isEmpty((Collection)node.getChildren())) {
                for (TreeNode child : node.getChildren()) {
                    this.getLongNumberMap(child, parentLongNumber + node.getId(), longNumberMap);
                }
            }
        }
    }

    protected void expand(String treeName, String nodeid) {
        TreeView treeView = (TreeView)this.getControl(treeName);
        TreeNode root = this.getRoot(treeName);
        TreeNode node = root.getTreeNode(nodeid, 20);
        if (node != null) {
            node.setIsOpened(true);
            treeView.deleteNode(node.getId());
            treeView.addNode(node);
        }
    }
}

