/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.plugin;

import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.constant.AccrualConstant;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bos.orgrelation.OrgRelationDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.orgmapping.TaxcOrgMappingDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.orgtakerelation.TaxOrgTakeRelationServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.provision.ProvisionSharePlanDataServiceHelper;
import kd.taxc.bdtaxr.common.plugin.ProvisionDimension;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;

public class ProvisionDimensionPlugin
extends AbstractBillPlugIn
implements ProvisionDimension,
BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        BasedataEdit accountorg = (BasedataEdit)this.getControl("accountorg");
        if (accountorg == null) {
            accountorg = (BasedataEdit)this.getControl("accorg");
        }
        accountorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        TextEdit bizdimensionname = (TextEdit)this.getControl("bizdimensionname");
        bizdimensionname.addClickListener((ClickListener)this);
    }

    public void afterCopyData(EventObject e) {
        this.createNewData();
    }

    private void createNewData() {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        DynamicObject taxorg = (DynamicObject)this.getModel().getValue(this.getOrgField());
        BasedataEdit accountOrgCtrl = (BasedataEdit)this.getControl("accountorg");
        String accountOrgStr = "accountorg";
        if (accountOrgCtrl == null) {
            accountOrgCtrl = (BasedataEdit)this.getControl("accorg");
            accountOrgStr = "accorg";
        }
        if (taxorg != null) {
            this.setFiledValueAndStatus(taxorg, accountOrgStr, accountOrgCtrl, true);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{accountOrgStr, "bizdimensiontype", "bizdimensionname", "bizdimensionid"});
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        if ("accountorg".equals(evt.getProperty().getName()) || "accorg".equals(evt.getProperty().getName())) {
            DynamicObject org = (DynamicObject)this.getModel().getValue(this.getOrgField());
            if (null == org) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u7a0e\u52a1\u7ec4\u7ec7", (String)"ProvisionDimensionPlugin_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            Date now = new Date();
            List accountOrgs = TaxOrgTakeRelationServiceHelper.getOrgTakeRelation(Collections.singletonList(org.getLong("id")), (Date)now, (Date)now);
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter().getShowParameter();
            showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)accountOrgs));
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.createNewData();
    }

    private void setFiledValueAndStatus(DynamicObject taxorg, String accountOrg, BasedataEdit accountOrgCtrl, boolean isInit) {
        String taxdimension;
        DynamicObject entry;
        TaxResult taxResult = ProvisionSharePlanDataServiceHelper.queryProvisionSharePlanByOrgIdsAndCategoryIdAndDateRange(Collections.singletonList(taxorg.getLong("id")), (Long)this.getBaseTaxCategory(), (Long)AccrualConstant.TAXSYSTEM_CHINA, (Date)new Date(), (Date)new Date());
        TaxResult taxtionResult = ProvisionSharePlanDataServiceHelper.queryTaxSharePlanByOrgIdsAndCategoryIdAndDateRange(Collections.singletonList(taxorg.getLong("id")), (Long)this.getBaseTaxCategory(), (Long)AccrualConstant.TAXSYSTEM_CHINA, (Date)new Date(), (Date)new Date());
        this.getView().setVisible(Boolean.FALSE, new String[]{accountOrg, "bizdimensiontype", "bizdimensionname", "bizdimensionid"});
        if (EmptyCheckUtils.isNotEmpty(taxResult.getData())) {
            entry = (DynamicObject)((DynamicObjectCollection)taxResult.getData()).get(0);
            boolean isdimprovision = entry.getBoolean("ruleentity.rule.isdimprovision");
            String provisiondimension = entry.getString("ruleentity.rule.provisiondimension");
            Long businessdimensionId = entry.getLong("ruleentity.rule.businessdimension.fbasedataid.id");
            this.setFiledValueAndStatus(taxorg, accountOrg, accountOrgCtrl, isInit, isdimprovision, provisiondimension, businessdimensionId);
        }
        if (EmptyCheckUtils.isNotEmpty(taxtionResult.getData()) && (taxdimension = (entry = (DynamicObject)((DynamicObjectCollection)taxtionResult.getData()).get(0)).getString("ruleentity.rule.provisiondimension")).contains("accountorg")) {
            this.setTaxFiledValueAndStatus(taxorg, accountOrg, accountOrgCtrl, isInit);
        }
    }

    private void setTaxFiledValueAndStatus(DynamicObject taxorg, String accountOrg, BasedataEdit accountOrgCtrl, boolean isInit) {
        if (isInit) {
            this.getModel().setValue(accountOrg, OrgRelationDataServiceHelper.getDefaultAccountingOrgIdByTaxcOrgId((Long)taxorg.getLong("id")).getData());
        }
        accountOrgCtrl.setMustInput(true);
        this.getView().setVisible(Boolean.TRUE, new String[]{accountOrg});
    }

    private void setFiledValueAndStatus(DynamicObject taxorg, String accountOrg, BasedataEdit accountOrgCtrl, boolean isInit, boolean isdimprovision, String provisiondimension, Long businessdimensionId) {
        BasedataEdit bizdimensiontype = (BasedataEdit)this.getControl("bizdimensiontype");
        TextEdit bizdimensionname = (TextEdit)this.getControl("bizdimensionname");
        if (isdimprovision && provisiondimension.contains("accountorg")) {
            if (isInit) {
                this.getModel().setValue(accountOrg, OrgRelationDataServiceHelper.getDefaultAccountingOrgIdByTaxcOrgId((Long)taxorg.getLong("id")).getData());
            }
            accountOrgCtrl.setMustInput(true);
            this.getView().setVisible(Boolean.TRUE, new String[]{accountOrg});
        } else {
            accountOrgCtrl.setMustInput(false);
            this.getView().setVisible(Boolean.FALSE, new String[]{accountOrg});
        }
        if (isdimprovision && provisiondimension.contains("businessdimension")) {
            TaxResult result = TaxcOrgMappingDataServiceHelper.getOrgMappingPlanByIds(Collections.singletonList(businessdimensionId));
            Object object = this.getModel().getValue("bizdimensiontype");
            if (result.isSuccess() && EmptyCheckUtils.isNotEmpty(result.getData()) && EmptyCheckUtils.isEmpty(object)) {
                String mapobject = ((DynamicObject)((List)result.getData()).get(0)).getDynamicObject("mapobject").getString("id");
                this.getModel().setValue("bizdimensiontype", (Object)mapobject);
                this.getModel().setDataChanged(false);
            }
            bizdimensiontype.setMustInput(true);
            bizdimensionname.setMustInput(true);
            this.getView().setVisible(Boolean.TRUE, new String[]{"bizdimensiontype", "bizdimensionname"});
        } else {
            bizdimensiontype.setMustInput(false);
            bizdimensionname.setMustInput(false);
            this.getView().setVisible(Boolean.FALSE, new String[]{"bizdimensiontype", "bizdimensionname"});
        }
    }

    public void afterLoadData(EventObject e) {
        DynamicObject taxorg = (DynamicObject)this.getModel().getValue(this.getOrgField());
        BasedataEdit accountOrgCtrl = (BasedataEdit)this.getControl("accountorg");
        String accountOrgStr = "accountorg";
        if (accountOrgCtrl == null) {
            accountOrgCtrl = (BasedataEdit)this.getControl("accorg");
            accountOrgStr = "accorg";
        }
        if (taxorg != null) {
            this.setFiledValueAndStatus(taxorg, accountOrgStr, accountOrgCtrl, false);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{accountOrgStr, "bizdimensiontype", "bizdimensionname", "bizdimensionid"});
        }
    }

    public void click(EventObject evt) {
        Object source = evt.getSource();
        if (source instanceof TextEdit && "bizdimensionname".equals(((TextEdit)source).getKey())) {
            Map map;
            DynamicObject dynamicObject = this.getModel().getDataEntity(true);
            DynamicObject taxorg = dynamicObject.getDynamicObject(this.getOrgField());
            if (taxorg == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7a0e\u52a1\u7ec4\u7ec7\u4e3a\u7a7a\uff0c\u8bf7\u9009\u62e9", (String)"ProvisionDimensionPlugin_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                return;
            }
            DynamicObject bizdimensiontype = dynamicObject.getDynamicObject("bizdimensiontype");
            if (bizdimensiontype == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u7ef4\u5ea6\u4e3a\u7a7a", (String)"ProvisionDimensionPlugin_2", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                return;
            }
            Date skssqq = new Date();
            Date skssqz = null;
            if (dynamicObject.containsProperty("skssqq") && dynamicObject.containsProperty("skssqz")) {
                skssqq = dynamicObject.getDate("skssqq");
                skssqz = dynamicObject.getDate("skssqz");
                if (skssqq == null || skssqz == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u4e3a\u7a7a\uff0c\u8bf7\u586b\u5199", (String)"ProvisionDimensionPlugin_3", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                    return;
                }
            }
            String bizdimensiontypeEntity = bizdimensiontype.getString("id");
            ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)bizdimensiontypeEntity, (boolean)false);
            Map allFields = EntityMetadataCache.getDataEntityType((String)bizdimensiontypeEntity).getAllFields();
            if (allFields.get("enable") != null) {
                listShowParameter.getListFilterParameter().setFilter(new QFilter("enable", "=", (Object)"1"));
            }
            if (allFields.get("status") != null) {
                listShowParameter.getListFilterParameter().setFilter(new QFilter("status", "=", (Object)"C"));
            }
            if (EmptyCheckUtils.isNotEmpty(map = (Map)TaxcOrgMappingDataServiceHelper.getOrgMappingByOrgIdAndCategoryId((Long)taxorg.getLong("id"), (Long)this.getBaseTaxCategory(), (Date)skssqq, (Date)skssqz).getData()) && EmptyCheckUtils.isNotEmpty(map.get(bizdimensiontypeEntity))) {
                List maps = (List)map.get(bizdimensiontypeEntity);
                List businessid = maps.stream().map(e -> e.get("businessid")).collect(Collectors.toList());
                listShowParameter.getListFilterParameter().setFilter(new QFilter("id", "in", businessid));
            } else {
                listShowParameter.getListFilterParameter().setFilter(QFilter.of((String)"1!=1", (Object[])new Object[0]));
            }
            listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bizdimensionname"));
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection returnData;
        if ("bizdimensionname".equals(closedCallBackEvent.getActionId()) && EmptyCheckUtils.isNotEmpty(returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData())) {
            this.getModel().setValue("bizdimensionname", (Object)returnData.get(0).getName());
            this.getModel().setValue("bizdimensionid", returnData.get(0).getPrimaryKeyValue());
        }
    }
}

