/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.declare;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.IFormController;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.declare.helper.DeclareCustomParamsHelper;
import kd.taxc.bdtaxr.common.enums.TemplateEnum;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import org.apache.commons.lang3.reflect.MethodUtils;

public class NsrxxPlugin
extends AbstractBillPlugIn {
    private static Log LOGGER = LogFactory.getLog(NsrxxPlugin.class);

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"labelap1"});
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        if ("labelap1".equals(c.getKey())) {
            DynamicObject nsrxx = this.getModel().getDataEntity();
            Map<String, Object> customParams = DeclareCustomParamsHelper.buildCustomParams(nsrxx);
            String type = nsrxx.getString("type");
            FormShowParameter param = new FormShowParameter();
            QFilter qFilter = new QFilter("type", "=", (Object)type);
            boolean isNewTemplate = QueryServiceHelper.exists((String)"bdtaxr_template_main", (QFilter[])new QFilter[]{qFilter});
            if (isNewTemplate) {
                TemplateEnum templateEnum = TemplateEnum.getEnumByDeclareType(type);
                if (templateEnum != null && StringUtil.isNotBlank((CharSequence)templateEnum.getDeclareShowPage())) {
                    param.setFormId(templateEnum.getDeclareShowPage());
                } else {
                    param.setFormId("bdtaxr_declare");
                }
            } else {
                param.setFormId("bdtaxr_declare_old");
            }
            param.setCaption(ResManager.loadKDString((String)"\u7533\u62a5\u6570\u636e", (String)"NsrxxPlugin_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            param.setCustomParams(customParams);
            param.getOpenStyle().setShowType(ShowType.InCurrentForm);
            this.getView().showForm(param);
        }
    }

    public void afterLoadData(EventObject e) {
        List params = (List)SerializationUtils.fromJsonString((String)"[{\"key\":\"labelap1\",\"methodName\":\"click\",\"args\":[],\"postData\":[{},[]]}]", List.class);
        this.invokeOperation(this.getView(), params);
    }

    private void invokeOperation(IFormView view, List<Map<String, Object>> params) {
        IFormController srv = (IFormController)view.getService(IFormController.class);
        for (Map<String, Object> param : params) {
            String key = (String)param.get("key");
            String methodName = (String)param.get("methodName");
            Object _args = param.get("args");
            Object post = param.get("postData");
            Object[] args = ((List)_args).toArray();
            List postData = (List)post;
            srv.postData(postData);
            try {
                if (StringUtils.isBlank((CharSequence)key)) {
                    MethodUtils.invokeMethod((Object)srv, (String)methodName, (Object[])args);
                    continue;
                }
                srv.registerListener();
                Control ctl = view.getControl(key);
                if (ctl == null) continue;
                MethodUtils.invokeMethod((Object)ctl, (String)methodName, (Object[])args);
            }
            catch (Exception e) {
                LOGGER.error((Throwable)e);
            }
        }
    }
}

