/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.declare.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.BaseTaxCategory;
import kd.taxc.bdtaxr.common.declare.model.result.BaseResult;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.ZspmEnum;
import kd.taxc.bdtaxr.common.helper.tctb.taxclicense.TaxcLicenseCheckDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.i18n.MultiLangEnumBridge;
import kd.taxc.bdtaxr.common.refactor.template.TemplateUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityInfo;
import kd.taxc.bdtaxr.common.util.number.BigDecimalUtil;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.vo.ImportDataVo;

public class QtsftysbbDeclareHelper {
    private static final Log logger = LogFactory.getLog(QtsftysbbDeclareHelper.class);
    private static final String ORG_KEY = "tcvat_nsrxx#1#org";
    private static final String TEMPLATE_TYPE_KEY = "tcvat_nsrxx#1#type";
    private static final String SKSSQQ_KEY = "tcvat_nsrxx#1#skssqq";
    private static final String SKSSQZ_KEY = "tcvat_nsrxx#1#skssqz";
    private static final String Const1 = "totf_sjfzsf_dtb#";
    private static final String DATATYPE_SYSTEM = "1";
    private static final Map<String, MultiLangEnumBridge> fieldNameMap = new HashMap<String, MultiLangEnumBridge>();

    public static BaseResult<Object> checkZeroDeclareValues(Map<String, String> resultMap, boolean checkLicense) {
        Long orgId = Long.parseLong(resultMap.get(ORG_KEY));
        String orgName = resultMap.get("tcvat_nsrxx#1#nsrmc");
        String templateType = resultMap.get(TEMPLATE_TYPE_KEY);
        Date skssqq = DateUtils.stringToDate(resultMap.get(SKSSQQ_KEY));
        Date skssqz = DateUtils.stringToDate(resultMap.get(SKSSQZ_KEY));
        List<ZspmEnum> zspmEnums = ZspmEnum.getZeroZspmEnums(templateType);
        TaxResult licenseResult = TaxcLicenseCheckDataServiceHelper.check((Long)orgId, (String)"totf");
        boolean hasLicense = Boolean.FALSE.equals(licenseResult.getData());
        if (checkLicense && !hasLicense && EmptyCheckUtils.isEmpty(zspmEnums)) {
            return BaseResult.fail(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u3010%s\u3011\u8bb8\u53ef\u5c1a\u672a\u6fc0\u6d3b\u4e14\u975e\u6838\u5b9a\u96f6\u7533\u62a5\uff0c\u4fdd\u5b58\u5931\u8d25\u3002", (String)"QtsftysbbDeclareHelper_41", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), orgName));
        }
        List<Map<ZspmEnum, String>> listEwblxhMap = QtsftysbbDeclareHelper.findEwblxhForDeclareType(resultMap, zspmEnums);
        for (Map<ZspmEnum, String> zspmMap : listEwblxhMap) {
            String value;
            String key;
            String declaration;
            Set<Map.Entry<ZspmEnum, String>> entries = zspmMap.entrySet();
            String ewblxh = "";
            ZspmEnum zspmEnum = null;
            for (Map.Entry<ZspmEnum, String> entry : entries) {
                zspmEnum = entry.getKey();
                ewblxh = entry.getValue();
            }
            if (StringUtil.isBlank((CharSequence)ewblxh) || zspmEnum == null) continue;
            String zspmName = zspmEnum.getName();
            String zeroDeclareName = zspmEnum.getParamKey();
            boolean zerodeclare = SystemParamUtil.getZeroDeclareParameter("totf", zeroDeclareName, orgId);
            if (checkLicense && !hasLicense && !zerodeclare) {
                return BaseResult.fail(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u3010%s\u3011\u8bb8\u53ef\u5c1a\u672a\u6fc0\u6d3b\u4e14\u975e\u6838\u5b9a\u96f6\u7533\u62a5\uff0c\u4fdd\u5b58\u5931\u8d25\u3002", (String)"QtsftysbbDeclareHelper_41", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), orgName));
            }
            if (zspmEnum == ZspmEnum.DFSLJSJJ && "3".equals(declaration = OrgUtils.getOrgGroupDeclaration(orgId, "sljsjj", skssqq, skssqz)) && !zerodeclare) {
                return BaseResult.fail(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u4e3a\u88ab\u6c47\u603b\u7533\u62a5\u7ec4\u7ec7\u4e14\u6c34\u5229\u5efa\u8bbe\u57fa\u91d1\u4e3a\u975e\u96f6\u7533\u62a5\uff0c\u56e0\u6b64\u4e0d\u80fd\u751f\u6210\u7533\u62a5\u8868\u3002", (String)"QtsftysbbDeclareHelper_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            }
            if (!zerodeclare) continue;
            EntityInfo entityInfo = MetadataUtil.getEntityById("totf_sjfzsf_dtb");
            List<EntityField> fieldList = entityInfo.getFieldList();
            Map<String, EntityField> entityFieldMap = fieldList.stream().collect(Collectors.toMap(EntityField::getFieldId, t -> t));
            if (EmptyCheckUtils.isNotEmpty(zspmEnum.getZeroFields())) {
                for (String field : zspmEnum.getZeroFields()) {
                    key = String.format("totf_sjfzsf_dtb#%s#%s", ewblxh, field);
                    value = resultMap.get(key);
                    if (BigDecimalUtil.toBigDecimal(value).compareTo(BigDecimal.ZERO) == 0) continue;
                    EntityField entityField = entityFieldMap.get(field);
                    String fieldName = QtsftysbbDeclareHelper.getFieldName(templateType, entityField);
                    if ("deductioncode".equals(field)) {
                        return BaseResult.fail(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u3010%1$s\u3011%2$s\u4e3a\u96f6\u7533\u62a5\uff0c\u3010%3$s\u3011\u7684\u503c\u3010%4$s\u3011\u4e0d\u4e3a\u7a7a\u3002", (String)"QtsftysbbDeclareHelper_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), orgName, zspmName, fieldName, value));
                    }
                    return BaseResult.fail(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u3010%1$s\u3011%2$s\u4e3a\u96f6\u7533\u62a5\uff0c\u3010%3$s\u3011\u7684\u503c\u3010%4$s\u3011\u4e0d\u4e3a\u96f6\u3002", (String)"QtsftysbbDeclareHelper_2", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), orgName, zspmName, fieldName, value));
                }
            }
            if (!EmptyCheckUtils.isNotEmpty(zspmEnum.getEmptyFields())) continue;
            for (String field : zspmEnum.getEmptyFields()) {
                key = String.format("totf_sjfzsf_dtb#%s#%s", ewblxh, field);
                value = resultMap.get(key);
                if (!EmptyCheckUtils.isNotEmpty(value)) continue;
                EntityField entityField = entityFieldMap.get(field);
                String fieldName = QtsftysbbDeclareHelper.getFieldName(templateType, entityField);
                return BaseResult.fail(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u3010%1$s\u3011%2$s\u4e3a\u96f6\u7533\u62a5\uff0c\u3010%3$s\u3011\u7684\u503c\u3010%4$s\u3011\u4e0d\u4e3a\u7a7a\u3002", (String)"QtsftysbbDeclareHelper_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), orgName, zspmName, fieldName, value));
            }
        }
        return BaseResult.ok();
    }

    private static String getFieldName(String templateType, EntityField entityField) {
        MultiLangEnumBridge multiLangEnumBridge;
        String fieldName = entityField.getFieldName();
        if ("qtsf_fsstysbb".equals(templateType) && (multiLangEnumBridge = fieldNameMap.get(entityField.getFieldId())) != null) {
            fieldName = multiLangEnumBridge.loadKDString();
        }
        return fieldName;
    }

    private static List<Map<ZspmEnum, String>> findEwblxhForDeclareType(Map<String, String> resultMap, List<ZspmEnum> zspmEnums) {
        ArrayList<Map<ZspmEnum, String>> rows = new ArrayList<Map<ZspmEnum, String>>();
        for (ZspmEnum zspmEnum : zspmEnums) {
            String zspmName = zspmEnum.getName();
            for (Map.Entry<String, String> entry : resultMap.entrySet()) {
                String[] split = entry.getKey().split("#");
                if (split.length != 3 || !"zspm".equals(split[2]) || !zspmName.equals(entry.getValue())) continue;
                HashMap<ZspmEnum, String> result = new HashMap<ZspmEnum, String>();
                result.put(zspmEnum, split[1]);
                rows.add(result);
            }
        }
        return rows;
    }

    public static void checkDynRowData(Map<String, String> resultMap, Long orgid, Map<String, String> zspmAndzsxmMap) {
        String declaredateStr = resultMap.get("tcvat_nsrxx#1#declaredate");
        Date declaredate = QtsftysbbDeclareHelper.formatDateStr(declaredateStr, ResManager.loadKDString((String)"\u7533\u62a5\u65e5\u671f", (String)"QtsftysbbDeclareHelper_3", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        if (declaredate == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7533\u62a5\u65e5\u671f\u3002", (String)"QtsftysbbDeclareHelper_4", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
        ArrayList zmspStrings = Lists.newArrayList();
        DynamicObjectCollection qtsfentity = new DynamicObjectCollection();
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainQtsfByOrgId(Collections.singletonList(orgid));
        if (EmptyCheckUtils.isNotEmpty(result.getData())) {
            qtsfentity = ((DynamicObject)((List)result.getData()).get(0)).getDynamicObjectCollection("qtsfentity");
        }
        QtsftysbbDeclareHelper.isEnableTaxcCard(orgid, resultMap.get("tcvat_nsrxx#1#nsrmc"));
        ArrayList<String> checkDateList = new ArrayList<String>();
        String type = resultMap.get(TEMPLATE_TYPE_KEY);
        String datatype = resultMap.get("tcvat_nsrxx#1#datatype");
        for (Map.Entry<String, String> entry : resultMap.entrySet()) {
            String key = entry.getKey();
            String[] split = key.split("#");
            if (split.length != 3 || !"zsxm".equals(split[2])) continue;
            String zsxm = resultMap.get(Const1.concat(split[1]).concat("#zsxm"));
            DynamicObject zsxmObj = QueryServiceHelper.queryOne((String)"bd_taxcategory", (String)"id", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)zsxm)});
            if (zsxm == null || zsxmObj == null || !zspmAndzsxmMap.values().contains(zsxm)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f81\u6536\u9879\u76ee\u4e3a\u7a7a\u6216\u8005\u4e0d\u7b26\u5408\u8981\u6c42\uff1a%s\u3002", (String)"QtsftysbbDeclareHelper_5", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), zsxm));
            }
            String zspm = resultMap.get(Const1.concat(split[1]).concat("#zspm"));
            DynamicObject zspmObj = QueryServiceHelper.queryOne((String)"tpo_zspm", (String)"id,taxtype", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)zspm)});
            if (BaseTaxCategory.JSXZSYXSFSR.longValue() == zsxmObj.getLong("id")) {
                zspmObj = QueryServiceHelper.queryOne((String)"tpo_zspm", (String)"id,taxtype", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"0091")});
            }
            if (zspm == null || zspmObj == null || !zspmAndzsxmMap.containsKey(zspm)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f81\u6536\u54c1\u76ee\u4e3a\u7a7a\u6216\u8005\u4e0d\u7b26\u5408\u8981\u6c42\uff1a%s\u3002", (String)"QtsftysbbDeclareHelper_6", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), zspm));
            }
            zmspStrings.add(zspm);
            if (!zsxm.equals(zspmAndzsxmMap.get(zspm))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f81\u6536\u54c1\u76ee\u548c\u5f81\u6536\u9879\u76ee\u4e0d\u5339\u914d\uff1a%s\u3002", (String)"QtsftysbbDeclareHelper_7", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), zspm));
            }
            String startdate = resultMap.get(Const1.concat(split[1]).concat("#startdate"));
            Date startdateDate = QtsftysbbDeclareHelper.formatDateStr(startdate, ResManager.loadKDString((String)"\u7a0e\uff08\u8d39\uff09 \u6b3e\u6240\u5c5e\u671f\u8d77", (String)"QtsftysbbDeclareHelper_8", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            String enddate = resultMap.get(Const1.concat(split[1]).concat("#enddate"));
            Date enddateDate = QtsftysbbDeclareHelper.formatDateStr(enddate, ResManager.loadKDString((String)"\u7a0e\uff08\u8d39\uff09 \u6b3e\u6240\u5c5e\u671f\u6b62", (String)"QtsftysbbDeclareHelper_9", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            if (startdateDate == null || enddateDate == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7a0e\uff08\u8d39\uff09 \u6b3e\u6240\u5c5e\u671f\u8d77\u548c\u6b62\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QtsftysbbDeclareHelper_10", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            }
            if (startdateDate.compareTo(enddateDate) == 0) {
                String strart = DateUtils.format(startdateDate);
                if (checkDateList.contains(strart)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6309\u6b21\u7533\u62a5\u7684\u591a\u884c\u76f8\u540c\u5f81\u6536\u54c1\u76ee\uff0c\u7a0e\u6b3e\u6240\u5c5e\u671f\u8d77\u6b62\u8303\u56f4\u4e0d\u80fd\u76f8\u540c\u3002", (String)"QtsftysbbDeclareHelper_19", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                }
                checkDateList.add(strart);
            } else if (DateUtils.getFirstDateOfMonth(startdateDate).compareTo(startdateDate) != 0 || DateUtils.getLastDateOfMonth2(enddateDate).compareTo(enddateDate) != 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u975e\u6309\u6b21\u7533\u62a5\u7684\u3010\u7a0e\u6b3e\u6240\u5c5e\u671f\u8d77\u3011\u3010\u7a0e\u6b3e\u6240\u5c5e\u671f\u6b62\u3011\u5fc5\u987b\u6708\u5934\u548c\u6708\u5c3e\uff0c\u6309\u6b21\u7533\u62a5\u7684\u3010\u7a0e\u6b3e\u6240\u5c5e\u671f\u8d77\u3011\u3010\u7a0e\u6b3e\u6240\u5c5e\u671f\u6b62\u3011\u5e74\u6708\u65e5\u5fc5\u987b\u4e00\u6837\u3002", (String)"QtsftysbbDeclareHelper_17", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            }
            Optional<DynamicObject> first = qtsfentity.stream().filter(s -> zspm.equals(s.getString("collectrate.name"))).filter(s -> startdateDate.compareTo(s.getDate("effectivestart")) >= 0).filter(s -> s.getDate("effectiveend") == null || enddateDate.compareTo(s.getDate("effectiveend")) <= 0).findFirst();
            if (!first.isPresent()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6b64\u5f81\u6536\u54c1\u76ee\u53ca\u5176\u7a0e\u6b3e\u6240\u5c5e\u671f\u8d77\u6b62\u6ca1\u6709\u7ef4\u62a4\u5230\u5176\u4ed6\u7a0e\u8d39\u5361\u7247\u3002", (String)"QtsftysbbDeclareHelper_11", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            }
            if (!DateUtils.validDateRange(first.get().getString("taxperiod"), startdateDate, enddateDate)) {
                String taxPeriodName = "";
                switch (first.get().getString("taxperiod")) {
                    case "year": {
                        taxPeriodName = ResManager.loadKDString((String)"\u8be5\u5f81\u6536\u54c1\u76ee\u7f34\u7eb3\u671f\u9650\u4e3a\u3010\u5e74\u3011\u3002", (String)"QtsftysbbDeclareHelper_20", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
                        break;
                    }
                    case "halfyear": {
                        taxPeriodName = ResManager.loadKDString((String)"\u8be5\u5f81\u6536\u54c1\u76ee\u7f34\u7eb3\u671f\u9650\u4e3a\u3010\u534a\u5e74\u3011\u3002", (String)"QtsftysbbDeclareHelper_21", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
                        break;
                    }
                    case "season": {
                        taxPeriodName = ResManager.loadKDString((String)"\u8be5\u5f81\u6536\u54c1\u76ee\u7f34\u7eb3\u671f\u9650\u4e3a\u3010\u5b63\u3011\u3002", (String)"QtsftysbbDeclareHelper_22", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
                        break;
                    }
                    case "month": {
                        taxPeriodName = ResManager.loadKDString((String)"\u8be5\u5f81\u6536\u54c1\u76ee\u7f34\u7eb3\u671f\u9650\u4e3a\u3010\u6708\u3011\u3002", (String)"QtsftysbbDeclareHelper_23", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
                        break;
                    }
                    case "count": {
                        taxPeriodName = ResManager.loadKDString((String)"\u8be5\u5f81\u6536\u54c1\u76ee\u7f34\u7eb3\u671f\u9650\u4e3a\u3010\u6b21\u3011\u3002", (String)"QtsftysbbDeclareHelper_24", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
                    }
                }
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\uff1a \u5f81\u6536\u54c1\u76ee\u7684\u8d39\u6b3e\u6240\u5c5e\u671f\u4e0d\u7b26\u5408\u7f34\u7eb3\u671f\u9650\u7684\u8981\u6c42\uff0c%2$s", (String)"QtsftysbbDeclareHelper_18", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), zspm, taxPeriodName));
            }
            int month = DateUtils.getMonthOfDate(declaredate);
            boolean check = false;
            String taxperiod = first.get().getString("taxperiod");
            if ("season".equals(taxperiod) && month != 1 && month != 4 && month != 7 && month != 10) {
                check = true;
            } else if ("halfyear".equals(taxperiod) && month != 1 && month != 7) {
                check = true;
            } else if ("year".equals(taxperiod) && month != 1) {
                check = true;
            }
            if (check) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7533\u62a5\u65e5\u671f\u4e0e\u5f81\u6536\u54c1\u76ee\u7684\u7f34\u7eb3\u671f\u9650\u4e0d\u7b26\u3002\u6309\u5b63\u7533\u62a5\uff0c\u7533\u62a5\u65e5\u671f\u4e3a4\u30017\u300110\u30011\u6708\uff0c\u6309\u5e74\u7533\u62a5\uff0c\u7533\u62a5\u65e5\u671f\u4e3a1\u6708\uff0c\u6309\u534a\u5e74\u7533\u62a5\u7533\u62a5\u65e5\u671f\u4e3a7\u6708\u30011\u6708", (String)"QtsftysbbDeclareHelper_12", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            }
            if ("count".equals(taxperiod)) {
                if (declaredate.compareTo(enddateDate) < 0) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7533\u62a5\u65e5\u671f\u4e0e\u5f81\u6536\u54c1\u76ee\u3010%s\u3011\u7684\u7f34\u7eb3\u671f\u9650\u4e0d\u7b26\u3002\u6309\u6b21\u7533\u62a5\uff0c\u7533\u62a5\u65e5\u671f\u5e94\u5927\u4e8e\u7b49\u4e8e\u6240\u5c5e\u7a0e\u671f\u6b62\u3002", (String)"QtsftysbbDeclareHelper_44", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), zspm));
                }
            } else {
                if (!DateUtils.formatMonth(DateUtils.addMonth(declaredate, -1)).equals(DateUtils.formatMonth(enddateDate))) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7533\u62a5\u65e5\u671f\u4e0e\u5f81\u6536\u54c1\u76ee\u3010%s\u3011\u7684\u7f34\u7eb3\u671f\u9650\u4e0d\u7b26\u3002\u6309\u671f\u7533\u62a5\uff0c\u7533\u62a5\u65e5\u671f\u5e94\u4e3a\u6240\u5c5e\u671f\u6b62\u6b21\u6708\u3002", (String)"QtsftysbbDeclareHelper_42", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), zspm));
                }
                if (!("qtsf_fsstysbb".equals(type) && DATATYPE_SYSTEM.equals(datatype) && ZspmEnum.CZLJCLF.getName().equals(zspm))) {
                    ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
                    String sbbid = resultMap.get("tcvat_nsrxx#1#id");
                    if (EmptyCheckUtils.isNotEmpty(sbbid)) {
                        qFilters.add(new QFilter("id", "!=", (Object)Long.parseLong(sbbid)));
                    }
                    qFilters.add(new QFilter("org", "=", (Object)orgid));
                    qFilters.add(new QFilter("taxauthority", "=", (Object)Long.parseLong(resultMap.get("tcvat_nsrxx#1#taxauthority"))));
                    qFilters.add(new QFilter("entryentity.startdate", "=", (Object)startdateDate));
                    qFilters.add(new QFilter("entryentity.enddate", "=", (Object)enddateDate));
                    qFilters.add(new QFilter("entryentity.zspm", "=", (Object)zspm));
                    DynamicObject object = QueryServiceHelper.queryOne((String)"totf_tysb_declare_main", (String)"billno", (QFilter[])qFilters.toArray(new QFilter[0]));
                    if (object != null) {
                        String nsrmc = resultMap.get("tcvat_nsrxx#1#nsrmc");
                        String msg = String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011%2$s\u81f3%3$s\u3010%4$s\u3011\u7684\u7533\u62a5\u8868\u3010%5$s\u3011\u5df2\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u8986\u76d6\uff01", (String)"QtsftysbbDeclareHelper_43", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), nsrmc, startdate, enddate, zspm, object.getString("billno"));
                        throw new KDBizException(msg);
                    }
                }
            }
            String deductioncodeId = resultMap.get(Const1.concat(split[1]).concat("#deductioncode"));
            QtsftysbbDeclareHelper.checkTaxdeductionMap(zsxm, deductioncodeId);
        }
        if (zmspStrings.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7533\u62a5\u7684\u201c\u5f81\u6536\u54c1\u76ee\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QtsftysbbDeclareHelper_13", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
        if (Sets.newHashSet((Iterable)zmspStrings).size() != zmspStrings.size()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7533\u62a5\u7684\u201c\u5f81\u6536\u54c1\u76ee\u201d\u4e0d\u80fd\u91cd\u590d\u3002", (String)"QtsftysbbDeclareHelper_14", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
    }

    public static void checkDynRowImportData(Map<String, String> resultMap, Long orgid, Map<String, String> zspmAndzsxmMap) {
        String declaredateStr = resultMap.get("tcvat_nsrxx#1#declaredate");
        Date declaredate = QtsftysbbDeclareHelper.formatDateStr(declaredateStr, ResManager.loadKDString((String)"\u7533\u62a5\u65e5\u671f", (String)"QtsftysbbDeclareHelper_3", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        if (declaredate == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7533\u62a5\u65e5\u671f\u3002", (String)"QtsftysbbDeclareHelper_4", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
        ArrayList zmspStrings = Lists.newArrayList();
        DynamicObjectCollection qtsfentity = new DynamicObjectCollection();
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainQtsfByOrgId(Collections.singletonList(orgid));
        if (EmptyCheckUtils.isNotEmpty(result.getData())) {
            qtsfentity = ((DynamicObject)((List)result.getData()).get(0)).getDynamicObjectCollection("qtsfentity");
        }
        QtsftysbbDeclareHelper.isEnableTaxcCard(orgid, resultMap.get("tcvat_nsrxx#1#nsrmc"));
        ArrayList<String> checkDateList = new ArrayList<String>();
        String type = resultMap.get(TEMPLATE_TYPE_KEY);
        String datatype = resultMap.get("tcvat_nsrxx#1#datatype");
        Optional<DynamicObject> ghjfHalfYearOpt = qtsfentity.stream().filter(e -> ZspmEnum.GHJH.getName().equals(e.getString("collectrate.name")) && "halfyear".equals(e.getString("taxperiod"))).findFirst();
        Optional<DynamicObject> ghcbjHalfYearOpt = qtsfentity.stream().filter(e -> ZspmEnum.GHCBJ.getName().equals(e.getString("collectrate.name")) && "halfyear".equals(e.getString("taxperiod"))).findFirst();
        ArrayList<Map.Entry<String, String>> ghjfMap = new ArrayList<Map.Entry<String, String>>(2);
        ArrayList<Map.Entry<String, String>> ghcbjMap = new ArrayList<Map.Entry<String, String>>(2);
        ArrayList<Map.Entry<String, String>> otherEntryMap = new ArrayList<Map.Entry<String, String>>(8);
        for (Map.Entry<String, String> entry : resultMap.entrySet()) {
            if (!entry.getKey().contains("zspm")) continue;
            if (ZspmEnum.GHJH.getName().equals(entry.getValue()) && ghjfHalfYearOpt.isPresent()) {
                ghjfMap.add(entry);
                continue;
            }
            if (ZspmEnum.GHCBJ.getName().equals(entry.getValue()) && ghcbjHalfYearOpt.isPresent()) {
                ghcbjMap.add(entry);
                continue;
            }
            otherEntryMap.add(entry);
        }
        if (ghjfMap.size() == 2) {
            QtsftysbbDeclareHelper.checkDynRowImportHalfYearData(resultMap, ghjfMap, orgid, zspmAndzsxmMap, declaredate, qtsfentity);
        } else {
            otherEntryMap.addAll(ghjfMap);
        }
        if (ghcbjMap.size() == 2) {
            QtsftysbbDeclareHelper.checkDynRowImportHalfYearData(resultMap, ghcbjMap, orgid, zspmAndzsxmMap, declaredate, qtsfentity);
        } else {
            otherEntryMap.addAll(ghcbjMap);
        }
        if (otherEntryMap.size() > 0) {
            QtsftysbbDeclareHelper.checkDynRowImportData(resultMap, otherEntryMap, orgid, zspmAndzsxmMap, declaredate, zmspStrings, qtsfentity, checkDateList, type, datatype);
        }
    }

    private static void checkDynRowImportHalfYearData(Map<String, String> resultMap, List<Map.Entry<String, String>> entryMap, Long orgid, Map<String, String> zspmAndzsxmMap, Date declaredate, DynamicObjectCollection qtsfentity) {
        Date startDate;
        Date endDate;
        for (Map.Entry<String, String> entry : entryMap) {
            String key = entry.getKey();
            String[] split = key.split("#");
            if (split.length != 3) continue;
            String zsxm = resultMap.get(Const1.concat(split[1]).concat("#zsxm"));
            DynamicObject zsxmObj = QueryServiceHelper.queryOne((String)"bd_taxcategory", (String)"id", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)zsxm)});
            if (zsxm == null || zsxmObj == null || !zspmAndzsxmMap.values().contains(zsxm)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f81\u6536\u9879\u76ee\u4e3a\u7a7a\u6216\u8005\u4e0d\u7b26\u5408\u8981\u6c42\uff1a%s\u3002", (String)"QtsftysbbDeclareHelper_5", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), zsxm));
            }
            String zspm = resultMap.get(Const1.concat(split[1]).concat("#zspm"));
            DynamicObject zspmObj = QueryServiceHelper.queryOne((String)"tpo_zspm", (String)"id,taxtype", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)zspm)});
            if (BaseTaxCategory.JSXZSYXSFSR.longValue() == zsxmObj.getLong("id")) {
                zspmObj = QueryServiceHelper.queryOne((String)"tpo_zspm", (String)"id,taxtype", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"0091")});
            }
            if (zspm == null || zspmObj == null || !zspmAndzsxmMap.containsKey(zspm)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f81\u6536\u54c1\u76ee\u4e3a\u7a7a\u6216\u8005\u4e0d\u7b26\u5408\u8981\u6c42\uff1a%s\u3002", (String)"QtsftysbbDeclareHelper_6", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), zspm));
            }
            if (!zsxm.equals(zspmAndzsxmMap.get(zspm))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f81\u6536\u54c1\u76ee\u548c\u5f81\u6536\u9879\u76ee\u4e0d\u5339\u914d\uff1a%s\u3002", (String)"QtsftysbbDeclareHelper_7", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), zspm));
            }
            String startdate = resultMap.get(Const1.concat(split[1]).concat("#startdate"));
            Date startdateDate = QtsftysbbDeclareHelper.formatDateStr(startdate, ResManager.loadKDString((String)"\u7a0e\uff08\u8d39\uff09 \u6b3e\u6240\u5c5e\u671f\u8d77", (String)"QtsftysbbDeclareHelper_8", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            String enddate = resultMap.get(Const1.concat(split[1]).concat("#enddate"));
            Date enddateDate = QtsftysbbDeclareHelper.formatDateStr(enddate, ResManager.loadKDString((String)"\u7a0e\uff08\u8d39\uff09 \u6b3e\u6240\u5c5e\u671f\u6b62", (String)"QtsftysbbDeclareHelper_9", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            if (startdateDate == null || enddateDate == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7a0e\uff08\u8d39\uff09 \u6b3e\u6240\u5c5e\u671f\u8d77\u548c\u6b62\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QtsftysbbDeclareHelper_10", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            }
            if (DateUtils.getFirstDateOfMonth(startdateDate).compareTo(startdateDate) != 0 || DateUtils.getLastDateOfMonth2(enddateDate).compareTo(enddateDate) != 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u975e\u6309\u6b21\u7533\u62a5\u7684\u3010\u7a0e\u6b3e\u6240\u5c5e\u671f\u8d77\u3011\u3010\u7a0e\u6b3e\u6240\u5c5e\u671f\u6b62\u3011\u5fc5\u987b\u6708\u5934\u548c\u6708\u5c3e\uff0c\u6309\u6b21\u7533\u62a5\u7684\u3010\u7a0e\u6b3e\u6240\u5c5e\u671f\u8d77\u3011\u3010\u7a0e\u6b3e\u6240\u5c5e\u671f\u6b62\u3011\u5e74\u6708\u65e5\u5fc5\u987b\u4e00\u6837\u3002", (String)"QtsftysbbDeclareHelper_17", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            }
            Optional<DynamicObject> first = qtsfentity.stream().filter(s -> zspm.equals(s.getString("collectrate.name"))).filter(s -> startdateDate.compareTo(s.getDate("effectivestart")) >= 0).filter(s -> s.getDate("effectiveend") == null || enddateDate.compareTo(s.getDate("effectiveend")) <= 0).findFirst();
            if (!first.isPresent()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6b64\u5f81\u6536\u54c1\u76ee\u53ca\u5176\u7a0e\u6b3e\u6240\u5c5e\u671f\u8d77\u6b62\u6ca1\u6709\u7ef4\u62a4\u5230\u5176\u4ed6\u7a0e\u8d39\u5361\u7247\u3002", (String)"QtsftysbbDeclareHelper_11", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            }
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            String sbbid = resultMap.get("tcvat_nsrxx#1#id");
            if (EmptyCheckUtils.isNotEmpty(sbbid)) {
                qFilters.add(new QFilter("id", "!=", (Object)Long.parseLong(sbbid)));
            }
            qFilters.add(new QFilter("org", "=", (Object)orgid));
            qFilters.add(new QFilter("taxauthority", "=", (Object)Long.parseLong(resultMap.get("tcvat_nsrxx#1#taxauthority"))));
            qFilters.add(new QFilter("entryentity.startdate", "=", (Object)startdateDate));
            qFilters.add(new QFilter("entryentity.enddate", "=", (Object)enddateDate));
            qFilters.add(new QFilter("entryentity.zspm", "=", (Object)zspm));
            DynamicObject object = QueryServiceHelper.queryOne((String)"totf_tysb_declare_main", (String)"billno", (QFilter[])qFilters.toArray(new QFilter[0]));
            if (object != null) {
                String nsrmc = resultMap.get("tcvat_nsrxx#1#nsrmc");
                String msg = String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011%2$s\u81f3%3$s\u3010%4$s\u3011\u7684\u7533\u62a5\u8868\u3010%5$s\u3011\u5df2\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u8986\u76d6\uff01", (String)"QtsftysbbDeclareHelper_43", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), nsrmc, startdate, enddate, zspm, object.getString("billno"));
                throw new KDBizException(msg);
            }
            String deductioncodeId = resultMap.get(Const1.concat(split[1]).concat("#deductioncode"));
            QtsftysbbDeclareHelper.checkTaxdeductionMap(zsxm, deductioncodeId);
        }
        Map.Entry<String, String> entry0 = entryMap.get(0);
        String[] split0 = entry0.getKey().split("#");
        String startdate0 = resultMap.get(Const1.concat(split0[1]).concat("#startdate"));
        Date startdateDate0 = QtsftysbbDeclareHelper.formatDateStr(startdate0, ResManager.loadKDString((String)"\u7a0e\uff08\u8d39\uff09 \u6b3e\u6240\u5c5e\u671f\u8d77", (String)"QtsftysbbDeclareHelper_8", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        String enddate0 = resultMap.get(Const1.concat(split0[1]).concat("#enddate"));
        Date enddateDate0 = QtsftysbbDeclareHelper.formatDateStr(enddate0, ResManager.loadKDString((String)"\u7a0e\uff08\u8d39\uff09 \u6b3e\u6240\u5c5e\u671f\u6b62", (String)"QtsftysbbDeclareHelper_9", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        Map.Entry<String, String> entry1 = entryMap.get(1);
        String[] split1 = entry1.getKey().split("#");
        String startdate1 = resultMap.get(Const1.concat(split1[1]).concat("#startdate"));
        Date startdateDate1 = QtsftysbbDeclareHelper.formatDateStr(startdate1, ResManager.loadKDString((String)"\u7a0e\uff08\u8d39\uff09 \u6b3e\u6240\u5c5e\u671f\u8d77", (String)"QtsftysbbDeclareHelper_8", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        String enddate1 = resultMap.get(Const1.concat(split1[1]).concat("#enddate"));
        Date enddateDate1 = QtsftysbbDeclareHelper.formatDateStr(enddate1, ResManager.loadKDString((String)"\u7a0e\uff08\u8d39\uff09 \u6b3e\u6240\u5c5e\u671f\u6b62", (String)"QtsftysbbDeclareHelper_9", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        if (startdateDate0 == null || enddateDate0 == null || startdateDate1 == null || enddateDate1 == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7a0e\uff08\u8d39\uff09 \u6b3e\u6240\u5c5e\u671f\u8d77\u548c\u6b62\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QtsftysbbDeclareHelper_10", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
        if (enddateDate0.compareTo(enddateDate1) > 0) {
            endDate = enddateDate0;
            startDate = startdateDate1;
        } else {
            endDate = enddateDate1;
            startDate = startdateDate0;
        }
        int monthDiff = DateUtils.getMonthDiff(endDate, startDate);
        if (monthDiff != 5) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5de5\u4f1a\u7ecf\u8d39/\u5de5\u4f1a\u7b79\u5907\u91d1\uff1a\u5f81\u6536\u54c1\u76ee\u7684\u8d39\u6b3e\u6240\u5c5e\u671f\u4e0d\u7b26\u5408\u7eb3\u7a0e\u671f\u9650\u7684\u8981\u6c42\uff0c\u8be5\u5f81\u6536\u54c1\u76ee\u7f34\u7eb3\u671f\u9650\u4e3a\u3010\u534a\u5e74\u3011\u3002", (String)"QtsftysbbDeclareHelper_50", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
        String zspm = resultMap.get(Const1.concat(split0[1]).concat("#zspm"));
        if (!DateUtils.formatMonth(DateUtils.addMonth(declaredate, -1)).equals(DateUtils.formatMonth(endDate))) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7533\u62a5\u65e5\u671f\u4e0e\u5f81\u6536\u54c1\u76ee\u3010%s\u3011\u7684\u7f34\u7eb3\u671f\u9650\u4e0d\u7b26\u3002\u6309\u671f\u7533\u62a5\uff0c\u7533\u62a5\u65e5\u671f\u5e94\u4e3a\u6240\u5c5e\u671f\u6b62\u6b21\u6708\u3002", (String)"QtsftysbbDeclareHelper_42", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), zspm));
        }
    }

    private static void checkDynRowImportData(Map<String, String> resultMap, List<Map.Entry<String, String>> entryMap, Long orgid, Map<String, String> zspmAndzsxmMap, Date declaredate, List<String> zmspStrings, DynamicObjectCollection qtsfentity, List<String> checkDateList, String type, String datatype) {
        for (Map.Entry<String, String> entry : entryMap) {
            String key = entry.getKey();
            String[] split = key.split("#");
            if (split.length != 3) continue;
            String zsxm = resultMap.get(Const1.concat(split[1]).concat("#zsxm"));
            DynamicObject zsxmObj = QueryServiceHelper.queryOne((String)"bd_taxcategory", (String)"id", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)zsxm)});
            if (zsxm == null || zsxmObj == null || !zspmAndzsxmMap.values().contains(zsxm)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f81\u6536\u9879\u76ee\u4e3a\u7a7a\u6216\u8005\u4e0d\u7b26\u5408\u8981\u6c42\uff1a%s\u3002", (String)"QtsftysbbDeclareHelper_5", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), zsxm));
            }
            String zspm = resultMap.get(Const1.concat(split[1]).concat("#zspm"));
            DynamicObject zspmObj = QueryServiceHelper.queryOne((String)"tpo_zspm", (String)"id,taxtype", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)zspm)});
            if (BaseTaxCategory.JSXZSYXSFSR.longValue() == zsxmObj.getLong("id")) {
                zspmObj = QueryServiceHelper.queryOne((String)"tpo_zspm", (String)"id,taxtype", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"0091")});
            }
            logger.info("\u5f81\u6536\u54c1\u76ee\uff1a" + zspm);
            if (zspm == null || zspmObj == null || !zspmAndzsxmMap.containsKey(zspm)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f81\u6536\u54c1\u76ee\u4e3a\u7a7a\u6216\u8005\u4e0d\u7b26\u5408\u8981\u6c42\uff1a%s\u3002", (String)"QtsftysbbDeclareHelper_6", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), zspm));
            }
            zmspStrings.add(zspm);
            if (!zsxm.equals(zspmAndzsxmMap.get(zspm))) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f81\u6536\u54c1\u76ee\u548c\u5f81\u6536\u9879\u76ee\u4e0d\u5339\u914d\uff1a%s\u3002", (String)"QtsftysbbDeclareHelper_7", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), zspm));
            }
            String startdate = resultMap.get(Const1.concat(split[1]).concat("#startdate"));
            Date startdateDate = QtsftysbbDeclareHelper.formatDateStr(startdate, ResManager.loadKDString((String)"\u7a0e\uff08\u8d39\uff09 \u6b3e\u6240\u5c5e\u671f\u8d77", (String)"QtsftysbbDeclareHelper_8", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            String enddate = resultMap.get(Const1.concat(split[1]).concat("#enddate"));
            Date enddateDate = QtsftysbbDeclareHelper.formatDateStr(enddate, ResManager.loadKDString((String)"\u7a0e\uff08\u8d39\uff09 \u6b3e\u6240\u5c5e\u671f\u6b62", (String)"QtsftysbbDeclareHelper_9", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            if (startdateDate == null || enddateDate == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7a0e\uff08\u8d39\uff09 \u6b3e\u6240\u5c5e\u671f\u8d77\u548c\u6b62\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QtsftysbbDeclareHelper_10", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            }
            if (startdateDate.compareTo(enddateDate) == 0) {
                String strart = DateUtils.format(startdateDate);
                if (checkDateList.contains(strart)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6309\u6b21\u7533\u62a5\u7684\u591a\u884c\u76f8\u540c\u5f81\u6536\u54c1\u76ee\uff0c\u7a0e\u6b3e\u6240\u5c5e\u671f\u8d77\u6b62\u8303\u56f4\u4e0d\u80fd\u76f8\u540c\u3002", (String)"QtsftysbbDeclareHelper_19", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
                }
                checkDateList.add(strart);
            } else if (DateUtils.getFirstDateOfMonth(startdateDate).compareTo(startdateDate) != 0 || DateUtils.getLastDateOfMonth2(enddateDate).compareTo(enddateDate) != 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u975e\u6309\u6b21\u7533\u62a5\u7684\u3010\u7a0e\u6b3e\u6240\u5c5e\u671f\u8d77\u3011\u3010\u7a0e\u6b3e\u6240\u5c5e\u671f\u6b62\u3011\u5fc5\u987b\u6708\u5934\u548c\u6708\u5c3e\uff0c\u6309\u6b21\u7533\u62a5\u7684\u3010\u7a0e\u6b3e\u6240\u5c5e\u671f\u8d77\u3011\u3010\u7a0e\u6b3e\u6240\u5c5e\u671f\u6b62\u3011\u5e74\u6708\u65e5\u5fc5\u987b\u4e00\u6837\u3002", (String)"QtsftysbbDeclareHelper_17", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            }
            Optional<DynamicObject> first = qtsfentity.stream().filter(s -> zspm.equals(s.getString("collectrate.name"))).filter(s -> startdateDate.compareTo(s.getDate("effectivestart")) >= 0).filter(s -> s.getDate("effectiveend") == null || enddateDate.compareTo(s.getDate("effectiveend")) <= 0).findFirst();
            if (!first.isPresent()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6b64\u5f81\u6536\u54c1\u76ee\u53ca\u5176\u7a0e\u6b3e\u6240\u5c5e\u671f\u8d77\u6b62\u6ca1\u6709\u7ef4\u62a4\u5230\u5176\u4ed6\u7a0e\u8d39\u5361\u7247\u3002", (String)"QtsftysbbDeclareHelper_11", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            }
            if (!DateUtils.validDateRange(first.get().getString("taxperiod"), startdateDate, enddateDate)) {
                String taxPeriodName = "";
                switch (first.get().getString("taxperiod")) {
                    case "year": {
                        taxPeriodName = ResManager.loadKDString((String)"\u8be5\u5f81\u6536\u54c1\u76ee\u7f34\u7eb3\u671f\u9650\u4e3a\u3010\u5e74\u3011\u3002", (String)"QtsftysbbDeclareHelper_20", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
                        break;
                    }
                    case "halfyear": {
                        taxPeriodName = ResManager.loadKDString((String)"\u8be5\u5f81\u6536\u54c1\u76ee\u7f34\u7eb3\u671f\u9650\u4e3a\u3010\u534a\u5e74\u3011\u3002", (String)"QtsftysbbDeclareHelper_21", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
                        break;
                    }
                    case "season": {
                        taxPeriodName = ResManager.loadKDString((String)"\u8be5\u5f81\u6536\u54c1\u76ee\u7f34\u7eb3\u671f\u9650\u4e3a\u3010\u5b63\u3011\u3002", (String)"QtsftysbbDeclareHelper_22", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
                        break;
                    }
                    case "month": {
                        taxPeriodName = ResManager.loadKDString((String)"\u8be5\u5f81\u6536\u54c1\u76ee\u7f34\u7eb3\u671f\u9650\u4e3a\u3010\u6708\u3011\u3002", (String)"QtsftysbbDeclareHelper_23", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
                        break;
                    }
                    case "count": {
                        taxPeriodName = ResManager.loadKDString((String)"\u8be5\u5f81\u6536\u54c1\u76ee\u7f34\u7eb3\u671f\u9650\u4e3a\u3010\u6b21\u3011\u3002", (String)"QtsftysbbDeclareHelper_24", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
                    }
                }
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\uff1a \u5f81\u6536\u54c1\u76ee\u7684\u8d39\u6b3e\u6240\u5c5e\u671f\u4e0d\u7b26\u5408\u7f34\u7eb3\u671f\u9650\u7684\u8981\u6c42\uff0c%2$s", (String)"QtsftysbbDeclareHelper_18", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), zspm, taxPeriodName));
            }
            int month = DateUtils.getMonthOfDate(declaredate);
            boolean check = false;
            String taxperiod = first.get().getString("taxperiod");
            if ("season".equals(taxperiod) && month != 1 && month != 4 && month != 7 && month != 10) {
                check = true;
            } else if ("halfyear".equals(taxperiod) && month != 1 && month != 7) {
                check = true;
            } else if ("year".equals(taxperiod) && month != 1) {
                check = true;
            }
            if (check) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7533\u62a5\u65e5\u671f\u4e0e\u5f81\u6536\u54c1\u76ee\u7684\u7f34\u7eb3\u671f\u9650\u4e0d\u7b26\u3002\u6309\u5b63\u7533\u62a5\uff0c\u7533\u62a5\u65e5\u671f\u4e3a4\u30017\u300110\u30011\u6708\uff0c\u6309\u5e74\u7533\u62a5\uff0c\u7533\u62a5\u65e5\u671f\u4e3a1\u6708\uff0c\u6309\u534a\u5e74\u7533\u62a5\u7533\u62a5\u65e5\u671f\u4e3a7\u6708\u30011\u6708", (String)"QtsftysbbDeclareHelper_12", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            }
            if ("count".equals(taxperiod)) {
                if (declaredate.compareTo(enddateDate) < 0) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7533\u62a5\u65e5\u671f\u4e0e\u5f81\u6536\u54c1\u76ee\u3010%s\u3011\u7684\u7f34\u7eb3\u671f\u9650\u4e0d\u7b26\u3002\u6309\u6b21\u7533\u62a5\uff0c\u7533\u62a5\u65e5\u671f\u5e94\u5927\u4e8e\u7b49\u4e8e\u6240\u5c5e\u7a0e\u671f\u6b62\u3002", (String)"QtsftysbbDeclareHelper_44", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), zspm));
                }
            } else {
                if (!DateUtils.formatMonth(DateUtils.addMonth(declaredate, -1)).equals(DateUtils.formatMonth(enddateDate))) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7533\u62a5\u65e5\u671f\u4e0e\u5f81\u6536\u54c1\u76ee\u3010%s\u3011\u7684\u7f34\u7eb3\u671f\u9650\u4e0d\u7b26\u3002\u6309\u671f\u7533\u62a5\uff0c\u7533\u62a5\u65e5\u671f\u5e94\u4e3a\u6240\u5c5e\u671f\u6b62\u6b21\u6708\u3002", (String)"QtsftysbbDeclareHelper_42", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), zspm));
                }
                if (!("qtsf_fsstysbb".equals(type) && DATATYPE_SYSTEM.equals(datatype) && ZspmEnum.CZLJCLF.getName().equals(zspm))) {
                    ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
                    String sbbid = resultMap.get("tcvat_nsrxx#1#id");
                    if (EmptyCheckUtils.isNotEmpty(sbbid)) {
                        qFilters.add(new QFilter("id", "!=", (Object)Long.parseLong(sbbid)));
                    }
                    qFilters.add(new QFilter("org", "=", (Object)orgid));
                    qFilters.add(new QFilter("taxauthority", "=", (Object)Long.parseLong(resultMap.get("tcvat_nsrxx#1#taxauthority"))));
                    qFilters.add(new QFilter("entryentity.startdate", "=", (Object)startdateDate));
                    qFilters.add(new QFilter("entryentity.enddate", "=", (Object)enddateDate));
                    qFilters.add(new QFilter("entryentity.zspm", "=", (Object)zspm));
                    DynamicObject object = QueryServiceHelper.queryOne((String)"totf_tysb_declare_main", (String)"billno", (QFilter[])qFilters.toArray(new QFilter[0]));
                    if (object != null) {
                        String nsrmc = resultMap.get("tcvat_nsrxx#1#nsrmc");
                        String msg = String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011%2$s\u81f3%3$s\u3010%4$s\u3011\u7684\u7533\u62a5\u8868\u3010%5$s\u3011\u5df2\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u8986\u76d6\uff01", (String)"QtsftysbbDeclareHelper_43", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), nsrmc, startdate, enddate, zspm, object.getString("billno"));
                        throw new KDBizException(msg);
                    }
                }
            }
            String deductioncodeId = resultMap.get(Const1.concat(split[1]).concat("#deductioncode"));
            QtsftysbbDeclareHelper.checkTaxdeductionMap(zsxm, deductioncodeId);
        }
        if (zmspStrings.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7533\u62a5\u7684\u201c\u5f81\u6536\u54c1\u76ee\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QtsftysbbDeclareHelper_13", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
        if (Sets.newHashSet(zmspStrings).size() != zmspStrings.size()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7533\u62a5\u7684\u201c\u5f81\u6536\u54c1\u76ee\u201d\u4e0d\u80fd\u91cd\u590d\u3002", (String)"QtsftysbbDeclareHelper_14", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
    }

    public static Date formatDateStr(String dateStr, String fieldName) {
        Date date;
        if (StringUtils.isBlank((CharSequence)dateStr)) {
            return null;
        }
        try {
            date = DateUtils.stringToDate(dateStr);
        }
        catch (Exception e) {
            try {
                date = DateUtils.stringToDate(dateStr, DateUtils.YYYYMMDD_CHINESE);
            }
            catch (Exception e1) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u683c\u5f0f\u4e0d\u7b26\u5408\u89c4\u8303\u3002\u8bf7\u4e25\u683c\u6309\u7167\u6a21\u677f\u683c\u5f0f\u5f15\u5165\uff0c\u5408\u6cd5\u65e5\u671f\u683c\u5f0f xxxx\u5e74xx\u6708xx\u65e5\u6216yyyy-MM-dd", (String)"QtsftysbbDeclareHelper_15", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), fieldName));
            }
        }
        return date;
    }

    public static void checkTaxdeductionMap(String zsxm, String deductioncodeId) {
        if (StringUtil.isNotEmpty((CharSequence)deductioncodeId) && !"0".equals(deductioncodeId) && !QtsftysbbDeclareHelper.isExistsDeduction(zsxm, deductioncodeId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u51cf\u514d\u6027\u8d28\u4ee3\u7801\u586b\u5199\u9519\u8bef\u3002", (String)"QtsftysbbDeclareHelper_16", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
    }

    private static boolean isExistsDeduction(String zsxmName, String deductioncodeId) {
        try {
            DynamicObject tpoTaxdeduction = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(deductioncodeId), (String)"tpo_taxdeduction");
            if (tpoTaxdeduction != null) {
                String taxname = tpoTaxdeduction.getDynamicObject("taxcategory").getString("name");
                return Objects.equals(zsxmName, taxname);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean checkOrgLicenseAndZeroDeclare(Map<String, String> resultMap) {
        return false;
    }

    public static void isEnableTaxcCard(Long orgid, String nsrmc) {
        TaxResult result = TaxcMainDataServiceHelper.isTaxcMainQtsfEnableByOrgId((Long)orgid);
        if (result.isSuccess()) {
            Boolean qtsfEnable = (Boolean)result.getData();
            if (!qtsfEnable.booleanValue()) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7ec4\u7ec7\u5176\u4ed6\u7a0e\u8d39\u7a0e\u79cd\u5c1a\u672a\u542f\u7528\u3002", (String)"QtsftysbbDeclareHelper_47", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), nsrmc));
            }
        } else {
            throw new KDBizException(result.getMessage());
        }
    }

    public static void checkDate(ImportDataVo importDataVo, DynamicObject template) {
        Date tempStartDate;
        Date skssqq = importDataVo.getStartDate();
        if (template != null && (tempStartDate = template.getDate("startdate")).compareTo(skssqq) > 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u5c5e\u671f\u4e0d\u5728\u6a21\u677f\u6709\u6548\u671f\u8303\u56f4\u5185\u3002", (String)"QtsftysbbDeclareHelper_48", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
    }

    public static void checkTemplate(ImportDataVo importDataVo, DynamicObject template) {
        DynamicObject templateByQuery;
        if (template != null && (templateByQuery = TemplateUtils.getTemplateObjectByConfig(template.getString("typenumber"), importDataVo.getOrgId(), importDataVo.getStartDate(), importDataVo.getEndDate())) != null && !templateByQuery.get("id").equals(template.get("id"))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u7684\u201c\u6ce8\u518c\u767b\u8bb0\u533a\u57df\u201d\u4e0e\u6a21\u677f\u7684\u4e0d\u4e00\u81f4\u3002", (String)"QtsftysbbDeclareHelper_49", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
    }

    static {
        fieldNameMap.put("yjfjs", new MultiLangEnumBridge("\u5e94\u7f34\u8d39\u57fa\u6570", "QtsftysbbDeclareHelper_30", "taxc-bdtaxr-common"));
        fieldNameMap.put("yjfjscke", new MultiLangEnumBridge("\u5e94\u7f34\u8d39\u57fa\u6570\u51cf\u9664\u989d", "QtsftysbbDeclareHelper_31", "taxc-bdtaxr-common"));
        fieldNameMap.put("jsfyjs", new MultiLangEnumBridge("\u8ba1\u8d39\u4f9d\u636e", "QtsftysbbDeclareHelper_32", "taxc-bdtaxr-common"));
        fieldNameMap.put("flhdwse", new MultiLangEnumBridge("\u5f81\u6536\u6807\u51c6", "QtsftysbbDeclareHelper_33", "taxc-bdtaxr-common"));
        fieldNameMap.put("sskcs", new MultiLangEnumBridge("\u6263\u9664\u6570", "QtsftysbbDeclareHelper_34", "taxc-bdtaxr-common"));
        fieldNameMap.put("zsbl", new MultiLangEnumBridge("\u5f81\u6536\u6bd4\u4f8b", "QtsftysbbDeclareHelper_35", "taxc-bdtaxr-common"));
        fieldNameMap.put("ynse", new MultiLangEnumBridge("\u672c\u671f\u5e94\u7eb3\u8d39\u989d", "QtsftysbbDeclareHelper_36", "taxc-bdtaxr-common"));
        fieldNameMap.put("jmse", new MultiLangEnumBridge("\u51cf\u514d\u8d39\u989d", "QtsftysbbDeclareHelper_37", "taxc-bdtaxr-common"));
        fieldNameMap.put("deductioncode", new MultiLangEnumBridge("\u51cf\u514d\u6027\u8d28", "QtsftysbbDeclareHelper_38", "taxc-bdtaxr-common"));
        fieldNameMap.put("yjse", new MultiLangEnumBridge("\u672c\u671f\u5df2\u7f34\u8d39\u989d", "QtsftysbbDeclareHelper_39", "taxc-bdtaxr-common"));
        fieldNameMap.put("ybse", new MultiLangEnumBridge("\u672c\u671f\u5e94\u8865\uff08\u9000\uff09\u8d39\u989d", "QtsftysbbDeclareHelper_40", "taxc-bdtaxr-common"));
    }
}

