/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.declare.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.taxc.bdtaxr.common.declare.helper.DeclareServiceHelper;
import kd.taxc.bdtaxr.common.i18n.MultiLangEnumBridge;
import kd.taxc.bdtaxr.common.refactor.declare.ImportExcelHandler;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.vo.ImportDataVo;
import kd.taxc.bdtaxr.common.vo.ValidDataResultVo;

public class KjqysdsImportServiceImpl
implements ImportExcelHandler {
    private static Map<String, MultiLangEnumBridge> mustInputCheck1 = new HashMap<String, MultiLangEnumBridge>();
    private static Map<String, MultiLangEnumBridge> mustInputCheck2 = new HashMap<String, MultiLangEnumBridge>();

    @Override
    public String getBillNo(String id, String month) {
        return DeclareServiceHelper.generateSBBNo("tcnfep_kj_declare_main");
    }

    @Override
    public ValidDataResultVo validResultMap(ImportDataVo importDataVo, Map<String, String> resultMap, DynamicObject template) {
        block3: {
            String sbfs;
            block2: {
                sbfs = resultMap.get("tcnfep_kjywrjbxx#1#sbfs");
                if (!"1".equals(sbfs)) break block2;
                for (Map.Entry<String, MultiLangEnumBridge> entry : mustInputCheck1.entrySet()) {
                    String value = resultMap.get(entry.getKey());
                    if (!StringUtil.isBlank((CharSequence)value)) continue;
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\uff1a%s", (String)"KjqysdsImportServiceImpl_11", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), entry.getValue().getDescription()));
                }
                break block3;
            }
            if (!"2".equals(sbfs)) break block3;
            for (Map.Entry<String, MultiLangEnumBridge> entry : mustInputCheck2.entrySet()) {
                String value = resultMap.get(entry.getKey());
                if (!StringUtil.isBlank((CharSequence)value)) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\uff1a%s", (String)"KjqysdsImportServiceImpl_11", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), entry.getValue().getDescription()));
            }
        }
        return ValidDataResultVo.success();
    }

    @Override
    public void initImportData(ImportDataVo importDataVo, Map<String, String> resultMap) {
        Date today = new Date();
        Date startDate = DateUtils.getFirstDateOfMonth(today);
        importDataVo.setStartDate(startDate);
        resultMap.put("tcvat_nsrxx#1#skssqq", DateUtils.format(startDate));
        Date endDate = DateUtils.getLastDateOfMonth1(today);
        importDataVo.setEndDate(endDate);
        resultMap.put("tcvat_nsrxx#1#skssqz", DateUtils.format(endDate));
    }

    @Override
    public DynamicObject queryReportExistsId(ImportDataVo vo) {
        return null;
    }

    static {
        mustInputCheck1.put("tcnfep_fdyqkjhzxsbqk#1#contractname", new MultiLangEnumBridge(ResManager.loadKDString((String)"\u6cd5\u5b9a\u6e90\u6cc9\u6263\u7f34\u548c\u81ea\u884c\u7533\u62a5\u60c5\u51b5#\u5408\u540c\u540d\u79f0", (String)"KjqysdsImportServiceImpl_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), "KjqysdsImportServiceImpl_0", "taxc-bdtaxr-common"));
        mustInputCheck1.put("tcnfep_fdyqkjhzxsbqk#1#contractnumber", new MultiLangEnumBridge(ResManager.loadKDString((String)"\u6cd5\u5b9a\u6e90\u6cc9\u6263\u7f34\u548c\u81ea\u884c\u7533\u62a5\u60c5\u51b5#\u5408\u540c\u7f16\u53f7", (String)"KjqysdsImportServiceImpl_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), "KjqysdsImportServiceImpl_1", "taxc-bdtaxr-common"));
        mustInputCheck1.put("tcnfep_fdyqkjhzxsbqk#1#startdate", new MultiLangEnumBridge(ResManager.loadKDString((String)"\u6cd5\u5b9a\u6e90\u6cc9\u6263\u7f34\u548c\u81ea\u884c\u7533\u62a5\u60c5\u51b5#\u5408\u540c\u6267\u884c\u8d77\u59cb\u65f6\u95f4", (String)"KjqysdsImportServiceImpl_2", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), "KjqysdsImportServiceImpl_2", "taxc-bdtaxr-common"));
        mustInputCheck1.put("tcnfep_fdyqkjhzxsbqk#1#enddate", new MultiLangEnumBridge(ResManager.loadKDString((String)"\u6cd5\u5b9a\u6e90\u6cc9\u6263\u7f34\u548c\u81ea\u884c\u7533\u62a5\u60c5\u51b5#\u5408\u540c\u6267\u884c\u7ec8\u6b62\u65f6\u95f4", (String)"KjqysdsImportServiceImpl_3", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), "KjqysdsImportServiceImpl_3", "taxc-bdtaxr-common"));
        mustInputCheck1.put("tcnfep_fdyqkjhzxsbqk#1#contractamount", new MultiLangEnumBridge(ResManager.loadKDString((String)"\u6cd5\u5b9a\u6e90\u6cc9\u6263\u7f34\u548c\u81ea\u884c\u7533\u62a5\u60c5\u51b5#\u5408\u540c\u603b\u91d1\u989d", (String)"KjqysdsImportServiceImpl_4", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), "KjqysdsImportServiceImpl_4", "taxc-bdtaxr-common"));
        mustInputCheck1.put("tcnfep_fdyqkjhzxsbqk#1#currency", new MultiLangEnumBridge(ResManager.loadKDString((String)"\u6cd5\u5b9a\u6e90\u6cc9\u6263\u7f34\u548c\u81ea\u884c\u7533\u62a5\u60c5\u51b5#\u5e01\u79cd", (String)"KjqysdsImportServiceImpl_5", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), "KjqysdsImportServiceImpl_5", "taxc-bdtaxr-common"));
        mustInputCheck2.put("tcnfep_zgswjgzdkjqk#1#zdkjwsbh", new MultiLangEnumBridge(ResManager.loadKDString((String)"\u4e3b\u7ba1\u7a0e\u52a1\u673a\u5173\u6307\u5b9a\u6263\u7f34\u60c5\u51b5#\u6307\u5b9a\u6263\u7f34\u6587\u4e66\u7f16\u53f7", (String)"KjqysdsImportServiceImpl_6", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), "KjqysdsImportServiceImpl_6", "taxc-bdtaxr-common"));
        mustInputCheck2.put("tcnfep_zgswjgzdkjqk#1#hdlrl", new MultiLangEnumBridge(ResManager.loadKDString((String)"\u4e3b\u7ba1\u7a0e\u52a1\u673a\u5173\u6307\u5b9a\u6263\u7f34\u60c5\u51b5#\u6309\u6838\u5b9a\u5229\u6da6\u7387\u8ba1\u7b97\uff0c\u6838\u5b9a\u5229\u6da6\u7387\u6c34\u5e73%", (String)"KjqysdsImportServiceImpl_7", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), "KjqysdsImportServiceImpl_7", "taxc-bdtaxr-common"));
        mustInputCheck2.put("tcnfep_zgswjgzdkjqk#1#paydate", new MultiLangEnumBridge(ResManager.loadKDString((String)"\u4e3b\u7ba1\u7a0e\u52a1\u673a\u5173\u6307\u5b9a\u6263\u7f34\u60c5\u51b5#\u652f\u4ed8\u65e5\u671f", (String)"KjqysdsImportServiceImpl_8", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), "KjqysdsImportServiceImpl_8", "taxc-bdtaxr-common"));
        mustInputCheck2.put("tcnfep_zgswjgzdkjqk#1#payamount", new MultiLangEnumBridge(ResManager.loadKDString((String)"\u4e3b\u7ba1\u7a0e\u52a1\u673a\u5173\u6307\u5b9a\u6263\u7f34\u60c5\u51b5#\u652f\u4ed8\u91d1\u989d\uff08\u4eba\u6c11\u5e01\uff0c\u5143\uff09", (String)"KjqysdsImportServiceImpl_9", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), "KjqysdsImportServiceImpl_9", "taxc-bdtaxr-common"));
        mustInputCheck2.put("tcnfep_zgswjgzdkjqk#1#bckjskje", new MultiLangEnumBridge(ResManager.loadKDString((String)"\u4e3b\u7ba1\u7a0e\u52a1\u673a\u5173\u6307\u5b9a\u6263\u7f34\u60c5\u51b5#\u672c\u6b21\u6263\u7f34\u7a0e\u6b3e\u91d1\u989d", (String)"KjqysdsImportServiceImpl_10", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), "KjqysdsImportServiceImpl_10", "taxc-bdtaxr-common"));
    }
}

