/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.declare.impl;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.declare.helper.DeclareServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.refactor.declare.ImportExcelHandler;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.vo.ImportDataVo;
import kd.taxc.bdtaxr.common.vo.ValidDataResultVo;

public class LatyjImportServiceImpl
implements ImportExcelHandler {
    private static final String Const1 = "tcret_tdzzssy_mx#";
    private static final String PRONUMBER = "tcret_tdzzs_base_tax#1#pronumber";

    @Override
    public String getBillNo(String id, String skssqz) {
        return DeclareServiceHelper.generateSBBNo("tcret_tdzzs_yjsyxx");
    }

    @Override
    public void initImportData(ImportDataVo importDataVo, Map<String, String> resultMap) {
        String pronumber = resultMap.get(PRONUMBER);
        DynamicObject object = QueryServiceHelper.queryOne((String)"tdm_tdzzs_clearing_unit", (String)"id,taxauthority", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)pronumber)});
        if (object != null) {
            resultMap.put("tcvat_nsrxx#1#taxsourcetype", "tdm_tdzzs_clearing_unit");
            resultMap.put("tcvat_nsrxx#1#taxsourceid", object.getString("id"));
        }
    }

    @Override
    public ValidDataResultVo validResultMap(ImportDataVo importDataVo, Map<String, String> resultMap, DynamicObject template) {
        QFilter q4;
        QFilter q3;
        QFilter q2;
        String pronumber = resultMap.get(PRONUMBER);
        if (pronumber == null) {
            return ValidDataResultVo.fail(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u9879\u76ee\u7f16\u53f7", (String)"LatyjImportServiceImpl_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
        DynamicObject object = QueryServiceHelper.queryOne((String)"tdm_tdzzs_clearing_unit", (String)"id,taxauthority,status,enable,taxorg.number as orgnumber, taxorg.id as orgid", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)pronumber)});
        if (object == null) {
            return ValidDataResultVo.fail(String.format(ResManager.loadKDString((String)"\u9879\u76ee\u7f16\u53f7\u3010%s\u3011\u4e0d\u5b58\u5728", (String)"LatyjImportServiceImpl_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), pronumber));
        }
        if (!((Boolean)TaxcMainDataServiceHelper.isTaxcMainByOrgIdAndIsTaxpayer((Long)Long.parseLong(importDataVo.getOrgId())).getData()).booleanValue() || object.getLong("orgid") != Long.parseLong(importDataVo.getOrgId())) {
            return ValidDataResultVo.fail(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u3010%s\u3011\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\u6216\u975e\u7eb3\u7a0e\u4e3b\u4f53\uff0c\u65e0\u6cd5\u5f15\u5165\u6570\u636e\u3002", (String)"LatyjImportServiceImpl_2", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), pronumber));
        }
        QFilter q1 = new QFilter("org", "=", (Object)Long.parseLong(importDataVo.getOrgId()));
        DynamicObject nsrxx = QueryServiceHelper.queryOne((String)"tcvat_nsrxx", (String)"id,datatype,sbbid", (QFilter[])new QFilter[]{q1, q2 = new QFilter("type", "=", (Object)"latyj"), q3 = new QFilter("taxsourceid.number", "=", (Object)pronumber), q4 = new QFilter("skssqq", "=", (Object)importDataVo.getStartDate()).and(new QFilter("skssqz", "=", (Object)importDataVo.getEndDate()))});
        if (nsrxx != null && nsrxx.getLong("sbbid") != 0L) {
            return ValidDataResultVo.fail(String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u3010%2$s\u3011\u3010%3$s\u3011\u3010%4$s\u3011\u7684\u7a0e\u6e90\u8868\u88ab\u7533\u62a5\u8868\u9501\u5b9a\uff0c\u4e0d\u53ef\u91cd\u65b0\u5f15\u5165\u3002", (String)"LatyjImportServiceImpl_3", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), importDataVo.getOrgName(), pronumber, DateUtils.format(importDataVo.getStartDate()), DateUtils.format(importDataVo.getEndDate())));
        }
        LatyjImportServiceImpl.checkDynRowData(resultMap);
        return ValidDataResultVo.success();
    }

    private static void checkDynRowData(Map<String, String> resultMap) {
        DynamicObjectCollection bizdef = QueryServiceHelper.query((String)"tpo_tdzzs_bizdef_entry", (String)"id,projectname", (QFilter[])new QFilter[0]);
        Map<String, String> map = bizdef.stream().collect(Collectors.toMap(a -> a.getString("id"), b -> b.getString("projectname"), (m, n) -> m));
        if (resultMap.get("tcret_tdzzssy_mx#1#buildingtype") == null || resultMap.get("tcret_tdzzssy_mx#1#subbuildingtype") == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u623f\u4ea7\u7c7b\u578b\u6216\u623f\u4ea7\u7c7b\u578b\u5b50\u76ee", (String)"LatyjImportServiceImpl_4", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
        for (Map.Entry<String, String> entry : resultMap.entrySet()) {
            String key = entry.getKey();
            String[] split = key.split("#");
            if (split.length != 3 || !"yssr".equals(split[2]) || "sum".equals(split[1])) continue;
            String pronumber = resultMap.get(PRONUMBER);
            String buildingtype = resultMap.get(Const1.concat(split[1]).concat("#buildingtype"));
            String subbuildingtype = resultMap.get(Const1.concat(split[1]).concat("#subbuildingtype"));
            if (buildingtype == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u623f\u4ea7\u7c7b\u578b\u4e0d\u5b58\u5728", (String)"LatyjImportServiceImpl_5", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            }
            if (subbuildingtype == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u623f\u4ea7\u7c7b\u578b\u5b50\u76ee\u4e0d\u5b58\u5728", (String)"LatyjImportServiceImpl_6", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            }
            DynamicObjectCollection unitObj = QueryServiceHelper.query((String)"tdm_tdzzs_clearing_unit", (String)"name,prepaymentinfo.buildingtype.id, prepaymentinfo.subbuildingtype.id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)pronumber)});
            Optional<DynamicObject> exists = unitObj.stream().filter(s -> s.getString("prepaymentinfo.buildingtype.id").equals(buildingtype)).findFirst();
            if (!exists.isPresent()) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u623f\u4ea7\u7c7b\u578b\u3010%1$s\u3011\u5c1a\u672a\u7ef4\u62a4\uff0c\u8bf7\u5148\u5728\u571f\u5730\u589e\u503c\u7a0e\u9879\u76ee\u3010%2$s\u3011\u4e2d\u7ef4\u62a4\u3002", (String)"LatyjImportServiceImpl_7", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), map.get(buildingtype), ((DynamicObject)unitObj.get(0)).getString("name")));
            }
            if (exists.get().getString("prepaymentinfo.subbuildingtype.id").equals(subbuildingtype)) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c\u623f\u4ea7\u7c7b\u578b\u201d \u201c\u623f\u4ea7\u7c7b\u578b\u5b50\u76ee\u201d \u7684\u7ec4\u5408\u503c\u4e0e\u571f\u5730\u589e\u503c\u7a0e\u9879\u76ee\u3010%s\u3011\u4e2d\u7ef4\u62a4\u7684\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"LatyjImportServiceImpl_8", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), ((DynamicObject)unitObj.get(0)).getString("name")));
        }
    }

    @Override
    public DynamicObject queryReportExistsId(ImportDataVo vo) {
        QFilter q1 = new QFilter("org", "=", (Object)Long.parseLong(vo.getOrgId()));
        QFilter q2 = new QFilter("type", "=", (Object)vo.getTemplateTypeId());
        QFilter q3 = new QFilter("taxsourceid.number", "=", (Object)vo.getResultMap().get(PRONUMBER));
        QFilter q4 = new QFilter("skssqq", "=", (Object)vo.getStartDate()).and(new QFilter("skssqz", "=", (Object)vo.getEndDate()));
        return QueryServiceHelper.queryOne((String)"tcvat_nsrxx", (String)"id,datatype", (QFilter[])new QFilter[]{q1, q2, q3, q4});
    }
}

