/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.declare.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.finance.TcvvtCategoryInfoBusinessImpl;
import kd.taxc.bdtaxr.common.refactor.declare.ImportExcelHandler;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.vo.ImportDataVo;
import kd.taxc.bdtaxr.common.vo.ValidDataResultVo;
import org.apache.commons.lang3.StringUtils;

public class QhMonthlyImportHandlerImpl
implements ImportExcelHandler {
    @Override
    public void initImportData(ImportDataVo importDataVo, Map<String, String> resultMap) {
        Date date = this.formatDateStr(resultMap.get("tcvvt_monthly_other#1#reportdate"), ResManager.loadKDString((String)"\u62a5\u8868\u671f", (String)"QhMonthlyImportHandlerImpl_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        Date startDate = DateUtils.getFirstDateOfMonth(date);
        importDataVo.setStartDate(startDate);
        resultMap.put("tcvat_nsrxx#1#skssqq", DateUtils.format(startDate));
        Date endDate = DateUtils.getLastDateOfMonth1(date);
        importDataVo.setEndDate(endDate);
        resultMap.put("tcvat_nsrxx#1#skssqz", DateUtils.format(endDate));
        importDataVo.setOrgId(resultMap.get("tcvat_nsrxx#1#org"));
        importDataVo.setOrgName(resultMap.get("tcvat_nsrxx#1#nsrmc"));
    }

    private Date formatDateStr(String dateStr, String fieldName) {
        Date date;
        if (StringUtils.isBlank((CharSequence)dateStr)) {
            return null;
        }
        try {
            date = DateUtils.stringToDate(dateStr, DateUtils.YYYYMM_CHINESE);
        }
        catch (Exception e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u683c\u5f0f\u4e0d\u7b26\u5408\u89c4\u8303\u3002\u8bf7\u4e25\u683c\u6309\u7167\u6a21\u677f\u683c\u5f0f\u5f15\u5165\uff0c\u5408\u6cd5\u65e5\u671f\u683c\u5f0f xxxx\u5e74xx\u6708", (String)"QhMonthlyImportHandlerImpl_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), fieldName));
        }
        return date;
    }

    @Override
    public ValidDataResultVo validExcelData(Map<String, String> excelDataMap, DynamicObject templateContent) {
        String zg_number = excelDataMap.get(QhMonthlyImportHandlerImpl.getSheetName1());
        if ((zg_number = zg_number.replace(",", "")) == null || !zg_number.matches("^[0-9]*[1-9][0-9]*$") || "0".equalsIgnoreCase(zg_number)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25\uff0c\u201c\u5343\u6237\u96c6\u56e2\u6708\u5ea6\u62a5\u9001\u9644\u8868\u201d\u7684\u201c\u672c\u671f_\u804c\u5de5\u4eba\u6570(\u4e2a)\u201d\u5217\u5fc5\u987b\u4e3a\u201c\u6b63\u6574\u6570\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"QhMonthlyImportHandlerImpl_2", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), new Object[0]));
        }
        String orgName = excelDataMap.get(QhMonthlyImportHandlerImpl.getSheetName3());
        DynamicObject[] taxorgs = BusinessDataServiceHelper.load((String)"bastax_taxorg", (String)"org.id", (QFilter[])new QFilter[]{new QFilter("taxpayer", "=", (Object)orgName)});
        List<Long> isTaxpayerOrg = this.getIsTaxpayerOrg();
        if (taxorgs != null && taxorgs.length > 1) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25\uff0c\u586b\u62a5\u5355\u4f4d\u5728\u7cfb\u7edf\u4e2d\u91cd\u590d\u3002", (String)"QhMonthlyImportHandlerImpl_3", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), new Object[0]));
        }
        if (taxorgs == null || taxorgs.length == 0 || !isTaxpayerOrg.contains(taxorgs[0].getLong("org.id"))) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25\uff0c\u586b\u62a5\u5355\u4f4d\u4e0d\u5b58\u5728\u6216\u4e0d\u53ef\u7528\u3002", (String)"QhMonthlyImportHandlerImpl_4", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), new Object[0]));
        }
        return ValidDataResultVo.success();
    }

    protected List<Long> getIsTaxpayerOrg() {
        DynamicObjectCollection taxOrgs;
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgsByUserId("tcvvt", "tcvvt_month_declare_list", "4730fc9f000003ae", RequestContext.get().getCurrUserId());
        QFilter istaxpayerQuery = new QFilter("istaxpayer", "=", (Object)Boolean.TRUE);
        QFilter status = new QFilter("status", "=", (Object)"1");
        if (EmptyCheckUtils.isNotEmpty(hasPermOrgResult) && !hasPermOrgResult.hasAllOrgPerm() && EmptyCheckUtils.isNotEmpty(hasPermOrgResult.getHasPermOrgs())) {
            QFilter authFilter = new QFilter("id", "in", (Object)hasPermOrgResult.getHasPermOrgs());
            taxOrgs = QueryServiceHelper.query((String)"bastax_taxorg", (String)"org.id as id", (QFilter[])new QFilter[]{istaxpayerQuery, status, authFilter});
        } else {
            taxOrgs = QueryServiceHelper.query((String)"bastax_taxorg", (String)"org.id as id", (QFilter[])new QFilter[]{istaxpayerQuery, status});
        }
        if (CollectionUtils.isEmpty((Collection)taxOrgs)) {
            return new ArrayList<Long>();
        }
        List<Long> ids = taxOrgs.parallelStream().map(s -> s.getLong("id")).collect(Collectors.toList());
        QFilter orgFilters = this.getOrgFilters(ids);
        DynamicObjectCollection results = QueryServiceHelper.query((String)"tctb_tax_main", (String)"orgid as id", (QFilter[])new QFilter[]{orgFilters});
        return CollectionUtils.isEmpty((Collection)results) ? new ArrayList<Long>() : results.parallelStream().map(s -> s.getLong("id")).collect(Collectors.toList());
    }

    protected QFilter getOrgFilters(List<Long> orgIds) {
        List<Long> ids = TcvvtCategoryInfoBusinessImpl.queryqhjtCategoryInfoByOrgIds(orgIds);
        return new QFilter("orgid", "in", ids);
    }

    private static String getSheetName1() {
        return String.format(ResManager.loadKDString((String)"\u5343\u6237\u96c6\u56e2\u6708\u5ea6\u62a5\u8868#22#3", (String)"QhMonthlyImportHandlerImpl_5", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), new Object[0]);
    }

    private static String getSheetName2() {
        return String.format(ResManager.loadKDString((String)"\u5343\u6237\u96c6\u56e2\u6708\u5ea6\u62a5\u8868#1#0", (String)"QhMonthlyImportHandlerImpl_6", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), new Object[0]);
    }

    private static String getSheetName3() {
        return String.format(ResManager.loadKDString((String)"\u5343\u6237\u96c6\u56e2\u6708\u5ea6\u62a5\u8868#1#1", (String)"QhMonthlyImportHandlerImpl_7", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), new Object[0]);
    }
}

