/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.declare.impl;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.refactor.declare.ImportExcelHandler;
import kd.taxc.bdtaxr.common.refactor.template.TemplateShowUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.vo.ImportDataVo;
import kd.taxc.bdtaxr.common.vo.ValidDataResultVo;

public class QysdsJbImportServiceImpl
implements ImportExcelHandler {
    private static Log logger = LogFactory.getLog(QysdsJbImportServiceImpl.class);
    public static final BigDecimal MAX_VALUE = new BigDecimal("9999999999999.99");
    private static final String SHEET_NAME_A06779 = "A06779";
    private static String SHEET_NAME_A200000 = "A200000";
    private static String SHEET_NAME_A201020 = "A201020";
    private static String SHEET_NAME_A202000 = "A202000";
    private List<String> templateNumbers = Lists.newArrayList((Object[])new String[]{"CITQR2021", "CITQR2023", "CITQR2023-HUBEI"});
    private static String regex = "(\\d+(\\.\\d+)?)";
    private String yes = ResManager.loadKDString((String)"\u662f", (String)"QysdsJbImportServiceImpl_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);

    @Override
    public ValidDataResultVo checkDynData(Map<String, List<Map.Entry<String, List<Map.Entry<String, String>>>>> dynRowDatas, String sheetName) {
        ValidDataResultVo validDataResultVo = ValidDataResultVo.success();
        if (dynRowDatas.isEmpty()) {
            return validDataResultVo;
        }
        StringBuilder buffer = new StringBuilder();
        List sorts = dynRowDatas.entrySet().stream().sorted(Comparator.comparing(s -> Double.valueOf((String)s.getKey()))).collect(Collectors.toList());
        for (Map.Entry sort : sorts) {
            String key = (String)sort.getKey();
            List rows = (List)sort.getValue();
            List collect = rows.stream().flatMap(s -> ((List)s.getValue()).stream().filter(a -> ((String)a.getKey()).endsWith("#1"))).collect(Collectors.toList());
            Map<String, List<Map.Entry>> groups = collect.stream().collect(Collectors.groupingBy(s -> (String)s.getValue()));
            List distinctDatas = groups.entrySet().stream().filter(s -> ((List)s.getValue()).size() > 1).collect(Collectors.toList());
            if (distinctDatas.size() > 0) {
                validDataResultVo.setSuccess(false);
                String numbers = distinctDatas.stream().flatMap(s -> ((List)s.getValue()).stream().map(a -> this.getActualRow((String)a.getKey()))).collect(Collectors.joining(","));
                buffer.append(String.format(ResManager.loadKDString((String)"\u3010sheetName:%1$s\u52a8\u6001\u884c%2$s\u533a\u57df\u7b2c%3$s\u884c\u9879\u76ee\u6570\u636e\u91cd\u590d\u3011", (String)"QysdsJbImportServiceImpl_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), sheetName, key, numbers));
            }
            validDataResultVo.setMessage(buffer.toString());
        }
        return validDataResultVo;
    }

    @Override
    public void initImportData(ImportDataVo importDataVo, Map<String, String> resultMap) {
        String skssqq = resultMap.get("tcvat_nsrxx#1#skssqq");
        List collect = resultMap.keySet().stream().map(s -> s.split("#")[0]).collect(Collectors.toList());
        if (collect.contains("tccit_qysds_a06779")) {
            resultMap.put("tccit_qysds_a06779_bill#1#declareyear", StringUtil.isNotBlank((CharSequence)skssqq) ? skssqq.split("-")[0] : "");
        }
    }

    @Override
    public ValidDataResultVo validExcelData(Map<String, String> excelDataMap, DynamicObject templateContent) {
        ValidDataResultVo validDataResultVo = ValidDataResultVo.success();
        String number = templateContent.getString("number");
        Map<String, EntityField> templateEntityMap = TemplateShowUtils.queryTemplateFieldByTmpId(templateContent.getLong("id"), "bdtaxr_template_main");
        if (this.templateNumbers.contains(number)) {
            String minCompany = "CITQR2021".equals(number) ? excelDataMap.get("A200000#9#9") : excelDataMap.get("A200000#11#9");
            String suittype = "CITQR2021".equals(number) ? excelDataMap.get("A200000#13#10") : excelDataMap.get("A200000#14#10");
            String startDate = excelDataMap.get("A200000#1#2");
            String endDate = excelDataMap.get("A200000#1#5");
            String socialCreditCode = excelDataMap.get("A200000#2#2");
            Map<String, List<Map.Entry>> collect = excelDataMap.entrySet().stream().collect(Collectors.groupingBy(s -> ((String)s.getKey()).split("#")[0]));
            for (Map.Entry<String, List<Map.Entry>> listEntry : collect.entrySet()) {
                List emptyRows;
                LinkedHashMap<String, String> names;
                InnerParseData parse;
                String key = listEntry.getKey();
                List<Map.Entry> list = listEntry.getValue();
                Map<String, List<Map.Entry>> rows = list.stream().collect(Collectors.groupingBy(s -> ((String)s.getKey()).substring(0, ((String)s.getKey()).lastIndexOf(35) + 1)));
                List<Map.Entry<String, List<Map.Entry<String, String>>>> sortRows = rows.entrySet().stream().sorted(Comparator.comparing(s -> Integer.parseInt(((String)s.getKey()).split("#")[1]))).collect(Collectors.toList());
                if (SHEET_NAME_A200000.equals(key)) {
                    parse = new A200000InnerParseData(sortRows).parse();
                    names = parse.getNames();
                    Map<String, String> dyn7Items = ((A200000InnerParseData)parse).getDyn7Items();
                    Map<String, String> dyn8Items = ((A200000InnerParseData)parse).getDyn8Items();
                    Map<String, String> dyn13Items = ((A200000InnerParseData)parse).getDyn13Items();
                    List<String> dynEmptyRows = parse.getDynEmptyRows();
                    List<String> orderNumbers = parse.getOrderNumbers();
                    List emptyRows2 = names.entrySet().stream().filter(s -> StringUtil.isEmpty((CharSequence)((CharSequence)s.getValue()))).map(s -> this.getActualRow((String)s.getKey())).sorted(Comparator.comparing(Integer::parseInt)).collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(emptyRows2)) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"sheet\u9875\uff1a%1$s\u7b2c\u3010%2$s\u3011\u884c\u9879\u76ee\u7b2c\u4e00\u5217\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QysdsJbImportServiceImpl_2", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), SHEET_NAME_A200000, emptyRows2.stream().collect(Collectors.joining(","))));
                    }
                    if (!CollectionUtils.isEmpty(orderNumbers)) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"sheet\u9875\uff1a%1$s\u7b2c\u4e00\u5217\u9879\u76ee\u5e8f\u53f7\uff1a\u3010%2$s\u3011\u987a\u5e8f\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u3002", (String)"QysdsJbImportServiceImpl_3", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), SHEET_NAME_A200000, orderNumbers.stream().collect(Collectors.joining(","))));
                    }
                    HashMap counter = new HashMap(16);
                    names.entrySet().stream().forEach(s -> counter.computeIfAbsent(s.getValue(), k -> new AtomicInteger()).getAndIncrement());
                    List repeats = counter.entrySet().stream().filter(s -> ((AtomicInteger)s.getValue()).intValue() > 1).sorted(Comparator.comparing(c -> Double.parseDouble((String)c.getKey()))).collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(repeats)) {
                        String name = repeats.stream().map(s -> (String)s.getKey()).collect(Collectors.joining("\uff0c"));
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"sheet\u9875\uff1a%1$s\uff0c\u52a8\u6001\u884c\u5e8f\u53f7\u3010%2$s\u3011\u91cd\u590d\u3002", (String)"QysdsJbImportServiceImpl_4", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), SHEET_NAME_A200000, name));
                    }
                    HashMap errorMaps = new HashMap(32);
                    BiFunction<Map, String, Map> biFunction = (dynItems, type) -> dynItems.entrySet().stream().filter(s -> this.existsItem("tpo_discount_tree", (String)s.getValue(), (String)type, startDate, endDate) == false).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (String)e.getValue()));
                    if (!dyn7Items.isEmpty()) {
                        errorMaps.putAll(biFunction.apply(dyn7Items, "7"));
                    }
                    if (!dyn8Items.isEmpty()) {
                        errorMaps.putAll(biFunction.apply(dyn8Items, "8"));
                    }
                    if (!dyn13Items.isEmpty()) {
                        errorMaps.putAll(biFunction.apply(dyn13Items, "13"));
                    }
                    if (!errorMaps.isEmpty()) {
                        String msg = String.format(ResManager.loadKDString((String)"sheet\u9875\uff1a%1$s\u7b2c\u3010%2$s\u3011\u7533\u62a5\u4e8b\u9879\u540d\u79f0\u6709\u8bef", (String)"QysdsJbImportServiceImpl_5", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), SHEET_NAME_A200000, errorMaps.entrySet().stream().map(s -> (String)s.getKey()).sorted().collect(Collectors.joining("\uff0c")));
                        throw new KDBizException(msg);
                    }
                    if (dynEmptyRows != null && dynEmptyRows.size() > 0) {
                        validDataResultVo.setSuccess(false);
                        validDataResultVo.setMessage(String.format(ResManager.loadKDString((String)"sheet\u9875\uff1a%1$s\u7b2c\u3010%2$s\u3011\u884c\u5305\u542b\u7a7a\u767d\u6570\u636e\uff0c\u662f\u5426\u7ee7\u7eed\u5bfc\u5165\uff1f", (String)"QysdsJbImportServiceImpl_6", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), SHEET_NAME_A200000, dynEmptyRows.stream().collect(Collectors.joining(","))));
                    }
                    boolean isMinCompany = this.yes.equals(minCompany);
                    boolean independenceOrg = this.isIndependenceOrg(socialCreditCode, DateUtils.stringToDate(startDate), DateUtils.stringToDate(endDate));
                    if (independenceOrg) continue;
                    if (dyn13Items.size() > 1) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"sheet\u9875\uff1a%1$s,\u52a8\u6001\u884c\u7b2c13\u884c\u51cf\u514d\u6240\u5f97\u7a0e\u989d\u6761\u76ee\uff0c\u4e0d\u5141\u8bb8\u8d85\u8fc7\u4e24\u6761\uff01", (String)"QysdsJbImportServiceImpl_7", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), SHEET_NAME_A200000));
                    }
                    if (isMinCompany && dyn13Items.size() > 1) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"sheet\u9875\uff1a%1$s,\u4f01\u4e1a\u5c5e\u4e8e\u5c0f\u578b\u5fae\u5229\u4f01\u4e1a\uff0c\u52a8\u6001\u884c\u7b2c13\u884c\u51cf\u514d\u6240\u5f97\u7a0e\u989d\u6761\u76ee\uff0c\u4e0d\u5141\u8bb8\u8d85\u8fc7\u4e00\u6761\uff01", (String)"QysdsJbImportServiceImpl_8", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), SHEET_NAME_A200000));
                    }
                    if (dyn13Items.size() <= 0) continue;
                    this.checkDynData(dyn13Items, isMinCompany, startDate, endDate, suittype);
                    continue;
                }
                if (SHEET_NAME_A201020.equals(key)) {
                    parse = new A201020InnerParseData(sortRows).parse();
                    Map<String, String> dyn1Items = ((A201020InnerParseData)parse).getDyn1Items();
                    Map<String, String> dyn2Items = ((A201020InnerParseData)parse).getDyn2Items();
                    LinkedHashMap<String, String> names2 = parse.getNames();
                    List<String> orderNumbers = parse.getOrderNumbers();
                    HashMap errorMaps = new HashMap(32);
                    List emptyRows3 = names2.entrySet().stream().filter(s -> StringUtil.isEmpty((CharSequence)((CharSequence)s.getValue()))).map(s -> this.getActualRow((String)s.getKey())).sorted(Comparator.comparing(Integer::parseInt)).collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(emptyRows3)) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"sheet\u9875\uff1a%1$s\u7b2c\u3010%2$s\u3011\u884c\u9879\u76ee\u7b2c\u4e00\u5217\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QysdsJbImportServiceImpl_2", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), SHEET_NAME_A201020, emptyRows3.stream().collect(Collectors.joining(","))));
                    }
                    if (!CollectionUtils.isEmpty(orderNumbers)) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"sheet\u9875\uff1a%1$s\u7b2c\u4e00\u5217\u9879\u76ee\u5e8f\u53f7\uff1a\u3010%2$s\u3011\u987a\u5e8f\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u3002", (String)"QysdsJbImportServiceImpl_3", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), SHEET_NAME_A201020, orderNumbers.stream().collect(Collectors.joining(","))));
                    }
                    HashMap counter = new HashMap(16);
                    names2.entrySet().stream().forEach(s -> counter.computeIfAbsent(s.getValue(), k -> new AtomicInteger()).getAndIncrement());
                    List repeats = counter.entrySet().stream().filter(s -> ((AtomicInteger)s.getValue()).intValue() > 1).sorted(Comparator.comparing(c -> Double.parseDouble((String)c.getKey()))).collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(repeats)) {
                        String name = repeats.stream().map(s -> (String)s.getKey()).collect(Collectors.joining("\uff0c"));
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"sheet\u9875\uff1a%1$s\uff0c\u52a8\u6001\u884c\u5e8f\u53f7\u3010%2$s\u3011\u91cd\u590d\u3002", (String)"QysdsJbImportServiceImpl_4", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), SHEET_NAME_A201020, name));
                    }
                    BiFunction<Map, String, Map> biFunction = (dynItems, type) -> dynItems.entrySet().stream().filter(s -> this.existsItem("tpo_yearitems_tree", (String)s.getValue(), (String)type, startDate, endDate) == false).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (String)e.getValue()));
                    if (!dyn1Items.isEmpty()) {
                        errorMaps.putAll(biFunction.apply(dyn1Items, "1.1"));
                    }
                    if (!dyn2Items.isEmpty()) {
                        errorMaps.putAll(biFunction.apply(dyn2Items, "2.1"));
                    }
                    if (errorMaps.isEmpty()) continue;
                    String msg = String.format(ResManager.loadKDString((String)"sheet\u9875\uff1a%1$s\u7b2c\u3010%2$s\u3011\u7533\u62a5\u4e8b\u9879\u540d\u79f0\u6709\u8bef", (String)"QysdsJbImportServiceImpl_5", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), SHEET_NAME_A201020, errorMaps.entrySet().stream().map(s -> (String)s.getKey()).sorted().collect(Collectors.joining("\uff0c")));
                    throw new KDBizException(msg);
                }
                if (SHEET_NAME_A202000.equals(key)) {
                    String msg = ResManager.loadKDString((String)"\u5408\u8ba1", (String)"QysdsJbImportServiceImpl_9", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
                    Map<String, String> rowMap = sortRows.stream().filter(s -> Integer.parseInt(((String)s.getKey()).split("#")[1]) >= 8).map(s -> (Map.Entry)((List)s.getValue()).get(0)).filter(v -> !((String)v.getValue()).equals(msg)).collect(Collectors.toMap(k -> ((String)k.getKey()).split("#")[1], Map.Entry::getValue));
                    List repRow = rowMap.values().stream().collect(Collectors.groupingBy(s -> s, Collectors.counting())).entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toList());
                    if (repRow.size() > 0) {
                        String rep = String.join((CharSequence)"\uff0c", repRow);
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"sheet\u9875\uff1a%1$s\uff0c\u52a8\u6001\u884c\u5e8f\u53f7\u3010%2$s\u3011\u91cd\u590d\u3002", (String)"QysdsJbImportServiceImpl_4", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), SHEET_NAME_A202000, rep));
                    }
                    emptyRows = rowMap.entrySet().stream().filter(r -> StringUtil.isEmpty((CharSequence)((CharSequence)r.getValue()))).map(Map.Entry::getKey).collect(Collectors.toList());
                    if (emptyRows.size() > 0) {
                        String empty = String.join((CharSequence)"\uff0c", emptyRows);
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"sheet\u9875\uff1a%1$s\u7b2c\u3010%2$s\u3011\u884c\u9879\u76ee\u7b2c\u4e00\u5217\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QysdsJbImportServiceImpl_2", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), SHEET_NAME_A202000, empty));
                    }
                    List intRow = rowMap.values().stream().filter(s -> !s.matches("\\d+")).collect(Collectors.toList());
                    if (intRow.size() <= 0) continue;
                    String empty = String.join((CharSequence)"\uff0c", intRow);
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"sheet\u9875\uff1a%1$s,\u52a8\u6001\u884c\u5e8f\u53f7\u3010%2$s\u3011\u5fc5\u987b\u4e3a\u6574\u6570\u3002", (String)"QysdsJbImportServiceImpl_10", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), SHEET_NAME_A202000, empty));
                }
                if (!SHEET_NAME_A06779.equals(key)) continue;
                parse = new A06779InnerParseData(sortRows).parse();
                names = parse.getNames();
                List<String> orderNumbers = parse.getOrderNumbers();
                emptyRows = names.entrySet().stream().filter(s -> StringUtil.isEmpty((CharSequence)((CharSequence)s.getValue()))).map(s -> this.getActualRow((String)s.getKey())).sorted(Comparator.comparing(Integer::parseInt)).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(emptyRows)) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"sheet\u9875\uff1a%1$s\u7b2c\u3010%2$s\u3011\u884c\u9879\u76ee\u7b2c\u4e00\u5217\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QysdsJbImportServiceImpl_2", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), SHEET_NAME_A06779, emptyRows.stream().collect(Collectors.joining("\uff0c"))));
                }
                if (!CollectionUtils.isEmpty(orderNumbers)) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"sheet\u9875\uff1a%1$s\u7b2c\u4e00\u5217\u9879\u76ee\u5e8f\u53f7\uff1a\u3010%2$s\u3011\u987a\u5e8f\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u3002", (String)"QysdsJbImportServiceImpl_3", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), SHEET_NAME_A06779, orderNumbers.stream().collect(Collectors.joining("\uff0c"))));
                }
                HashMap counter = new HashMap(16);
                names.entrySet().stream().forEach(s -> counter.computeIfAbsent(s.getValue(), k -> new AtomicInteger()).getAndIncrement());
                List repeats = counter.entrySet().stream().filter(s -> ((AtomicInteger)s.getValue()).intValue() > 1).sorted(Comparator.comparing(c -> Double.parseDouble((String)c.getKey()))).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(repeats)) {
                    String name = repeats.stream().map(s -> (String)s.getKey()).collect(Collectors.joining("\uff0c"));
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"sheet\u9875\uff1a%1$s\uff0c\u52a8\u6001\u884c\u5e8f\u53f7\u3010%2$s\u3011\u91cd\u590d\u3002", (String)"QysdsJbImportServiceImpl_4", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), SHEET_NAME_A06779, name));
                }
                List entries = sortRows.stream().filter(s -> names.keySet().contains(s.getKey())).collect(Collectors.toList());
                Map map = sortRows.stream().filter(s -> ((String)s.getKey()).startsWith("A06779#3#")).map(s -> ((List)s.getValue()).stream().collect(Collectors.toMap(a -> (String)a.getKey(), a -> (String)a.getValue()))).findFirst().get();
                StringBuilder builder = new StringBuilder();
                for (Map.Entry entry2 : entries) {
                    String maxLengthMsg;
                    String validDates;
                    String row = this.getActualRow((String)entry2.getKey());
                    List value = (List)entry2.getValue();
                    value.stream().filter(s -> ((String)s.getKey()).endsWith("#2") || ((String)s.getKey()).endsWith("#10")).filter(s -> StringUtil.isNotBlank((CharSequence)((CharSequence)s.getValue()))).filter(s -> !this.existItems((String)s.getKey(), (String)s.getValue(), startDate, endDate)).findFirst().ifPresent(s -> {
                        String[] split = ((String)s.getKey()).split("#");
                        String field = (String)map.get(split[0] + "#3#" + split[2]);
                        builder.append("\n");
                        builder.append(String.format(ResManager.loadKDString((String)"sheet\u9875\uff1a%1$s\u7b2c\u3010%2$s\u3011\u884c\u201c%3$s\u201d\u4e0d\u5b58\u5728\u7cfb\u7edf\u4e2d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"QysdsJbImportServiceImpl_21", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), SHEET_NAME_A06779, row, field));
                    });
                    String msg = ((List)entry2.getValue()).stream().filter(s -> StringUtil.isNotBlank((CharSequence)((CharSequence)s.getValue()))).filter(s -> ((String)s.getKey()).matches("A06779#\\d+#4") || ((String)s.getKey()).matches("A06779#\\d+#5") || ((String)s.getKey()).matches("A06779#\\d+#7")).filter(s -> StringUtil.isNotBlank((CharSequence)((CharSequence)s.getValue())) && new BigDecimal((String)s.getValue()).compareTo(MAX_VALUE) > 0).map(a -> {
                        String[] split = ((String)a.getKey()).split("#");
                        String field = (String)map.get(split[0] + "#3#" + split[2]);
                        return field;
                    }).collect(Collectors.joining("\uff0c"));
                    if (StringUtil.isNotBlank((CharSequence)msg)) {
                        builder.append("\n");
                        builder.append(String.format(ResManager.loadKDString((String)"sheet\u9875\uff1a%1$s\u7b2c\u3010%2$s\u3011\u884c\u201c%3$s\u201d\u5b57\u6bb5\u4e0d\u80fd\u8d85\u8fc7\u9650\u5236\u8303\u56f4\uff0813\u4f4d\u6574\u65702\u4f4d\u5c0f\u6570\uff09\u3002", (String)"QysdsJbImportServiceImpl_22", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), SHEET_NAME_A06779, row, msg));
                    }
                    if (!StringUtil.isEmpty((CharSequence)(validDates = ((List)entry2.getValue()).stream().filter(s -> StringUtil.isNotBlank((CharSequence)((CharSequence)s.getValue()))).filter(s -> ((String)s.getKey()).matches("A06779#\\d+#6") && !this.validDate((String)s.getValue())).map(s -> {
                        String[] split = ((String)s.getKey()).split("#");
                        return (String)map.get(split[0] + "#3#" + split[2]);
                    }).collect(Collectors.joining("\uff0c"))))) {
                        builder.append("\n");
                        builder.append(String.format(ResManager.loadKDString((String)"sheet\u9875\uff1a%1$s\u7b2c\u3010%2$s\u3011\u884c\u201c%3$s\u201d\u5b57\u6bb5\u65e5\u671f\u683c\u5f0f\u4e0d\u5408\u6cd5\uff0c\u5408\u6cd5\u683c\u5f0f\uff1aYYYY-MM-DD\u3002", (String)"QysdsJbImportServiceImpl_23", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), SHEET_NAME_A06779, row, validDates));
                    }
                    if (StringUtil.isEmpty((CharSequence)(maxLengthMsg = value.stream().filter(s -> StringUtil.isNotBlank((CharSequence)((CharSequence)s.getValue()))).filter(s -> {
                        String[] split = ((String)s.getKey()).split("#");
                        String inputValue = (String)s.getValue();
                        EntityField entityField = (EntityField)templateEntityMap.get(split[0] + "#5#" + split[2]);
                        if (entityField != null && "Text".equals(entityField.getFieldType())) {
                            int maxLength = entityField.getMaxLength() > 0 ? entityField.getMaxLength() : 2000;
                            return inputValue != null && inputValue.length() > maxLength;
                        }
                        return false;
                    }).map(s -> {
                        String[] split = ((String)s.getKey()).split("#");
                        EntityField entityField = (EntityField)templateEntityMap.get(split[0] + "#5#" + split[2]);
                        String maxLengthField = entityField.getFieldName();
                        String format = String.format(ResManager.loadKDString((String)"sheet\u9875\uff1a%1$s\u7b2c\u3010%2$s\u3011\u884c\u201c%3$s\u201d\u5f55\u5165\u6587\u672c\u5b57\u7b26\u8d85\u8fc7\u89c4\u5b9a\u957f\u5ea6\uff1a%4$s\uff0c\u8bf7\u4fee\u6539\u3002", (String)"QysdsJbImportServiceImpl_24", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), SHEET_NAME_A06779, row, maxLengthField, entityField.getMaxLength());
                        return format;
                    }).collect(Collectors.joining("\n"))))) continue;
                    builder.append("\n");
                    builder.append(maxLengthMsg);
                }
                Optional<Map.Entry> countRow = list.stream().filter(s -> s.getValue() != null && ((String)s.getValue()).contains(ResManager.loadKDString((String)"\u5408\u8ba1", (String)"QysdsJbImportServiceImpl_9", (String)"taxc-bdtaxr-common", (Object[])new Object[0]))).findFirst();
                if (countRow.isPresent()) {
                    String row = ((String)countRow.get().getKey()).split("#")[1];
                    String msg = list.stream().filter(s -> StringUtil.isNotBlank((CharSequence)((CharSequence)s.getValue()))).filter(s -> ((String)s.getKey()).matches("A06779#" + row + "+#4") || ((String)s.getKey()).matches("A06779#" + row + "+#5") || ((String)s.getKey()).matches("A06779#" + row + "+#7")).filter(s -> s.getValue() != null && new BigDecimal((String)s.getValue()).compareTo(MAX_VALUE) > 0).map(a -> {
                        String[] split = ((String)a.getKey()).split("#");
                        String field = (String)map.get(split[0] + "#3#" + split[2]);
                        return field;
                    }).collect(Collectors.joining("\uff0c"));
                    if (StringUtil.isNotBlank((CharSequence)msg)) {
                        builder.append("\n");
                        builder.append(String.format(ResManager.loadKDString((String)"sheet\u9875\uff1a%1$s\u7b2c\u3010%2$s\u3011\u884c\u201c%3$s\u201d\u5b57\u6bb5\u4e0d\u80fd\u8d85\u8fc7\u9650\u5236\u8303\u56f4\uff0813\u4f4d\u6574\u65702\u4f4d\u5c0f\u6570\uff09\u3002", (String)"QysdsJbImportServiceImpl_22", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), SHEET_NAME_A06779, this.getActualRow((String)countRow.get().getKey()), msg));
                    }
                }
                if (!StringUtil.isNotBlank((CharSequence)builder.toString())) continue;
                throw new KDBizException(builder.toString());
            }
        }
        return validDataResultVo;
    }

    private boolean existItems(String key, String value, String startDate, String endDate) {
        if (key.matches("A06779#\\d+#2")) {
            QFilter q1 = new QFilter("validfrom", "<=", (Object)DateUtils.stringToDate2(startDate));
            QFilter q2 = new QFilter("expired", ">=", (Object)DateUtils.stringToDate2(endDate)).or(new QFilter("expired", "is null", null));
            QFilter q3 = new QFilter("projectname", "=", (Object)value);
            return QueryServiceHelper.exists((String)"tpo_tccit_bizdef_entry", (QFilter[])new QFilter[]{q1, q2, q3});
        }
        if (key.matches("A06779#\\d+#10")) {
            QFilter q1 = new QFilter("name", "=", (Object)value);
            return QueryServiceHelper.exists((String)"bastax_taxorgan", (QFilter[])new QFilter[]{q1});
        }
        return false;
    }

    private boolean isIndependenceOrg(String socialCreditCode, Date startDate, Date endDate) {
        List data;
        TaxResult listTaxResult = TaxcMainDataServiceHelper.queryTaxcMainOrgIdsByUnifiedsocialCodes(Collections.singletonList(socialCreditCode));
        Long orgid = 0L;
        if (listTaxResult.isSuccess() && !CollectionUtils.isEmpty((Collection)(data = (List)listTaxResult.getData()))) {
            orgid = (Long)data.get(0);
        }
        logger.info("queryTaxcMainOrgIdsByUnifiedsocialCodes  Result: " + listTaxResult.getMessage());
        QFilter q1 = new QFilter("orgrow.orgid", "=", (Object)orgid);
        QFilter q2 = new QFilter("taxtype", "=", (Object)"qysds");
        QFilter q3 = new QFilter("billstatus", "=", (Object)"C");
        QFilter q4 = new QFilter("effectdate", "<=", (Object)startDate);
        QFilter q5 = new QFilter("invaliddate", "is null", null).or(new QFilter("invaliddate", ">=", (Object)endDate));
        QFilter q6 = new QFilter("status", "=", (Object)"2");
        return QueryServiceHelper.exists((String)"tctb_org_group_latest", (QFilter[])new QFilter[]{q1, q2, q3, q4, q5, q6});
    }

    private void checkDynData(Map<String, String> dyn13Items, boolean isMinCompany, String startDate, String endDate, String suittype) {
        List<String> checkNumbers = Arrays.asList("JMSE00301A", "JMSE00302A", "JMSE00303A", "JMSE00304A", "JMSE00305A", "JMSE00308A", "JMSE00309A", "JMSE00302B", "JMSE00303B", "JMSE00304B", "JMSE00306B", "JMSE00307B", "JMSE00308B", "JMSE00309B", "JMSE00602");
        List names = dyn13Items.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toList());
        QFilter qFilter = this.appendQfiler("13");
        QFilter nameFilter = new QFilter("name", "in", names);
        QFilter q1 = new QFilter("start", "<=", (Object)DateUtils.stringToDate(startDate)).and("end", ">=", (Object)DateUtils.stringToDate(endDate));
        QFilter q2 = new QFilter("start", "<=", (Object)DateUtils.stringToDate(startDate)).and("end", "is null", null);
        QFilter q3 = new QFilter("enable", "=", (Object)"1");
        QFilter q4 = new QFilter("template", "=", (Object)"qysdsyj");
        QFilter dateFilter = q1.or(q2);
        QFilter[] filters = new QFilter[]{nameFilter, dateFilter, q3, q4, qFilter};
        DynamicObjectCollection checkList = QueryServiceHelper.query((String)"tpo_discount_tree", (String)"number", (QFilter[])filters);
        String number1 = ((DynamicObject)checkList.get(0)).getString("number");
        if (checkList.size() == 1 && isMinCompany && !"JMSE00100".equals(number1)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"sheet\u9875\uff1a%1$s,\u4f01\u4e1a\u5c5e\u4e8e\u5c0f\u578b\u5fae\u5229\u4f01\u4e1a\uff0c\u52a8\u6001\u884c\u7b2c13\u884c\u51cf\u514d\u6240\u5f97\u7a0e\u989d\u4f18\u60e0\u9879\u4e0d\u7b26\u5408", (String)"QysdsJbImportServiceImpl_11", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), SHEET_NAME_A200000));
        }
        if (checkList.size() == 1 && !isMinCompany && "JMSE00100".equals(number1)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"sheet\u9875\uff1a%1$s,\u4f01\u4e1a\u4e0d\u5c5e\u4e8e\u5c0f\u578b\u5fae\u5229\u4f01\u4e1a\uff0c\u52a8\u6001\u884c\u7b2c13\u884c\u51cf\u514d\u6240\u5f97\u7a0e\u989d\u4f18\u60e0\u9879\u4e0d\u7b26\u5408", (String)"QysdsJbImportServiceImpl_12", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), SHEET_NAME_A200000));
        }
        if (checkList.size() > 1) {
            String number2 = ((DynamicObject)checkList.get(1)).getString("number");
            if ("JMSE00100".equals(number1) || "JMSE00100".equals(number2)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"sheet\u9875\uff1a%1$s,\u52a8\u6001\u884c\u7b2c13\u884c,\u5b58\u5728\u4e13\u5c5e\u5c0f\u578b\u5fae\u5229\u4f01\u4e1a\u7684\u4f18\u60e0\u9879\u76ee\uff0c\u4e0d\u5141\u8bb8\u8d85\u8fc7\u4e00\u6761\uff01", (String)"QysdsJbImportServiceImpl_13", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), SHEET_NAME_A200000));
            }
            if ("JMSE00601".equals(number1) && !checkNumbers.contains(number2)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"sheet\u9875\uff1a%1$s,\u52a8\u6001\u884c\u7b2c13\u884c,\u5b58\u5728\u76f8\u51b2\u7a81\u7684\u51cf\u514d\u6240\u5f97\u7a0e\u989d\u4f18\u60e0\u9879\u76ee\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"QysdsJbImportServiceImpl_14", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), SHEET_NAME_A200000));
            }
            if ("JMSE00601".equals(number2) && !checkNumbers.contains(number1)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"sheet\u9875\uff1a%1$s,\u52a8\u6001\u884c\u7b2c13\u884c,\u5b58\u5728\u76f8\u51b2\u7a81\u7684\u51cf\u514d\u6240\u5f97\u7a0e\u989d\u4f18\u60e0\u9879\u76ee\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"QysdsJbImportServiceImpl_14", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), SHEET_NAME_A200000));
            }
            if (checkNumbers.contains(number1) && !"JMSE00601".equals(number2)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"sheet\u9875\uff1a%1$s,\u52a8\u6001\u884c\u7b2c13\u884c,\u5b58\u5728\u76f8\u51b2\u7a81\u7684\u51cf\u514d\u6240\u5f97\u7a0e\u989d\u4f18\u60e0\u9879\u76ee\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"QysdsJbImportServiceImpl_14", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), SHEET_NAME_A200000));
            }
            if (checkNumbers.contains(number2) && !"JMSE00601".equals(number1)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"sheet\u9875\uff1a%1$s,\u52a8\u6001\u884c\u7b2c13\u884c,\u5b58\u5728\u76f8\u51b2\u7a81\u7684\u51cf\u514d\u6240\u5f97\u7a0e\u989d\u4f18\u60e0\u9879\u76ee\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"QysdsJbImportServiceImpl_14", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), SHEET_NAME_A200000));
            }
            if (!checkNumbers.contains(number1) && !"JMSE00601".equals(number1)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"sheet\u9875\uff1a%1$s,\u52a8\u6001\u884c\u7b2c13\u884c,\u5b58\u5728\u76f8\u51b2\u7a81\u7684\u51cf\u514d\u6240\u5f97\u7a0e\u989d\u4f18\u60e0\u9879\u76ee\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"QysdsJbImportServiceImpl_14", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), SHEET_NAME_A200000));
            }
            if (!checkNumbers.contains(number2) && !"JMSE00601".equals(number2)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"sheet\u9875\uff1a%1$s,\u52a8\u6001\u884c\u7b2c13\u884c,\u5b58\u5728\u76f8\u51b2\u7a81\u7684\u51cf\u514d\u6240\u5f97\u7a0e\u989d\u4f18\u60e0\u9879\u76ee\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"QysdsJbImportServiceImpl_14", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), SHEET_NAME_A200000));
            }
        }
        String newPolicy = ResManager.loadKDString((String)"\u65b0\u653f\u7b56", (String)"QysdsJbImportServiceImpl_15", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
        String oldPolicy = ResManager.loadKDString((String)"\u539f\u653f\u7b56", (String)"QysdsJbImportServiceImpl_16", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
        if (!CollectionUtils.isEmpty((Collection)checkList)) {
            if (newPolicy.equals(suittype)) {
                List<String> policy = Arrays.asList("JMSE00301A", "JMSE00302A", "JMSE00303A", "JMSE00304A", "JMSE00305A", "JMSE00308A", "JMSE00309A");
                Optional<DynamicObject> number = checkList.stream().filter(e -> policy.contains(e.getString("number"))).findFirst();
                if (number.isPresent()) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"sheet\u9875\uff1a%1$s,\u8f6f\u4ef6\u96c6\u6210\u7535\u8def\u4f01\u4e1a\u4f18\u60e0\u653f\u7b56\u9002\u7528\u7c7b\u578b\u4e3a\u65b0\u653f\u7b56\uff0c\u52a8\u6001\u884c\u7b2c13\u884c,\u5b58\u5728\u539f\u653f\u7b56\u4f18\u60e0\u9879\u76ee\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"QysdsJbImportServiceImpl_17", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), SHEET_NAME_A200000));
                }
            } else if (oldPolicy.equals(suittype)) {
                List<String> policy = Arrays.asList("JMSE00301B", "JMSE00302B", "JMSE00303B", "JMSE00304B", "JMSE00305B", "JMSE00306B", "JMSE00307B", "JMSE00308B", "JMSE00309B", "JMSE00310B");
                Optional<DynamicObject> number = checkList.stream().filter(e -> policy.contains(e.getString("number"))).findFirst();
                if (number.isPresent()) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"sheet\u9875\uff1a%1$s,\u8f6f\u4ef6\u96c6\u6210\u7535\u8def\u4f01\u4e1a\u4f18\u60e0\u653f\u7b56\u9002\u7528\u7c7b\u578b\u4e3a\u539f\u653f\u7b56\uff0c\u52a8\u6001\u884c\u7b2c13\u884c,\u5b58\u5728\u65b0\u653f\u7b56\u4f18\u60e0\u9879\u76ee\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"QysdsJbImportServiceImpl_18", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), SHEET_NAME_A200000));
                }
            } else {
                List<String> policy = Arrays.asList("JMSE00301B", "JMSE00302B", "JMSE00303B", "JMSE00304B", "JMSE00305B", "JMSE00306B", "JMSE00307B", "JMSE00308B", "JMSE00309B", "JMSE00310B", "JMSE00301A", "JMSE00302A", "JMSE00303A", "JMSE00304A", "JMSE00305A", "JMSE00308A", "JMSE00309A");
                Optional<DynamicObject> number = checkList.stream().filter(e -> policy.contains(e.getString("number"))).findFirst();
                if (number.isPresent()) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"sheet\u9875\uff1a%1$s,\u8f6f\u4ef6\u96c6\u6210\u7535\u8def\u4f01\u4e1a\u4f18\u60e0\u653f\u7b56\u9002\u7528\u7c7b\u578b\u4e3a\u7a7a\uff0c\u52a8\u6001\u884c\u7b2c13\u884c,\u5b58\u5728\u8f6f\u4ef6\u96c6\u6210\u7535\u8def\u4f01\u4e1a\u4f18\u60e0\u653f\u7b56\u4f18\u60e0\u9879\u76ee\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"QysdsJbImportServiceImpl_19", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), SHEET_NAME_A200000));
                }
            }
        }
    }

    private Map.Entry<String, List<String>> sortByValue(Map.Entry<String, List<String>> value) {
        if (value.getValue().size() == 1) {
            return value;
        }
        List collect = value.getValue().stream().sorted(Comparator.comparing(s -> this.getFormatBigDecimal((String)s))).collect(Collectors.toList());
        value.setValue(collect);
        return value;
    }

    private BigDecimal getFormatBigDecimal(String text) {
        int i = text.indexOf(46);
        if (i == -1) {
            return new BigDecimal(text);
        }
        int length = text.substring(i).length() - 1;
        BigDecimal temp = BigDecimal.ONE;
        for (int i1 = 0; i1 < length; ++i1) {
            temp = temp.multiply(BigDecimal.TEN);
        }
        return new BigDecimal(text).multiply(temp);
    }

    private String getActualRow(String key) {
        return String.valueOf(Integer.parseInt(key.split("#")[1]) + 1);
    }

    private boolean isDynRows(Map.Entry<String, List<Map.Entry<String, String>>> sortRow) {
        String value = sortRow.getValue().get(0).getValue();
        return value.startsWith("7.") || value.startsWith("8.") || value.startsWith("13.");
    }

    private void RecordRow(Map<String, String> map, Map.Entry<String, List<Map.Entry<String, String>>> sortRow, Map.Entry<String, String> entry, String key) {
        Map.Entry<String, String> itemName;
        if ((entry.getValue().startsWith(key) || entry.getValue().matches(key)) && StringUtil.isNotEmpty((CharSequence)(itemName = sortRow.getValue().get(1)).getValue())) {
            map.put(entry.getValue(), itemName.getValue());
        }
    }

    private Boolean existsItem(String entityName, String name, String type, String startDate, String endDate) {
        QFilter qFilter = this.appendQfiler(type);
        QFilter nameFilter = new QFilter("name", "=", (Object)name);
        QFilter q1 = new QFilter("start", "<=", (Object)DateUtils.stringToDate(startDate)).and("end", ">=", (Object)DateUtils.stringToDate(endDate));
        QFilter q2 = new QFilter("start", "<=", (Object)DateUtils.stringToDate(startDate)).and("end", "is null", null);
        QFilter q3 = new QFilter("enable", "=", (Object)"1");
        QFilter q4 = new QFilter("template", "=", (Object)"qysdsyj");
        QFilter dateFilter = q1.or(q2);
        QFilter[] filters = new QFilter[]{nameFilter, dateFilter, q3, q4, qFilter};
        Boolean objectList = QueryServiceHelper.exists((String)entityName, (QFilter[])filters);
        return objectList;
    }

    private QFilter appendQfiler(String type) {
        QFilter q1 = null;
        if (type.equals("7")) {
            q1 = new QFilter("longnumber", "like", (Object)"%YJ-JJSR2021%").or(new QFilter("longnumber", "like", (Object)"%YJ-MSSR2021%")).or(new QFilter("longnumber", "like", (Object)"%YJ-JJKC2021%"));
        } else if (type.equals("8")) {
            q1 = new QFilter("longnumber", "like", (Object)"YJ-SDJM2021").or(new QFilter("longnumber", "like", (Object)"YJ-SDJM2021.%"));
        } else if (type.equals("13")) {
            q1 = new QFilter("longnumber", "like", (Object)"YJ-JMSE2021").or(new QFilter("longnumber", "like", (Object)"YJ-JMSE2021.%")).and(new QFilter("number", "not in", (Object)new String[]{"JMSE00306A", "JMSE00307A", "JMSE00604"}));
        } else if (type.equals("1.1")) {
            q1 = new QFilter("longnumber", "=", (Object)"acce").or(new QFilter("longnumber", "like", (Object)"%acce.10%"));
        } else if (type.equals("2.1")) {
            q1 = new QFilter("longnumber", "=", (Object)"acce").or(new QFilter("longnumber", "like", (Object)"%acce.20%")).and(new QFilter("number", "!=", (Object)"JSZJ1020"));
        }
        return q1;
    }

    private boolean isEmptyRow(Map.Entry<String, List<Map.Entry<String, String>>> row) {
        boolean isEmptyCloumn1 = row.getValue().stream().filter(s -> ((String)s.getKey()).endsWith("#1")).allMatch(s -> StringUtil.isEmpty((CharSequence)((CharSequence)s.getValue())));
        boolean isEmptyCloumn10 = row.getValue().stream().filter(s -> ((String)s.getKey()).endsWith("#10")).allMatch(s -> StringUtil.isEmpty((CharSequence)((CharSequence)s.getValue())) || "0".equals(s.getValue()));
        return isEmptyCloumn1 && isEmptyCloumn10;
    }

    public boolean validDate(String datestr) {
        if (StringUtil.isEmpty((CharSequence)datestr)) {
            return false;
        }
        try {
            Date date = DateUtils.stringToDate2(datestr);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private class A201020InnerParseData
    extends InnerParseData {
        private Map<String, String> dyn1Items;
        private Map<String, String> dyn2Items;

        public A201020InnerParseData(List<Map.Entry<String, List<Map.Entry<String, String>>>> sortRows) {
            super(sortRows);
            this.dyn1Items = new HashMap<String, String>(32);
            this.dyn2Items = new HashMap<String, String>(32);
        }

        public Map<String, String> getDyn1Items() {
            return this.dyn1Items;
        }

        public Map<String, String> getDyn2Items() {
            return this.dyn2Items;
        }

        private A201020InnerParseData parse() {
            for (Map.Entry sortRow : ((InnerParseData)this).sortRows) {
                Map.Entry entry = (Map.Entry)((List)sortRow.getValue()).get(0);
                if (((String)entry.getValue()).equals("1")) {
                    ((InnerParseData)this).record = Boolean.TRUE;
                }
                if (((InnerParseData)this).record.booleanValue()) {
                    ((InnerParseData)this).names.put(sortRow.getKey(), ((Map.Entry)((List)sortRow.getValue()).get(0)).getValue());
                }
                QysdsJbImportServiceImpl.this.RecordRow(this.dyn1Items, sortRow, entry, "1.");
                QysdsJbImportServiceImpl.this.RecordRow(this.dyn2Items, sortRow, entry, "2.");
                if (!((String)entry.getValue()).equals("3")) continue;
                ((InnerParseData)this).record = Boolean.FALSE;
            }
            ((InnerParseData)this).isIncrease(((InnerParseData)this).names.values().stream().collect(Collectors.toList()));
            return this;
        }
    }

    private abstract class InnerParseData {
        private List<Map.Entry<String, List<Map.Entry<String, String>>>> sortRows;
        private List<String> dynEmptyRows = new ArrayList<String>(16);
        private LinkedHashMap<String, String> names = new LinkedHashMap(32);
        private Boolean record = Boolean.FALSE;
        private List<String> orderNumbers = new ArrayList<String>();

        public InnerParseData(List<Map.Entry<String, List<Map.Entry<String, String>>>> sortRows) {
            this.sortRows = sortRows;
        }

        public List<String> getDynEmptyRows() {
            return this.dynEmptyRows;
        }

        public LinkedHashMap<String, String> getNames() {
            return this.names;
        }

        public void setNames(LinkedHashMap<String, String> names) {
            this.names = names;
        }

        public List<String> getOrderNumbers() {
            return this.orderNumbers;
        }

        private List<String> isIncrease(List<String> elements) {
            List inputSort = elements.stream().filter(s -> s.matches(regex)).collect(Collectors.toList());
            Map<String, List<String>> groupByMaps = inputSort.stream().collect(Collectors.groupingBy(s -> s.split("\\.")[0]));
            LinkedHashMap sortByKey = groupByMaps.entrySet().stream().sorted(Comparator.comparing(s -> new BigDecimal((String)s.getKey()))).collect(Collectors.toMap(t -> t, t1 -> t1, (oldVal, newVal) -> oldVal, LinkedHashMap::new));
            sortByKey.entrySet().forEach(s -> s.setValue(QysdsJbImportServiceImpl.this.sortByValue((Map.Entry)s.getValue())));
            List standardSort = sortByKey.entrySet().stream().flatMap(s -> ((List)((Map.Entry)s.getValue()).getValue()).stream()).collect(Collectors.toList());
            for (int i = 0; i < standardSort.size(); ++i) {
                String input;
                String standard = (String)standardSort.get(i);
                if (standard.compareTo(input = (String)inputSort.get(i)) == 0) continue;
                this.orderNumbers.add(input.replace(".0", ""));
            }
            return this.orderNumbers;
        }
    }

    private class A06779InnerParseData
    extends InnerParseData {
        private Map<String, String> dynItems;

        public A06779InnerParseData(List<Map.Entry<String, List<Map.Entry<String, String>>>> sortRows) {
            super(sortRows);
            this.dynItems = new HashMap<String, String>(32);
        }

        public Map<String, String> getDynItems() {
            return this.dynItems;
        }

        private A06779InnerParseData parse() {
            for (Map.Entry sortRow : ((InnerParseData)this).sortRows) {
                Map.Entry entry = (Map.Entry)((List)sortRow.getValue()).get(0);
                if ("A06779#5#".startsWith((String)sortRow.getKey())) {
                    ((InnerParseData)this).record = Boolean.TRUE;
                }
                if (((String)entry.getValue()).equals(ResManager.loadKDString((String)"\u5408\u8ba1", (String)"QysdsJbImportServiceImpl_9", (String)"taxc-bdtaxr-common", (Object[])new Object[0]))) {
                    ((InnerParseData)this).record = Boolean.FALSE;
                }
                if (((InnerParseData)this).record.booleanValue()) {
                    ((InnerParseData)this).names.put(sortRow.getKey(), ((Map.Entry)((List)sortRow.getValue()).get(0)).getValue());
                }
                QysdsJbImportServiceImpl.this.RecordRow(this.dynItems, sortRow, entry, "\\d+");
            }
            ((InnerParseData)this).isIncrease(((InnerParseData)this).names.values().stream().collect(Collectors.toList()));
            return this;
        }
    }

    private class A200000InnerParseData
    extends InnerParseData {
        private Map<String, String> dyn7Items;
        private Map<String, String> dyn8Items;
        private Map<String, String> dyn13Items;

        public A200000InnerParseData(List<Map.Entry<String, List<Map.Entry<String, String>>>> sortRows) {
            super(sortRows);
            this.dyn7Items = new HashMap<String, String>(32);
            this.dyn8Items = new HashMap<String, String>(32);
            this.dyn13Items = new HashMap<String, String>(32);
        }

        public Map<String, String> getDyn7Items() {
            return this.dyn7Items;
        }

        public Map<String, String> getDyn8Items() {
            return this.dyn8Items;
        }

        public Map<String, String> getDyn13Items() {
            return this.dyn13Items;
        }

        private A200000InnerParseData parse() {
            for (Map.Entry sortRow : ((InnerParseData)this).sortRows) {
                Map.Entry entry = (Map.Entry)((List)sortRow.getValue()).get(0);
                if (((String)entry.getValue()).equals("1")) {
                    ((InnerParseData)this).record = Boolean.TRUE;
                }
                if (((InnerParseData)this).record.booleanValue()) {
                    ((InnerParseData)this).names.put(sortRow.getKey(), ((Map.Entry)((List)sortRow.getValue()).get(0)).getValue());
                }
                if (((InnerParseData)this).record.booleanValue() && QysdsJbImportServiceImpl.this.isDynRows(sortRow) && QysdsJbImportServiceImpl.this.isEmptyRow(sortRow)) {
                    ((InnerParseData)this).dynEmptyRows.add(QysdsJbImportServiceImpl.this.getActualRow((String)sortRow.getKey()));
                }
                QysdsJbImportServiceImpl.this.RecordRow(this.dyn7Items, sortRow, entry, "7.");
                QysdsJbImportServiceImpl.this.RecordRow(this.dyn8Items, sortRow, entry, "8.");
                QysdsJbImportServiceImpl.this.RecordRow(this.dyn13Items, sortRow, entry, "13.");
                if (!((String)entry.getValue()).equals("15")) continue;
                ((InnerParseData)this).record = Boolean.FALSE;
            }
            ((InnerParseData)this).isIncrease(((InnerParseData)this).names.values().stream().collect(Collectors.toList()));
            return this;
        }
    }
}

