/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.declare.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.declare.helper.DeclareServiceHelper;
import kd.taxc.bdtaxr.common.enums.TaxationsysMappingEnum;
import kd.taxc.bdtaxr.common.refactor.declare.ImportExcelHandler;
import kd.taxc.bdtaxr.common.refactor.template.TemplateUtils;
import kd.taxc.bdtaxr.common.util.FilterBuilderUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.vo.ImportDataVo;
import kd.taxc.bdtaxr.common.vo.ValidDataResultVo;
import org.apache.commons.collections.CollectionUtils;

public class SzysBImportServiceImpl
implements ImportExcelHandler {
    private static final String TCWAT_DECLARE_QUERY = "tcwat_declare_query";
    private static final String Const1 = "tcwat_declare_a_tax#";
    private static final String Const2 = "tcvat_nsrxx#";
    private static final List<String> ZSPMLIST = new ArrayList<String>();

    @Override
    public String getBillNo(String id, String skssqz) {
        return DeclareServiceHelper.generateSBBNo(TCWAT_DECLARE_QUERY);
    }

    @Override
    public DynamicObject queryReportExistsId(ImportDataVo vo) {
        return TemplateUtils.queryReportExists(vo.getOrgId(), vo.getTemplateTypeId(), vo.getStartDate(), vo.getEndDate(), vo.getTaxauthority(), vo.getBusinessno());
    }

    @Override
    public ValidDataResultVo validResultMap(ImportDataVo importDataVo, Map<String, String> resultMap, DynamicObject template) {
        DynamicObject dynamicObject;
        String conditionjson;
        String orgId = importDataVo.getOrgId();
        SzysBImportServiceImpl.checkDynRowData(resultMap);
        if (template != null && StringUtils.isNotEmpty((CharSequence)orgId) && StringUtils.isNotEmpty((CharSequence)(conditionjson = (dynamicObject = BusinessDataServiceHelper.loadSingle((Object)template.getLong("id"), (String)"bdtaxr_template_main")).getString("conditionjson")))) {
            QFilter orgQfilter = new QFilter("orgid", "=", (Object)Long.valueOf(orgId));
            QFilter taxationsys = new QFilter("taxationsys", "=", (Object)TaxationsysMappingEnum.CHN.getId());
            QFilter qFilter4 = FilterBuilderUtils.buildFilter(conditionjson, "tctb_tax_main_form");
            TemplateUtils.dealAddress(qFilter4);
            DynamicObjectCollection query = QueryServiceHelper.query((String)"tctb_tax_main", (String)"id", (QFilter[])new QFilter[]{qFilter4, orgQfilter, taxationsys});
            if (CollectionUtils.isEmpty((Collection)query)) {
                return ValidDataResultVo.fail(ResManager.loadKDString((String)"\u5f15\u5165\u7533\u62a5\u6570\u636e\u4e2d\u7684\u7a0e\u52a1\u7ec4\u7ec7\u4e0d\u5728\u7533\u62a5\u6a21\u677f\u7684\u9002\u7528\u5730\u533a\u8303\u56f4\u5185", (String)"SzysBImportServiceImpl_3", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            }
        }
        return ValidDataResultVo.success();
    }

    private static void checkDynRowData(Map<String, String> resultMap) {
        for (Map.Entry<String, String> entry : resultMap.entrySet()) {
            String key = entry.getKey();
            String[] split = key.split("#");
            if (split.length != 3 || !"zspm".equals(split[2])) continue;
            String zspm = resultMap.get(Const1.concat(split[1]).concat("#zspm"));
            if (zspm == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f81\u6536\u54c1\u76ee\u4e3a\u7a7a", (String)"SzysBImportServiceImpl_4", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            }
            if (!ZSPMLIST.contains(zspm)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5f81\u6536\u54c1\u76ee\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u8bf7\u9009\u62e9\u5730\u8868\u6c34\u6c34\u8d44\u6e90\u7a0e\u3001\u5730\u4e0b\u6c34\u6c34\u8d44\u6e90\u7a0e\u3001\u6216\u81ea\u6765\u6c34\u6c34\u8d44\u6e90\u7a0e", (String)"SzysBImportServiceImpl_5", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), 12 + Integer.parseInt(split[1])));
            }
            String zszm = resultMap.get(Const1.concat(split[1]).concat("#zszm"));
            DynamicObjectCollection zszmObj = QueryServiceHelper.query((String)"tpo_szys_bizdef", (String)"entry_detail.projectname,entry_detail.validfrom,entry_detail.expired,entry_detail.value", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"ZSZM")});
            String startdate = resultMap.get(Const2.concat("1").concat("#skssqq"));
            Date startdateDate = DateUtils.stringToDate(startdate);
            String enddate = resultMap.get(Const2.concat("1").concat("#skssqz"));
            Date enddateDate = DateUtils.stringToDate(enddate);
            String syse = resultMap.get(Const1.concat(split[1]).concat("#bqsybzse"));
            Optional<DynamicObject> first = zszmObj.stream().filter(s -> zszm.equals(s.getString("entry_detail.projectname"))).filter(s -> startdateDate.compareTo(s.getDate("entry_detail.validfrom")) >= 0).filter(s -> s.getDate("entry_detail.expired") == null || enddateDate.compareTo(s.getDate("entry_detail.expired")) <= 0).findFirst();
            if (!first.isPresent()) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5f81\u6536\u5b50\u76ee\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u8bf7\u68c0\u67e5\u5f81\u6536\u5b50\u76ee\u662f\u5426\u88ab\u6b63\u786e\u7ef4\u62a4\u5728\u7a0e\u52a1\u653f\u7b56\u8fd0\u7ef4-\u5176\u4ed6\u7a0e\u8d39-\u6c34\u8d44\u6e90\u7a0e-\u4e1a\u52a1\u5b9a\u4e49\u91cc", (String)"SzysBImportServiceImpl_6", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), 12 + Integer.parseInt(split[1])));
            }
            if (first.get().getBigDecimal("entry_detail.value").compareTo(new BigDecimal(syse)) == 0) continue;
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u9002\u7528\u7a0e\u989d\u4e0d\u662f\u8be5\u5f81\u6536\u5b50\u76ee\u7684\u9002\u7528\u7a0e\u989d", (String)"SzysBImportServiceImpl_7", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), 12 + Integer.parseInt(split[1])));
        }
    }

    static {
        ZSPMLIST.add(ResManager.loadKDString((String)"\u5730\u8868\u6c34\u6c34\u8d44\u6e90\u7a0e", (String)"SzysBImportServiceImpl_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        ZSPMLIST.add(ResManager.loadKDString((String)"\u5730\u4e0b\u6c34\u6c34\u8d44\u6e90\u7a0e", (String)"SzysBImportServiceImpl_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        ZSPMLIST.add(ResManager.loadKDString((String)"\u81ea\u6765\u6c34\u6c34\u8d44\u6e90\u7a0e", (String)"SzysBImportServiceImpl_2", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
    }
}

