/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.declare.savecheck;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.db.DataSaveService;
import kd.taxc.bdtaxr.common.declare.model.response.DeclareResponseModel;
import kd.taxc.bdtaxr.common.declare.model.result.BaseResult;
import kd.taxc.bdtaxr.common.refactor.declare.savecheck.TaxDeclareCheckHandler;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import org.apache.commons.collections.CollectionUtils;

public class CcxwsDeclareCheckImpl
implements TaxDeclareCheckHandler {
    @Override
    public BaseResult beforeSaveCheck(Map<String, String> updateMap, Map<String, String> newDataMap, DeclareResponseModel responseModel) {
        String typevalue = ResManager.loadKDString((String)"\u5370\u82b1\u7a0e", (String)"CcxwsDeclareCheckImpl_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
        Map<String, String> data = newDataMap;
        if (newDataMap == null) {
            data = responseModel.getData();
        }
        String orgid = data.get("tcvat_nsrxx#1#org");
        String nsrmc = data.get("tcvat_nsrxx#1#nsrmc");
        boolean zeroDeclare = SystemParamUtil.getZeroDeclareParameter("tcret", "zerodeclare", Long.parseLong(orgid));
        if (zeroDeclare) {
            List<String> keys = Arrays.asList("jsyj", "ynse", "jmse", "yjse", "ybse");
            List yhstypes = data.entrySet().stream().filter(e -> ((String)e.getValue()).equals(typevalue)).map(e -> ((String)e.getKey()).substring(0, ((String)e.getKey()).lastIndexOf("#"))).collect(Collectors.toList());
            for (String yhstype : yhstypes) {
                List<String> values = data.entrySet().stream().filter(e -> ((String)e.getKey()).contains(yhstype)).filter(e -> keys.contains(((String)e.getKey()).substring(((String)e.getKey()).lastIndexOf("#") + 1))).map(Map.Entry::getValue).collect(Collectors.toList());
                if (!this.checkZero(values)) continue;
                return BaseResult.fail(ResManager.loadKDString((String)"\u6b64\u7ec4\u7ec7\u7684\u5370\u82b1\u7a0e\u4e3a\u96f6\u7533\u62a5\uff0c\u3010\u8ba1\u7a0e\u4f9d\u636e\u3011\u3010\u5e94\u7eb3\u7a0e\u989d\u3011\u3010\u51cf\u514d\u7a0e\u989d\u3011\u3010\u5df2\u7f34\u7a0e\u989d\u3011\u3010\u5e94\u8865\u9000\u7a0e\u989d\u3011\u5fc5\u987b\u4e3a\u96f6", (String)"CcxwsDeclareCheckImpl_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            }
        }
        Map<String, DynamicObjectCollection> collectionMap = DataSaveService.mapToTable("tcvat_nsrxx", data, data);
        String currentSbbid = data.get("tcvat_nsrxx#1#id");
        QFilter idFilter = new QFilter("id", "!=", (Object)Long.parseLong(currentSbbid));
        QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(orgid));
        String taxauthority = data.get("tcvat_nsrxx#1#taxauthority");
        QFilter taxauthorityFilter = new QFilter("taxauthority", "=", (Object)Long.parseLong(taxauthority));
        QFilter typeFilter = new QFilter("type", "=", (Object)"ccxws");
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"tcvat_nsrxx", (String)"id,datatype", (QFilter[])new QFilter[]{idFilter, orgFilter, taxauthorityFilter, typeFilter});
        List sbbids = dynamicObjects.stream().map(s -> s.getLong("id") + "").distinct().collect(Collectors.toList());
        QFilter sbbidFilter = new QFilter("sbbid", "in", sbbids);
        DynamicObjectCollection zbhbList = collectionMap.get("tcret_ccxws_zb_hb");
        if (CollectionUtils.isNotEmpty((Collection)zbhbList)) {
            for (DynamicObject zbhb : zbhbList) {
                QFilter smFilter = new QFilter("sm", "=", (Object)zbhb.getString("sm"));
                QFilter sksssqFilter = new QFilter("startdate", "=", (Object)zbhb.getDate("startdate")).and(new QFilter("enddate", "=", (Object)zbhb.getDate("enddate")));
                boolean exists = QueryServiceHelper.exists((String)"tcret_ccxws_zb_hb", (QFilter[])new QFilter[]{sbbidFilter, smFilter, sksssqFilter});
                if (!exists) continue;
                DynamicObject taxorgan = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(taxauthority), (String)"bastax_taxorgan");
                String msg = String.format(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u7ec4\u7ec7\u4e3a\u3010%1$s\u3011\u3001\u7a0e\u52a1\u673a\u5173\u4e3a\u3010%2$s\u3011\u3001\u6240\u5c5e\u7a0e\u671f\u4e3a\u3010%3$s\u81f3%4$s\u3011\u3001\u7a0e\u79cd\u4e3a\u3010%5$s\u3011\u7684\u76f8\u540c\u7533\u62a5\u6570\u636e\u3002", (String)"CcxwsDeclareCheckImpl_2", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), nsrmc, taxorgan.getString("name"), DateUtils.format(zbhb.getDate("startdate")), DateUtils.format(zbhb.getDate("enddate")), zbhb.get("taxtype"));
                return BaseResult.fail(msg);
            }
        }
        return BaseResult.ok();
    }

    private boolean checkZero(List<String> values) {
        for (String value : values) {
            if (value == null || new BigDecimal(value).compareTo(BigDecimal.ZERO) <= 0) continue;
            return true;
        }
        return false;
    }
}

