/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.declare.savecheck;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.taxc.bdtaxr.common.constant.TaxConstant;
import kd.taxc.bdtaxr.common.declare.model.response.DeclareResponseModel;
import kd.taxc.bdtaxr.common.declare.model.result.BaseResult;
import kd.taxc.bdtaxr.common.refactor.declare.savecheck.TaxDeclareCheckHandler;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class QysdsNbDeclareCheckImpl
implements TaxDeclareCheckHandler {
    private static final String SKSSQQ = "tcvat_nsrxx#1#skssqq";
    private static final String SKSSQZ = "tcvat_nsrxx#1#skssqz";

    @Override
    public BaseResult beforeSaveCheck(Map<String, String> updateMap, Map<String, String> newDataMap, DeclareResponseModel responseModel) {
        if (newDataMap == null) {
            return BaseResult.ok();
        }
        String skssqq = newDataMap.get(SKSSQQ);
        String skssqz = newDataMap.get(SKSSQZ);
        if (StringUtil.isNotBlank((CharSequence)skssqq) && StringUtil.isNotBlank((CharSequence)skssqz)) {
            try {
                Date startDate = DateUtils.stringToDate(skssqq);
                Date endDate = DateUtils.stringToDate(skssqz);
                if (!DateUtils.validDateRange("year", startDate, endDate)) {
                    return BaseResult.fail(this.buildErrorMsg(new String[]{"year"}));
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return BaseResult.ok();
    }

    private String buildErrorMsg(String[] taxLimits) {
        String msgTmp = ResManager.loadKDString((String)"\u6240\u5c5e\u7a0e\u671f\u5fc5\u987b\u4e3a%s\u3002", (String)"QysdsNbDeclareCheckImpl_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
        ArrayList<String> nameList = new ArrayList<String>(4);
        for (String taxLimit : taxLimits) {
            nameList.add(TaxConstant.getTaxLimitNameMap().get(taxLimit));
        }
        return String.format(msgTmp, String.join((CharSequence)"\u3001", nameList));
    }

    @Override
    public Boolean dynCheck(Map<String, String> data, String cellId, String number) {
        return Boolean.TRUE;
    }
}

