/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.declare.savecheck;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.declare.model.response.DeclareResponseModel;
import kd.taxc.bdtaxr.common.declare.model.result.BaseResult;
import kd.taxc.bdtaxr.common.refactor.declare.savecheck.TaxDeclareCheckHandler;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class QysdsTaxDeclareCheckImpl
implements TaxDeclareCheckHandler {
    public static final String REGEX_ID_CARD18 = "^[1-9]\\d{5}[1-9]\\d{3}((0\\d)|(1[0-2]))(([0|1|2]\\d)|3[0-1])\\d{3}([0-9Xx])$";

    @Override
    public BaseResult beforeSaveCheck(Map<String, String> updateMap, Map<String, String> newDataMap, DeclareResponseModel responseModel) {
        if (updateMap == null) {
            return BaseResult.ok();
        }
        return this.checkIsMinCompany(updateMap, newDataMap);
    }

    @Override
    public Boolean dynCheck(Map<String, String> data, String cellId, String number) {
        return this.checkDyn3(data, cellId, number);
    }

    private Boolean checkDyn3(Map<String, String> data, String cellId, String number) {
        if (null == data || !cellId.startsWith("tccit_qysds_ext_dyn3")) {
            return true;
        }
        String orgid = data.get("tcvat_nsrxx#1#org");
        String skssqq = data.get("tcvat_nsrxx#1#skssqq");
        String skssqz = data.get("tcvat_nsrxx#1#skssqz");
        if (StringUtil.isBlank((CharSequence)orgid) || StringUtil.isBlank((CharSequence)skssqq) || StringUtil.isBlank((CharSequence)skssqz)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7533\u62a5\u8868\u7ec4\u7ec7\u5c5e\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"QysdsTaxDeclareCheckImpl_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
        boolean independenceOrg = this.isIndependenceOrg(Long.parseLong(orgid), DateUtils.stringToDate(skssqq), DateUtils.stringToDate(skssqz));
        if (independenceOrg) {
            return true;
        }
        List<String> checkList = Arrays.asList("JMSE00301A", "JMSE00302A", "JMSE00303A", "JMSE00304A", "JMSE00305A", "JMSE00308A", "JMSE00309A", "JMSE00302B", "JMSE00303B", "JMSE00304B", "JMSE00306B", "JMSE00307B", "JMSE00308B", "JMSE00309B", "JMSE00602");
        List collect = data.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("tccit_qysds_ext_dyn3")).filter(e -> ((String)e.getKey()).endsWith("item")).filter(e -> StringUtil.isNotEmpty((CharSequence)((CharSequence)e.getValue()))).filter(e -> !cellId.equals(e.getKey())).map(e -> Long.parseLong((String)e.getValue())).collect(Collectors.toList());
        DynamicObjectCollection numbers = QueryServiceHelper.query((String)"tpo_discount_tree", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "in", collect)});
        if (numbers.size() <= 0) {
            return true;
        }
        List existCount = collect.stream().filter(e -> 0L != e).collect(Collectors.toList());
        if (existCount.size() > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u51cf\u514d\u6240\u5f97\u7a0e\u989d\u6761\u76ee\uff0c\u4e0d\u5141\u8bb8\u8d85\u8fc7\u4e24\u6761\uff01", (String)"QysdsTaxDeclareCheckImpl_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
        String oldNumber = ((DynamicObject)numbers.get(0)).getString("number");
        if ("JMSE00100".equals(oldNumber) && !"JMSE00100".equals(number)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u76f8\u51b2\u7a81\u7684\u51cf\u514d\u6240\u5f97\u7a0e\u989d\u4f18\u60e0\u9879\u76ee\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"QysdsTaxDeclareCheckImpl_2", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
        if ("JMSE00601".equals(oldNumber) && !checkList.contains(number)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u76f8\u51b2\u7a81\u7684\u51cf\u514d\u6240\u5f97\u7a0e\u989d\u4f18\u60e0\u9879\u76ee\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"QysdsTaxDeclareCheckImpl_2", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
        if (checkList.contains(oldNumber) && !"JMSE00601".equals(number)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u76f8\u51b2\u7a81\u7684\u51cf\u514d\u6240\u5f97\u7a0e\u989d\u4f18\u60e0\u9879\u76ee\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"QysdsTaxDeclareCheckImpl_2", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
        if (!("JMSE00100".equals(oldNumber) || checkList.contains(oldNumber) || "JMSE00601".equals(oldNumber))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u76f8\u51b2\u7a81\u7684\u51cf\u514d\u6240\u5f97\u7a0e\u989d\u4f18\u60e0\u9879\u76ee\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"QysdsTaxDeclareCheckImpl_2", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
        return true;
    }

    private boolean isIndependenceOrg(long orgId, Date startDate, Date endDate) {
        QFilter q1 = new QFilter("orgrow.orgid", "=", (Object)orgId);
        QFilter q2 = new QFilter("taxtype", "=", (Object)"qysds");
        QFilter q3 = new QFilter("billstatus", "=", (Object)"C");
        QFilter q4 = new QFilter("effectdate", "<=", (Object)startDate);
        QFilter q5 = new QFilter("invaliddate", "is null", null).or(new QFilter("invaliddate", ">=", (Object)endDate));
        QFilter q6 = new QFilter("status", "=", (Object)"2");
        return QueryServiceHelper.exists((String)"tctb_org_group_latest", (QFilter[])new QFilter[]{q1, q2, q3, q4, q5, q6});
    }

    private BaseResult checkIsMinCompany(Map<String, String> updateMap, Map<String, String> newData) {
        Map.Entry entry;
        String operatorno;
        Optional<Map.Entry> optional;
        Optional<Map.Entry> any = updateMap.entrySet().stream().filter(e -> "tccit_qysds_zb#1#xxwlqy".equals(e.getKey())).findAny();
        if (any.isPresent()) {
            String value = (String)any.get().getValue();
            List dynList = newData.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("tccit_qysds_ext_dyn3")).filter(e -> ((String)e.getKey()).endsWith("item")).filter(e -> StringUtil.isNotEmpty((CharSequence)((CharSequence)e.getValue()))).map(e -> Long.parseLong((String)e.getValue())).filter(e -> 0L != e).collect(Collectors.toList());
            if (dynList.size() == 0) {
                return BaseResult.ok();
            }
            DynamicObjectCollection checkList = QueryServiceHelper.query((String)"tpo_discount_tree", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "in", dynList)});
            String number = ((DynamicObject)checkList.get(0)).getString("number");
            if ("1".equals(value) && dynList.size() > 1 || "1".equals(value) && !"JMSE00100".equals(number)) {
                return BaseResult.fail(ResManager.loadKDString((String)"\u52a8\u6001\u884c13\u884c\u5b58\u5728\u76f8\u51b2\u7a81\u7684\u51cf\u514d\u6240\u5f97\u7a0e\u989d\u4f18\u60e0\u9879\u76ee\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"QysdsTaxDeclareCheckImpl_3", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            }
            if ("0".equals(value) && "JMSE00100".equals(number)) {
                return BaseResult.fail(ResManager.loadKDString((String)"\u52a8\u6001\u884c13\u884c\u5b58\u5728\u76f8\u51b2\u7a81\u7684\u51cf\u514d\u6240\u5f97\u7a0e\u989d\u4f18\u60e0\u9879\u76ee\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"QysdsTaxDeclareCheckImpl_3", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            }
        }
        if ((optional = updateMap.entrySet().stream().filter(e -> "tcvat_nsrxx#1#operatorno".equals(e.getKey())).findAny()).isPresent() && StringUtil.isNotEmpty((CharSequence)(operatorno = (String)(entry = optional.get()).getValue())) && !QysdsTaxDeclareCheckImpl.isIDCard18(operatorno)) {
            return BaseResult.fail(ResManager.loadKDString((String)"\u7ecf\u529e\u4eba\u8eab\u4efd\u8bc1\u4e0d\u5408\u6cd5\uff01", (String)"QysdsTaxDeclareCheckImpl_4", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
        return BaseResult.ok();
    }

    public static boolean isIDCard18(CharSequence input) {
        Matcher matcher = Pattern.compile(REGEX_ID_CARD18).matcher(input);
        return matcher.matches();
    }
}

