/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.formula.cal;

import com.greenpineyu.fel.context.Var;
import com.greenpineyu.fel.function.Function;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.exception.FelException;
import kd.taxc.bdtaxr.common.refactor.formula.cal.ContainsFunction;
import kd.taxc.bdtaxr.common.refactor.formula.cal.IfFunction;
import kd.taxc.bdtaxr.common.refactor.formula.fel.FelEngine;
import kd.taxc.bdtaxr.common.refactor.formula.fel.function.operator.CountInGroup;
import kd.taxc.bdtaxr.common.refactor.formula.fel.function.operator.MaxFun;
import kd.taxc.bdtaxr.common.refactor.formula.fel.function.operator.MinFun;
import kd.taxc.bdtaxr.common.refactor.formula.fel.function.operator.SumFun;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.number.DataFormatUtils;
import kd.taxc.bdtaxr.common.util.number.DoubleUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class FelService {
    private static final Log logger = LogFactory.getLog(FelService.class);
    private static FelEngine felEngine = (FelEngine)TypesContainer.getOrRegisterSingletonInstance((String)"kd.taxc.bdtaxr.common.refactor.formula.fel.FelEngineImpl");
    private static final char[] LOGICAL_OPERATOR;
    private static final char[] CALCULATION_SYMBOL;
    private static final StringBuilder DATA_FORMAT_FUNMAME;

    private static Object exec(String exp) {
        Object result = felEngine.eval(exp);
        if (result == null) {
            result = exp;
        }
        return result;
    }

    public static Object eval(String exp) {
        Object result = "";
        if (StringUtil.isNotBlank((CharSequence)exp)) {
            try {
                result = FelService.exec(exp);
            }
            catch (Exception e) {
                logger.error("\u8ba1\u7b97\u5f15\u64ce\u6267\u884c\u8868\u8fbe\u5f0f\u51fa\u73b0\u9519\u8bef,exp=" + exp, (Throwable)e);
            }
        }
        return result;
    }

    public static Object eval(String exp, boolean throwExcep) {
        Object result;
        block3: {
            result = "";
            if (StringUtil.isNotBlank((CharSequence)exp)) {
                try {
                    result = FelService.exec(exp);
                }
                catch (Exception e) {
                    logger.error("\u8ba1\u7b97\u5f15\u64ce\u6267\u884c\u8868\u8fbe\u5f0f\u51fa\u73b0\u9519\u8bef,exp=" + exp, (Throwable)e);
                    if (!throwExcep) break block3;
                    throw e;
                }
            }
        }
        return result;
    }

    public static Object evalWithKey(String exp, String key) {
        Object result = null;
        if (StringUtil.isNotBlank((CharSequence)exp)) {
            try {
                result = FelService.exec(exp);
            }
            catch (Exception e) {
                logger.error(String.format("\u516c\u5f0f\u8ba1\u7b97\u51fa\u9519,key=%s,exp=%s", key, exp), (Throwable)e);
                throw new FelException(String.format(ResManager.loadKDString((String)"\u516c\u5f0f\u8ba1\u7b97\u51fa\u9519,key=%1$s,exp=%2$s", (String)"FelService_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), key, exp), e);
            }
            catch (Error e) {
                logger.error(String.format("\u516c\u5f0f\u8ba1\u7b97\u51fa\u9519,key=%s,exp=%s", key, exp), (Throwable)e);
                throw e;
            }
        }
        return result;
    }

    public static String replaceExpression(String exp) {
        if (StringUtil.isBlank((CharSequence)exp)) {
            return exp;
        }
        char[] exps = exp.toCharArray();
        StringBuilder newExp = new StringBuilder();
        StringBuilder subExp = new StringBuilder();
        Boolean validFlag = false;
        Boolean excludeFlag = true;
        for (int i = 0; i < exps.length; ++i) {
            char str = exps[i];
            if (!validFlag.booleanValue() && FelService.containChar(str, CALCULATION_SYMBOL)) {
                validFlag = true;
                subExp.append(str);
                continue;
            }
            if (FelService.containChar(str, LOGICAL_OPERATOR)) {
                if (str != ',') {
                    excludeFlag = false;
                }
                if (validFlag.booleanValue() && StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{subExp})) {
                    newExp.append((CharSequence)DATA_FORMAT_FUNMAME).append((CharSequence)subExp).append(",\"#.0000000000\")");
                    validFlag = false;
                    subExp = new StringBuilder();
                }
                if (!validFlag.booleanValue()) {
                    newExp.append((CharSequence)subExp).append(str);
                }
                subExp = new StringBuilder();
                continue;
            }
            subExp.append(str);
            if (i != exps.length - 1) continue;
            if (excludeFlag.booleanValue()) {
                return exp;
            }
            if (validFlag.booleanValue()) {
                newExp.append((CharSequence)DATA_FORMAT_FUNMAME).append((CharSequence)subExp).append(",\"#.0000000000\")");
                continue;
            }
            newExp.append((CharSequence)subExp);
        }
        return newExp.toString();
    }

    public static boolean containChar(char c, char[] cList) {
        if (cList == null || cList.length == 0) {
            return false;
        }
        for (int i = 0; i < cList.length; ++i) {
            char str = cList[i];
            if (str != c) continue;
            return true;
        }
        return false;
    }

    static {
        felEngine.addFun((Function)new IfFunction());
        felEngine.addFun((Function)new ContainsFunction());
        felEngine.addFun((Function)new MinFun());
        felEngine.addFun((Function)new MaxFun());
        felEngine.addFun((Function)new SumFun());
        felEngine.addFun((Function)new MinFun());
        felEngine.addFun((Function)new MaxFun());
        felEngine.addFun((Function)new CountInGroup());
        felEngine.getContext().set("DateUtils", (Object)new DateUtils());
        felEngine.getContext().set("DataFormatUtils", (Object)new DataFormatUtils());
        felEngine.getContext().set("StringUtil", (Object)new StringUtil());
        felEngine.getContext().set("DoubleUtil", (Object)new DoubleUtil());
        felEngine.getContext().setVar(new Var("errorinfo", (Object)ResManager.loadKDString((String)"\u9519\u8bef\u7684", (String)"FelService_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0])));
        LOGICAL_OPERATOR = new char[]{'&', '|', '>', '<', '=', '!', ','};
        CALCULATION_SYMBOL = new char[]{'+', '-', '*', '/'};
        DATA_FORMAT_FUNMAME = new StringBuilder("DataFormatUtils.decimalFormat(");
    }
}

