/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.formula.context;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.taxc.bdtaxr.common.refactor.formula.cal.CalculateService;
import kd.taxc.bdtaxr.common.refactor.formula.context.AbstractContext;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaVo;
import kd.taxc.bdtaxr.common.refactor.formula.parse.ParseUtils;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;

public class CheckFormulaContext
extends AbstractContext {
    @Deprecated
    public List<Map<String, String>> cal(Map<String, String> data, Map param, List<FormulaVo> formulas) {
        this.data = data;
        this.param = param;
        this.variableKey = new HashMap();
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        for (FormulaVo formula : formulas) {
            String result = this.calculate(formula);
            if (!"0".equals(result)) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("jump", formula.getFormulaKey());
            map.put("title", formula.getTitle());
            map.put("content", this.calculateContent(formula.getContent()));
            map.put("items", formula.getFormulaKey());
            list.add(map);
        }
        return list;
    }

    public List<Map<String, String>> cal(Map<String, String> data, Map param, List<FormulaVo> formulas, Map<String, EntityField> typeMap) {
        this.data = data;
        this.param = param;
        this.variableKey = new HashMap();
        this.allEntityFieldByType = typeMap;
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        for (FormulaVo formula : formulas) {
            String result = this.calculate(formula);
            if (!"0".equals(result)) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("jump", formula.getFormulaKey());
            map.put("title", formula.getTitle());
            map.put("content", this.calculateContent(formula.getContent()));
            map.put("items", formula.getFormulaKey());
            list.add(map);
        }
        return list;
    }

    public List<Map<String, String>> calCheckFormulas(Map<String, String> data, Map param, Map<String, List<FormulaVo>> formulas, Map<String, EntityField> typeMap) {
        this.data = data;
        this.param = param;
        this.variableKey = new HashMap();
        this.allEntityFieldByType = typeMap;
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        for (List<FormulaVo> listValue : formulas.values()) {
            for (FormulaVo formula : listValue) {
                String result = this.calculate(formula);
                if (!"0".equals(result)) continue;
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("jump", formula.getFormulaKey());
                map.put("title", formula.getTitle());
                map.put("content", this.multiCalculateContent(formula));
                map.put("items", formula.getFormulaKey());
                map.put("level", formula.getChecktype());
                list.add(map);
            }
        }
        return list;
    }

    private String calculateContent(String content) {
        List<String> contentList = ParseUtils.parseformulaContent(content);
        Iterator<String> iterator = contentList.iterator();
        while (iterator.hasNext()) {
            String formula;
            String temp = formula = iterator.next();
            List<String> list = ParseUtils.parseformula(formula);
            for (String f : list) {
                Map<String, String> map = ParseUtils.parseFormulaZKH(f);
                String value = this.getValue(map, null);
                if (value == null) continue;
                temp = temp.replace(f, value);
            }
            temp = temp.replace("{F[", "").replace("]}", "");
            content = this.replaceFirst(formula, content, temp);
        }
        return content;
    }

    private String multiCalculateContent(FormulaVo formulaVo) {
        String content = formulaVo.getContent();
        if (formulaVo.getFormulaKey().split("#").length == 3) {
            boolean isDyn = true;
            try {
                Integer.parseInt(formulaVo.getFormulaKey().split("#")[1]);
            }
            catch (Exception e) {
                isDyn = false;
            }
            if (isDyn) {
                content = content.replaceAll(formulaVo.getFormulaKey().split("#")[0] + "#", formulaVo.getFormulaKey().split("#")[0] + "#" + formulaVo.getFormulaKey().split("#")[1] + "#");
            }
        }
        List<String> contentList = ParseUtils.parseformulaContent(content);
        Iterator<String> iterator = contentList.iterator();
        while (iterator.hasNext()) {
            String formula;
            String temp = formula = iterator.next();
            List<String> list = ParseUtils.parseformula(formula);
            for (String f : list) {
                Map<String, String> map = ParseUtils.parseFormulaZKH(f);
                String value = this.getValue(map, null);
                if (value == null) continue;
                temp = temp.replace(f, value);
            }
            temp = temp.replace("{F[", "").replace("]}", "");
            content = this.replaceFirst(formula, content, temp);
        }
        return content;
    }

    private String replaceFirst(String formula, String content, String temp) {
        int index = content.indexOf(formula);
        int end = index + formula.length();
        StringBuilder sb = new StringBuilder();
        return sb.append(content.substring(0, index)).append(CalculateService.calculate(temp)).append(content.substring(end)).toString();
    }

    @Override
    public String calculate(FormulaVo formulaVo) {
        String ret = this.parse(formulaVo);
        if (CalculateService.check(ret, formulaVo.getFormulaKey())) {
            return "1";
        }
        return "0";
    }

    @Override
    public String getValue(Map<String, String> map, FormulaVo formulaVo) {
        String values = super.getValue(map, formulaVo);
        if (null != formulaVo) {
            // empty if block
        }
        return values;
    }
}

