/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.formula.context;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.taxc.bdtaxr.common.refactor.formula.cal.CalculateService;
import kd.taxc.bdtaxr.common.refactor.formula.context.AbstractContext;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaVo;
import kd.taxc.bdtaxr.common.refactor.formula.parse.ParseUtils;
import kd.taxc.bdtaxr.common.refactor.template.dynamic.DynamicRowService;
import kd.taxc.bdtaxr.common.tctb.common.vo.formula.DynamicRowModel;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;
import kd.taxc.bdtaxr.common.util.number.DataFormatUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class StyleFormulaContext
extends AbstractContext {
    private List<DynamicRowModel> dynRowList;

    public Map<String, String> cal(Map<String, String> data, Map param, Map<String, EntityField> typeMap, List<DynamicRowModel> dynRowList, List<FormulaVo> formulaVos) {
        this.data = data;
        this.param = param;
        this.variableKey = new HashMap(10);
        this.allEntityFieldByType = typeMap;
        this.dynRowList = dynRowList;
        HashMap<String, String> result = new HashMap<String, String>(10);
        for (FormulaVo formula : formulaVos) {
            result.put(formula.getFormulaKey(), this.calculate(formula));
        }
        return result;
    }

    @Override
    public String calculate(FormulaVo formulaVo) {
        return this.calculateFormulaName(formulaVo.getFormulaKey(), formulaVo.getFormulaName());
    }

    public String calculateFormulaName(String cellKey, String formulaName) {
        if (StringUtil.isEmpty((CharSequence)cellKey)) {
            return null;
        }
        if (DynamicRowService.matchDyn(this.dynRowList, cellKey) != null) {
            formulaName = formulaName.replaceAll(cellKey.split("#")[0] + "#", cellKey.split("#")[0] + "#" + cellKey.split("#")[1] + "#");
        }
        List<String> contentList = ParseUtils.parseformulaContent(formulaName);
        Iterator<String> iterator = contentList.iterator();
        while (iterator.hasNext()) {
            String formula;
            String temp = formula = iterator.next();
            List<String> list = ParseUtils.parseformula(formula);
            for (String f : list) {
                Map<String, String> map = ParseUtils.parseFormulaZKH(f);
                String value = this.getValue(map, null);
                if (value == null) {
                    value = DataFormatUtils.dataFormatByFieldType(value, (EntityField)this.allEntityFieldByType.get(cellKey));
                }
                temp = temp.replace(f, value);
            }
            temp = temp.replace("{F[", "").replace("]}", "");
            formulaName = this.replaceFirst(formula, formulaName, temp);
        }
        return formulaName;
    }

    private String replaceFirst(String formula, String content, String temp) {
        int index = content.indexOf(formula);
        int end = index + formula.length();
        StringBuilder sb = new StringBuilder();
        return sb.append(content.substring(0, index)).append(CalculateService.calculateNoBusiness(temp)).append(content.substring(end)).toString();
    }
}

