/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.formula.fel.function.operator;

import com.greenpineyu.fel.common.NumberUtil;
import com.greenpineyu.fel.common.ObjectUtils;
import com.greenpineyu.fel.compile.FelMethod;
import com.greenpineyu.fel.compile.SourceBuilder;
import com.greenpineyu.fel.context.FelContext;
import com.greenpineyu.fel.function.StableFunction;
import com.greenpineyu.fel.function.TolerantFunction;
import com.greenpineyu.fel.parser.FelNode;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.taxc.bdtaxr.common.refactor.formula.fel.common.ReflectUtil;

public class Add
extends StableFunction {
    public static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    public Object call(FelNode node, FelContext context) {
        Object returnMe = null;
        for (Object child : node.getChildren()) {
            Object r;
            if ((child = TolerantFunction.eval((FelContext)context, child)) instanceof String) {
                if (returnMe == null) {
                    returnMe = child;
                    continue;
                }
                returnMe = returnMe + (String)child;
            }
            if (!(child instanceof Number)) continue;
            if (returnMe == null) {
                returnMe = child;
                continue;
            }
            Number value = (Number)child;
            if (returnMe instanceof Number) {
                r = (Number)returnMe;
                returnMe = BigDecimal.valueOf(NumberUtil.toDouble((Number)r)).add(BigDecimal.valueOf(NumberUtil.toDouble((Number)value)));
                continue;
            }
            if (!(returnMe instanceof String)) continue;
            r = (String)returnMe;
            returnMe = (String)r + value;
        }
        if (returnMe instanceof Number) {
            return NumberUtil.parseNumber((String)returnMe.toString());
        }
        return returnMe;
    }

    public String getName() {
        return "+";
    }

    public FelMethod toMethod(FelNode node, FelContext ctx) {
        Class type = null;
        List children = node.getChildren();
        StringBuilder sb = new StringBuilder();
        if (children.size() == 2) {
            FelNode left = (FelNode)children.get(0);
            SourceBuilder lm = left.toMethod(ctx);
            this.appendArg(sb, lm, ctx, left);
            Class leftType = lm.returnType(ctx, left);
            FelNode right = (FelNode)children.get(1);
            sb.append('+');
            SourceBuilder rm = right.toMethod(ctx);
            Class rightType = rm.returnType(ctx, right);
            type = CharSequence.class.isAssignableFrom(leftType) ? leftType : (CharSequence.class.isAssignableFrom(rightType) ? rightType : (ReflectUtil.isPrimitiveOrWrapNumber(leftType) && ReflectUtil.isPrimitiveOrWrapNumber(rightType) ? NumberUtil.arithmeticClass((Class)leftType, (Class)rightType) : String.class));
            this.appendArg(sb, rm, ctx, right);
        } else if (children.size() == 1) {
            FelNode right = (FelNode)children.get(0);
            SourceBuilder rm = right.toMethod(ctx);
            Class rightType = rm.returnType(ctx, right);
            if (ReflectUtil.isPrimitiveOrWrapNumber(rightType)) {
                this.appendArg(sb, rm, ctx, right);
            }
            type = rightType;
        }
        FelMethod m = new FelMethod(type, sb.toString());
        return m;
    }

    private void appendArg(StringBuilder sb, SourceBuilder argMethod, FelContext ctx, FelNode node) {
        Class t = argMethod.returnType(ctx, node);
        sb.append('(');
        if (ReflectUtil.isPrimitiveOrWrapNumber(t) || CharSequence.class.isAssignableFrom(t)) {
            sb.append(argMethod.source(ctx, node));
        } else {
            sb.append("ObjectUtils.toString(").append(argMethod.source(ctx, node)).append(')');
        }
        sb.append(')');
    }

    public static Object add(Object left, Object right) {
        if (left == null || right == null) {
            throw new NullPointerException(ResManager.loadKDString((String)"\u8c03\u7528add()\u65b9\u6cd5\u51fa\u9519\uff01,\u539f\u56e0\uff1a\u5f53\u524d\u53c2\u6570\u4e3a\u7a7a", (String)"Add_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
        try {
            if (left instanceof Object[]) {
                left = NumberUtil.calArray((Object)left);
            }
            if (right instanceof Object[]) {
                right = NumberUtil.calArray((Object)right);
            }
            if (NumberUtil.isFloatingPointNumber((Object)left) || NumberUtil.isFloatingPointNumber((Object)right)) {
                double l = NumberUtil.toDouble((Object)left);
                double r = NumberUtil.toDouble((Object)right);
                return l + r;
            }
            if (left instanceof BigInteger && right instanceof BigInteger) {
                BigInteger l = NumberUtil.toBigInteger((Object)left);
                BigInteger r = NumberUtil.toBigInteger((Object)right);
                return l.add(r);
            }
            if (left instanceof BigDecimal || right instanceof BigDecimal) {
                BigDecimal l = NumberUtil.toBigDecimal((Object)left);
                BigDecimal r = NumberUtil.toBigDecimal((Object)right);
                return l.add(r);
            }
            if (left instanceof String && right instanceof Date) {
                Instant instant = ((Date)right).toInstant();
                ZoneId zone = ZoneId.systemDefault();
                LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zone);
                String nowStr = localDateTime.format(DATE_FORMAT);
                return left + nowStr;
            }
            if (left instanceof Date && right instanceof String) {
                Instant instant = ((Date)left).toInstant();
                ZoneId zone = ZoneId.systemDefault();
                LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zone);
                String nowStr = localDateTime.format(DATE_FORMAT);
                return nowStr + right;
            }
            BigInteger l = NumberUtil.toBigInteger((Object)left);
            BigInteger r = NumberUtil.toBigInteger((Object)right);
            BigInteger result = l.add(r);
            return NumberUtil.narrowBigInteger((Object)left, (Object)right, (BigInteger)result);
        }
        catch (Exception e) {
            return ObjectUtils.toString((Object)left).concat(ObjectUtils.toString((Object)right));
        }
    }
}

