/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.formula.fel.function.operator;

import com.greenpineyu.fel.compile.FelMethod;
import com.greenpineyu.fel.compile.InterpreterSourceBuilder;
import com.greenpineyu.fel.compile.SourceBuilder;
import com.greenpineyu.fel.context.FelContext;
import com.greenpineyu.fel.function.StableFunction;
import com.greenpineyu.fel.function.TolerantFunction;
import com.greenpineyu.fel.parser.FelNode;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CollectionGet
extends StableFunction {
    private String[][] a = new String[][]{{"a", "b"}, {"c", "d"}};
    private int[][] num = new int[][]{{1, 2}, {3, 4}};

    public Object call(FelNode node, FelContext context) {
        if (node.getChildCount() >= 2) {
            Object coll = TolerantFunction.eval((FelContext)context, (Object)node.getChild(0));
            Object index = TolerantFunction.eval((FelContext)context, (Object)node.getChild(1));
            int i = 0;
            if (index instanceof Number) {
                i = ((Number)index).intValue();
            }
            return CollectionGet.get(coll, i);
        }
        return null;
    }

    public String getName() {
        return "[";
    }

    public SourceBuilder toMethod(FelNode node, FelContext ctx) {
        Class<Object> type = null;
        List children = node.getChildren();
        FelNode left = (FelNode)children.get(0);
        SourceBuilder leftMethod = left.toMethod(ctx);
        Class leftType = leftMethod.returnType(ctx, left);
        if (!leftType.isArray() && !List.class.isAssignableFrom(leftType)) {
            return InterpreterSourceBuilder.getInstance();
        }
        FelNode right = (FelNode)children.get(1);
        SourceBuilder rightMethod = right.toMethod(ctx);
        Class rightType = rightMethod.returnType(ctx, right);
        String leftSrc = leftMethod.source(ctx, left);
        String rightSrc = this.getRightSrc(ctx, right, rightMethod, rightType);
        String src = "";
        if (leftType.isArray()) {
            type = leftType.getComponentType();
            src = "(" + leftSrc + ")[" + rightSrc + "]";
        } else if (List.class.isAssignableFrom(leftType)) {
            type = Object.class;
            src = "(" + leftSrc + ").get(" + rightSrc + ")";
        }
        return new FelMethod(type, src);
    }

    private String getRightSrc(FelContext ctx, FelNode right, SourceBuilder rightMethod, Class<?> rightType) {
        String rightSrc = "";
        Class[] cls = new Class[]{Integer.class, Short.class, Character.class, Byte.class, Integer.TYPE, Short.TYPE, Character.TYPE, Byte.TYPE};
        boolean isInt = false;
        for (int i = 0; i < cls.length; ++i) {
            if (!cls[i].isAssignableFrom(rightType)) continue;
            isInt = true;
            break;
        }
        if (isInt) {
            rightSrc = rightMethod.source(ctx, right);
        } else if (Number.class.isAssignableFrom(rightType)) {
            rightSrc = "(" + rightMethod.source(ctx, right) + ").intValue()";
        }
        return rightSrc;
    }

    public static Object get(Object object, int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index cannot be negative: " + index);
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            Iterator iterator = map.entrySet().iterator();
            return CollectionGet.get(iterator, index);
        }
        if (object instanceof List) {
            return ((List)object).get(index);
        }
        if (object instanceof Object[]) {
            return ((Object[])object)[index];
        }
        if (object instanceof Iterator) {
            Iterator it = (Iterator)object;
            while (it.hasNext()) {
                if (--index == -1) {
                    return it.next();
                }
                it.next();
            }
            throw new IndexOutOfBoundsException("Entry does not exist: " + index);
        }
        if (object instanceof Collection) {
            Iterator iterator = ((Collection)object).iterator();
            return CollectionGet.get(iterator, index);
        }
        if (object instanceof Enumeration) {
            Enumeration it = (Enumeration)object;
            while (it.hasMoreElements()) {
                if (--index == -1) {
                    return it.nextElement();
                }
                it.nextElement();
            }
            throw new IndexOutOfBoundsException("Entry does not exist: " + index);
        }
        if (object == null) {
            throw new IllegalArgumentException("Unsupported object type: null");
        }
        try {
            return Array.get(object, index);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Unsupported object type: ", ex);
        }
    }

    public int[][] getNum() {
        return this.num;
    }

    public void setNum(int[][] num) {
        this.num = num;
    }

    public String[][] getA() {
        return this.a;
    }

    public void setA(String[][] a) {
        this.a = a;
    }

    public static boolean isEqual(float a, float b) {
        if (Double.isNaN(a) || Double.isNaN(b) || Double.isInfinite(a) || Double.isInfinite(b)) {
            return false;
        }
        double eps = 1.0E-8;
        return (double)Math.abs(a - b) < eps;
    }

    public static boolean isEqual(double a, double b) {
        if (Double.isNaN(a) || Double.isNaN(b) || Double.isInfinite(a) || Double.isInfinite(b)) {
            return false;
        }
        double eps = 1.0E-8;
        return Math.abs(a - b) < eps;
    }
}

