/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.formula.fel.function.operator;

import com.greenpineyu.fel.common.NumberUtil;
import com.greenpineyu.fel.compile.FelMethod;
import com.greenpineyu.fel.compile.SourceBuilder;
import com.greenpineyu.fel.context.FelContext;
import com.greenpineyu.fel.exception.CompileException;
import com.greenpineyu.fel.exception.EvalException;
import com.greenpineyu.fel.function.StableFunction;
import com.greenpineyu.fel.parser.FelNode;
import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.taxc.bdtaxr.common.refactor.formula.fel.common.ReflectUtil;

public class Mul
extends StableFunction {
    public Object call(FelNode node, FelContext context) {
        List children = node.getChildren();
        if (children.size() == 2) {
            FelNode left = (FelNode)children.get(0);
            Object leftValue = left.eval(context);
            FelNode right = (FelNode)children.get(1);
            Object rightValue = right.eval(context);
            if (leftValue instanceof Number && rightValue instanceof Number) {
                double l = NumberUtil.toDouble((Object)leftValue);
                double r = NumberUtil.toDouble((Object)rightValue);
                return this.calc(l, r);
            }
            throw new EvalException(String.format(ResManager.loadKDString((String)"\u6267\u884c%s\u51fa\u9519\uff0c\u53c2\u6570\u5fc5\u987b\u662f\u6570\u503c\u578b", (String)"Mul_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), this.getName()));
        }
        throw new EvalException(String.format(ResManager.loadKDString((String)"\u6267\u884c%s\u51fa\u9519\uff0c\u53c2\u6570\u6570\u91cf\u5fc5\u987b\u4e3a2", (String)"Mul_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), this.getName()));
    }

    Object calc(double l, double r) {
        if (Double.isInfinite(l) || Double.isInfinite(r) || Double.isNaN(l) || Double.isNaN(r)) {
            return NumberUtil.parseNumber((double)(l * r));
        }
        return NumberUtil.parseNumber((double)BigDecimal.valueOf(l).multiply(BigDecimal.valueOf(r)).doubleValue());
    }

    public String getName() {
        return "*";
    }

    public FelMethod toMethod(FelNode node, FelContext ctx) {
        String code = "";
        FelNode left = (FelNode)node.getChildren().get(0);
        FelNode right = (FelNode)node.getChildren().get(1);
        SourceBuilder lm = left.toMethod(ctx);
        Class leftType = lm.returnType(ctx, left);
        SourceBuilder rm = right.toMethod(ctx);
        Class rightType = lm.returnType(ctx, right);
        Class type = null;
        if (!ReflectUtil.isPrimitiveOrWrapNumber(leftType) || !ReflectUtil.isPrimitiveOrWrapNumber(rightType)) {
            throw new CompileException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u7c7b\u578b[%1$s\u3001%2$s]\u3002[%3$s]\u8fd0\u7b97\u53ea\u652f\u6301\u6570\u503c\u7c7b\u578b", (String)"Mul_2", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), ReflectUtil.getClassName(leftType), ReflectUtil.getClassName(rightType), this.getName()));
        }
        type = NumberUtil.arithmeticClass((Class)leftType, (Class)rightType);
        code = "(" + lm.source(ctx, left) + ")" + this.getName() + "(" + rm.source(ctx, right) + ")";
        FelMethod m = new FelMethod(type, code);
        return m;
    }

    public boolean stable() {
        return true;
    }
}

