/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.formula.fel.function.operator;

import com.greenpineyu.fel.common.NumberUtil;
import com.greenpineyu.fel.compile.FelMethod;
import com.greenpineyu.fel.compile.SourceBuilder;
import com.greenpineyu.fel.context.FelContext;
import com.greenpineyu.fel.exception.CompileException;
import com.greenpineyu.fel.exception.EvalException;
import com.greenpineyu.fel.function.StableFunction;
import com.greenpineyu.fel.parser.FelNode;
import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.taxc.bdtaxr.common.refactor.formula.fel.common.ReflectUtil;

public class Sub
extends StableFunction {
    private void appendArg(StringBuilder sb, SourceBuilder argMethod, FelContext ctx, FelNode node) {
        Class t = argMethod.returnType(ctx, node);
        sb.append('(');
        if (ReflectUtil.isPrimitiveOrWrapNumber(t)) {
            sb.append(argMethod.source(ctx, node));
        } else if (CharSequence.class.isAssignableFrom(t)) {
            // empty if block
        }
        sb.append(')');
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FelMethod toMethod(FelNode node, FelContext ctx) {
        List children = node.getChildren();
        StringBuilder sb = new StringBuilder();
        Class type = null;
        if (children.size() == 2) {
            FelNode left = (FelNode)children.get(0);
            SourceBuilder lm = left.toMethod(ctx);
            Class leftType = lm.returnType(ctx, left);
            this.appendArg(sb, lm, ctx, left);
            FelNode right = (FelNode)children.get(1);
            SourceBuilder rm = right.toMethod(ctx);
            Class rightType = rm.returnType(ctx, right);
            sb.append('-');
            this.appendArg(sb, rm, ctx, right);
            if (!ReflectUtil.isPrimitiveOrWrapNumber(leftType) || !ReflectUtil.isPrimitiveOrWrapNumber(rightType)) throw new CompileException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u7c7b\u578b[%1$s\u3001%2$s]\u3002\u51cf[-]\u8fd0\u7b97\u53ea\u652f\u6301\u6570\u503c\u7c7b\u578b", (String)"Sub_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), ReflectUtil.getClassName(leftType), ReflectUtil.getClassName(rightType)));
            type = NumberUtil.arithmeticClass((Class)leftType, (Class)rightType);
            return new FelMethod(type, sb.toString());
        } else {
            if (children.size() != 1) return new FelMethod(type, sb.toString());
            FelNode right = (FelNode)children.get(0);
            SourceBuilder rm = right.toMethod(ctx);
            Class rightType = rm.returnType(ctx, right);
            sb.append('-');
            this.appendArg(sb, rm, ctx, right);
            if (!ReflectUtil.isPrimitiveOrWrapNumber(rightType)) return new FelMethod(type, sb.toString());
            type = rightType;
        }
        return new FelMethod(type, sb.toString());
    }

    public String getName() {
        return "-";
    }

    public Object call(FelNode node, FelContext context) {
        List children = node.getChildren();
        if (children.size() == 2) {
            FelNode left = (FelNode)children.get(0);
            Object leftValue = left.eval(context);
            FelNode right = (FelNode)children.get(1);
            Object rightValue = right.eval(context);
            if (leftValue instanceof Number && rightValue instanceof Number) {
                double l = NumberUtil.toDouble((Object)leftValue);
                double r = NumberUtil.toDouble((Object)rightValue);
                return NumberUtil.parseNumber((double)NumberUtil.toDouble((Number)BigDecimal.valueOf(l).subtract(BigDecimal.valueOf(r))));
            }
            throw new EvalException(ResManager.loadKDString((String)"\u6267\u884c\u51cf\u6cd5\u51fa\u9519\uff0c\u53c2\u6570\u5fc5\u987b\u662f\u6570\u503c\u578b", (String)"Sub_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
        if (children.size() == 1) {
            FelNode right = (FelNode)children.get(0);
            Object rightValue = right.eval(context);
            if (rightValue instanceof Number) {
                if (NumberUtil.isFloatingPoint((Object)rightValue)) {
                    return NumberUtil.toDouble((Object)rightValue) * -1.0;
                }
                return NumberUtil.parseNumber((long)(((Number)rightValue).longValue() * -1L));
            }
            throw new EvalException(ResManager.loadKDString((String)"\u6267\u884c\u51cf\u6cd5\u51fa\u9519\uff0c\u53c2\u6570\u5fc5\u987b\u662f\u6570\u503c\u578b", (String)"Sub_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
        }
        throw new EvalException(ResManager.loadKDString((String)"\u6267\u884c\u51cf\u6cd5\u51fa\u9519\uff0c\u53c2\u6570\u957f\u5ea6\u5fc5\u987b\u662f1\u62162", (String)"Sub_2", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
    }

    public static void main(String[] args) {
        int a = -1;
        System.out.println(a);
    }
}

