/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.formula.fel.function.operator.big;

import com.greenpineyu.fel.common.NumberUtil;
import com.greenpineyu.fel.common.ObjectUtils;
import com.greenpineyu.fel.compile.InterpreterSourceBuilder;
import com.greenpineyu.fel.compile.SourceBuilder;
import com.greenpineyu.fel.context.FelContext;
import com.greenpineyu.fel.function.StableFunction;
import com.greenpineyu.fel.function.TolerantFunction;
import com.greenpineyu.fel.parser.FelNode;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;

public class BigAdd
extends StableFunction {
    public Object call(FelNode node, FelContext context) {
        List children = node.getChildren();
        if (children == null || children.isEmpty()) {
            return null;
        }
        Object left = TolerantFunction.eval((FelContext)context, children.get(0));
        if (children.size() == 1) {
            return left;
        }
        Object right = TolerantFunction.eval((FelContext)context, children.get(1));
        if (left instanceof String || right instanceof String) {
            return ObjectUtils.toString((Object)left).concat(ObjectUtils.toString((Object)right));
        }
        try {
            if (BigAdd.hasFloat(left, right)) {
                BigDecimal l = NumberUtil.toBigDecimal((Object)left);
                BigDecimal r = NumberUtil.toBigDecimal((Object)right);
                return l.add(r);
            }
            if (BigAdd.isInt(left, right)) {
                BigInteger l = NumberUtil.toBigInteger((Object)left);
                BigInteger r = NumberUtil.toBigInteger((Object)right);
                return l.add(r);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return ObjectUtils.toString((Object)left).concat(ObjectUtils.toString((Object)right));
    }

    public static boolean isInt(Object left, Object right) {
        return BigAdd.isInt(left) && BigAdd.isInt(right);
    }

    public static boolean hasFloat(Object left, Object right) {
        return BigAdd.isFloat(left) || BigAdd.isFloat(right);
    }

    public String getName() {
        return "+";
    }

    public static boolean isFloat(Object o) {
        return NumberUtil.isFloatingPoint((Object)o) || o instanceof BigDecimal;
    }

    public static boolean isInt(Object o) {
        return NumberUtil.isNumberable((Object)o) || o instanceof BigInteger;
    }

    public SourceBuilder toMethod(FelNode node, FelContext ctx) {
        return InterpreterSourceBuilder.getInstance();
    }

    public static void main(String[] args) {
    }
}

