/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.formula.optimize;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLExprImpl;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLInListExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableSourceImpl;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlASTVisitor;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlASTVisitorAdapter;
import com.alibaba.druid.sql.parser.SQLParserUtils;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.alibaba.druid.util.JdbcConstants;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.refactor.formula.optimize.OptimizeTypeEnum;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class MsqlOptimizer {
    private static Log logger = LogFactory.getLog(MsqlOptimizer.class);
    private String originalSql;
    private String reusltSql;
    private SQLSelectQueryBlock queryBlock;

    public MsqlOptimizer(String originalSql) {
        this.originalSql = originalSql;
        this.reusltSql = originalSql;
    }

    private SQLSelectQueryBlock parseSql() {
        SQLStatementParser mysql = SQLParserUtils.createSQLStatementParser((String)this.originalSql, (DbType)JdbcConstants.MYSQL);
        SQLStatement sqlStatement = mysql.parseSelect();
        SQLSelectStatement sqlSelectStatement = (SQLSelectStatement)sqlStatement;
        this.queryBlock = sqlSelectStatement.getSelect().getQueryBlock();
        return this.queryBlock;
    }

    public String getReusltSql() {
        return this.reusltSql;
    }

    public MsqlOptimizer doOptimize() {
        this.parseSql();
        OptimizeItemCollectVisitor optimizerVisitor = new OptimizeItemCollectVisitor();
        this.queryBlock.getFrom().accept((SQLASTVisitor)optimizerVisitor);
        if (optimizerVisitor.getOptimizeItems().size() > 0) {
            for (OptimizeItem optimizeItem : optimizerVisitor.getOptimizeItems()) {
                if (OptimizeTypeEnum.SingleTable != optimizeItem.getOptimizeTypeEnum()) continue;
                this.optimizeSingleTable(optimizeItem);
            }
        }
        this.reusltSql = SQLUtils.toMySqlString((SQLObject)this.queryBlock);
        return this;
    }

    private void replaceTargetTable(OptimizeItem optimizeItem) {
        SQLExprTableSource targetTable;
        SQLObject parent;
        SQLTableSourceImpl targetTableReplacement = optimizeItem.getTargetTableReplacement();
        if (targetTableReplacement != null && (parent = (targetTable = optimizeItem.getTargetTable()).getParent()) instanceof SQLJoinTableSource) {
            ((SQLJoinTableSource)parent).replace((SQLTableSource)targetTable, (SQLTableSource)targetTableReplacement);
        }
    }

    private SQLSubqueryTableSource buildTargetTableReplacement(OptimizeItem optimizeItem) {
        SQLExprTableSource targetTable = optimizeItem.getTargetTable();
        SQLSubqueryTableSource replacementTableSource = new SQLSubqueryTableSource();
        replacementTableSource.setAlias(targetTable.getAlias());
        SQLSelect sqlSelect = new SQLSelect();
        sqlSelect.setParent((SQLObject)replacementTableSource);
        replacementTableSource.setSelect(sqlSelect);
        MySqlSelectQueryBlock mySqlSelectQueryBlock = new MySqlSelectQueryBlock();
        mySqlSelectQueryBlock.setParent((SQLObject)sqlSelect);
        sqlSelect.setQuery((SQLSelectQuery)mySqlSelectQueryBlock);
        SQLExprTableSource tableSource = targetTable.clone();
        tableSource.setAlias(null);
        mySqlSelectQueryBlock.setFrom((SQLTableSource)tableSource);
        List selectList = mySqlSelectQueryBlock.getSelectList();
        HashSet<String> set = new HashSet<String>();
        for (SQLPropertyExpr column : optimizeItem.getNeedfulColumn()) {
            if (column.getOwnerName().contains(".")) {
                SQLPropertyExpr clone = column.clone();
                SQLPropertyExpr propertyExprRoot = MsqlOptimizer.getPropertyExprRoot(clone);
                propertyExprRoot.setOwner((String)null);
                SQLUtils.toMySqlExpr((String)clone.toString());
                if (set.contains(clone.toString())) continue;
                SQLSelectItem sqlSelectItem = new SQLSelectItem();
                sqlSelectItem.setExpr(SQLUtils.toMySqlExpr((String)clone.toString()));
                selectList.add(sqlSelectItem);
                set.add(column.toString());
                continue;
            }
            if (set.contains(column.getName())) continue;
            SQLSelectItem sqlSelectItem = new SQLSelectItem();
            sqlSelectItem.setExpr((SQLExpr)new SQLIdentifierExpr(column.getName()));
            selectList.add(sqlSelectItem);
            set.add(column.getName());
        }
        SQLExprImpl where = null;
        for (SQLExprImpl sqlExpr : optimizeItem.getNeedfulWhere()) {
            SQLExprImpl clone = this.removePropertyExprAlias(sqlExpr, targetTable.getAlias());
            if (clone == null) continue;
            if (where != null) {
                SQLBinaryOpExpr parent = new SQLBinaryOpExpr();
                parent.setOperator(SQLBinaryOperator.BooleanAnd);
                parent.setLeft((SQLExpr)where);
                parent.setRight((SQLExpr)clone);
                parent.setDbType(DbType.mysql);
                where.setParent((SQLObject)parent);
                clone.setParent((SQLObject)parent);
                where = parent;
                continue;
            }
            where = clone;
        }
        if (where != null) {
            where.setParent((SQLObject)mySqlSelectQueryBlock);
            mySqlSelectQueryBlock.setWhere(where);
        }
        optimizeItem.setTargetTableReplacement((SQLTableSourceImpl)replacementTableSource);
        return replacementTableSource;
    }

    private SQLExprImpl removePropertyExprAlias(SQLExprImpl expr, String alias) {
        if (expr instanceof SQLBinaryOpExpr) {
            SQLBinaryOpExpr clone = ((SQLBinaryOpExpr)expr).clone();
            if (clone.getLeft() instanceof SQLPropertyExpr) {
                SQLIdentifierExpr sqlExpr;
                SQLPropertyExpr left = (SQLPropertyExpr)clone.getLeft();
                if (left.getOwnerName().contains(".")) {
                    SQLPropertyExpr propertyExprRoot = MsqlOptimizer.getPropertyExprRoot(left);
                    propertyExprRoot.setOwner((String)null);
                    sqlExpr = SQLUtils.toMySqlExpr((String)left.toString());
                } else {
                    sqlExpr = new SQLIdentifierExpr(left.getName());
                }
                sqlExpr.setParent((SQLObject)clone);
                clone.setLeft((SQLExpr)sqlExpr);
            } else if (clone.getRight() instanceof SQLPropertyExpr) {
                SQLIdentifierExpr sqlExpr;
                SQLPropertyExpr right = (SQLPropertyExpr)clone.getRight();
                if (right.getOwnerName().contains(".")) {
                    SQLPropertyExpr propertyExprRoot = MsqlOptimizer.getPropertyExprRoot(right);
                    propertyExprRoot.setOwner((String)null);
                    sqlExpr = SQLUtils.toMySqlExpr((String)right.toString());
                } else {
                    sqlExpr = new SQLIdentifierExpr(right.getName());
                }
                sqlExpr.setParent((SQLObject)clone);
                clone.setLeft((SQLExpr)sqlExpr);
            } else {
                String s = SQLUtils.toMySqlString((SQLObject)clone).replace(alias + ".", "");
                SQLExpr result = SQLUtils.toSQLExpr((String)s, (DbType)DbType.mysql);
                return (SQLExprImpl)result;
            }
            return clone;
        }
        if (expr instanceof SQLInListExpr) {
            SQLInListExpr clone = ((SQLInListExpr)expr).clone();
            SQLExpr conditionExpr = clone.getExpr();
            String s = SQLUtils.toMySqlString((SQLObject)conditionExpr).replace(alias + ".", "");
            SQLExpr sqlIdentifierExpr = SQLUtils.toSQLExpr((String)s, (DbType)DbType.mysql);
            sqlIdentifierExpr.setParent((SQLObject)clone);
            clone.setExpr(sqlIdentifierExpr);
            return clone;
        }
        return null;
    }

    private void optimizeSingleTable(OptimizeItem optimizeItem) {
        SQLSelectQueryBlock tableParentSelect = optimizeItem.getTargetTableParentSelect();
        SQLExprTableSource targetTable = optimizeItem.targetTable;
        final String alias = StringUtil.isNotEmpty((CharSequence)targetTable.getAlias()) ? targetTable.getAlias() : targetTable.getTableName();
        final ArrayList<SQLPropertyExpr> needfulColumn = new ArrayList<SQLPropertyExpr>();
        tableParentSelect.accept((SQLASTVisitor)new MySqlASTVisitor(){

            public boolean visit(SQLPropertyExpr x) {
                SQLPropertyExpr propertyExprRoot = MsqlOptimizer.getPropertyExprRoot(x);
                if (StringUtil.equals((CharSequence)propertyExprRoot.getOwnerName(), (CharSequence)alias)) {
                    needfulColumn.add(x);
                }
                return false;
            }
        });
        boolean dealWhere = optimizeItem.isDealWhere();
        final ArrayList<SQLExprImpl> needfulWhere = new ArrayList<SQLExprImpl>();
        if (dealWhere) {
            tableParentSelect.getWhere().accept((SQLASTVisitor)new MySqlASTVisitor(){

                public boolean isBracket(SQLBinaryOpExpr x) {
                    Method isBracket = null;
                    if ((isBracket = this.getMethodByName(isBracket, "isParenthesized")) == null) {
                        isBracket = this.getMethodByName(isBracket, "isBracket");
                    }
                    if (isBracket != null) {
                        try {
                            return (Boolean)isBracket.invoke((Object)x, new Object[0]);
                        }
                        catch (IllegalAccessException | InvocationTargetException e) {
                            logger.error("\u5224\u65ad\u662f\u5426\u62ec\u53f7\u5931\u8d25:" + e.getMessage());
                        }
                    }
                    return false;
                }

                private Method getMethodByName(Method isBracket, String isBracketMethodName) {
                    try {
                        isBracket = SQLBinaryOpExpr.class.getMethod(isBracketMethodName, new Class[0]);
                    }
                    catch (NoSuchMethodException e) {
                        logger.error("\u83b7\u53d6\u662f\u5426\u62ec\u53f7\u65b9\u6cd5\u5931\u8d25:" + e.getMessage());
                    }
                    return isBracket;
                }

                public boolean visit(SQLBinaryOpExpr x) {
                    SQLPropertyExpr right1;
                    SQLPropertyExpr propertyExprRoot;
                    if (x.isBracket()) {
                        HashSet set = MsqlOptimizer.collectPropertyOwner((SQLExpr)x);
                        if (set.size() == 1 && set.contains(alias)) {
                            needfulWhere.add(x);
                            return false;
                        }
                        return true;
                    }
                    boolean left = x.getLeft() instanceof SQLPropertyExpr;
                    boolean right = x.getRight() instanceof SQLPropertyExpr;
                    if (left && !right) {
                        SQLPropertyExpr left1 = (SQLPropertyExpr)x.getLeft();
                        SQLPropertyExpr propertyExprRoot2 = MsqlOptimizer.getPropertyExprRoot(left1);
                        if (StringUtil.equals((CharSequence)propertyExprRoot2.getOwnerName(), (CharSequence)alias)) {
                            needfulWhere.add(x);
                        }
                    } else if (!left && right && StringUtil.equals((CharSequence)(propertyExprRoot = MsqlOptimizer.getPropertyExprRoot(right1 = (SQLPropertyExpr)x.getRight())).getOwnerName(), (CharSequence)alias)) {
                        needfulWhere.add(x);
                    }
                    return true;
                }

                public boolean visit(SQLInListExpr x) {
                    SQLExpr expr = x.getExpr();
                    HashSet set = MsqlOptimizer.collectPropertyOwner(expr);
                    if (set.size() == 1 && Objects.equals(set.toArray()[0], alias)) {
                        needfulWhere.add(x);
                    }
                    return false;
                }
            });
        }
        if (needfulWhere.size() == 0) {
            SQLExpr defaultWhere = SQLUtils.toSQLExpr((String)"id is not null", (DbType)DbType.mysql);
            needfulWhere.add((SQLExprImpl)((SQLBinaryOpExpr)defaultWhere));
        }
        optimizeItem.setNeedfulColumn(needfulColumn);
        optimizeItem.setNeedfulWhere(needfulWhere);
        this.buildTargetTableReplacement(optimizeItem);
        this.replaceTargetTable(optimizeItem);
    }

    private static HashSet<String> collectPropertyOwner(SQLExpr expr) {
        final HashSet<String> set = new HashSet<String>();
        expr.accept(new SQLASTVisitor(){

            public boolean visit(SQLPropertyExpr x) {
                set.add(x.getOwnerName());
                return false;
            }
        });
        return set;
    }

    private static SQLPropertyExpr getPropertyExprRoot(SQLPropertyExpr expr) {
        SQLPropertyExpr propertyExpr = expr;
        while (propertyExpr.getOwner() instanceof SQLPropertyExpr) {
            propertyExpr = (SQLPropertyExpr)propertyExpr.getOwner();
        }
        return propertyExpr;
    }

    static class OptimizeItem {
        private OptimizeTypeEnum optimizeTypeEnum = OptimizeTypeEnum.SingleTable;
        private SQLExprTableSource targetTable;
        private SQLTableSourceImpl targetTableReplacement;
        private SQLSelectQueryBlock targetTableParentSelect;
        private boolean dealWhere = true;
        List<SQLExprImpl> needfulWhere = new ArrayList<SQLExprImpl>();
        List<SQLPropertyExpr> needfulColumn = new ArrayList<SQLPropertyExpr>();

        public OptimizeItem(SQLExprTableSource targetTable, SQLSelectQueryBlock targetTableParentSelect) {
            this.targetTable = targetTable;
            this.targetTableParentSelect = targetTableParentSelect;
        }

        public SQLTableSourceImpl getTargetTableReplacement() {
            return this.targetTableReplacement;
        }

        public void setTargetTableReplacement(SQLTableSourceImpl targetTableReplacement) {
            this.targetTableReplacement = targetTableReplacement;
        }

        public OptimizeTypeEnum getOptimizeTypeEnum() {
            return this.optimizeTypeEnum;
        }

        public List<SQLExprImpl> getNeedfulWhere() {
            return this.needfulWhere;
        }

        public void setNeedfulWhere(List<SQLExprImpl> needfulWhere) {
            this.needfulWhere = needfulWhere;
        }

        public List<SQLPropertyExpr> getNeedfulColumn() {
            return this.needfulColumn;
        }

        public void setNeedfulColumn(List<SQLPropertyExpr> needfulColumn) {
            this.needfulColumn = needfulColumn;
        }

        public void setOptimizeTypeEnum(OptimizeTypeEnum optimizeTypeEnum) {
            this.optimizeTypeEnum = optimizeTypeEnum;
        }

        public SQLExprTableSource getTargetTable() {
            return this.targetTable;
        }

        public void setTargetTable(SQLExprTableSource targetTable) {
            this.targetTable = targetTable;
        }

        public SQLSelectQueryBlock getTargetTableParentSelect() {
            return this.targetTableParentSelect;
        }

        public void setTargetTableParentSelect(SQLSelectQueryBlock targetTableParentSelect) {
            this.targetTableParentSelect = targetTableParentSelect;
        }

        public boolean isDealWhere() {
            return this.dealWhere;
        }

        public void setDealWhere(boolean dealWhere) {
            this.dealWhere = dealWhere;
        }
    }

    static class OptimizeItemCollectVisitor
    extends MySqlASTVisitorAdapter {
        private List<OptimizeItem> OptimizeItems = new ArrayList<OptimizeItem>();

        OptimizeItemCollectVisitor() {
        }

        public List<OptimizeItem> getOptimizeItems() {
            return this.OptimizeItems;
        }

        public boolean visit(SQLExprTableSource x) {
            SQLObject parentSelect;
            boolean hasSingleTable;
            boolean bl = hasSingleTable = !(x.getParent() instanceof SQLSelectQueryBlock);
            if (hasSingleTable && (parentSelect = this.findParentSelect((SQLObject)x)) instanceof SQLSelectQueryBlock) {
                SQLSelectQueryBlock parentSelectBlock = (SQLSelectQueryBlock)parentSelect;
                final OptimizeItem optimizeItem = new OptimizeItem(x, parentSelectBlock);
                SQLExpr where = parentSelectBlock.getWhere();
                if (where != null) {
                    where.accept((SQLASTVisitor)new MySqlASTVisitorAdapter(){

                        public boolean visit(SQLBinaryOpExpr x) {
                            boolean hasMultiTableOr = false;
                            if (SQLBinaryOperator.BooleanOr.equals((Object)x.getOperator())) {
                                HashSet ownerNames = MsqlOptimizer.collectPropertyOwner((SQLExpr)x);
                                boolean bl = hasMultiTableOr = ownerNames.size() > 1;
                            }
                            if (hasMultiTableOr) {
                                optimizeItem.setDealWhere(!hasMultiTableOr);
                                return false;
                            }
                            return true;
                        }
                    });
                } else {
                    optimizeItem.setDealWhere(false);
                }
                this.OptimizeItems.add(optimizeItem);
            }
            return false;
        }

        private SQLObject findParentSelect(SQLObject x) {
            SQLObject y = x;
            while (y.getParent() != null && !(y.getParent() instanceof SQLSelectQueryBlock)) {
                y = y.getParent();
            }
            return y.getParent();
        }
    }
}

