/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.formula.parse;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLExprImpl;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLInListExpr;
import com.alibaba.druid.sql.ast.expr.SQLInSubQueryExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.parser.SQLParserUtils;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.alibaba.druid.util.JdbcConstants;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.taxc.bdtaxr.common.refactor.formula.service.MsqlQueryService;
import kd.taxc.bdtaxr.common.refactor.formula.service.SqlDataSet;
import kd.taxc.bdtaxr.common.refactor.formula.utils.MsqlQueryUtil;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class MetaDataSqlParser {
    private int level;
    private String sql;
    private List<SQLSelectItem> selectList;
    private SQLTableSource from;
    private SQLExpr where;
    private HashMap<String, SqlDataSet> dataSetAliasHashMap;
    private List<String> logs;

    public MetaDataSqlParser(String sql, int level) {
        this.sql = sql;
        this.level = level;
        this.logs = new ArrayList<String>(32);
    }

    public static void main(String[] args) {
        String sql11 = ResManager.loadKDString((String)"select sum(s.taxamount + s.accountingamount) from (select t1.taxamount,t1.accountingamount,t1.serialno,t1.businesstype from tcvat_account_summary t1 where TAXMETHOD in('\u4e00\u822c\u8ba1\u7a0e') and ORG = '100000' and jzjt = '0') s left join (select t3.id,t3.mergecode from tpo_tcvat_taxrateentry t3 where (t3.mergecode like '2%' or t3.mergecode like '1%')) t on s.businesstype = t.id left join tcvat_accdetail_income c on s.serialno = c.taxaccountserialno", (String)"MetaDataSqlParser_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
        MetaDataSqlParser metaDataSqlParser = new MetaDataSqlParser(sql11, 0);
        metaDataSqlParser.parse(true);
    }

    private SQLSelectQueryBlock parseSql(String sql) {
        SQLStatementParser mysql = SQLParserUtils.createSQLStatementParser((String)sql, (DbType)JdbcConstants.MYSQL);
        SQLStatement sqlStatement = mysql.parseSelect();
        SQLSelectStatement sqlSelectStatement = (SQLSelectStatement)sqlStatement;
        return sqlSelectStatement.getSelect().getQueryBlock();
    }

    public MetaDataSqlParser parse(boolean dealInSubQuery) {
        SQLSelectQueryBlock queryBlock = this.parseSql(this.sql);
        this.selectList = queryBlock.getSelectList();
        this.from = queryBlock.getFrom();
        this.where = queryBlock.getWhere();
        MsqlQueryUtil.checkFrom(this.from);
        if (this.level == 0) {
            ArrayList<SQLObject> sqlObjects = new ArrayList<SQLObject>(32);
            sqlObjects.addAll(this.selectList);
            sqlObjects.add((SQLObject)this.from);
            sqlObjects.add((SQLObject)this.where);
            this.aliasToLower(sqlObjects);
        }
        if (dealInSubQuery) {
            SQLExprImpl inListExpr = this.replaceWhereSubQuery(this.where);
            if (inListExpr != null) {
                this.where = inListExpr;
                inListExpr.setParent((SQLObject)queryBlock);
            }
            this.sql = SQLUtils.toMySqlString((SQLObject)queryBlock);
        }
        this.dataSetAliasHashMap = new LinkedHashMap<String, SqlDataSet>(8);
        this.parseTables(this.from, this.dataSetAliasHashMap, this.level + 1);
        return this;
    }

    private void aliasToLower(List<SQLObject> sqlObjects) {
        for (SQLObject sqlObject : sqlObjects) {
            SQLExpr right;
            SQLExpr left;
            if (sqlObject instanceof SQLSelectItem) {
                this.aliasToLower(Collections.singletonList(((SQLSelectItem)sqlObject).getExpr()));
            } else if (sqlObject instanceof SQLBinaryOpExpr) {
                left = ((SQLBinaryOpExpr)sqlObject).getLeft();
                right = ((SQLBinaryOpExpr)sqlObject).getRight();
                this.aliasToLower(Arrays.asList(left, right));
            } else if (sqlObject instanceof SQLJoinTableSource) {
                left = ((SQLJoinTableSource)sqlObject).getLeft();
                right = ((SQLJoinTableSource)sqlObject).getRight();
                SQLExpr condition = ((SQLJoinTableSource)sqlObject).getCondition();
                this.aliasToLower(Arrays.asList(left, right, condition));
            } else if (sqlObject instanceof SQLInSubQueryExpr) {
                this.aliasToLower(Collections.singletonList(((SQLInSubQueryExpr)sqlObject).getExpr()));
            } else if (sqlObject instanceof SQLInListExpr) {
                this.aliasToLower(Collections.singletonList(((SQLInListExpr)sqlObject).getExpr()));
            } else if (sqlObject instanceof SQLAggregateExpr) {
                List<SQLObject> arguments = ((SQLAggregateExpr)sqlObject).getArguments().stream().map(a -> a).collect(Collectors.toList());
                this.aliasToLower(arguments);
            } else if (sqlObject instanceof SQLSubqueryTableSource) {
                SQLSelectQueryBlock queryBlock = ((SQLSubqueryTableSource)sqlObject).getSelect().getQueryBlock();
                ArrayList<SQLObject> objects = new ArrayList<SQLObject>(32);
                objects.addAll(queryBlock.getSelectList());
                objects.add((SQLObject)queryBlock.getFrom());
                objects.add((SQLObject)queryBlock.getWhere());
                this.aliasToLower(objects);
            } else if (sqlObject instanceof SQLPropertyExpr) {
                ((SQLPropertyExpr)sqlObject).setOwner(this.toLower(((SQLPropertyExpr)sqlObject).getOwnernName()));
                ((SQLPropertyExpr)sqlObject).setName(this.toLower(((SQLPropertyExpr)sqlObject).getName()));
            }
            if (!(sqlObject instanceof SQLTableSource)) continue;
            ((SQLTableSource)sqlObject).setAlias(this.toLower(((SQLTableSource)sqlObject).getAlias()));
        }
    }

    private String toLower(String alias) {
        if (StringUtil.isNotEmpty((CharSequence)alias)) {
            return alias.toLowerCase();
        }
        return null;
    }

    private SQLExprImpl replaceWhereSubQuery(SQLExpr where) {
        if (where instanceof SQLInSubQueryExpr) {
            SQLInSubQueryExpr subQueryExpr = (SQLInSubQueryExpr)where;
            ArrayList<SQLExpr> list = this.getSubQueryList(subQueryExpr.getSubQuery());
            SQLObject parent = where.getParent();
            boolean not = subQueryExpr.isNot();
            if (list.size() == 0) {
                if (not) {
                    return (SQLExprImpl)SQLUtils.toSQLExpr((String)"1 = 1");
                }
                return (SQLExprImpl)SQLUtils.toSQLExpr((String)"1 != 1");
            }
            SQLInListExpr sqlInListExpr = new SQLInListExpr();
            sqlInListExpr.setExpr(subQueryExpr.getExpr());
            sqlInListExpr.setTargetList(list);
            sqlInListExpr.setParent(parent);
            sqlInListExpr.setNot(not);
            return sqlInListExpr;
        }
        if (where instanceof SQLBinaryOpExpr) {
            SQLExprImpl inListExprRight;
            SQLBinaryOpExpr opExpr = (SQLBinaryOpExpr)where;
            SQLExpr left = opExpr.getLeft();
            SQLExpr right = opExpr.getRight();
            if (left instanceof SQLQueryExpr || right instanceof SQLQueryExpr) {
                ArrayList<SQLExpr> exprArrayList;
                SQLSelect subQuery;
                boolean noValue = false;
                if (left instanceof SQLQueryExpr) {
                    subQuery = ((SQLQueryExpr)left).getSubQuery();
                    exprArrayList = this.getSubQueryList(subQuery);
                    if (exprArrayList.size() > 1) {
                        throw new KDBizException("Single value required, multiple actual!" + opExpr);
                    }
                    if (exprArrayList.size() == 1) {
                        opExpr.setLeft(exprArrayList.get(0));
                    } else {
                        noValue = true;
                    }
                }
                if (right instanceof SQLQueryExpr && !noValue) {
                    subQuery = ((SQLQueryExpr)right).getSubQuery();
                    exprArrayList = this.getSubQueryList(subQuery);
                    if (exprArrayList.size() > 1) {
                        throw new KDBizException("Single value required, multiple actual!" + opExpr);
                    }
                    if (exprArrayList.size() == 1) {
                        opExpr.setRight(exprArrayList.get(0));
                    } else {
                        noValue = true;
                    }
                }
                return noValue ? (SQLExprImpl)SQLUtils.toSQLExpr((String)"1 != 1") : opExpr;
            }
            SQLExprImpl inListExprLeft = this.replaceWhereSubQuery(left);
            if (inListExprLeft != null) {
                opExpr.setLeft((SQLExpr)inListExprLeft);
                inListExprLeft.setParent((SQLObject)opExpr);
            }
            if ((inListExprRight = this.replaceWhereSubQuery(right)) != null) {
                opExpr.setRight((SQLExpr)inListExprRight);
                inListExprRight.setParent((SQLObject)opExpr);
            }
        }
        return (SQLExprImpl)where;
    }

    private ArrayList<SQLExpr> getSubQueryList(SQLSelect subQuery) {
        ArrayList<SQLExpr> list = new ArrayList<SQLExpr>();
        String inSql = subQuery.toString();
        List<Object> query = new MsqlQueryService().queryLowerSql(inSql, this.logs, false);
        List collect = query.stream().filter(a -> a != null).map(a -> MsqlQueryUtil.objectToString(a)).collect(Collectors.toList());
        if (EmptyCheckUtils.isNotEmpty(query) && query.get(0) instanceof Map) {
            Map map = (Map)query.get(0);
            ArrayList keys = new ArrayList();
            keys.addAll(map.keySet());
            String key = (String)keys.get(0);
            collect = query.stream().map(v -> (Map)v).map(a -> MsqlQueryUtil.objectToString(a.get(key))).collect(Collectors.toList());
        }
        for (String s : collect) {
            list.add((SQLExpr)new SQLCharExpr(s));
        }
        return list;
    }

    private void parseTables(SQLTableSource from, HashMap<String, SqlDataSet> tableAliasHashMap, int level) {
        if (from instanceof SQLJoinTableSource) {
            SQLJoinTableSource sqlJoinTableSource = (SQLJoinTableSource)from;
            SQLTableSource left = sqlJoinTableSource.getLeft();
            SQLTableSource right = sqlJoinTableSource.getRight();
            if (left instanceof SQLJoinTableSource) {
                this.parseTables(left, tableAliasHashMap, level + 1);
            } else {
                this.putSqlTable(left, tableAliasHashMap, level);
            }
            if (right instanceof SQLJoinTableSource) {
                this.parseTables(right, tableAliasHashMap, level + 1);
            } else {
                this.putSqlTable(right, tableAliasHashMap, level);
            }
        } else if (from instanceof SQLExprTableSource || from instanceof SQLSubqueryTableSource) {
            if (level == 1 && from instanceof SQLExprTableSource || from instanceof SQLExprTableSource && from.getParent() instanceof SQLSelectQueryBlock) {
                return;
            }
            this.putSqlTable(from, tableAliasHashMap, level);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void putSqlTable(SQLTableSource exprTableSource, HashMap<String, SqlDataSet> tableAliasHashMap, int level) {
        String alias = exprTableSource.getAlias();
        if (StringUtil.isEmpty((CharSequence)alias)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bed\u6cd5\u9519\u8bef, \u7f3a\u5931\u522b\u540d, \u5b50\u67e5\u8be2\uff1a%s", (String)"MetaDataSqlParser_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), exprTableSource.toString()));
        }
        if (exprTableSource instanceof SQLSubqueryTableSource) {
            SQLSubqueryTableSource subquery = (SQLSubqueryTableSource)exprTableSource;
            String simpleName = exprTableSource.toString();
            SqlDataSet sqlDataSet = tableAliasHashMap.get(alias);
            if (sqlDataSet != null) throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bed\u6cd5\u9519\u8bef, \u91cd\u590d\u522b\u540d, \u5b50\u67e5\u8be2\uff1a%s", (String)"MetaDataSqlParser_2", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), subquery));
            sqlDataSet = new SqlDataSet(alias, simpleName, exprTableSource);
            MetaDataSqlParser metaDataSqlParser = new MetaDataSqlParser(subquery.toString(), level).parse(true);
            sqlDataSet.setLevel(level);
            sqlDataSet.setWhere(metaDataSqlParser.getWhere());
            sqlDataSet.setFrom(metaDataSqlParser.getFrom());
            sqlDataSet.setSelectItems(metaDataSqlParser.getSelectList());
            sqlDataSet.setDataSetAliasHashMap(metaDataSqlParser.getDataSetAliasHashMap());
            tableAliasHashMap.put(alias, sqlDataSet);
            return;
        } else {
            if (!(exprTableSource instanceof SQLExprTableSource)) return;
            SQLExprTableSource sqlExprTableSource = (SQLExprTableSource)exprTableSource;
            String simpleName = sqlExprTableSource.getName().getSimpleName();
            SqlDataSet sqlDataSet = tableAliasHashMap.get(alias);
            if (sqlDataSet != null) throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bed\u6cd5\u9519\u8bef, \u91cd\u590d\u522b\u540d, \u8868\uff1a%s", (String)"MetaDataSqlParser_3", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), sqlExprTableSource));
            sqlDataSet = new SqlDataSet(alias, simpleName, exprTableSource);
            sqlDataSet.setLevel(level);
            tableAliasHashMap.put(alias, sqlDataSet);
        }
    }

    public String getSql() {
        return this.sql;
    }

    public SQLExpr getWhere() {
        return this.where;
    }

    public SQLTableSource getFrom() {
        return this.from;
    }

    public List<SQLSelectItem> getSelectList() {
        return this.selectList;
    }

    public HashMap<String, SqlDataSet> getDataSetAliasHashMap() {
        return this.dataSetAliasHashMap;
    }

    public List<String> getLogs() {
        return this.logs;
    }
}

