/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.formula.service;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLInListExpr;
import com.alibaba.druid.sql.ast.expr.SQLInSubQueryExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.taxc.bdtaxr.common.refactor.formula.parse.MetaDataSqlParser;
import kd.taxc.bdtaxr.common.refactor.formula.service.SqlDataSet;
import kd.taxc.bdtaxr.common.refactor.formula.utils.MsqlQueryUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class MsqlCheckService {
    private MetaDataSqlParser parser;
    private boolean isSingleTable = false;

    public List<String> check(String sql) {
        ArrayList<String> warnMsgs = new ArrayList<String>(4);
        try {
            this.parser = new MetaDataSqlParser(MsqlQueryUtil.toLowerSql(sql), 0);
            this.parser.parse(false);
            this.isSingleTable = this.parser.getDataSetAliasHashMap().size() == 0 && this.parser.getFrom() instanceof SQLExprTableSource;
            HashMap<String, SqlDataSet> dataSetAliasHashMap = this.parser.getDataSetAliasHashMap();
            if (!this.isSingleTable) {
                this.checkSelect(this.parser, warnMsgs);
                this.checkWhere(this.parser.getWhere(), dataSetAliasHashMap, warnMsgs);
            }
        }
        catch (Throwable e) {
            warnMsgs.add(StringUtil.getStackTraceMessage(e));
        }
        return warnMsgs;
    }

    private void checkSelect(MetaDataSqlParser metaDataSqlParser, List<String> warnMsgs) {
        for (SQLSelectItem sqlSelectItem : metaDataSqlParser.getSelectList()) {
            this.containSqlDataSet(sqlSelectItem.getExpr(), metaDataSqlParser.getDataSetAliasHashMap(), warnMsgs);
        }
    }

    private void checkWhere(SQLExpr where, HashMap<String, SqlDataSet> tableAliasHashMap, List<String> warnMsgs) {
        if (where instanceof SQLBinaryOpExpr) {
            SQLExpr left = ((SQLBinaryOpExpr)where).getLeft();
            SQLExpr right = ((SQLBinaryOpExpr)where).getRight();
            if (left instanceof SQLBinaryOpExpr || left instanceof SQLInListExpr || left instanceof SQLInSubQueryExpr) {
                this.checkWhere(left, tableAliasHashMap, warnMsgs);
            } else if (this.containSqlDataSet(left, tableAliasHashMap, warnMsgs)) {
                this.isTable(left, this.getDataSet(left, tableAliasHashMap), warnMsgs);
            }
            if (right instanceof SQLBinaryOpExpr || right instanceof SQLInListExpr) {
                this.checkWhere(right, tableAliasHashMap, warnMsgs);
            } else if (this.containSqlDataSet(right, tableAliasHashMap, warnMsgs)) {
                this.isTable(right, this.getDataSet(right, tableAliasHashMap), warnMsgs);
            }
        } else if (where instanceof SQLInSubQueryExpr || where instanceof SQLInListExpr) {
            SQLExpr expr;
            SQLExpr sQLExpr = expr = where instanceof SQLInSubQueryExpr ? ((SQLInSubQueryExpr)where).getExpr() : ((SQLInListExpr)where).getExpr();
            if (this.containSqlDataSet(expr, tableAliasHashMap, warnMsgs)) {
                this.isTable(expr, this.getDataSet(expr, tableAliasHashMap), warnMsgs);
            }
        }
    }

    private void isTable(SQLExpr sqlExpr, SqlDataSet dataSet, List<String> warnMsgs) {
        SQLTableSource parentTableSource;
        SQLTableSource sQLTableSource = parentTableSource = null != dataSet ? dataSet.getParentTableSource() : null;
        if (parentTableSource instanceof SQLExprTableSource) {
            warnMsgs.add(String.format(ResManager.loadKDString((String)"\u5f53\u67e5\u8be2\u7684\u8868\u5305\u542b\u8fc7\u6ee4\u6761\u4ef6\u65f6\uff0c\u5f3a\u70c8\u63a8\u8350\u4f7f\u7528\u5b50\u67e5\u8be2\uff0c\u5c06\u8fc7\u6ee4\u6761\u4ef6\u63d0\u524d\u8fc7\u6ee4\u3002 \u8fc7\u6ee4\u6761\u4ef6: %1$s, \u8868: %2$s", (String)"MsqlCheckService_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), SQLUtils.toMySqlString((SQLObject)sqlExpr.getParent()), parentTableSource));
        }
    }

    private SqlDataSet getDataSet(SQLExpr expr, HashMap<String, SqlDataSet> tableAliasHashMap) {
        if (expr instanceof SQLPropertyExpr) {
            String ownernName = ((SQLPropertyExpr)expr).getOwnernName();
            return tableAliasHashMap.get(ownernName);
        }
        return null;
    }

    private boolean containSqlDataSet(SQLExpr expr, HashMap<String, SqlDataSet> tableAliasHashMap, List<String> warnMsgs) {
        if (expr instanceof SQLPropertyExpr) {
            String ownernName = ((SQLPropertyExpr)expr).getOwnernName();
            SqlDataSet sqlDataSet = tableAliasHashMap.get(ownernName);
            if (sqlDataSet == null) {
                warnMsgs.add(String.format(ResManager.loadKDString((String)"\u8bed\u6cd5\u9519\u8bef \uff0c\u522b\u540d[%s]\u4e0d\u5b58\u5728", (String)"MsqlCheckService_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), ownernName));
            }
            return sqlDataSet != null;
        }
        return false;
    }
}

