/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.formula.service;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.refactor.formula.utils.MsqlQueryUtil;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class SqlDataSet {
    private static Log logger = LogFactory.getLog(SqlDataSet.class);
    private String sql;
    private String name;
    private String alias = "";
    private int level;
    private SQLTableSource parentTableSource;
    private List<SQLSelectItem> selectItems = new ArrayList<SQLSelectItem>(16);
    private SQLTableSource from;
    private SQLExpr where;
    private HashMap<String, SqlDataSet> dataSetAliasHashMap;
    private DataSet dataSet;
    private boolean created = false;
    private Map<String, EntityField> fieldMap = new HashMap<String, EntityField>(64);

    public SqlDataSet() {
    }

    public SqlDataSet(String alias, String name, SQLTableSource parentTableSource) {
        this.alias = alias;
        this.name = name;
        this.parentTableSource = parentTableSource;
    }

    public SqlDataSet createDataSet(List<String> logs) {
        if (!this.created) {
            if (this.dataSetAliasHashMap != null) {
                for (SqlDataSet subSqlDataSet : this.dataSetAliasHashMap.values()) {
                    subSqlDataSet.createDataSet(logs);
                }
            }
            if (this.level == 0) {
                logs.add(String.format(ResManager.loadKDString((String)"\u6267\u884c\u6700\u5916\u5c42\u6570\u636e\u96c6\u4f9d\u8d56\u7684\u8fde\u63a5\u6570\u636e\u96c6\uff1a%s ", (String)"SqlDataSet_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), this.sql));
                if (this.from instanceof SQLJoinTableSource) {
                    this.dataSet = this.queryJoinDataSet(this, false);
                } else if (this.from instanceof SQLSubqueryTableSource) {
                    this.dataSet = this.queryRootSubQuery(this);
                } else if (this.from instanceof SQLExprTableSource) {
                    // empty if block
                }
            } else {
                if (StringUtil.isEmpty((CharSequence)this.alias)) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bed\u6cd5\u9519\u8bef, \u7f3a\u5931\u522b\u540d, \u5b50\u67e5\u8be2sql\uff1a%s", (String)"SqlDataSet_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), this.parentTableSource));
                }
                if (this.parentTableSource instanceof SQLSubqueryTableSource) {
                    if (this.from instanceof SQLExprTableSource) {
                        logs.add(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5355\u8868\u5b50\u67e5\u8be2\uff1a%s", (String)"SqlDataSet_2", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), SQLUtils.toMySqlString((SQLObject)this.parentTableSource)));
                        this.dataSet = this.queryTableDataSet(this);
                    } else if (this.from instanceof SQLJoinTableSource) {
                        logs.add(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u591a\u8868\u8fde\u63a5\u5b50\u67e5\u8be2\uff1a%s", (String)"SqlDataSet_3", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), SQLUtils.toMySqlString((SQLObject)this.parentTableSource)));
                        this.dataSet = this.queryJoinDataSet(this, true);
                    } else if (this.from instanceof SQLSubqueryTableSource) {
                        this.dataSet = this.querySubQueryDataSet(this);
                    }
                } else if (this.parentTableSource instanceof SQLExprTableSource) {
                    logs.add(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5355\u8868\u8868\u8fbe\u5f0f\uff1a%s", (String)"SqlDataSet_4", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), SQLUtils.toMySqlString((SQLObject)this.parentTableSource)));
                    throw new KDBizException("No support that full table query without filter and without select item!\n Please use the subquery with filter! " + SQLUtils.toMySqlString((SQLObject)this.from));
                }
            }
            this.created = true;
        }
        return this;
    }

    private DataSet queryRootSubQuery(SqlDataSet cSqlDataSet) {
        SqlDataSet subSqlDataSet = (SqlDataSet)((Map.Entry)cSqlDataSet.getDataSetAliasHashMap().entrySet().stream().findFirst().get()).getValue();
        DataSet dataSet = subSqlDataSet.getDataSet();
        SQLExpr where = cSqlDataSet.getWhere();
        if (where != null) {
            dataSet = MsqlQueryUtil.doWhere(dataSet, SQLUtils.toMySqlString((SQLObject)where), subSqlDataSet.getFieldMap());
        }
        return dataSet;
    }

    private DataSet querySubQueryDataSet(SqlDataSet cSqlDataSet) {
        Map.Entry entry = (Map.Entry)cSqlDataSet.getDataSetAliasHashMap().entrySet().stream().findFirst().get();
        SqlDataSet subSqlDataSet = (SqlDataSet)entry.getValue();
        String parentAlias = cSqlDataSet.getAlias();
        Map<String, EntityField> fieldMap = subSqlDataSet.getFieldMap();
        List<SQLSelectItem> selectItems = cSqlDataSet.getSelectItems();
        for (SQLSelectItem selectItem : selectItems) {
            String key = SQLUtils.toMySqlString((SQLObject)selectItem.getExpr());
            String targetKey = parentAlias + "." + MsqlQueryUtil.getSourcePropertyName(selectItem);
            if (!fieldMap.containsKey(key)) continue;
            cSqlDataSet.getFieldMap().put(targetKey, fieldMap.get(key));
        }
        DataSet dataSet = subSqlDataSet.getDataSet();
        SQLExpr where = cSqlDataSet.getWhere();
        if (where != null) {
            dataSet = MsqlQueryUtil.doWhere(dataSet, SQLUtils.toMySqlString((SQLObject)where), subSqlDataSet.getFieldMap());
        }
        String cDataSetFieldStr = selectItems.stream().map(a -> String.format("%s as %s.%s", SQLUtils.toMySqlString((SQLObject)a), parentAlias, MsqlQueryUtil.getSourcePropertyName(a))).collect(Collectors.joining(","));
        dataSet = dataSet.executeSql("select " + cDataSetFieldStr);
        return dataSet;
    }

    private DataSet queryJoinDataSet(SqlDataSet sqlDataSet, boolean isDealSelectItems) {
        SQLTableSource from = sqlDataSet.getFrom();
        if (from instanceof SQLJoinTableSource && SQLJoinTableSource.JoinType.COMMA == ((SQLJoinTableSource)from).getJoinType()) {
            MsqlQueryUtil.checkFrom(from);
        }
        HashMap<String, SqlDataSet> dataSetAliasHashMap = sqlDataSet.getDataSetAliasHashMap();
        SQLExpr where = sqlDataSet.getWhere();
        String parentAlias = sqlDataSet.getAlias();
        HashMap<String, EntityField> fieldMap = new HashMap<String, EntityField>(16);
        for (Map.Entry<String, SqlDataSet> entry : dataSetAliasHashMap.entrySet()) {
            fieldMap.putAll(entry.getValue().getFieldMap());
        }
        HashMap<String, Object> resultMap = SqlDataSet.recursionJoin(from, dataSetAliasHashMap);
        DataSet dataSet = (DataSet)resultMap.get("dataset");
        if (dataSet != null) {
            if (where != null) {
                dataSet = MsqlQueryUtil.doWhere(dataSet, where.toString(), fieldMap);
            }
            if (isDealSelectItems) {
                ArrayList<String> outFieldList = new ArrayList<String>(8);
                List<SQLSelectItem> selectItems = sqlDataSet.getSelectItems();
                for (SQLSelectItem selectItem : selectItems) {
                    String outStr = selectItem.getExpr().toString();
                    String selectItemAlias = selectItem.getAlias();
                    String propertyName = MsqlQueryUtil.getSourcePropertyName(selectItem);
                    String outFieldName = StringUtil.isNotEmpty((CharSequence)selectItemAlias) ? parentAlias + "." + selectItemAlias : parentAlias + "." + propertyName;
                    if (fieldMap.containsKey(outStr)) {
                        sqlDataSet.getFieldMap().put(outFieldName, (EntityField)fieldMap.get(outStr));
                    }
                    outStr = outStr + " as " + outFieldName;
                    outFieldList.add(outStr);
                }
                String outFields = outFieldList.stream().collect(Collectors.joining(","));
                return dataSet.executeSql("select " + outFields);
            }
            sqlDataSet.getFieldMap().putAll(fieldMap);
            return dataSet;
        }
        return null;
    }

    private static HashMap<String, Object> recursionJoin(SQLTableSource from, Map<String, SqlDataSet> tableAliasHashMap) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        if (from instanceof SQLJoinTableSource) {
            SQLJoinTableSource sqlJoinTableSource = (SQLJoinTableSource)from;
            SQLTableSource left = sqlJoinTableSource.getLeft();
            SQLTableSource right = sqlJoinTableSource.getRight();
            SQLExpr condition = sqlJoinTableSource.getCondition();
            SQLJoinTableSource.JoinType joinType = sqlJoinTableSource.getJoinType();
            DataSet leftSqlTableDataSet = null;
            String leftFields = "";
            String leftAlias = left.getAlias();
            String rightAlias = right.getAlias();
            if (left instanceof SQLJoinTableSource) {
                HashMap<String, Object> resultMap = SqlDataSet.recursionJoin(left, tableAliasHashMap);
                leftSqlTableDataSet = (DataSet)resultMap.get("dataset");
                leftFields = (String)resultMap.get("fields");
            } else if (left instanceof SQLExprTableSource || left instanceof SQLSubqueryTableSource) {
                SqlDataSet leftSqlTable = tableAliasHashMap.get(leftAlias);
                leftSqlTableDataSet = leftSqlTable.getDataSet();
                leftFields = Arrays.stream(leftSqlTableDataSet.getRowMeta().getFields()).map(a -> a.getName()).collect(Collectors.joining(","));
            }
            if ((right instanceof SQLExprTableSource || right instanceof SQLSubqueryTableSource) && leftSqlTableDataSet != null) {
                SqlDataSet rightSqlTable = tableAliasHashMap.get(rightAlias);
                if (condition != null && condition instanceof SQLBinaryOpExpr || joinType == SQLJoinTableSource.JoinType.COMMA) {
                    DataSet rightSqlTableDataSet = rightSqlTable.getDataSet();
                    String rightFields = Arrays.stream(rightSqlTableDataSet.getRowMeta().getFields()).map(a -> a.getName()).collect(Collectors.joining(","));
                    String fields = leftFields;
                    if (StringUtil.isNotEmpty((CharSequence)leftFields)) {
                        fields = leftFields + "," + rightFields;
                    }
                    DataSet finish = null;
                    long t1 = System.currentTimeMillis();
                    if (condition != null) {
                        SQLPropertyExpr leftField = (SQLPropertyExpr)((SQLBinaryOpExpr)condition).getLeft();
                        SQLPropertyExpr rightField = (SQLPropertyExpr)((SQLBinaryOpExpr)condition).getRight();
                        String leftFieldStr = leftField.toString();
                        String rightFieldStr = rightField.toString();
                        if (StringUtil.isNotEmpty((CharSequence)rightAlias) && leftFieldStr.contains(rightAlias + ".")) {
                            String temp = leftFieldStr;
                            leftFieldStr = rightFieldStr;
                            rightFieldStr = temp;
                        }
                        JoinDataSet on = leftSqlTableDataSet.join(rightSqlTableDataSet, MsqlQueryUtil.getJoinType(joinType)).on(leftFieldStr, rightFieldStr);
                        finish = on.select(fields.split(",")).finish();
                    } else if (joinType == SQLJoinTableSource.JoinType.COMMA) {
                        JoinDataSet on = leftSqlTableDataSet.join(rightSqlTableDataSet, MsqlQueryUtil.getJoinType(joinType));
                        finish = on.select(leftFields.split(","), rightFields.split(",")).finish();
                    }
                    long t2 = System.currentTimeMillis();
                    if (t2 - t1 > 500L) {
                        logger.warn("MetadataGetValue.sql.SqlDataSet=\u6570\u636e\u96c6\u8fde\u63a5\u8017\u65f6:{}ms;msql:{}", (Object)(t2 - t1), (Object)SQLUtils.toMySqlString((SQLObject)from));
                    }
                    map.put("dataset", finish);
                    map.put("fields", fields);
                    return map;
                }
            }
        }
        return map;
    }

    @Deprecated
    private DataSet querySimpleDataSet(SqlDataSet sqlDataSet) {
        SQLExprTableSource parentTableSource = (SQLExprTableSource)sqlDataSet.getParentTableSource();
        String entity = parentTableSource.getExpr().toString().toLowerCase();
        Map<String, EntityField> fieldMap = MsqlQueryUtil.getFieldMap(entity);
        String parentPartAlias = sqlDataSet.getAlias();
        String allFieldString = MetadataUtil.getAllSubFieldString(entity);
        String[] split = allFieldString.split(",");
        for (int i = 0; i < split.length; ++i) {
            String key = split[i];
            sqlDataSet.getFieldMap().put(parentPartAlias + "." + key, fieldMap.get(key));
            SQLSelectItem sqlSelectItem = new SQLSelectItem((SQLExpr)new SQLPropertyExpr(parentPartAlias, key));
            sqlDataSet.getSelectItems().add(sqlSelectItem);
        }
        return QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entity, (String)SqlDataSet.wrapAlias(allFieldString, parentPartAlias), (QFilter[])QFilter.isNotNull((String)"id").toArray(), (String)"");
    }

    private static String wrapAlias(String allFieldString, String alias) {
        String[] split = allFieldString.split(",");
        List collect = Arrays.stream(split).map(a -> String.format("%s as %s.%s", a, alias, a)).collect(Collectors.toList());
        return String.join((CharSequence)",", collect);
    }

    private DataSet queryTableDataSet(SqlDataSet sqlDataSet) {
        List<SQLSelectItem> selectList = sqlDataSet.getSelectItems();
        SQLExpr where = sqlDataSet.getWhere();
        SQLExprTableSource from = (SQLExprTableSource)sqlDataSet.getFrom();
        String parentPartAlias = sqlDataSet.getAlias();
        Map<String, EntityField> outFieldMap = sqlDataSet.getFieldMap();
        String formAlias = "";
        if (StringUtil.isNotEmpty((CharSequence)from.getAlias())) {
            formAlias = from.getAlias() + ".";
        }
        String entity = from.getExpr().toString().toLowerCase();
        QFilter of = null;
        Map<String, EntityField> fieldMap = MsqlQueryUtil.getFieldMap(entity);
        if (where != null) {
            String whereStr = SQLUtils.toMySqlString((SQLObject)where).replace("`", "").replace(formAlias, "");
            of = QFilter.of((String)whereStr, (Object[])new Object[0]);
            of = MsqlQueryUtil.formatFieldValue(of, fieldMap);
        } else {
            of = QFilter.isNotNull((String)"id");
        }
        ArrayList<Object> originalFields = new ArrayList(16);
        List<Object> targetFields = new ArrayList(16);
        if (selectList.size() == 1 && "*".equals(SQLUtils.toMySqlString((SQLObject)((SQLObject)selectList.get(0))).replace(formAlias, ""))) {
            originalFields.addAll(fieldMap.keySet());
            targetFields = originalFields.stream().map(a -> String.format("%s as %s.%s", a, parentPartAlias, a)).collect(Collectors.toList());
            fieldMap.forEach((k, v) -> outFieldMap.put(parentPartAlias + "." + k, (EntityField)v));
        } else {
            originalFields = MsqlQueryUtil.getOriginalFields(selectList);
            for (SQLSelectItem sqlSelectItem : selectList) {
                String key;
                SQLExpr expr = sqlSelectItem.getExpr();
                String exprStr = SQLUtils.toMySqlString((SQLObject)expr).replace(formAlias, "");
                String innerFiledAlias = sqlSelectItem.getAlias();
                if (!StringUtil.isNotEmpty((CharSequence)parentPartAlias)) continue;
                String outField = exprStr;
                if (expr instanceof SQLIdentifierExpr || expr instanceof SQLPropertyExpr) {
                    String entityField = SQLUtils.toMySqlString((SQLObject)expr).replace(formAlias, "");
                    String key2 = parentPartAlias + "." + (StringUtil.isNotEmpty((CharSequence)innerFiledAlias) ? innerFiledAlias : entityField);
                    outField = String.format("%s as %s", entityField, key2);
                    outFieldMap.put(key2, fieldMap.get(entityField));
                } else if (expr instanceof SQLMethodInvokeExpr) {
                    if (StringUtil.isNotEmpty((CharSequence)innerFiledAlias)) {
                        key = parentPartAlias + "." + innerFiledAlias;
                        outField = String.format("%s as %s", exprStr, key);
                    }
                    List arguments = ((SQLMethodInvokeExpr)expr).getArguments();
                    for (SQLExpr argument : arguments) {
                        if (argument instanceof SQLIdentifierExpr || argument instanceof SQLPropertyExpr) {
                            String entityField1 = argument.toString().replace(formAlias, "");
                            String key1 = parentPartAlias + "." + entityField1;
                            outFieldMap.put(key1, fieldMap.get(entityField1));
                            continue;
                        }
                        if (!(argument instanceof SQLBinaryOpExpr)) continue;
                        this.collectOutField((SQLBinaryOpExpr)argument, outFieldMap, fieldMap, formAlias, parentPartAlias);
                    }
                } else if (expr instanceof SQLBinaryOpExpr) {
                    if (StringUtil.isNotEmpty((CharSequence)innerFiledAlias)) {
                        key = parentPartAlias + "." + innerFiledAlias;
                        outField = String.format("%s as %s", exprStr, key);
                    }
                    this.collectOutField((SQLBinaryOpExpr)expr, outFieldMap, fieldMap, formAlias, parentPartAlias);
                }
                targetFields.add(outField);
            }
        }
        String fieldStr = originalFields.stream().collect(Collectors.joining(",")).replace(formAlias, "");
        long t1 = System.currentTimeMillis();
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entity, (String)fieldStr, (QFilter[])of.toArray(), null);
        long t2 = System.currentTimeMillis();
        if (t2 - t1 > 500L) {
            String sql = SQLUtils.toMySqlString((SQLObject)from.getParent());
            logger.warn("MetadataGetValue.sql.SqlDataSet=\u6570\u636e\u5e93\u67e5\u8be2\u8017\u65f6:{}ms;entity:{};fields:{};filter:{};msql:{}", new Object[]{t2 - t1, entity, fieldStr, of.toString(), sql});
        }
        String outFieldStr = targetFields.stream().collect(Collectors.joining(","));
        dataSet = dataSet.executeSql("select " + outFieldStr);
        return dataSet;
    }

    private void collectOutField(SQLBinaryOpExpr opExpr, Map<String, EntityField> outFieldMap, Map<String, EntityField> fieldMap, String fromAlias, String parentPartAlias) {
        String key1;
        String entityField1;
        SQLExpr left = opExpr.getLeft();
        SQLExpr right = opExpr.getRight();
        if (left instanceof SQLIdentifierExpr || left instanceof SQLPropertyExpr) {
            entityField1 = left.toString().replace(fromAlias, "");
            key1 = parentPartAlias + "." + entityField1;
            outFieldMap.put(key1, fieldMap.get(entityField1));
        } else if (left instanceof SQLBinaryOpExpr) {
            this.collectOutField((SQLBinaryOpExpr)left, outFieldMap, fieldMap, fromAlias, parentPartAlias);
        }
        if (right instanceof SQLIdentifierExpr || right instanceof SQLPropertyExpr) {
            entityField1 = right.toString().replace(fromAlias, "");
            key1 = parentPartAlias + "." + entityField1;
            outFieldMap.put(key1, fieldMap.get(entityField1));
        } else if (right instanceof SQLBinaryOpExpr) {
            this.collectOutField((SQLBinaryOpExpr)right, outFieldMap, fieldMap, fromAlias, parentPartAlias);
        }
    }

    public String toString() {
        return this.parentTableSource != null ? this.parentTableSource.toString() : null;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<SQLSelectItem> getSelectItems() {
        return this.selectItems;
    }

    public void setSelectItems(List<SQLSelectItem> selectItems) {
        this.selectItems = selectItems;
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public void setDataSet(DataSet dataSet) {
        this.dataSet = dataSet;
    }

    public SQLTableSource getParentTableSource() {
        return this.parentTableSource;
    }

    public void setParentTableSource(SQLTableSource parentTableSource) {
        this.parentTableSource = parentTableSource;
    }

    public Map<String, EntityField> getFieldMap() {
        return this.fieldMap;
    }

    public void setFieldMap(Map<String, EntityField> fieldMap) {
        this.fieldMap = fieldMap;
    }

    public SQLExpr getWhere() {
        return this.where;
    }

    public void setWhere(SQLExpr where) {
        this.where = where;
    }

    public boolean isCreated() {
        return this.created;
    }

    public void setCreated(boolean created) {
        this.created = created;
    }

    public SQLTableSource getFrom() {
        return this.from;
    }

    public void setFrom(SQLTableSource from) {
        this.from = from;
    }

    public HashMap<String, SqlDataSet> getDataSetAliasHashMap() {
        return this.dataSetAliasHashMap;
    }

    public void setDataSetAliasHashMap(HashMap<String, SqlDataSet> dataSetAliasHashMap) {
        this.dataSetAliasHashMap = dataSetAliasHashMap;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }
}

