/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.formula.utils;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLInListExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLJoinTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlASTVisitorAdapter;
import com.alibaba.druid.sql.parser.SQLParserUtils;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.alibaba.druid.util.JdbcConstants;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.datatype.BooleanType;
import kd.bos.algo.datatype.NumericType;
import kd.bos.algo.datatype.StringType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.refactor.formula.cal.FelService;
import kd.taxc.bdtaxr.common.refactor.formula.parse.AliasToLowerVisitor;
import kd.taxc.bdtaxr.common.refactor.formula.service.SqlDataSet;
import kd.taxc.bdtaxr.common.refactor.formula.value.impl.MetadataGetValue;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityInfo;
import kd.taxc.bdtaxr.common.util.number.DataFormatUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class MsqlQueryUtil {
    private static final String DOT = ".";
    private static Log logger = LogFactory.getLog(MsqlQueryUtil.class);
    public static final boolean NO_SUPPORT_SQL = true;
    private static final String TARGETVALUE = "targetvalue";
    private static final String STRING = "'";
    private static HashMap<SQLJoinTableSource.JoinType, JoinType> joinTypeMap = new HashMap(){
        {
            this.put(SQLJoinTableSource.JoinType.INNER_JOIN, JoinType.INNER);
            this.put(SQLJoinTableSource.JoinType.LEFT_OUTER_JOIN, JoinType.LEFT);
            this.put(SQLJoinTableSource.JoinType.RIGHT_OUTER_JOIN, JoinType.RIGHT);
            this.put(SQLJoinTableSource.JoinType.FULL_OUTER_JOIN, JoinType.FULL);
            this.put(SQLJoinTableSource.JoinType.CROSS_JOIN, JoinType.CROSS);
            this.put(SQLJoinTableSource.JoinType.COMMA, JoinType.CROSS);
        }
    };
    private static Set<String> TEXT_TYPE = Sets.newHashSet((Object[])new String[]{"Text", "Combo"});

    private static String convertString(List<Object> queryResult) {
        StringBuilder sb = new StringBuilder();
        if (queryResult != null && queryResult.size() > 0) {
            for (Object o : queryResult) {
                sb.append(',').append(MsqlQueryUtil.wrapObjStr(o));
            }
            return sb.toString().substring(1);
        }
        return sb.toString();
    }

    public static JoinType getJoinType(SQLJoinTableSource.JoinType joinType) {
        return joinTypeMap.getOrDefault(joinType, JoinType.LEFT);
    }

    private static String wrapObjStr(Object o) {
        if (o instanceof String) {
            return STRING + o + STRING;
        }
        if (o instanceof Date) {
            return STRING + DateUtils.format((Date)o) + STRING;
        }
        return o.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Object> querySqlDataSet(SqlDataSet sqlDataSet, boolean isOnlyOne) {
        ArrayList<Object> resultObjs = new ArrayList(4);
        List<SQLSelectItem> selectItems = sqlDataSet.getSelectItems();
        if (sqlDataSet.getDataSetAliasHashMap().size() == 0) {
            resultObjs = MsqlQueryUtil.querySingleParsed(selectItems, sqlDataSet.getFrom(), sqlDataSet.getWhere(), isOnlyOne);
        } else {
            DataSet originalDataSet = sqlDataSet.getDataSet();
            try (DataSet dataSet = null;){
                if (originalDataSet != null) {
                    boolean isFitSingleCol;
                    boolean bl = isFitSingleCol = selectItems.size() == 1 && StringUtil.isEmpty((CharSequence)selectItems.get(0).getAlias());
                    if (isFitSingleCol) {
                        String selectSql = String.format("select %s as %s", selectItems.get(0).getExpr().toString(), TARGETVALUE);
                        dataSet = originalDataSet.executeSql(selectSql);
                    } else {
                        String targetFields = selectItems.stream().map(a -> SQLUtils.toMySqlString((SQLObject)a)).collect(Collectors.joining(","));
                        dataSet = originalDataSet.executeSql(String.format("select %s ", targetFields));
                    }
                    MsqlQueryUtil.getDataSetResult(selectItems, isOnlyOne, resultObjs, dataSet, isFitSingleCol);
                }
            }
        }
        return resultObjs;
    }

    public static void recursionCloseDataSet(SqlDataSet sqlDataSet) {
        if (sqlDataSet != null) {
            if (sqlDataSet.getDataSet() != null) {
                sqlDataSet.getDataSet().close();
            }
            if (sqlDataSet.getDataSetAliasHashMap() != null) {
                for (SqlDataSet value : sqlDataSet.getDataSetAliasHashMap().values()) {
                    MsqlQueryUtil.recursionCloseDataSet(value);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Object> querySingleParsed(List<SQLSelectItem> selectList, SQLTableSource from, SQLExpr where, boolean isOnlyOne) {
        ArrayList<Object> resultObjs = new ArrayList<Object>(4);
        try (DataSet dataSet = null;){
            String entity = SQLUtils.toMySqlString((SQLObject)((SQLExprTableSource)from).getExpr());
            String alias = StringUtil.isNotEmpty((CharSequence)from.getAlias()) ? from.getAlias() + DOT : entity + DOT;
            if (where == null) {
                throw new KDBizException("No support the illegal sql,please add condition to filter data set and use the subquery syntax.");
            }
            String whereStr = SQLUtils.toMySqlString((SQLObject)where).replace("`", "").replace(alias, "");
            Map<String, EntityField> fieldMap = MsqlQueryUtil.getFieldMap(entity);
            QFilter of = QFilter.of((String)whereStr, (Object[])new Object[0]);
            of = MsqlQueryUtil.formatFieldValue(of, fieldMap);
            Set<Object> originalSet = new HashSet(16);
            ArrayList<String> targetList = new ArrayList<String>(16);
            for (SQLSelectItem selectItem : selectList) {
                Set<String> originalFieldStr = MsqlQueryUtil.getOriginalFields(selectItem.getExpr(), from.getAlias() == null ? entity : from.getAlias());
                String targetFieldStr = MsqlQueryUtil.complementField(selectItem, from.getAlias(), entity);
                originalSet.addAll(originalFieldStr);
                targetList.add(targetFieldStr);
            }
            if (StringUtil.isNotEmpty((CharSequence)from.getAlias())) {
                originalSet = originalSet.stream().map(a -> String.format("%s as %s.%s", a, from.getAlias(), a)).collect(Collectors.toSet());
            }
            String originalFields = String.join((CharSequence)",", originalSet);
            String targetFields = String.join((CharSequence)",", targetList);
            long t1 = System.currentTimeMillis();
            dataSet = QueryServiceHelper.queryDataSet((String)MetadataGetValue.class.getName(), (String)entity, (String)originalFields, (QFilter[])of.toArray(), null);
            long t2 = System.currentTimeMillis();
            if (t2 - t1 > 500L) {
                String sql = SQLUtils.toMySqlString((SQLObject)from.getParent());
                logger.warn("MetadataGetValue.sql.MsqlQueryUtil=\u6570\u636e\u5e93\u67e5\u8be2\u8017\u65f6:{}ms;entity:{};fields:{};filter:{};msql:{}", new Object[]{t2 - t1, entity, originalFields, of.toString(), sql});
            }
            boolean isFitSingleCol = selectList.size() == 1 && StringUtil.isEmpty((CharSequence)selectList.get(0).getAlias());
            dataSet = isFitSingleCol ? dataSet.executeSql(String.format("select %s as %s ", targetFields, TARGETVALUE)) : dataSet.executeSql(String.format("select %s ", targetFields));
            MsqlQueryUtil.getDataSetResult(selectList, isOnlyOne, resultObjs, dataSet, isFitSingleCol);
        }
        return resultObjs;
    }

    private static void getDataSetResult(List<SQLSelectItem> selectList, boolean isOnlyOne, List<Object> resultObjs, DataSet dataSet, boolean isFitSingleCol) {
        Field[] field = dataSet.getRowMeta().getFields();
        if (!dataSet.isEmpty()) {
            while (dataSet.hasNext()) {
                Row next = dataSet.next();
                if (isFitSingleCol) {
                    resultObjs.add(MsqlQueryUtil.getFieldValue(field[0], next));
                } else {
                    HashMap<String, Object> result = new HashMap<String, Object>(field.length);
                    for (Field f : field) {
                        result.put(f.getName(), MsqlQueryUtil.getFieldValue(f, next));
                    }
                    resultObjs.add(result);
                }
                if (!isOnlyOne) continue;
            }
        }
        if (resultObjs.size() == 0 && field.length > 0) {
            if (selectList != null && selectList.size() > 1) {
                HashMap map = new HashMap();
                Arrays.stream(field).forEach(b -> map.put(b.getAlias(), MsqlQueryUtil.getDefaultValue(b.getDataType())));
                resultObjs.add(map);
            } else {
                resultObjs.add(MsqlQueryUtil.getDefaultValue(field[0].getDataType()));
            }
        }
    }

    private static Object getFieldValue(Field f, Row next) {
        if (next == null) {
            return MsqlQueryUtil.getDefaultValue(f.getDataType());
        }
        Object val = next.get(f.getName());
        if (val == null) {
            return MsqlQueryUtil.getDefaultValue(f.getDataType());
        }
        return val;
    }

    private static String getDefaultValue(DataType dataType) {
        if (dataType instanceof StringType) {
            return "";
        }
        if (dataType instanceof NumericType) {
            return "0";
        }
        if (dataType instanceof BooleanType) {
            return Boolean.FALSE.toString();
        }
        return null;
    }

    private static String complementField(SQLSelectItem selectItem, final String alias, String entity) {
        if (!StringUtil.isNotEmpty((CharSequence)alias)) {
            return SQLUtils.toMySqlString((SQLObject)selectItem).replace(entity + DOT, "");
        }
        MySqlASTVisitorAdapter adapter = new MySqlASTVisitorAdapter(){

            public boolean visit(SQLIdentifierExpr sqlObject) {
                if (!alias.equals(sqlObject.getName())) {
                    sqlObject.setName(alias + MsqlQueryUtil.DOT + sqlObject.getName());
                }
                return false;
            }
        };
        selectItem.accept((SQLASTVisitor)adapter);
        return SQLUtils.toMySqlString((SQLObject)selectItem);
    }

    public static String removeAlias(String expr, String alias) {
        String[] split = expr.split("\\.");
        if (split.length > 1 && Objects.equals(split[0], alias)) {
            return expr.substring(expr.indexOf(DOT) + 1);
        }
        return expr;
    }

    public static Set<String> getOriginalFields(SQLExpr expr, String formAlias) {
        HashSet<String> set = new HashSet<String>(4);
        MsqlQueryUtil.levelTraverseFind(set, formAlias, expr);
        return set;
    }

    private static Set<String> levelTraverseFind(Set<String> set, String formAlias, SQLExpr expr) {
        LinkedList<SQLExpr> queue = new LinkedList<SQLExpr>();
        queue.add(expr);
        while (!queue.isEmpty()) {
            SQLExpr poll = (SQLExpr)queue.poll();
            if (poll instanceof SQLBinaryOpExpr) {
                SQLBinaryOpExpr pollBinary = (SQLBinaryOpExpr)poll;
                queue.add(pollBinary.getLeft());
                queue.add(pollBinary.getRight());
                continue;
            }
            if (poll instanceof SQLMethodInvokeExpr) {
                List arguments = ((SQLMethodInvokeExpr)poll).getArguments();
                for (SQLExpr argument : arguments) {
                    queue.add(argument);
                }
                continue;
            }
            if (poll instanceof SQLIdentifierExpr) {
                set.add(((SQLIdentifierExpr)poll).getLowerName());
                continue;
            }
            if (!(poll instanceof SQLPropertyExpr)) continue;
            String str = SQLUtils.toMySqlString((SQLObject)poll);
            set.add(MsqlQueryUtil.removeAlias(str, formAlias));
        }
        return set;
    }

    public static ArrayList<String> getOriginalFields(List<SQLSelectItem> selectList) {
        ArrayList<String> originalFields = new ArrayList<String>(16);
        for (SQLSelectItem sqlSelectItem : selectList) {
            MsqlQueryUtil.collectOriginalFields(sqlSelectItem.getExpr(), originalFields);
        }
        return originalFields;
    }

    private static void collectOriginalFields(SQLExpr expr, ArrayList<String> originalFields) {
        if (expr instanceof SQLBinaryOpExpr) {
            SQLExpr left = ((SQLBinaryOpExpr)expr).getLeft();
            SQLExpr right = ((SQLBinaryOpExpr)expr).getRight();
            if (left instanceof SQLBinaryOpExpr) {
                MsqlQueryUtil.collectOriginalFields(left, originalFields);
            } else {
                MsqlQueryUtil.addOriginalFields(left, originalFields);
            }
            if (right instanceof SQLBinaryOpExpr) {
                MsqlQueryUtil.collectOriginalFields(right, originalFields);
            } else {
                MsqlQueryUtil.addOriginalFields(right, originalFields);
            }
        } else {
            MsqlQueryUtil.addOriginalFields(expr, originalFields);
        }
    }

    private static void addOriginalFields(SQLExpr expr, ArrayList<String> originalFields) {
        if (expr instanceof SQLIdentifierExpr || expr instanceof SQLPropertyExpr) {
            originalFields.add(expr.toString());
        } else if (expr instanceof SQLMethodInvokeExpr) {
            List arguments = ((SQLMethodInvokeExpr)expr).getArguments();
            List collect = arguments.stream().map(Objects::toString).collect(Collectors.toList());
            originalFields.addAll(collect);
        }
    }

    public static Map<String, EntityField> getFieldMap(String entity) {
        EntityInfo entityById = MetadataUtil.getEntityAllById(entity);
        return entityById.getFieldList().stream().collect(Collectors.toMap(EntityField::getFieldId, b -> b, (m, n) -> n));
    }

    public static String toExprString(SQLObject expr) {
        if (expr instanceof SQLInListExpr) {
            SQLInListExpr inListExpr = (SQLInListExpr)expr;
            String str = inListExpr.getExpr().toString() + " in (";
            if (inListExpr.getTargetList().size() > 0) {
                StringBuilder stringBuilder = new StringBuilder();
                for (SQLExpr sqlExpr : inListExpr.getTargetList()) {
                    stringBuilder.append(',').append(sqlExpr);
                }
                str = str + stringBuilder.toString().substring(1);
            }
            str = str + ")";
            return str;
        }
        return expr.toString();
    }

    public static QFilter formatFieldValue(QFilter filter, Map<String, EntityField> fieldMap) {
        String property = filter.getProperty().toLowerCase();
        Object value = filter.getValue();
        if (value != null) {
            String substring;
            int i;
            String prop = property;
            if (!fieldMap.containsKey(property) && (i = property.lastIndexOf(DOT)) > 0 && fieldMap.containsKey(substring = property.substring(0, i))) {
                EntityField entityField = fieldMap.get(substring);
                MsqlQueryUtil.setRefField(fieldMap, entityField, substring);
            }
            MsqlQueryUtil.setValue(filter, fieldMap, prop, value);
        }
        List nests = filter.getNests(false);
        for (QFilter.QFilterNest nest : nests) {
            MsqlQueryUtil.formatFieldValue(nest.getFilter(), fieldMap);
        }
        return filter;
    }

    public static void setRefField(Map<String, EntityField> fieldMap, EntityField entityField, String prefix) {
        if (entityField != null) {
            String baseEntityId = entityField.getBaseEntityId();
            Map<String, EntityField> fieldMaps = MsqlQueryUtil.getFieldMap(baseEntityId);
            fieldMaps.forEach((k, v) -> fieldMap.put(prefix + DOT + k, (EntityField)v));
        }
    }

    public static void setValue(QFilter filter, Map<String, EntityField> fieldMap, String property, Object value) {
        EntityField entityField = fieldMap.get(property);
        if (entityField != null) {
            if (value instanceof List) {
                List collect = ((List)value).stream().map(a -> MsqlQueryUtil.convertObject(a, entityField)).collect(Collectors.toList());
                filter.__setValue(collect);
            } else {
                filter.__setValue(MsqlQueryUtil.convertObject(value, entityField));
            }
        }
    }

    public static String objectToString(Object object) {
        if (object instanceof BigDecimal) {
            return DataFormatUtils.decimalFormat((BigDecimal)object);
        }
        if (object instanceof Double) {
            return DataFormatUtils.decimalFormat(BigDecimal.valueOf((Double)object));
        }
        return object != null ? object.toString() : null;
    }

    public static Object convertObject(Object value, EntityField entityField) {
        if (entityField != null && value != null) {
            String valueStr = value.toString();
            if ("Date".equals(entityField.getFieldType()) && value instanceof String) {
                return DateUtils.stringToDateInAnyFormat((String)value);
            }
            if (("Long".equals(entityField.getFieldType()) || entityField.getFieldType().toLowerCase().contains("org") || "BigInt".equals(entityField.getFieldType())) && value instanceof String) {
                return Long.parseLong(FelService.eval(valueStr).toString());
            }
            if (entityField.getFieldType().contains("Decimal") && value instanceof String) {
                return new BigDecimal(FelService.eval(valueStr).toString());
            }
            if ("Double".equals(entityField.getFieldType()) && value instanceof String) {
                return new Double(FelService.eval(valueStr).toString());
            }
            if ("Integer".equals(entityField.getFieldType()) && value instanceof String) {
                return Integer.valueOf(FelService.eval(valueStr).toString());
            }
            if ("Basedata".equals(entityField.getFieldType()) && value instanceof String && "Long".equals(entityField.getRefIdType())) {
                return Long.parseLong((String)value);
            }
            if (TEXT_TYPE.contains(entityField.getFieldType())) {
                return valueStr;
            }
        }
        return value;
    }

    public static DataSet doWhere(DataSet dataSet, String whereStr, Map<String, EntityField> fieldMaps) {
        String where = whereStr.replace('\t', ' ').replace('\n', ' ');
        QFilter of = QFilter.of((String)where, (Object[])new Object[0]);
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        QFilter qFilter = MsqlQueryUtil.setWhereFieldValue(of, fieldMaps, params, 0);
        where = qFilter.toString();
        for (String key : params.keySet()) {
            where = where.replaceAll(STRING + key + STRING, key);
        }
        return dataSet.where(where, params);
    }

    public static QFilter setWhereFieldValue(QFilter filter, Map<String, EntityField> fieldMaps, Map<String, Object> values, int index) {
        String property = filter.getProperty().toLowerCase();
        String cp = filter.getCP();
        Object value = filter.getValue();
        String placeHolder = "v" + index;
        if (value != null && !fieldMaps.containsKey(value)) {
            EntityField entityField = fieldMaps.get(property);
            if (value instanceof List && (Objects.equals(cp, "in") || Objects.equals(cp, "not in"))) {
                ArrayList<Object> arrayList = new ArrayList<Object>(((List)value).size());
                for (int i = 0; i < ((List)value).size(); ++i) {
                    Object o = ((List)value).get(i);
                    arrayList.add(MsqlQueryUtil.convertObject(o, entityField));
                }
                filter.__setValue((Object)placeHolder);
                values.put(placeHolder, arrayList);
            } else if (value instanceof String && !TEXT_TYPE.contains(entityField.getFieldType()) || value instanceof Number) {
                filter.__setValue((Object)placeHolder);
                values.put(placeHolder, MsqlQueryUtil.convertObject(value, entityField));
            }
        }
        List nests = filter.getNests(false);
        for (QFilter.QFilterNest nest : nests) {
            MsqlQueryUtil.setWhereFieldValue(nest.getFilter(), fieldMaps, values, ++index);
        }
        return filter;
    }

    public static String toLowerSql(String sql) {
        SQLStatementParser mysql = SQLParserUtils.createSQLStatementParser((String)sql, (DbType)JdbcConstants.MYSQL);
        SQLStatement sqlStatement = mysql.parseSelect();
        sqlStatement.accept((SQLASTVisitor)new AliasToLowerVisitor());
        return SQLUtils.toMySqlString((SQLObject)sqlStatement);
    }

    public static String getSourcePropertyName(SQLSelectItem selectItem) {
        SQLExpr expr = selectItem.getExpr();
        if (expr instanceof SQLPropertyExpr) {
            SQLExpr owner = ((SQLPropertyExpr)expr).getOwner();
            if (owner instanceof SQLPropertyExpr) {
                return ((SQLPropertyExpr)owner).getName() + DOT + ((SQLPropertyExpr)expr).getName();
            }
            return ((SQLPropertyExpr)expr).getName();
        }
        return SQLUtils.toMySqlString((SQLObject)selectItem);
    }

    public static void checkFrom(SQLTableSource from) {
        final HashMap map = new HashMap();
        from.accept(new SQLASTVisitor(){

            public boolean visit(SQLJoinTableSource x) {
                SQLTableSource left = x.getLeft();
                SQLTableSource right = x.getRight();
                if (left instanceof SQLExprTableSource || right instanceof SQLExprTableSource) {
                    map.put("can", Boolean.FALSE);
                    return false;
                }
                return true;
            }
        });
        if (!map.getOrDefault("can", Boolean.TRUE).booleanValue()) {
            throw new KDBizException("No support that full table query without filter and without select item!\n Please use the subquery with filter! " + SQLUtils.toMySqlString((SQLObject)from));
        }
    }
}

