/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.formula.value.impl;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.taxc.bdtaxr.common.refactor.formula.context.Context;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaVo;
import kd.taxc.bdtaxr.common.refactor.formula.parse.ParseUtils;
import kd.taxc.bdtaxr.common.refactor.formula.value.impl.AbstractGetValue;
import kd.taxc.bdtaxr.common.refactor.template.plugin.AbstractCodeGetValueBasePlugin;
import kd.taxc.bdtaxr.common.util.number.DataFormatUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class CodePluginGetValue
extends AbstractGetValue {
    private static Log logger = LogFactory.getLog(CodePluginGetValue.class);

    public CodePluginGetValue(Context context) {
        super(context);
    }

    @Override
    public String getValue(Object formula, FormulaVo formulaVo) {
        String value = "";
        if (formula != null && StringUtil.isNotEmpty((CharSequence)((String)formula))) {
            try {
                logger.info("CodePluginGetValue Formula: {}", formula);
                String cacheValue = this.getFormulaContext().getCpValues().get(formulaVo.getFormulaKey() + formulaVo.getFormula());
                if (cacheValue != null) {
                    return cacheValue.toString();
                }
                Class<?> aClass = Class.forName(((String)formula).split("\\(")[0]);
                String formulaStr = formulaVo.getFormula();
                String[] paramsList = new String[]{};
                if (formulaStr.contains("(")) {
                    formulaStr = formulaStr.split("\\(")[1];
                    formulaStr = formulaStr.split("\\)")[0];
                    paramsList = formulaStr.split(",");
                }
                if (AbstractCodeGetValueBasePlugin.class.isAssignableFrom(aClass)) {
                    AbstractCodeGetValueBasePlugin plugin = (AbstractCodeGetValueBasePlugin)aClass.newInstance();
                    Method method = aClass.getMethod("setContext", Context.class);
                    Object obj = aClass.newInstance();
                    method.invoke((Object)plugin, this.getFormulaContext());
                    String formulaKey = formulaVo.getFormulaKey();
                    Map<String, Object> params = this.getFormulaContext().getBusinessParam();
                    if (params == null) {
                        params = new HashMap<String, Object>(16);
                    }
                    params.put("cellKey", formulaKey);
                    for (int i = 0; i < paramsList.length; ++i) {
                        String param = paramsList[i];
                        String paramsKey1 = "codePluginParam" + i;
                        String paramsKey2 = "codePluginParam_" + formulaKey + "_" + i;
                        if (!ParseUtils.isFormulaFormat(param)) {
                            params.put(paramsKey1, param);
                            params.put(paramsKey2, param);
                            continue;
                        }
                        Map<String, String> map = ParseUtils.parseFormulaZKH(param);
                        String cellKey = map.get("value");
                        params.put(paramsKey1, this.getFormulaContext().getData().get(cellKey));
                        params.put(paramsKey2, this.getFormulaContext().getData().get(cellKey));
                    }
                    value = plugin.queryByFormulaVo(params, formulaVo);
                    if (!CollectionUtils.isEmpty(this.getFormulaContext().getAllEntityFieldByType()) && value != null) {
                        value = DataFormatUtils.dataFormatByFieldType(value, this.getFormulaContext().getAllEntityFieldByType().get(formulaKey));
                    }
                    if (value != null) {
                        this.getFormulaContext().getCpValues().put(formulaVo.getFormulaKey() + formulaVo.getFormula(), value);
                    }
                }
            }
            catch (Exception e) {
                logger.error("CodePluginGetValue.\u83b7\u53d6\u6570\u636e\u5f02\u5e38\uff0cplugin={}", formula);
                logger.error("\u4ee3\u7801\u63d2\u4ef6\u516c\u5f0f\u83b7\u53d6\u6570\u636e\u5f02\u5e38\uff1a" + e);
            }
        }
        return value;
    }
}

