/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.formula.value.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.taxc.bdtaxr.common.refactor.formula.cache.CacheUtils;
import kd.taxc.bdtaxr.common.refactor.formula.context.Context;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaVo;
import kd.taxc.bdtaxr.common.refactor.formula.value.impl.AbstractGetValue;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.bdtaxr.common.vo.BussinessParamsVo;

public class RuleGetValue
extends AbstractGetValue {
    private static Log logger = LogFactory.getLog(RuleGetValue.class);
    public static final String RULE_VALUES = "ruleIds_%s";

    public RuleGetValue(Context context) {
        super(context);
    }

    @Override
    public String getValue(Object formula, FormulaVo srcFormulaVo) {
        Long tmpId = this.getFormulaContext().getTmpId();
        Map<String, String> ruleList = (Map<String, String>)CacheUtils.get(String.format(RULE_VALUES, this.getCacheKey(tmpId)));
        if (CollectionUtils.isEmpty((Map)ruleList)) {
            ruleList = this.batchGetRuleValue(tmpId);
        }
        return (String)ruleList.get(formula);
    }

    private String getCacheKey(Long tmpId) {
        Map<String, Object> paramMap = this.getFormulaContext().getBusinessParam();
        String cacheKey = String.valueOf(paramMap.get("cacheKey"));
        if (null == cacheKey || "".equals(cacheKey)) {
            cacheKey = tmpId.toString();
        }
        return cacheKey;
    }

    private Map<String, String> batchGetRuleValue(Long tmpId) {
        Map<String, String> ruleList = this.getFormulaContext().getRuleValues();
        List<Long> idList = this.getIdList(ruleList);
        Map<String, Object> paramMap = this.getFormulaContext().getBusinessParam();
        BussinessParamsVo bussinessParamsVo = new BussinessParamsVo();
        bussinessParamsVo.setOrgId(String.valueOf(paramMap.get("orgId")));
        bussinessParamsVo.setExtendParams(paramMap);
        logger.info("\u5f00\u59cbcalculateService.ruleCalService\u8c03\u7528\uff0cbussinessParamsVo={}\uff0cruleIds={}", (Object)JsonUtil.toJson(bussinessParamsVo), (Object)JsonUtil.toJson(idList));
        long time = System.currentTimeMillis();
        Map ruleMap = (Map)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"RuleCalculateService", (String)"ruleCalService", (Object[])new Object[]{JsonUtil.toJson(bussinessParamsVo), idList});
        logger.info("R\u516c\u5f0f\u53d6\u6570\u8017\u65f6--R--" + (System.currentTimeMillis() - time));
        logger.info("\u7ed3\u675fcalculateService.ruleCalService\u8c03\u7528,result={}", (Object)JsonUtil.toJson(ruleMap));
        for (String id : ruleList.keySet()) {
            if (StringUtils.isBlank((CharSequence)id)) continue;
            Long ruleId = Long.parseLong(id);
            if (ruleMap.get(ruleId) == null) {
                ruleList.put(id, "0");
                continue;
            }
            ruleList.put(id, ruleMap.get(ruleId).toString());
        }
        CacheUtils.put(String.format(RULE_VALUES, this.getCacheKey(tmpId)), ruleList);
        return ruleList;
    }

    private List<Long> getIdList(Map<String, String> ruleList) {
        ArrayList<Long> idList = new ArrayList<Long>();
        for (String id : ruleList.keySet()) {
            if (!StringUtils.isNotBlank((CharSequence)id)) continue;
            Long ruleId = Long.parseLong(id);
            idList.add(ruleId);
        }
        return idList;
    }
}

