/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.formula.value.impl;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.refactor.formula.context.Context;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaVo;
import kd.taxc.bdtaxr.common.refactor.formula.value.impl.AbstractGetValue;
import kd.taxc.bdtaxr.common.util.number.DataFormatUtils;

public class TableGetValue
extends AbstractGetValue {
    private static Log LOGGER = LogFactory.getLog(TableGetValue.class);

    public TableGetValue(Context context) {
        super(context);
    }

    @Override
    public String getValue(Object formulaObj, FormulaVo srcFormulaVo) {
        long start = System.currentTimeMillis();
        String formula = (String)formulaObj;
        String result = null;
        if (srcFormulaVo != null && formula.equals(srcFormulaVo.getFormulaKey()) && !srcFormulaVo.getFormulaType().equals("2")) {
            result = this.getFormulaContext().getData().get(formula);
            result = DataFormatUtils.dataFormatByFieldType(result, this.getFormulaContext().getAllEntityFieldByType().get(formula));
            return result;
        }
        String variableValue = this.getFormulaContext().getVariableKey().get(formula);
        if (null != variableValue) {
            if (null != this.getFormulaContext().getFormulas()) {
                FormulaVo formulaVo = this.getFormulaContext().getFormulas().get(formula);
                if (null == formulaVo) {
                    return this.getFormulaContext().putDefautData(formula);
                }
                result = this.getFormulaContext().calculate(formulaVo).replaceAll("%", "");
                this.getFormulaContext().getVariableKey().remove(formula);
            }
        } else {
            result = this.getFormulaContext().getData().get(formula);
            if (result == null && null != this.getFormulaContext().getFormulas()) {
                FormulaVo formulaVo = this.getFormulaContext().getFormulas().get(formula);
                if (null != formulaVo && !formula.equals(formulaVo.getFormula())) {
                    result = this.getFormulaContext().calculate(formulaVo).replaceAll("%", "");
                } else {
                    return this.getFormulaContext().putDefautData(formula);
                }
            }
        }
        result = DataFormatUtils.dataFormatByFieldType(result, this.getFormulaContext().getAllEntityFieldByType().get(formula));
        if (System.currentTimeMillis() - start > 5L) {
            LOGGER.info("TableGetValue cost:{}ms,formula:{}", (Object)(System.currentTimeMillis() - start), (Object)formula);
        }
        return result;
    }

    @Override
    public String getValueWithLog(Object formula, FormulaVo formulaVo, List<String> logs) {
        logs.add(String.format(ResManager.loadKDString((String)"{Q[%s]\uff0cQ\u516c\u5f0f\u662f\u8868\u5185\u53d6\u6570\u516c\u5f0f\uff0c\u7ed9\u9ed8\u8ba4\u503c0\u3002", (String)"TableGetValue_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), formula));
        return "0";
    }
}

