/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.rule.rulecal.task;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.threadpools.Task;
import kd.taxc.bdtaxr.common.util.rule.RuleSettingUtils;
import kd.taxc.bdtaxr.common.vo.BussinessParamsVo;

public class RuleSettingTask
extends Task {
    private static Log logger = LogFactory.getLog(RuleSettingTask.class);
    private int batchSize = 2;
    private BussinessParamsVo bussinessParams;
    private List<DynamicObject> ruleObjs;

    public RuleSettingTask(BussinessParamsVo bussinessParams, List<DynamicObject> ruleObjs) {
        this.bussinessParams = bussinessParams;
        this.ruleObjs = ruleObjs;
    }

    public List<List<DynamicObject>> getValue() {
        return Lists.partition(this.ruleObjs, (int)this.batchSize);
    }

    public Object executor(Object ruleObjs) {
        logger.info("\u53d6\u6570\u914d\u7f6e\u8ba1\u7b97\u5f00\u59cb\u6267\u884c");
        long start = System.currentTimeMillis();
        ConcurrentHashMap<Long, Object> calResult = new ConcurrentHashMap<Long, Object>();
        RuleSettingUtils.calculate((List)ruleObjs, calResult, this.bussinessParams, false);
        logger.info("\u53d6\u6570\u914d\u7f6e\u8ba1\u7b97\u6570\u7ed3\u675f\u6267\u884c\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
        return calResult;
    }
}

