/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.tax.log.taxlinelog;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.constant.TaxLineLogStepEnum;
import kd.taxc.bdtaxr.common.refactor.tax.utils.ObjectQueryUtils;
import kd.taxc.bdtaxr.common.refactor.tax.utils.TaxLineCalLoggerUtils;
import kd.taxc.bdtaxr.common.refactor.tax.utils.TaxLogUtils;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;

public class TaxLineLogService {
    private static Log logger = LogFactory.getLog(TaxLineLogService.class);
    private Map<String, LinkedHashMap<String, LinkedHashMap<String, String>>> logs;
    private DynamicObjectCollection internationalTax;
    private String materialLine;
    private String currentTaxLine;
    private String taxDetailLineTaxCodeKey;
    private String taxDetailLineTaxTypeKey;
    private TaxLineCalLoggerUtils calLogger;

    public TaxLineLogService(Map<String, LinkedHashMap<String, LinkedHashMap<String, String>>> logs) {
        this.logs = logs;
        this.calLogger = new TaxLineCalLoggerUtils();
    }

    private boolean isOpenWriteLog() {
        boolean isOpen = false;
        Object uselog = SystemParamUtil.getAppParameter("bdtaxr", "taxlinelog");
        if (uselog instanceof Boolean && ((Boolean)uselog).booleanValue()) {
            isOpen = true;
        }
        return isOpen;
    }

    public void initStepMap(String materialLine, Map<String, LinkedHashMap<String, LinkedHashMap<String, String>>> logs, DynamicObjectCollection internationalTax, String taxDetailLineTaxCodeKey, String taxDetailLineTaxTypeKey) {
        if (null != internationalTax && this.isOpenWriteLog()) {
            LinkedHashMap mapLinkedHashMap = new LinkedHashMap();
            for (int i = 0; i < internationalTax.size(); ++i) {
                LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                for (TaxLineLogStepEnum value : TaxLineLogStepEnum.values()) {
                    map.put(value.getCode(), value.getInitShowInfo());
                    mapLinkedHashMap.put(String.valueOf(i + 1), map);
                }
            }
            this.setInternationalTax(internationalTax);
            this.setMaterialLine(materialLine);
            this.setTaxDetailLineTaxCodeKey(taxDetailLineTaxCodeKey);
            this.setTaxDetailLineTaxTypeKey(taxDetailLineTaxTypeKey);
            logs.put(materialLine, mapLinkedHashMap);
        }
    }

    public void stepTaxLineLog(String step, Map<String, Object> logParams) {
        if (!this.isOpenWriteLog()) {
            return;
        }
        LinkedHashMap<String, String> map = this.getCurrentTaxLineLogMap();
        if (StringUtils.equalsIgnoreCase((CharSequence)step, (CharSequence)TaxLineLogStepEnum.STEP_ONE.getCode())) {
            int currentLine = (Integer)logParams.get("current_line");
            DynamicObject taxRow = (DynamicObject)this.getInternationalTax().get(currentLine);
            DynamicObject taxCodeObject = taxRow.getDynamicObject(this.getTaxDetailLineTaxCodeKey());
            if (null != taxCodeObject && null != taxCodeObject.get("id")) {
                Long taxCodeId = taxCodeObject.getLong("id");
                DynamicObject taxCode = ObjectQueryUtils.queryDynamicObject("bastax_taxcode", "id,number,name", taxCodeId);
                map.put(TaxLineLogStepEnum.STEP_ONE.getCode(), taxCode == null ? TaxLineLogStepEnum.STEP_ONE.getInitShowInfo() : taxCode.getString("number") + "\uff1a" + taxCode.getString("name"));
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)step, (CharSequence)TaxLineLogStepEnum.STEP_TWO.getCode())) {
            if (logParams.get("logparam_formula") instanceof Long) {
                Long formulaId = (Long)logParams.get("logparam_formula");
                DynamicObject formula = ObjectQueryUtils.queryDynamicObject("bdtaxr_tax_cal_formula", "formula", formulaId);
                map.put(TaxLineLogStepEnum.STEP_TWO.getCode(), formula == null ? TaxLineLogStepEnum.STEP_TWO.getInitShowInfo() : formula.getString("name") + "\uff1a" + formula.getString("formula"));
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)step, (CharSequence)TaxLineLogStepEnum.STEP_THREE.getCode())) {
            List<Object> info = new ArrayList();
            Long formulaId = (Long)logParams.get("logparam_formula");
            HashMap fieldValues = (HashMap)logParams.get("logparam_fieldkeysvalue");
            HashMap taxTypeValueMap = (HashMap)logParams.get("logparam_fieldkey_taxtype");
            DynamicObject formula = ObjectQueryUtils.queryDynamicObject("bdtaxr_tax_cal_formula", "bill.number", formulaId);
            if (null != formula) {
                String callBillNumber = formula.getString("bill.number");
                QFilter callBillNumberQ = new QFilter("billnumber", "=", (Object)callBillNumber);
                QFilter fieldQ = new QFilter("number", "in", (Object)fieldValues.keySet().toArray());
                DynamicObjectCollection collection = QueryServiceHelper.query((String)"bdtaxr_where_fields", (String)"id,number,name", (QFilter[])new QFilter[]{callBillNumberQ, fieldQ});
                info = collection.stream().map(o -> o.getString("name") + "\uff1a" + String.valueOf(fieldValues.get(o.get("number")))).collect(Collectors.toList());
                List taxTypeKey = fieldValues.keySet().stream().filter(o -> o.startsWith("taxType_")).collect(Collectors.toList());
                if (!ObjectUtils.isEmpty(taxTypeKey)) {
                    List taxTypeIds = taxTypeKey.stream().map(o -> Long.valueOf(o.replaceAll("taxType_", ""))).collect(Collectors.toList());
                    MainEntityType type = EntityMetadataCache.getDataEntityType((String)"bd_taxcategory");
                    DynamicObject[] taxTypeObject = BusinessDataServiceHelper.load((Object[])taxTypeIds.toArray(), (DynamicObjectType)type);
                    List taxTypeInfo = Arrays.stream(taxTypeObject).map(o -> o.getString("name") + "\uff1a" + String.valueOf(taxTypeValueMap.get("taxType_" + o.getString("id")))).collect(Collectors.toList());
                    info.addAll(taxTypeInfo);
                }
            }
            map.put(TaxLineLogStepEnum.STEP_THREE.getCode(), ObjectUtils.isEmpty(info) ? TaxLineLogStepEnum.STEP_THREE.getInitShowInfo() : org.apache.commons.lang3.StringUtils.join(info, (String)", "));
        } else if (StringUtils.equalsIgnoreCase((CharSequence)step, (CharSequence)TaxLineLogStepEnum.STEP_FOUR.getCode())) {
            Object value = logParams.get("logparam_amount");
            map.put(TaxLineLogStepEnum.STEP_FOUR.getCode(), ObjectUtils.isEmpty((Object)value) ? ResManager.loadKDString((String)"\u7a0e\u989d\uff1anull", (String)"TaxLineLogService_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]) : String.format(ResManager.loadKDString((String)"\u7a0e\u989d\uff1a%s", (String)"TaxLineLogService_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), value.toString()));
        }
    }

    public void saveTaxLineLog(DynamicObject dos, Map<String, LinkedHashMap<String, LinkedHashMap<String, String>>> logs, String taxResults) {
        if (!this.isOpenWriteLog()) {
            return;
        }
        DynamicObject taxLineLog = BusinessDataServiceHelper.newDynamicObject((String)"bdtaxr_taxlinelog");
        taxLineLog.set("billid", (Object)dos.getLong("id"));
        taxLineLog.set("number", (Object)dos.getString("billno"));
        taxLineLog.set("billlname", (Object)dos.getDataEntityType().getName());
        taxLineLog.set("createtime", (Object)new Date());
        taxLineLog.set("creator", (Object)RequestContext.get().getUserId());
        taxLineLog.set("enable", (Object)1);
        taxLineLog.set("status", (Object)"C");
        taxLineLog.set("lognumber", (Object)TaxLogUtils.getLogNumber("SH", dos.getDataEntityType().getName()));
        taxLineLog.set("taxResults", (Object)taxResults);
        try (TXHandle h = TX.requiresNew();){
            try {
                DynamicObject[] saveDb = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taxLineLog});
                Long id = saveDb[0].getLong("id");
                ArrayList list = new ArrayList();
                logs.forEach((key, value) -> {
                    DynamicObject content = BusinessDataServiceHelper.newDynamicObject((String)"bdtaxr_linecontent");
                    content.set("number", key);
                    content.set("taxlinelog", (Object)id);
                    content.set("enable", (Object)1);
                    content.set("status", (Object)"C");
                    value.forEach((k, v) -> v.forEach((kk, vv) -> {
                        DynamicObject stepObject = content.getDynamicObjectCollection("entryentity").addNew();
                        stepObject.set("taxline", k);
                        stepObject.set("stepno", kk);
                        stepObject.set("step", (Object)TaxLineLogStepEnum.getStepName(kk));
                        stepObject.set("logcontent", vv);
                    }));
                    list.add(content);
                });
                SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[list.size()]));
            }
            catch (Exception e) {
                logger.error("tax-TaxLineLogService save exception", (Throwable)e);
                h.markRollback();
            }
        }
    }

    public LinkedHashMap<String, String> getCurrentTaxLineLogMap() {
        Map<String, LinkedHashMap<String, LinkedHashMap<String, String>>> logs = this.getLogs();
        return logs.get(this.getMaterialLine()).get(this.getCurrentTaxLine());
    }

    public DynamicObjectCollection getInternationalTax() {
        return this.internationalTax;
    }

    public void setInternationalTax(DynamicObjectCollection internationalTax) {
        this.internationalTax = internationalTax;
    }

    public Map<String, LinkedHashMap<String, LinkedHashMap<String, String>>> getLogs() {
        return this.logs;
    }

    public String getMaterialLine() {
        return this.materialLine;
    }

    public void setMaterialLine(String materialLine) {
        this.materialLine = materialLine;
    }

    public String getTaxDetailLineTaxCodeKey() {
        return this.taxDetailLineTaxCodeKey;
    }

    public void setTaxDetailLineTaxCodeKey(String taxDetailLineTaxCodeKey) {
        this.taxDetailLineTaxCodeKey = taxDetailLineTaxCodeKey;
    }

    public String getCurrentTaxLine() {
        return this.currentTaxLine;
    }

    public void setCurrentTaxLine(String currentTaxLine) {
        this.currentTaxLine = currentTaxLine;
    }

    public String getTaxDetailLineTaxTypeKey() {
        return this.taxDetailLineTaxTypeKey;
    }

    public void setTaxDetailLineTaxTypeKey(String taxDetailLineTaxTypeKey) {
        this.taxDetailLineTaxTypeKey = taxDetailLineTaxTypeKey;
    }

    public TaxLineCalLoggerUtils getCalLogger() {
        return this.calLogger;
    }
}

