/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.tax.service.impl;

import java.util.Arrays;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.refactor.tax.service.BillConfigService;
import kd.taxc.bdtaxr.common.refactor.tax.service.BusinessScenarioService;
import kd.taxc.bdtaxr.common.refactor.tax.service.impl.BillConfigServiceImpl;
import kd.taxc.bdtaxr.common.refactor.tax.service.impl.TaxRuleAlgoService;
import kd.taxc.bdtaxr.common.refactor.tax.utils.FilterGetValueUtils;
import kd.taxc.bdtaxr.common.refactor.tax.utils.FilterUtils;
import kd.taxc.bdtaxr.common.refactor.tax.utils.ObjectQueryUtils;
import kd.taxc.bdtaxr.common.refactor.tax.vo.BillTaxVo;
import kd.taxc.bdtaxr.common.refactor.tax.vo.FieldsAndDataTypeVo;

public class BusinessScenarioServiceImpl
implements BusinessScenarioService {
    private static Log logger = LogFactory.getLog(BusinessScenarioServiceImpl.class);
    private BillConfigService billConfigService = new BillConfigServiceImpl();

    @Override
    public DynamicObject service(BillTaxVo billTaxVo) {
        Object ret = null;
        Object[] businessScenario = ObjectQueryUtils.queryBdtaxrBilltaxConfigs(billTaxVo.getEntityNumber(), billTaxVo.getOrgId(), billTaxVo.getCountry());
        billTaxVo.getLogger().addBusinessScenario((DynamicObject[])businessScenario);
        billTaxVo.getTaxLogMaterialLineDto().collectBillTaxConfigs((DynamicObject[])businessScenario);
        logger.info("tax-BusinessScenarioServiceImpl BilltaxConfigs: " + Arrays.toString(businessScenario));
        if (businessScenario.length == 0) {
            return ret;
        }
        DynamicObject billConfigs = this.billConfigService.service(billTaxVo.getDos().getDataEntityType().getName());
        logger.info("tax-BusinessScenarioServiceImpl CallBillFieldConfigs: " + String.valueOf(billConfigs));
        String[] fileds = null;
        if (null == billConfigs) {
            ret = businessScenario.length > 0 ? businessScenario[0] : new DynamicObject();
        } else {
            fileds = billConfigs.getString("billfieldnumber").split(",");
            if (null == fileds || fileds.length == 0) {
                ret = businessScenario[0];
            } else {
                int size = 0;
                List<FieldsAndDataTypeVo> list = FilterGetValueUtils.fetchValue(billTaxVo, fileds, "bdtaxr_billtax_configs");
                billTaxVo.getLogger().addFieldsAndDataTypeVo(list);
                billTaxVo.getTaxLogMaterialLineDto().collectBillConfigsFieldList(list);
                DataSet dataSet = TaxRuleAlgoService.service(list);
                for (Object d : businessScenario) {
                    String condition = d.getString("callconditionjson");
                    if (!StringUtils.isEmpty((CharSequence)condition)) {
                        QFilter qFilter = FilterUtils.buildFilter(condition, true);
                        if (null != qFilter) {
                            int length;
                            String json = qFilter.toString();
                            DataSet dataSetTemp = dataSet.copy().filter(json, FilterUtils.getFilterParams(condition));
                            boolean issure = dataSetTemp.isEmpty();
                            billTaxVo.getLogger().addQFilter((DynamicObject)d, !issure);
                            if (issure || size >= (length = qFilter.recombine().length)) continue;
                            ret = d;
                            size = length;
                            continue;
                        }
                        if (size != 0) continue;
                        ret = d;
                        continue;
                    }
                    if (size != 0) continue;
                    ret = d;
                }
            }
        }
        return ret;
    }
}

