/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.tax.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.refactor.tax.service.TaxConfigService;
import kd.taxc.bdtaxr.common.refactor.tax.service.impl.TaxConfigAbstractService;
import kd.taxc.bdtaxr.common.refactor.tax.utils.FetchValueUtils;
import kd.taxc.bdtaxr.common.refactor.tax.utils.FilterUtils;
import kd.taxc.bdtaxr.common.refactor.tax.utils.ObjectQueryUtils;
import kd.taxc.bdtaxr.common.refactor.tax.vo.BillTaxVo;
import kd.taxc.bdtaxr.common.refactor.tax.vo.FiledsPropertyVo;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;

public class SpecificServiceImpl
extends TaxConfigAbstractService
implements TaxConfigService {
    private static Log logger = LogFactory.getLog(SpecificServiceImpl.class);
    private final String euproduct = "euproduct";
    private final String specificproduct = "specificproduct";
    private final String SPECIFIC_KEY = "specificKey";
    private static final Map<String, Map<String, Object>> specificTaxMap = new HashMap<String, Map<String, Object>>();
    private static final Map<String, Map<String, Map<DynamicObject, Map<String, Object>>>> specificfourPLogMap = new HashMap<String, Map<String, Map<DynamicObject, Map<String, Object>>>>();

    public SpecificServiceImpl() {
        this.entryKey = "specific_entity";
        this.sourceKey = "specificsourcekey";
        this.fieldKey = "specificfieldkey";
        this.conditionjson = "specificconditionjson";
        this.condition = "specificcondition";
    }

    public static Map<String, Map<String, Object>> getSpecificTaxMap() {
        return specificTaxMap;
    }

    public static Map<String, Map<String, Map<DynamicObject, Map<String, Object>>>> getSpecificfourPLogMap() {
        return specificfourPLogMap;
    }

    @Override
    public List<Map<String, Object>> service(BillTaxVo billTaxVo, DynamicObject dynamicObject, DynamicObject taxBillEntry) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(16);
        DynamicObjectCollection pageDos = dynamicObject.getDynamicObjectCollection(this.entryKey);
        HashMap<String, Map<DynamicObject, Map<String, Object>>> fourPMap = new HashMap<String, Map<DynamicObject, Map<String, Object>>>();
        HashMap rowFourMap = new HashMap();
        String specificTaxMapKey = billTaxVo.getEntityNumber() + billTaxVo.getDos().getString("id");
        Map<String, Object> specificTaxMapKeyMap = specificTaxMap.get(specificTaxMapKey);
        if (null != specificTaxMapKeyMap) {
            billTaxVo.getTaxLogMaterialLineDto().collectFourPList(specificfourPLogMap.get(specificTaxMapKey));
            billTaxVo.getLogger().addFourPMap(specificfourPLogMap.get(specificTaxMapKey));
            return (List)specificTaxMapKeyMap.get("specificKey");
        }
        pageDos.stream().forEach(d -> {
            int isEUproduct = this.isEUSpecificProduct(billTaxVo, (DynamicObject)d);
            logger.info("tax-isEUproduct begin isEUproduct{" + isEUproduct + "};settingEUproduct{" + d.getInt("euproduct") + "}");
            if (isEUproduct == d.getInt("euproduct")) {
                String filter;
                boolean isCal = true;
                if (StringUtils.isNotEmpty((CharSequence)this.conditionjson) && StringUtils.isNotEmpty((CharSequence)(filter = d.getString(this.conditionjson)))) {
                    String entityNumber = d.getString(this.sourceKey);
                    QFilter conditionJson = FilterUtils.buildFilter(filter, false);
                    if (null != conditionJson) {
                        isCal = billTaxVo.getEntityNumber().equalsIgnoreCase(entityNumber) ? this.currentBillCondition(billTaxVo, conditionJson, filter) : this.otherBillCondition(billTaxVo, entityNumber, conditionJson);
                    }
                }
                if (isCal) {
                    Map<String, Object> map = this.cal(billTaxVo, (DynamicObject)d);
                    if (null != map) {
                        list.add(map);
                        HashMap<String, List> objectMap = new HashMap<String, List>();
                        objectMap.put("specificKey", list);
                        specificTaxMap.put(specificTaxMapKey, objectMap);
                    }
                    rowFourMap.put(d, map);
                } else {
                    rowFourMap.put(d, null);
                }
            } else {
                rowFourMap.put(d, null);
            }
        });
        if (null == specificTaxMap.get(specificTaxMapKey)) {
            HashMap<String, ArrayList<Map<String, Object>>> objectMap = new HashMap<String, ArrayList<Map<String, Object>>>();
            objectMap.put("specificKey", list);
            specificTaxMap.put(specificTaxMapKey, objectMap);
        }
        if (null == specificfourPLogMap.get(specificTaxMapKey)) {
            fourPMap.put(this.getClass().getSimpleName(), rowFourMap);
            specificfourPLogMap.put(specificTaxMapKey, fourPMap);
            billTaxVo.getTaxLogMaterialLineDto().collectFourPList(fourPMap);
            billTaxVo.getLogger().addFourPMap(fourPMap);
        }
        return list;
    }

    @Override
    public Map<String, Object> cal(BillTaxVo billTaxVo, DynamicObject d) {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("entrytype", 0L);
        map.put("valueid", d.getDynamicObject("specificproduct").getLong("id"));
        return map;
    }

    private int isEUSpecificProduct(BillTaxVo billTaxVo, DynamicObject d) {
        int isEUProduct = 0;
        List<Object> list = this.getFieldValues(billTaxVo, d);
        logger.info("tax-SpecificServiceImpl:" + list.toString());
        if (!list.isEmpty()) {
            QFilter ENABLE = new QFilter("enable", "=", (Object)"1");
            QFilter country = new QFilter("country", "=", (Object)billTaxVo.getCountry());
            QFilter startDate = new QFilter("startdate", "<=", (Object)billTaxVo.getDate());
            QFilter endDate = new QFilter("enddate", "is null", null).or("enddate", ">=", (Object)DateUtils.getDayLast(billTaxVo.getDate()));
            List disLists = list.stream().distinct().collect(Collectors.toList());
            List disList = disLists.stream().map(o -> o == null ? "" : o.toString()).collect(Collectors.toList());
            QFilter values = new QFilter("bastax_euproductbase.comparevalue", "in", (Object)disList.toArray());
            DynamicObjectCollection rows = QueryServiceHelper.query((String)"bastax_euproduct", (String)"id", (QFilter[])new QFilter[]{ENABLE, country, startDate, endDate, values});
            logger.info("tax-SpecificServiceImpl>rows:" + (rows == null ? 0 : rows.size()));
            if (null != rows && rows.size() == disList.size()) {
                isEUProduct = 1;
            }
        }
        return isEUProduct;
    }

    private List<Object> getFieldValues(BillTaxVo billTaxVo, DynamicObject d) {
        ArrayList<Object> list = new ArrayList<Object>();
        String entityNumber = d.getString(this.sourceKey);
        String fieldKeys = d.getString(this.fieldKey);
        if (billTaxVo.getEntityNumber().equalsIgnoreCase(entityNumber)) {
            DynamicObject currentRow = billTaxVo.getTaxBillEntry();
            DynamicObjectCollection taxBillEntrys = billTaxVo.getDos().getDynamicObjectCollection(billTaxVo.getTaxBillEntryKey());
            taxBillEntrys.stream().forEach(taxBillEntry -> {
                billTaxVo.setTaxBillEntry((DynamicObject)taxBillEntry);
                list.add(FetchValueUtils.fetchValue(billTaxVo, billTaxVo.getEntityNumber(), fieldKeys).getValue());
            });
            billTaxVo.setTaxBillEntry(currentRow);
            logger.info("tax-SpecificServiceImpl-getFieldValues(currentbill):" + (null != list ? ((Object)list).toString() : Long.valueOf(0L)));
        } else {
            String[] filedsArr = new String[3];
            List<LinkedList<FiledsPropertyVo>> filedsPropertyVos = MetadataUtil.queryProperty(entityNumber, fieldKeys, filedsArr, false);
            LinkedList<FiledsPropertyVo> filedsPropertyVo = filedsPropertyVos.get(0);
            DynamicObjectCollection source = billTaxVo.getSourceData().get(entityNumber);
            if (null != source && source.size() > 0) {
                int length = filedsPropertyVo.size();
                DynamicObject main = null;
                main = ObjectQueryUtils.queryDynamicObject(entityNumber, filedsPropertyVo.get(0).getFiled(), ((DynamicObject)source.get(0)).get("id"));
                if (filedsPropertyVo.size() == 1) {
                    Object value = this.getFieldValue(filedsPropertyVo.get(0).getDynamicProperty().getPropertyType(), main, filedsPropertyVo.get(0).getFiled());
                    list.add(value);
                    logger.info("tax-SpecificServiceImpl-getFieldValues(filedsPropertyVo.size()=1):" + (null != list ? ((Object)list).toString() : Long.valueOf(0L)));
                } else if (filedsPropertyVo.size() > 1) {
                    int i = 0;
                    if (filedsPropertyVo.get(i).getDynamicProperty() instanceof BasedataProp) {
                        DynamicObject dynamicObject = main.getDynamicObject(filedsPropertyVo.get(i).getFiled());
                        entityNumber = ((BasedataProp)filedsPropertyVo.get(i).getDynamicProperty()).getBaseEntityId();
                        if (null != dynamicObject) {
                            DynamicObject object = ObjectQueryUtils.queryDynamicObject(entityNumber, filedsPropertyVo.get(1).getFiled(), dynamicObject.getLong("id"));
                            list.add(object.get(filedsPropertyVo.get(1).getFiled()));
                            logger.info("tax-SpecificServiceImpl-getFieldValues(filedsPropertyVo.size()>1) BasedataProp:" + (null != list ? ((Object)list).toString() : Long.valueOf(0L)));
                        }
                    } else if (filedsPropertyVo.get(i).getDynamicProperty() instanceof EntryProp) {
                        ArrayList<Long> ids = new ArrayList<Long>();
                        ids.add(((DynamicObject)source.get(0)).getLong("id"));
                        DynamicObject[] maintemp = ObjectQueryUtils.queryDynamicObject(entityNumber, filedsPropertyVo.get(0).getFiled() + "." + filedsPropertyVo.get(1).getFiled(), ids);
                        if (null != maintemp && maintemp.length > 0) {
                            DynamicObjectCollection collection = maintemp[0].getDynamicObjectCollection(filedsPropertyVo.get(0).getFiled());
                            if (filedsPropertyVo.get(++i).getDynamicProperty() instanceof BasedataProp) {
                                entityNumber = ((BasedataProp)filedsPropertyVo.get(i).getDynamicProperty()).getBaseEntityId();
                                int j = i++;
                                List<Long> fid = collection.stream().map(o -> o.getDynamicObject(((FiledsPropertyVo)filedsPropertyVo.get(j)).getFiled()).getLong("id")).collect(Collectors.toList());
                                DynamicObject[] jobject = ObjectQueryUtils.queryDynamicObject(entityNumber, filedsPropertyVo.get(i).getFiled(), fid);
                                if (filedsPropertyVo.get(i).getDynamicProperty() instanceof BasedataProp) {
                                    int ff = i;
                                    entityNumber = ((BasedataProp)filedsPropertyVo.get(i).getDynamicProperty()).getBaseEntityId();
                                    List<Long> ffid = Arrays.stream(jobject).map(o -> o.getDynamicObject(((FiledsPropertyVo)filedsPropertyVo.get(ff)).getFiled()).getLong("id")).collect(Collectors.toList());
                                    int fff = ++i;
                                    if (null != filedsPropertyVo.get(i) && !StringUtils.equalsIgnoreCase((CharSequence)filedsPropertyVo.get(fff).getFiled(), (CharSequence)"id")) {
                                        DynamicObject[] fffobject = ObjectQueryUtils.queryDynamicObject(entityNumber, filedsPropertyVo.get(fff).getFiled(), ffid);
                                        list.addAll(Arrays.stream(fffobject).map(o -> o.get(((FiledsPropertyVo)filedsPropertyVo.get(fff)).getFiled())).collect(Collectors.toList()));
                                    } else {
                                        list.add(ffid);
                                    }
                                } else {
                                    int k = i;
                                    list.addAll(Arrays.stream(jobject).map(o -> o.get(((FiledsPropertyVo)filedsPropertyVo.get(k)).getFiled())).collect(Collectors.toList()));
                                }
                                logger.info("tax-SpecificServiceImpl-getFieldValues(filedsPropertyVo.size()>1) EntryProp>BasedataProp:" + (null != list ? ((Object)list).toString() : Long.valueOf(0L)));
                            } else {
                                list.addAll(collection.stream().map(o -> o.get(((FiledsPropertyVo)filedsPropertyVo.get(1)).getFiled())).collect(Collectors.toList()));
                                logger.info("tax-SpecificServiceImpl-getFieldValues(filedsPropertyVo.size()>1) EntryProp>:" + (null != list ? ((Object)list).toString() : Long.valueOf(0L)));
                            }
                        }
                    }
                    logger.info("tax-SpecificServiceImpl-getvalueid(filedsPropertyVo.size() > 1):" + (null != list ? ((Object)list).toString() : Long.valueOf(0L)));
                }
            }
        }
        return list;
    }

    private Object getFieldValue(Class<?> cls, DynamicObject dos, String key) {
        Object object = new Object();
        object = cls.getSimpleName().equalsIgnoreCase("BigDecimal") || cls.getSimpleName().equalsIgnoreCase("Double") ? (null == dos ? BigDecimal.valueOf(0.0) : dos.getBigDecimal(key)) : (cls.getSimpleName().equalsIgnoreCase("Long") ? Long.valueOf(null == dos ? 0L : dos.getLong(key)) : (cls.getSimpleName().equalsIgnoreCase("String") || cls.getSimpleName().equalsIgnoreCase("ILocaleString") ? (null == dos ? "" : dos.getString(key)) : (cls.getSimpleName().equalsIgnoreCase("Date") ? (null == dos ? null : dos.getDate(key)) : (cls.getSimpleName().equalsIgnoreCase("int") || cls.getSimpleName().equalsIgnoreCase("Integer") ? Integer.valueOf(null == dos ? 0 : dos.getInt(key)) : (cls.getSimpleName().equalsIgnoreCase("Boolean") || cls.getSimpleName().equalsIgnoreCase("boolean") ? (null == dos ? Integer.valueOf(0) : (dos.getBoolean(key) ? "1" : "0")) : (null == dos ? "" : dos.getString(key)))))));
        return object;
    }
}

