/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.tax.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.fs.util.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.refactor.tax.service.TaxConfigService;
import kd.taxc.bdtaxr.common.refactor.tax.service.impl.TaxRuleAlgoService;
import kd.taxc.bdtaxr.common.refactor.tax.utils.FetchValueUtils;
import kd.taxc.bdtaxr.common.refactor.tax.utils.FilterGetValueUtils;
import kd.taxc.bdtaxr.common.refactor.tax.utils.FilterUtils;
import kd.taxc.bdtaxr.common.refactor.tax.vo.BillTaxVo;
import kd.taxc.bdtaxr.common.refactor.tax.vo.FieldsAndDataTypeVo;
import kd.taxc.bdtaxr.common.refactor.tax.vo.FiledsPropertyVo;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;

public abstract class TaxConfigAbstractService
implements TaxConfigService {
    protected String entryKey;
    protected String sourceKey;
    protected String fieldKey;
    protected String conditionjson;
    protected String condition;
    private static Log logger = LogFactory.getLog(TaxConfigAbstractService.class);

    @Override
    public List<Map<String, Object>> service(BillTaxVo billTaxVo, DynamicObject dynamicObject, DynamicObject taxBillEntry) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(16);
        DynamicObjectCollection pageDos = dynamicObject.getDynamicObjectCollection(this.entryKey);
        HashMap<String, Map<DynamicObject, Map<String, Object>>> fourPMap = new HashMap<String, Map<DynamicObject, Map<String, Object>>>();
        HashMap rowFourMap = new HashMap();
        pageDos.stream().forEach(d -> {
            String filter;
            boolean isCal = true;
            if (StringUtils.isNotEmpty((String)this.conditionjson) && StringUtils.isNotEmpty((String)(filter = d.getString(this.conditionjson)))) {
                String entityNumber = d.getString(this.sourceKey);
                QFilter conditionJson = FilterUtils.buildFilter(filter, false);
                if (null != conditionJson) {
                    isCal = billTaxVo.getEntityNumber().equalsIgnoreCase(entityNumber) ? this.currentBillCondition(billTaxVo, conditionJson, filter) : this.otherBillCondition(billTaxVo, entityNumber, conditionJson);
                }
            }
            if (isCal) {
                Map<String, Object> map = this.cal(billTaxVo, (DynamicObject)d);
                if (null != map) {
                    list.add(map);
                }
                rowFourMap.put(d, map);
            } else {
                rowFourMap.put(d, null);
            }
        });
        fourPMap.put(this.getClass().getSimpleName(), rowFourMap);
        billTaxVo.getLogger().addFourPMap(fourPMap);
        billTaxVo.getTaxLogMaterialLineDto().collectFourPList(fourPMap);
        return list;
    }

    protected boolean currentBillCondition(BillTaxVo billTaxVo, QFilter conditionJson, String filter) {
        String conditionStr = conditionJson.toString();
        String[] qFilterKey = FilterUtils.getQFilterKey(conditionJson.recombine());
        List<FieldsAndDataTypeVo> fieldsAndDataTypeVolist = FilterGetValueUtils.fetchValue(billTaxVo, qFilterKey, "");
        DataSet datSet = TaxRuleAlgoService.service(fieldsAndDataTypeVolist);
        DataSet dataSetTemp = datSet.filter(conditionStr, FilterUtils.getFilterParams(filter));
        return !dataSetTemp.isEmpty();
    }

    protected boolean otherBillCondition(BillTaxVo billTaxVo, String entityNumber, QFilter conditionJson) {
        DynamicObjectCollection source = billTaxVo.getSourceData().get(entityNumber);
        QFilter ids = null;
        if (null != source) {
            QFilter[] qFilter = conditionJson.recombine();
            String[] filedsArr = null;
            DynamicObject main = null;
            DynamicObject sub = null;
            String property = null;
            DynamicObject[] array = null;
            List<LinkedList<FiledsPropertyVo>> filedsPropertyVos = null;
            LinkedList<FiledsPropertyVo> filedsPropertyVo = null;
            for (QFilter q : qFilter) {
                property = q.getProperty();
                filedsPropertyVos = MetadataUtil.queryProperty(entityNumber, property, filedsArr = new String[3], false);
                filedsPropertyVo = filedsPropertyVos.get(0);
                array = FetchValueUtils.calEntryValue(billTaxVo, entityNumber, filedsPropertyVo);
                if (array == null) continue;
                for (int i = 0; i < array.length; ++i) {
                    if (0 == i) {
                        main = array[i];
                        continue;
                    }
                    if (1 != i) continue;
                    sub = array[i];
                }
                if (null != sub) break;
            }
            ids = new QFilter("id", "=", (Object)(null != main ? main.getLong("id") : 0L));
            if (null != sub) {
                ids.and(new QFilter(filedsPropertyVo.get(0).getFiled() + ".id", "=", (Object)sub.getLong("id")));
            }
        } else {
            ids = new QFilter("id", "=", (Object)0);
        }
        logger.info("tax-ids:{" + ids + "};conditionJson:{" + conditionJson.toString() + "}");
        DynamicObjectCollection doc = QueryServiceHelper.query((String)entityNumber, (String)"id", (QFilter[])new QFilter[]{conditionJson, ids});
        return doc.size() > 0;
    }

    public abstract Map<String, Object> cal(BillTaxVo var1, DynamicObject var2);

    public FieldsAndDataTypeVo getValue(BillTaxVo billTaxVo, DynamicObject d) {
        String entityNumber = d.getString(this.sourceKey);
        String fieldKeys = d.getString(this.fieldKey);
        FieldsAndDataTypeVo list = FetchValueUtils.fetchValue(billTaxVo, entityNumber, fieldKeys);
        logger.info("tax-getvalueid:" + (null != list ? list.getValue() : Long.valueOf(0L)));
        return list;
    }
}

