/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.tax.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.ext.taxc.vo.TaxAmountLineVo;
import kd.bos.fs.util.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.constant.TaxLineLogStepEnum;
import kd.taxc.bdtaxr.common.refactor.tax.log.taxlinelog.TaxLineLogService;
import kd.taxc.bdtaxr.common.refactor.tax.service.TaxLineService;
import kd.taxc.bdtaxr.common.refactor.taxLinecalculate.TaxLineCalculateService;
import kd.taxc.bdtaxr.common.refactor.taxLinecalculate.impl.TaxLineCalculateServiceImpl;
import kd.taxc.bdtaxr.common.util.string.StringUtil;

public class TaxLineServiceImpl
implements TaxLineService {
    private String BDTAXR_FORMULA_RANGE = "bdtaxr_formula_range";
    private TaxLineCalculateService taxLineCalculateService = new TaxLineCalculateServiceImpl();

    @Override
    public List<TaxAmountLineVo> service(DynamicObject dos, String billKey, DynamicObject materDynamic, TaxLineLogService taxLineLogService, Map<String, String> keyMap, int materialLine) {
        String materialLineNum = String.valueOf(materialLine + 1);
        String taxDetailLineKey = keyMap.get("taxDetailLineKey");
        String taxDetailLineTaxTypeKey = keyMap.get("taxDetailLineTaxTypeKey");
        String taxDetailLineTaxCodeKey = keyMap.get("taxDetailLineTaxCodeKey");
        DynamicObjectCollection internationalTax = materDynamic.getDynamicObjectCollection(taxDetailLineKey);
        if (null == internationalTax) {
            return new ArrayList<TaxAmountLineVo>();
        }
        if (null != internationalTax && internationalTax.size() == 0) {
            return new ArrayList<TaxAmountLineVo>();
        }
        taxLineLogService.initStepMap(materialLineNum, taxLineLogService.getLogs(), internationalTax, taxDetailLineTaxCodeKey, taxDetailLineTaxTypeKey);
        Object[] taxTypeValue = new Long[internationalTax.size()];
        Long[] tempTaxTypeValue = this.getTaxType(internationalTax, taxDetailLineTaxTypeKey, taxLineLogService);
        if (null != tempTaxTypeValue) {
            taxTypeValue = tempTaxTypeValue;
        }
        ArrayList<TaxAmountLineVo> ret = new ArrayList<TaxAmountLineVo>(taxTypeValue.length);
        HashMap<String, BigDecimal> taxTypeValueMap = new HashMap<String, BigDecimal>();
        DynamicObjectCollection doc = this.getTaxLineConfing(billKey, taxTypeValue);
        taxLineLogService.getCalLogger().addTaxTypeFormula(doc);
        HashMap<Long, Long> map = new HashMap<Long, Long>(taxTypeValue.length);
        for (DynamicObject d : doc) {
            Long key = d.getLong("taxtype");
            Long value = d.getLong("formula");
            map.put(key, value);
        }
        taxLineLogService.getCalLogger().addTaxTypeValueHead();
        for (int i = 0; i < taxTypeValue.length; ++i) {
            taxLineLogService.setCurrentTaxLine(String.valueOf(i + 1));
            TaxAmountLineVo taxAmountLineVo = new TaxAmountLineVo(this.calTaxLine(dos, materDynamic, (Long)map.get(taxTypeValue[i]), (Long)taxTypeValue[i], taxLineLogService, taxTypeValueMap, i, taxDetailLineKey));
            ret.add(taxAmountLineVo);
            taxLineLogService.getCalLogger().addTaxTypeValue((Long)taxTypeValue[i], taxAmountLineVo);
        }
        taxLineLogService.getCalLogger().printLog();
        return ret;
    }

    private DynamicObjectCollection getTaxLineConfing(String billKey, Object[] taxTypeValue) {
        QFilter billKeyFilters = new QFilter("bill", "=", (Object)billKey);
        QFilter taxTypeKeyFilters = new QFilter("taxtype", "in", (Object)taxTypeValue);
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        DynamicObjectCollection dos = QueryServiceHelper.query((String)this.BDTAXR_FORMULA_RANGE, (String)"formula,taxtype,formula.name,taxtype.name", (QFilter[])new QFilter[]{billKeyFilters, taxTypeKeyFilters, enable});
        return dos;
    }

    private BigDecimal calTaxLine(DynamicObject dos, DynamicObject materDynamic, Long formulaId, Long taxType, TaxLineLogService taxLineLogService, Map<String, BigDecimal> taxTypeValueMap, int currentRow, String taxDetailLineKey) {
        HashMap<String, Object> stepOneParams = new HashMap<String, Object>();
        stepOneParams.put("logparam_taxtype", taxType);
        stepOneParams.put("current_line", currentRow);
        HashMap<String, Object> stepTwoParams = new HashMap<String, Object>();
        stepTwoParams.put("logparam_formula", formulaId);
        HashMap<String, Object> stepThreeParams = new HashMap<String, Object>();
        stepThreeParams.put("logparam_formula", formulaId);
        taxLineLogService.stepTaxLineLog(TaxLineLogStepEnum.STEP_ONE.getCode(), stepOneParams);
        taxLineLogService.stepTaxLineLog(TaxLineLogStepEnum.STEP_TWO.getCode(), stepTwoParams);
        if (null != formulaId) {
            List<String> formulaKey = this.taxLineCalculateService.getFieldsByFormulaId(formulaId);
            HashMap<String, Object> params = new HashMap<String, Object>(16);
            for (String key : formulaKey) {
                params.put(key, this.getValue(dos, materDynamic, key, taxTypeValueMap, currentRow, taxDetailLineKey));
            }
            taxLineLogService.getCalLogger().addTaxTypeFormulaKey(params);
            stepThreeParams.put("logparam_fieldkeysvalue", params);
            stepThreeParams.put("logparam_fieldkey_taxtype", taxTypeValueMap);
            taxLineLogService.stepTaxLineLog(TaxLineLogStepEnum.STEP_THREE.getCode(), stepThreeParams);
            Object value = this.taxLineCalculateService.getTaxLineCalResult(formulaId, params);
            HashMap<String, Object> stepFourParams = new HashMap<String, Object>();
            stepFourParams.put("logparam_amount", value);
            taxLineLogService.stepTaxLineLog(TaxLineLogStepEnum.STEP_FOUR.getCode(), stepFourParams);
            this.putTaxTypeValue(taxTypeValueMap, taxType, value);
            if (ObjectUtils.isEmpty((Object)value)) {
                return null;
            }
            return StringUtil.isNumeric(value.toString()) ? new BigDecimal(value.toString()) : null;
        }
        this.putTaxTypeValue(taxTypeValueMap, taxType, "");
        return null;
    }

    private BigDecimal getValue(DynamicObject dos, DynamicObject materDynamic, String key, Map<String, BigDecimal> taxTypeValueMap, int currentRow, String taxDetailLineKey) {
        if (StringUtils.isNotEmpty((String)key)) {
            String materKey = materDynamic.getDataEntityType().getName();
            if (key.indexOf(".") != -1 && key.startsWith(materKey)) {
                String lastKey = key.substring(key.lastIndexOf(".") + 1, key.length());
                return materDynamic.getBigDecimal(lastKey);
            }
            if (key.indexOf(".") != -1 && key.startsWith("subentryentity")) {
                DynamicObjectCollection taxCollection = materDynamic.getDynamicObjectCollection(taxDetailLineKey);
                String lastKey = key.substring(key.lastIndexOf(".") + 1, key.length());
                return ((DynamicObject)taxCollection.get(currentRow)).getBigDecimal(lastKey);
            }
            if (key.indexOf(".") != -1 && !key.startsWith(materKey)) {
                return new BigDecimal("0.0");
            }
            if (key.startsWith("taxType_")) {
                return null == taxTypeValueMap.get(key) ? new BigDecimal("0.0") : taxTypeValueMap.get(key);
            }
            return dos.getBigDecimal(key);
        }
        return new BigDecimal("0.0");
    }

    private void putTaxTypeValue(Map<String, BigDecimal> taxTypeValueMap, Long taxType, Object value) {
        String taxTypeExpress = "taxType_" + taxType;
        BigDecimal bigDecimal = new BigDecimal("0.0");
        if (!ObjectUtils.isEmpty((Object)value)) {
            if (null != taxTypeValueMap.get(taxTypeExpress) && StringUtil.isNumeric(value.toString())) {
                taxTypeValueMap.put(taxTypeExpress, taxTypeValueMap.get(taxTypeExpress).add(new BigDecimal(value.toString())));
            } else if (null == taxTypeValueMap.get(taxTypeExpress) && StringUtil.isNumeric(value.toString())) {
                taxTypeValueMap.put(taxTypeExpress, new BigDecimal(value.toString()));
            } else {
                taxTypeValueMap.put(taxTypeExpress, bigDecimal);
            }
        }
    }

    private Long[] getTaxType(DynamicObjectCollection internationalTax, String taxTypeKey, TaxLineLogService taxLineLogService) {
        taxLineLogService.getCalLogger().addTaxLineTaxType(internationalTax, taxTypeKey);
        Long[] taxTypeValue = new Long[internationalTax.size()];
        for (int i = 0; i < internationalTax.size(); ++i) {
            DynamicObject object = ((DynamicObject)internationalTax.get(i)).getDynamicObject(taxTypeKey);
            taxTypeValue[i] = null == object ? null : Long.valueOf(object.getLong("id"));
        }
        return taxTypeValue;
    }
}

