/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.tax.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.refactor.tax.service.TaxConfigService;
import kd.taxc.bdtaxr.common.refactor.tax.service.impl.TaxConfigAbstractService;
import kd.taxc.bdtaxr.common.refactor.tax.vo.BillTaxVo;
import kd.taxc.bdtaxr.common.refactor.tax.vo.FieldsAndDataTypeVo;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;

public class TaxProductServiceImpl
extends TaxConfigAbstractService
implements TaxConfigService {
    private static Log logger = LogFactory.getLog(TaxProductServiceImpl.class);
    private String product = "product";
    private String converttype = "converttype";
    private String valuerules = "valuerules";
    private String taxelement = "valuerules_entry.taxelement";
    private String basicdatatype = "basicdatatype";
    private String materialtaxonomy = "materialtaxonomy";
    private static final String BD_MATERIALGROUP = "bd_materialgroup";
    private static final String BD_MATERIALGROUPDETAIL = "bd_materialgroupdetail";

    public TaxProductServiceImpl() {
        this.entryKey = "product_entity";
        this.sourceKey = "productsourcekey";
        this.fieldKey = "productfieldkey";
        this.conditionjson = "productconditionjson";
        this.condition = "productcondition";
    }

    @Override
    public Map<String, Object> cal(BillTaxVo billTaxVo, DynamicObject d) {
        String converttypeValue = d.getString(this.converttype);
        if ("1".equals(converttypeValue)) {
            HashMap<String, Object> map = new HashMap<String, Object>(2);
            map.put("entrytype", 0L);
            map.put("valueid", d.getDynamicObject(this.product).getLong("id"));
            return map;
        }
        if ("2".equals(converttypeValue)) {
            FieldsAndDataTypeVo value = this.getValue(billTaxVo, d);
            logger.info("taxc-TaxProductServiceImpl valuerules:" + JsonUtil.toJson(value));
            if (null != value) {
                long valueruleId = d.getDynamicObject(this.valuerules).getLong("id");
                return this.handler(valueruleId, value);
            }
        }
        return null;
    }

    private Map<String, Object> handler(long valueruleId, FieldsAndDataTypeVo value) {
        QFilter id = new QFilter("id", "=", (Object)valueruleId);
        DynamicObject row = BusinessDataServiceHelper.loadSingle((String)"bdtaxr_valuerules", (String)(this.basicdatatype + "," + this.materialtaxonomy), (QFilter[])new QFilter[]{id});
        if (StringUtils.equalsIgnoreCase((CharSequence)row.getDynamicObject(this.basicdatatype).getString("id"), (CharSequence)BD_MATERIALGROUP)) {
            Long materialId = 0L;
            if (value.getDatatypes().getJavaType().getSimpleName().equals("Long")) {
                materialId = (Long)value.getValue();
            }
            QFilter materialIdQ = new QFilter("material", "=", (Object)materialId);
            DynamicObjectCollection taxonomyColl = row.getDynamicObjectCollection(this.materialtaxonomy);
            if (null != taxonomyColl && taxonomyColl.size() > 0) {
                List materialtaxonomyIds = taxonomyColl.stream().map(o -> o.getDynamicObject("fbasedataid").get("id")).collect(Collectors.toList());
                materialIdQ.and(new QFilter("standard", "in", materialtaxonomyIds));
            }
            DynamicObjectCollection collection = QueryServiceHelper.query((String)BD_MATERIALGROUPDETAIL, (String)"group", (QFilter[])new QFilter[]{materialIdQ});
            List<Long> groupIds = collection.stream().map(o -> o.getLong("group")).collect(Collectors.toList());
            ArrayList<Long> allIds = new ArrayList<Long>();
            this.getAllParentId(allIds, groupIds);
            QFilter values = new QFilter("valuerules_entry.basicdataid", "in", (Object)allIds.toArray());
            DynamicObjectCollection doc = QueryServiceHelper.query((String)"bdtaxr_valuerules", (String)this.taxelement, (QFilter[])new QFilter[]{id, values});
            if (doc.size() > 0) {
                HashMap<String, Object> map = new HashMap<String, Object>(2);
                map.put("entrytype", 0L);
                List list = doc.stream().map(o -> o.getString(this.taxelement)).collect(Collectors.toList());
                map.put("valueid", org.apache.commons.lang3.StringUtils.join(list, (String)","));
                return map;
            }
        } else {
            QFilter values = null;
            values = value.getDatatypes().getJavaType().getSimpleName().equals("Long") ? new QFilter("valuerules_entry.basicdataid", "=", value.getValue()) : new QFilter("valuerules_entry.basicdataid", "=", (Object)0L);
            DynamicObjectCollection doc = QueryServiceHelper.query((String)"bdtaxr_valuerules", (String)this.taxelement, (QFilter[])new QFilter[]{id, values});
            if (doc.size() > 0) {
                HashMap<String, Object> map = new HashMap<String, Object>(2);
                map.put("entrytype", 0L);
                map.put("valueid", ((DynamicObject)doc.get(0)).get(this.taxelement));
                return map;
            }
        }
        return null;
    }

    private void getAllParentId(List<Long> allIds, List<Long> childIds) {
        allIds.addAll(childIds);
        QFilter qFilter = new QFilter("id", "in", (Object)childIds.toArray());
        DynamicObjectCollection collection = QueryServiceHelper.query((String)BD_MATERIALGROUP, (String)"parent", (QFilter[])new QFilter[]{qFilter});
        List<Long> ids = collection.stream().filter(o -> !ObjectUtils.isEmpty((Object)o.get("parent"))).map(o -> o.getLong("parent")).collect(Collectors.toList());
        if (!ObjectUtils.isEmpty(ids)) {
            this.getAllParentId(allIds, ids);
        }
    }
}

