/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.tax.utils;

import java.math.BigDecimal;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.refactor.rule.rulecal.filter.FilterAssistDto;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.vo.BillTaxFilterVo;

public class FilterUtils {
    public static String[] getQFilterKey(QFilter[] qFilter) {
        String[] key = new String[qFilter.length];
        for (int i = 0; i < qFilter.length; ++i) {
            key[i] = qFilter[i].getProperty();
        }
        return key;
    }

    public static QFilter buildFilter(String conditionjson, boolean isUserParams) {
        List<BillTaxFilterVo> dtos = JsonUtil.fromJsonList(conditionjson, BillTaxFilterVo.class);
        QFilter qFilter = FilterUtils.buildFilterByFilterVo(dtos, isUserParams);
        return qFilter;
    }

    public static String getFilterDesc(String conditionjson) {
        List<BillTaxFilterVo> dtos = JsonUtil.fromJsonList(conditionjson, BillTaxFilterVo.class);
        StringBuilder sb = new StringBuilder();
        for (BillTaxFilterVo dto : dtos) {
            sb.append(dto.toCnString()).append(' ');
        }
        String desc = sb.toString().trim();
        if (desc.endsWith(FilterUtils.getAndCn()) || desc.endsWith(FilterUtils.getOrCn())) {
            desc = desc.substring(0, desc.length() - 2);
        }
        return desc;
    }

    public static QFilter buildFilterByFilterVo(List<BillTaxFilterVo> billTaxFilterVo, boolean isUserParams) {
        if (ObjectUtils.isEmpty(billTaxFilterVo)) {
            return null;
        }
        LinkedList<Object> filterStack = new LinkedList<Object>();
        int number = 0;
        for (BillTaxFilterVo dto : billTaxFilterVo) {
            QFilter filter = FilterUtils.getFilterString(dto, number++);
            if (!isUserParams) {
                filter = FilterUtils.getFilter(dto);
            }
            if (null == filter) continue;
            String leftBracket = dto.getLeftBracket();
            if (!StringUtil.isEmpty((CharSequence)leftBracket)) {
                int count = leftBracket.length();
                while (count-- > 0) {
                    filterStack.push("(");
                }
            }
            filterStack.push(new FilterAssistDto(filter, dto.getLogic()));
            String rightBracket = dto.getRightBracket();
            if (StringUtil.isEmpty((CharSequence)rightBracket)) continue;
            int count = rightBracket.length();
            LinkedList<FilterAssistDto> filterAssistDtos = new LinkedList<FilterAssistDto>();
            while (count > 0 && !filterStack.isEmpty()) {
                if (filterStack.peek() instanceof FilterAssistDto) {
                    filterAssistDtos.add(0, (FilterAssistDto)filterStack.pop());
                    continue;
                }
                filterStack.pop();
                int i = 0;
                while (i + 1 < filterAssistDtos.size()) {
                    FilterAssistDto head = (FilterAssistDto)filterAssistDtos.get(i);
                    FilterAssistDto follow = (FilterAssistDto)filterAssistDtos.get(i + 1);
                    if ("0".equals(head.getLogic())) {
                        head.getqFilter().and(follow.getqFilter());
                    } else {
                        head.getqFilter().or(follow.getqFilter());
                    }
                    ++i;
                }
                ((FilterAssistDto)filterAssistDtos.get(0)).setLogic(((FilterAssistDto)filterAssistDtos.get(filterAssistDtos.size() - 1)).getLogic());
                filterStack.push(filterAssistDtos.get(0));
                --count;
                Iterator it = filterAssistDtos.iterator();
                while (it.hasNext()) {
                    it.next();
                    it.remove();
                }
            }
        }
        QFilter endFilter = FilterUtils.buildFilter(filterStack);
        return endFilter;
    }

    private static QFilter buildFilter(Deque<Object> filterDeque) {
        LinkedList<FilterAssistDto> filterAssistDtos = new LinkedList<FilterAssistDto>();
        while (!filterDeque.isEmpty()) {
            Object obj = filterDeque.pop();
            if (!(obj instanceof FilterAssistDto)) continue;
            filterAssistDtos.add(0, (FilterAssistDto)obj);
        }
        int i = 0;
        while (i + 1 < filterAssistDtos.size()) {
            FilterAssistDto head = (FilterAssistDto)filterAssistDtos.get(i);
            FilterAssistDto follow = (FilterAssistDto)filterAssistDtos.get(i + 1);
            if ("0".equals(head.getLogic())) {
                head.getqFilter().and(follow.getqFilter());
            } else {
                head.getqFilter().or(follow.getqFilter());
            }
            ++i;
        }
        return filterAssistDtos.size() == 0 ? null : ((FilterAssistDto)filterAssistDtos.get(0)).getqFilter();
    }

    private static QFilter getFilterString(BillTaxFilterVo dto, int number) {
        QFilter temp = null;
        String fieldNumber = dto.getFieldNumber();
        String fieldsType = dto.getFieldType();
        String compareType = dto.getConditonNumber();
        String value = dto.getValue().get(0);
        switch (compareType) {
            case "=": 
            case "!=": 
            case "<": 
            case "<=": 
            case ">": 
            case ">=": {
                temp = new QFilter(fieldNumber, compareType, (Object)(fieldNumber + String.valueOf(number)), true);
                break;
            }
            default: {
                return temp;
            }
        }
        return temp;
    }

    public static Map<String, Object> getFilterParams(String conditionjson) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        List<BillTaxFilterVo> dtos = JsonUtil.fromJsonList(conditionjson, BillTaxFilterVo.class);
        int number = 0;
        block11: for (BillTaxFilterVo dto : dtos) {
            String fieldNumber = dto.getFieldNumber();
            String fieldsType = dto.getFieldType();
            String compareType = dto.getConditonNumber();
            String value = dto.getValue().get(0);
            switch (compareType) {
                case "=": 
                case "!=": 
                case "<": 
                case "<=": 
                case ">": 
                case ">=": {
                    params.putAll(FilterUtils.createParamsByFieldTpye(fieldNumber, fieldsType, value, number++));
                    continue block11;
                }
            }
            return params;
        }
        return params;
    }

    private static QFilter getFilter(BillTaxFilterVo dto) {
        QFilter temp = null;
        String fieldNumber = dto.getFieldNumber();
        String fieldsType = dto.getFieldType();
        String compareType = dto.getConditonNumber();
        String value = dto.getValue().get(0);
        switch (compareType) {
            case "=": 
            case "!=": 
            case "<": 
            case "<=": 
            case ">": 
            case ">=": {
                temp = FilterUtils.createQFilterByFieldTpye(fieldNumber, compareType, fieldsType, value);
                break;
            }
            case "is null": 
            case "is not null": {
                temp = new QFilter(dto.getFieldNumber(), compareType, null);
                break;
            }
            case "in": 
            case "not in": {
                temp = new QFilter(dto.getFieldNumber(), compareType, dto.getValue());
                break;
            }
            case "like": 
            case "not like": {
                temp = new QFilter(dto.getFieldNumber(), compareType, (Object)("%" + dto.getValue().get(0) + "%"));
                break;
            }
            case "start with": {
                temp = new QFilter(dto.getFieldNumber(), "like", (Object)(dto.getValue().get(0) + "%"));
                break;
            }
            case "end with": {
                temp = new QFilter(dto.getFieldNumber(), "like", (Object)("%" + dto.getValue().get(0)));
                break;
            }
            default: {
                return temp;
            }
        }
        return temp;
    }

    private static Map<String, Object> createParamsByFieldTpye(String fieldNumber, String fieldsType, String value, int number) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        StringBuilder fieldKeyBu = new StringBuilder();
        fieldKeyBu.append(fieldNumber).append(number);
        String fieldKey = fieldKeyBu.toString();
        if (StringUtils.equalsIgnoreCase((CharSequence)fieldsType, (CharSequence)"BigDecimal") || StringUtils.equalsIgnoreCase((CharSequence)fieldsType, (CharSequence)"Double")) {
            map.put(fieldKey, StringUtils.isEmpty((CharSequence)value) ? Double.valueOf(0.0) : BigDecimal.valueOf(Double.parseDouble(value)));
        } else if (StringUtils.equalsIgnoreCase((CharSequence)fieldsType, (CharSequence)"Long") || StringUtils.equalsIgnoreCase((CharSequence)fieldsType, (CharSequence)"DynamicObject")) {
            map.put(fieldKey, StringUtils.isEmpty((CharSequence)value) ? 0L : Long.parseLong(value));
        } else if (StringUtils.equalsIgnoreCase((CharSequence)fieldsType, (CharSequence)"Date")) {
            map.put(fieldKey, StringUtils.isEmpty((CharSequence)value) ? null : DateUtils.stringToDate(value));
        } else if (StringUtils.equalsIgnoreCase((CharSequence)fieldsType, (CharSequence)"int") || StringUtils.equalsIgnoreCase((CharSequence)fieldsType, (CharSequence)"Integer")) {
            map.put(fieldKey, StringUtils.isEmpty((CharSequence)value) ? 0 : Integer.parseInt(value));
        } else if (StringUtils.equalsIgnoreCase((CharSequence)fieldsType, (CharSequence)"String") || StringUtils.equalsIgnoreCase((CharSequence)fieldsType, (CharSequence)"ILocaleString")) {
            map.put(fieldKey, StringUtils.isEmpty((CharSequence)value) ? "" : value);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)fieldsType, (CharSequence)"Boolean")) {
            map.put(fieldKey, StringUtils.isEmpty((CharSequence)value) ? Integer.valueOf(0) : value);
        } else {
            map.put(fieldKey, StringUtils.isEmpty((CharSequence)value) ? "" : value);
        }
        return map;
    }

    private static QFilter createQFilterByFieldTpye(String fieldNumber, String compareType, String fieldsType, String value) {
        QFilter qFilter = null;
        qFilter = StringUtils.equalsIgnoreCase((CharSequence)fieldsType, (CharSequence)"BigDecimal") || StringUtils.equalsIgnoreCase((CharSequence)fieldsType, (CharSequence)"Double") ? new QFilter(fieldNumber, compareType, (Object)(StringUtils.isEmpty((CharSequence)value) ? Double.valueOf(0.0) : BigDecimal.valueOf(Double.parseDouble(value)))) : (StringUtils.equalsIgnoreCase((CharSequence)fieldsType, (CharSequence)"Long") || StringUtils.equalsIgnoreCase((CharSequence)fieldsType, (CharSequence)"DynamicObject") ? new QFilter(fieldNumber, compareType, (Object)(StringUtils.isEmpty((CharSequence)value) ? 0L : Long.parseLong(value))) : (StringUtils.equalsIgnoreCase((CharSequence)fieldsType, (CharSequence)"String") || StringUtils.equalsIgnoreCase((CharSequence)fieldsType, (CharSequence)"ILocaleString") ? new QFilter(fieldNumber, compareType, (Object)(StringUtils.isEmpty((CharSequence)value) ? "" : value)) : (StringUtils.equalsIgnoreCase((CharSequence)fieldsType, (CharSequence)"Date") ? new QFilter(fieldNumber, compareType, (Object)(StringUtils.isEmpty((CharSequence)value) ? null : DateUtils.stringToDate(value))) : (StringUtils.equalsIgnoreCase((CharSequence)fieldsType, (CharSequence)"int") || StringUtils.equalsIgnoreCase((CharSequence)fieldsType, (CharSequence)"Integer") ? new QFilter(fieldNumber, compareType, (Object)(StringUtils.isEmpty((CharSequence)value) ? 0 : Integer.parseInt(value))) : (StringUtils.equalsIgnoreCase((CharSequence)fieldsType, (CharSequence)"Boolean") ? new QFilter(fieldNumber, compareType, StringUtils.isEmpty((CharSequence)value) ? Integer.valueOf(0) : value) : new QFilter(fieldNumber, compareType, (Object)(StringUtils.isEmpty((CharSequence)value) ? "" : value)))))));
        return qFilter;
    }

    private static String getOrCn() {
        return ResManager.loadKDString((String)"\u6216\u8005", (String)"FilterUtils_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
    }

    private static String getAndCn() {
        return ResManager.loadKDString((String)"\u5e76\u4e14", (String)"FilterUtils_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]);
    }
}

