/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.tax.utils;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.property.MaterielProp;
import kd.bos.ext.taxc.vo.TaxLineVo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.refactor.tax.vo.FieldsAndDataTypeVo;
import kd.taxc.bdtaxr.common.refactor.tax.vo.FourPVo;

public class TaxCalLoggerUtils {
    private boolean islog = true;
    private static Log logger = LogFactory.getLog(TaxCalLoggerUtils.class);
    private StringBuilder sb = new StringBuilder("tax-");

    public void addSourceData(Map<String, DynamicObjectCollection> sourceData) {
        if (this.islog) {
            this.sb.append("\r\n");
            this.sb.append(ResManager.loadKDString((String)"\u83b7\u53d6\u5f53\u524d\u5355\u636e\u4e0a\u4e0b\u6e38\u4fe1\u606f", (String)"TaxCalLoggerUtils_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            this.sb.append("\r\n");
            if (null != sourceData) {
                sourceData.forEach((k, v) -> {
                    this.sb.append(" key :").append((String)k).append(",value:");
                    v.forEach(vv -> this.sb.append(vv.getLong("id")).append(",billno:").append(vv.getString("billno")));
                    this.sb.append("\r\n");
                });
            }
            this.sb.append("\r\n");
            this.sb.append("-------------------------------");
        }
    }

    public void addTaxBillEntry(DynamicObject taxBillEntry, int entryLine) {
        if (this.islog) {
            this.sb.append("\r\n");
            this.sb.append(String.format(ResManager.loadKDString((String)"\u7269\u6599\u884c\u5206\u5f55\u5e8f\u53f7:%s", (String)"TaxCalLoggerUtils_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), entryLine));
            this.sb.append("\r\n");
            this.sb.append(ResManager.loadKDString((String)"\u7a0e\u7801\u4e0e\u7a0e\u7387\u6240\u5728\u5b50\u8868\u7684\u884c\u6570\u636e", (String)"TaxCalLoggerUtils_2", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            this.sb.append("\r\n");
            if (null != taxBillEntry) {
                this.sb.append(" id :").append(taxBillEntry.get("id")).append(", ");
                DynamicObjectType d = taxBillEntry.getDynamicObjectType();
                DataEntityPropertyCollection dd = d.getProperties();
                for (IDataEntityProperty ddd : dd) {
                    DynamicObject s;
                    if (!(ddd instanceof MaterielProp) || null == (s = taxBillEntry.getDynamicObject(ddd.getName()))) continue;
                    this.sb.append(ddd.getName());
                    this.sb.append(", number:").append(s.getString("number")).append(", name:").append(s.getString("name"));
                    this.sb.append("\r\n");
                }
            }
            this.sb.append("\r\n");
            this.sb.append("-------------------------------");
        }
    }

    public void addBusinessScenario(DynamicObject[] businessScenarios) {
        if (this.islog) {
            this.sb.append("\r\n");
            this.sb.append(ResManager.loadKDString((String)"----------\u7b2c\u4e00\u6b65:\u7b26\u5408\u6761\u4ef6\u7684\u5355\u636e\u8ba1\u7a0e\u914d\u7f6e--------------------", (String)"TaxCalLoggerUtils_3", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            this.sb.append("\r\n");
            this.sb.append(ResManager.loadKDString((String)"-----\u2460\u8bfb\u53d6\u5f53\u524d\u56fd\u5bb6\u5730\u533a\u751f\u6548\u7684\u5355\u636e\u8ba1\u7a0e\u914d\u7f6e---------", (String)"TaxCalLoggerUtils_4", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            this.sb.append("\r\n");
            if (null != businessScenarios) {
                Arrays.stream(businessScenarios).forEach(v -> {
                    this.sb.append(" id :").append(v.get("id")).append(",number:").append(v.get("number")).append(",name:").append(v.get("name"));
                    this.sb.append("\r\n");
                    this.sb.append("callconditions:").append(v.get("callcondition"));
                    this.sb.append("\r\n");
                });
            }
            this.sb.append(ResManager.loadKDString((String)"-----\u2461\u8bfb\u53d6\u8c03\u7528\u5355\u636e\u914d\u7f6e\u7684\u6761\u4ef6\u5b57\u6bb5\u503c---------", (String)"TaxCalLoggerUtils_5", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            this.sb.append("\r\n");
        }
    }

    public void addFieldsAndDataTypeVo(List<FieldsAndDataTypeVo> list) {
        if (this.islog) {
            if (null != list) {
                for (FieldsAndDataTypeVo v : list) {
                    this.sb.append(v.toString());
                    this.sb.append("\r\n");
                }
            }
            this.sb.append("\r\n");
            this.sb.append("-------------------------------");
        }
    }

    public void addQFilter(DynamicObject d, boolean isSure) {
        if (this.islog) {
            this.sb.append("\r\n");
            this.sb.append(ResManager.loadKDString((String)"-----\u2462\u5355\u636e\u8ba1\u7a0e\u914d\u7f6e\u8c03\u7528\u6761\u4ef6------", (String)"TaxCalLoggerUtils_6", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            this.sb.append("\r\n");
            this.sb.append("number:").append(d.get("number")).append(",name:").append(d.get("name")).append(",callconditions:").append(d.get("callcondition"));
            this.sb.append(ResManager.loadKDString((String)";\u7ed3\u679c: ", (String)"TaxCalLoggerUtils_7", (String)"taxc-bdtaxr-common", (Object[])new Object[0])).append(isSure);
            this.sb.append("\r\n");
            this.sb.append("-------------------------------");
        }
    }

    public void addBusinessScenario(DynamicObject businessScenario) {
        if (this.islog) {
            this.sb.append("\r\n");
            this.sb.append(ResManager.loadKDString((String)"----------\u7b2c\u4e8c\u6b65\uff1a\u6839\u636e\u8c03\u7528\u6761\u4ef6\u7b97\u51fa\u6ee1\u8db3\u6761\u4ef6\u6700\u591a\u7684\u5355\u636e\u8ba1\u7a0e\u914d\u7f6e-------------", (String)"TaxCalLoggerUtils_8", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            this.sb.append("\r\n");
            if (null != businessScenario) {
                this.sb.append(" id :").append(businessScenario.get("id")).append(",number:").append(businessScenario.get("number")).append(",name:").append(businessScenario.get("name"));
            }
            this.sb.append("\r\n");
            this.sb.append("-------------------------------");
        }
    }

    public void addFourPMapHead() {
        if (this.islog) {
            this.sb.append("\r\n");
            this.sb.append(ResManager.loadKDString((String)"----------\u7b2c\u4e09\u6b65\uff1a\u67e5\u627e\u5230\u7684\u4e1a\u52a1\u8981\u7d20-------------", (String)"TaxCalLoggerUtils_9", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            this.sb.append("\r\n");
        }
    }

    public void addFourPMap(Map<String, Map<DynamicObject, Map<String, Object>>> fourPMap) {
        if (this.islog) {
            this.sb.append("\r\n");
            if (null != fourPMap) {
                fourPMap.forEach((className, entityMap) -> {
                    this.sb.append((String)className).append(":");
                    this.sb.append("\r\n");
                    if (null != entityMap) {
                        entityMap.forEach((row, value) -> {
                            if (null != row) {
                                this.sb.append(row.toString());
                            }
                            this.sb.append("\r\n");
                            this.sb.append(value);
                        });
                    }
                });
            }
            this.sb.append("\r\n");
        }
    }

    public void addFourP(List<FourPVo> fourP) {
        if (this.islog) {
            this.sb.append("\r\n");
            this.sb.append(ResManager.loadKDString((String)"----------\u7b2c\u56db\u6b65\uff1a\u6839\u636e\u8ba1\u7a0e\u914d\u7f6e\u8f6c\u6362\u7684\u7a0e\u52a1\u8981\u7d20-----------", (String)"TaxCalLoggerUtils_10", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            this.sb.append("\r\n");
            if (null != fourP) {
                fourP.stream().forEach(v -> {
                    this.sb.append(" entryClass :").append(v.getEntryClass()).append(";entryType").append(v.getEntryType()).append(";valueId:").append(v.getValueId());
                    this.sb.append("\r\n");
                });
            }
            this.sb.append("\r\n");
            this.sb.append("-------------------------------");
        }
    }

    public void addTaxRule(DynamicObject[] dos) {
        if (this.islog) {
            this.sb.append("\r\n");
            this.sb.append(ResManager.loadKDString((String)"----------\u7b2c\u4e94\u6b65\uff1a\u7b26\u5408\u6761\u4ef6\u7684\u7a0e\u52a1\u89c4\u5219----------------------------------", (String)"TaxCalLoggerUtils_11", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            this.sb.append("\r\n");
            this.sb.append(ResManager.loadKDString((String)"-----\u2460\u5f53\u524d\u56fd\u5bb6\u76f8\u5173\u7a0e\u5219--------------------", (String)"TaxCalLoggerUtils_12", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            this.sb.append("\r\n");
            if (null != dos) {
                Stream.of(dos).forEach(v -> {
                    this.sb.append(" number :").append(v.getString("number"));
                    this.sb.append("\r\n");
                });
            }
            this.sb.append("\r\n");
            this.sb.append("-------------------------------");
        }
    }

    public void addTaxRule(String number, String filter) {
        if (this.islog) {
            this.sb.append("\r\n");
            this.sb.append(ResManager.loadKDString((String)"-----\u2461\u4e0d\u6ee1\u8db3\u6761\u4ef6\u7684\u7a0e\u52a1\u89c4\u5219--------------------", (String)"TaxCalLoggerUtils_13", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            this.sb.append("\r\n");
            this.sb.append("number:").append(number).append(";filter:").append(filter);
            this.sb.append("\r\n");
            this.sb.append("-------------------------------");
        }
    }

    public void addTaxRule(DynamicObject ret) {
        if (this.islog) {
            this.sb.append("\r\n");
            this.sb.append(ResManager.loadKDString((String)"-----\u2462\u6ee1\u8db3\u6761\u4ef6\u7684\u6700\u591a\u7684\u7a0e\u5219--------------------", (String)"TaxCalLoggerUtils_14", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            this.sb.append("\r\n");
            if (null != ret) {
                this.sb.append(" number :").append(ret.getString("number"));
                this.sb.append("\r\n");
            }
            this.sb.append("\r\n");
            this.sb.append("-------------------------------");
        }
    }

    public void addTaxCodeAndTaxRate(List<TaxLineVo> taxLineVos) {
        if (this.islog) {
            this.sb.append("\r\n");
            this.sb.append(ResManager.loadKDString((String)"----------\u7b2c\u516d\u6b65\uff1a\u8f93\u51fa\u7ed3\u679c--------------------", (String)"TaxCalLoggerUtils_15", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            this.sb.append("\r\n");
            if (null != taxLineVos) {
                taxLineVos.stream().forEach(o -> {
                    this.sb.append(o.toString());
                    this.sb.append("\n");
                });
                this.sb.append("\r\n");
            }
            this.sb.append("\r\n");
            this.sb.append("-------------------------------");
        }
    }

    public void addLog(String json) {
        if (this.islog) {
            this.sb.append("\r\n");
            this.sb.append(ResManager.loadKDString((String)"----------\u5165\u53e3\u53c2\u6570----------", (String)"TaxCalLoggerUtils_16", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            this.sb.append("\r\n");
            this.sb.append(json);
            this.sb.append("\r\n");
            this.sb.append("----------------------------------------");
            this.sb.append("\r\n");
        }
    }

    public void printLog(int i, Map<String, String> taxcodeLineLog) {
        if (this.islog) {
            String log = this.sb.toString();
            logger.info(log);
            taxcodeLineLog.put(String.valueOf(i + 1), log);
            this.sb = new StringBuilder("tax-");
        }
    }
}

