/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.common.refactor.tax.utils;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.taxc.vo.TaxAmountLineVo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class TaxLineCalLoggerUtils {
    private boolean islog = true;
    private static Log logger = LogFactory.getLog(TaxLineCalLoggerUtils.class);
    private StringBuilder sb = new StringBuilder("tax-");

    public void addTaxLineTaxType(DynamicObjectCollection internationalTax, String taxTypeKey) {
        if (this.islog) {
            this.sb.append("\r\n");
            this.sb.append(ResManager.loadKDString((String)"----------1.\u7a0e\u52a1\u660e\u7ec6\u884c\u7a0e\u79cd\u4fe1\u606f----------", (String)"TaxLineCalLoggerUtils_0", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            this.sb.append("\r\n");
            if (null != internationalTax) {
                for (int i = 0; i < internationalTax.size(); ++i) {
                    DynamicObject taxRow = ((DynamicObject)internationalTax.get(i)).getDynamicObject(taxTypeKey);
                    String taxTypeName = null == taxRow ? null : taxRow.getString("name");
                    this.sb.append("taxLine:").append(i).append(",taxType:").append(taxTypeName);
                    this.sb.append("\r\n");
                }
            }
            this.sb.append("\r\n");
            this.sb.append("-------------------------------");
        }
    }

    public void addTaxTypeFormula(DynamicObjectCollection doc) {
        if (this.islog) {
            this.sb.append("\r\n");
            this.sb.append(ResManager.loadKDString((String)"----------2.\u7a0e\u79cd\u914d\u7f6e\u7684\u516c\u5f0f\u4fe1\u606f----------", (String)"TaxLineCalLoggerUtils_1", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            this.sb.append("\r\n");
            if (null != doc) {
                for (int i = 0; i < doc.size(); ++i) {
                    DynamicObject row = (DynamicObject)doc.get(i);
                    this.sb.append("taxTypeId:").append(row.get("taxtype")).append(",taxType:").append(row.getString("taxtype.name")).append(",formula:").append(row.getString("formula.name"));
                    this.sb.append("\r\n");
                }
            }
            this.sb.append("\r\n");
            this.sb.append("-------------------------------");
        }
    }

    public void addTaxTypeValueHead() {
        if (this.islog) {
            this.sb.append("\r\n");
            this.sb.append(ResManager.loadKDString((String)"----------3.\u7a0e\u79cd\u8ba1\u7b97\u7684\u503c----------", (String)"TaxLineCalLoggerUtils_2", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            this.sb.append("\r\n");
        }
    }

    public void addTaxTypeFormulaKey(Map<String, Object> params) {
        if (this.islog) {
            this.sb.append("\r\n");
            if (null != params) {
                params.forEach((k, v) -> {
                    this.sb.append("formulaKey:").append((String)k).append(",value:").append(v);
                    this.sb.append("\r\n");
                });
            }
            this.sb.append("\r\n");
        }
    }

    public void addTaxTypeValue(Long taxTypeValue, TaxAmountLineVo taxAmountLineVo) {
        if (this.islog) {
            this.sb.append("\r\n");
            this.sb.append("last result taxTypeId:").append(taxTypeValue).append(",value:").append(taxAmountLineVo.getTaxAmount());
            this.sb.append("\r\n");
            this.sb.append("-------------------------------");
        }
    }

    public void printLog() {
        if (this.islog) {
            String log = this.sb.toString();
            logger.info(log);
            this.sb = new StringBuilder("tax-");
        }
    }
}

